

/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SHLWIN.H__   1.13   13 Dec 1996 11:20:08   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SHLWIN.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:08   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:06   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:22   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:20   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:18   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:32   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:28   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:50   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:24   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:56   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:45:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:52   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:05:22   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:04   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLWIN.H
//
//  Description:The header file for the class: CShellWindow
//
//  Author:     Roger Zhang
//
//  Date:       03/10/95
//
//  Modification:
//
//      1. 03/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLWIN_
#define _SHLWIN_

/////////////////////////////////////////////////////////////////////////////
// CShellWindow frame

class CShellWindow : public CMDIChildWnd
{
    DECLARE_DYNCREATE(CShellWindow)
public:
    CShellWindow();         
    BOOL Create(LPCSTR szTitle, LONG style = 0,
        const RECT& rect = rectDefault, CMDIFrameWnd * pParent = NULL );

// Attributes
public:
    enum { MSGBARHT = 20 };
    enum { SHLHZEDGE = 4, SHLVTEDGE = 4 };
// Operations
public:
    void AddDispLine(char * pch, int nLen, BOOL isWS);
    void OvrDispLine(char * pch, int nLen);
    void StopAsm();
    void RunInclude(const char * pszFileName);
    void RunMacro(const char * pszFileName, int nLen);    

// Implementation
protected:
    static CMenu NEAR m_menu;
    CMessageBar m_MsgBar;
    HistoryList m_Hist;
    ShellBuffer m_Buf;

	// Rabit
    ShellEditor1 m_SEdit;
    //ShellEditor m_SEdit;

    int m_nFont;
    CSize m_szFont;    
    CSize m_szClient;
    CRect m_rectScroll;
    CPoint m_ptBuf;
    BOOL m_isCaretOn;
    BOOL m_isCaretVisible;    
    BOOL m_isScrolling;      
    BOOL m_isEdting;  
    BOOL m_isAsm; 
    int m_nRsv;       

    virtual ~CShellWindow();
    
	void ShowHints(void);
    void AddCommand(char * pch, int nLen);
    void SetCaret();
    void ScrollHorz(int nIdx);
    void ScrollVert(int nIdx);    
    BOOL IsHorzIn(void);
    BOOL IsVertIn(void);  
    void RestoreInput(void);  
    void HorzAjust(void);
    void VertAjust(void);
    void RedrawEdit(void);  
    void OnReturn(void);
    void OnMoveCaret(void);        
    void AddInputLine(void);
    void SwitchCaret(void);
    BOOL RecallPrev(void);
    BOOL RecallNext(void);
    
    // Generated message map functions
    //{{AFX_MSG(CShellWindow)
    afx_msg void OnChildActivate();
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnPaint();
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
    afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
    afx_msg void OnFileOpenlogfile();
    afx_msg void OnFileLoggingoff();
    afx_msg void OnUpdateFileLoggingoff(CCmdUI* pCmdUI);
    afx_msg void OnFileLoggingon();
    afx_msg void OnUpdateFileLoggingon(CCmdUI* pCmdUI);
    afx_msg void OnUpdateFileOpenlogfile(CCmdUI* pCmdUI);
    afx_msg void OnFileCloselogfile();
    afx_msg void OnUpdateFileCloselogfile(CCmdUI* pCmdUI);
    afx_msg void OnOptionsSethistorysize();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////(EOF)//////////////////////////////////////////
