/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SPATVW.CPP   1.13   13 Dec 1996 11:20:16   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SPATVW.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:16   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:14   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:30   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:28   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:51:02   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:50   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.4   09 Sep 1996 13:18:08   ZJRD
** No change.
** 
**    Rev 1.3   05 Sep 1996 11:29:40   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 09:56:44   ZJRD
** No change.
** 
**    Rev 1.1   28 Aug 1996 15:52:34   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.0   12 Aug 1996 10:56:00   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPATVW.CPP
//
//  Description: The implementation file for the class: CSpaTextView.
//
//  Author: Chen Jun
//
//  Date: 06/19/96
//
//  Modification:
//      1. 06/19/96, Initial version of the class: CSpaTextView.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "spamsg.h"
#include "spafrm.h"
#include "spaline.h"
#include "spatdoc.h"
#include "spatvw.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Global variables.

/////////////////////////////////////////////////////////////////////////////
// CSpaTextView

IMPLEMENT_DYNCREATE(CSpaTextView, CScrollView)

CSpaTextView::CSpaTextView()
{
}

CSpaTextView::~CSpaTextView()
{
}


BEGIN_MESSAGE_MAP(CSpaTextView, CScrollView)
	//{{AFX_MSG_MAP(CSpaTextView)
	ON_WM_SETFOCUS()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpaTextView common routine

void CSpaTextView::UpdateCoverageInfo(const CString& strModule)
{
	// Get the source file full path name.
	if ( strModule.IsEmpty() ) {
		return;
	}

	// Scroll to the top.
	SendMessage(WM_HSCROLL, SB_TOP);
	SendMessage(WM_VSCROLL, SB_TOP);
	
	// Get from the document.
	GetDocument()->UpdateDocument(strModule);
	
	// Update the entire view.
	InvalidateRect(NULL);
}

void CSpaTextView::DisplayDocContent(CDC* pDC)
{
	// Show nothing if no any contents.
	CObList* pList = GetDocument()->m_pLineList;
	if ( pList->IsEmpty() ) {
		return;
	}
	ASSERT(pList->GetCount() == GetDocument()->GetTotalSize().cy);
	
	// Display the document content.
	POSITION pos = pList->GetHeadPosition();
	int nLine(0);
    while ( pos ) {
        CSpaTextLine* pObj = (CSpaTextLine*)pList->GetNext(pos);
        CString strLine = pObj->GetText();
		if ( !pObj->GetGrayed() ) {
			pDC->SetBkColor(RGB(255,255,255));
			pDC->SetTextColor(RGB(0,0,255));
			pDC->TextOut(m_nFontWidth*4, m_nFontHeight*nLine, strLine);
		}
		else {
			pDC->SetBkColor(RGB(255,255,255));
			pDC->SetTextColor(RGB(192,192,192));
			pDC->TextOut(m_nFontWidth*4, m_nFontHeight*nLine, strLine);
		}
		nLine++;
    }
}


/////////////////////////////////////////////////////////////////////////////
// CSpaTextView drawing

void CSpaTextView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	// TODO: calculate the total size of this view
    SetScrollSizes(MM_TEXT, CSize(m_nFontWidth, m_nFontHeight));
}

void CSpaTextView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo)
{
    CScrollView::OnPrepareDC(pDC, pInfo);

    // TODO: add extra preparing DC code here
    
	// TODO: calculate the total size of this view
	CSize size(GetDocument()->GetTotalSize());
	CSize sizeTotal((size.cx+5)*m_nFontWidth, (size.cy+1)*m_nFontHeight);

	CSize sizePage(m_nFontWidth*10, m_nFontHeight*5);

	CSize sizeLine(m_nFontWidth*1, m_nFontHeight*1);

    SetScrollSizes(MM_TEXT, sizeTotal, sizePage, sizeLine);

    pDC->SelectStockObject(ANSI_FIXED_FONT);
}

CSpaTextDoc* CSpaTextView::GetDocument()
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSpaTextDoc)));
    return (CSpaTextDoc*)m_pDocument;
}

void CSpaTextView::OnDraw(CDC* pDC)
{
	// TODO: add draw code here
	
	// Display the document contents.
	DisplayDocContent(pDC);
}

/////////////////////////////////////////////////////////////////////////////
// CSpaTextView diagnostics

#ifdef _DEBUG
void CSpaTextView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CSpaTextView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSpaTextView message handlers

int CSpaTextView::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CScrollView::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
    // Set standard font.
    CDC* pDC = GetDC();

    pDC->SelectStockObject(ANSI_FIXED_FONT);

    TEXTMETRIC tm;
    pDC->GetTextMetrics(&tm);
    m_nFontWidth = tm.tmAveCharWidth;
    m_nFontHeight = tm.tmHeight + tm.tmExternalLeading;

    ReleaseDC(pDC);

	return 0;
}
