
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SRCCOM.H__   1.13   13 Dec 1996 11:20:18   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SRCCOM.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:18   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:16   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:32   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:30   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:48   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:12   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:00   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:14   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:50   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:18   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:34   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:42   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:18   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:28   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCCOM.H
//
//  Description:The header file for the class:
//              BrowseModuleList
//              SourceSearchData
//              JumpDataClass
//              LoadOptionClass
//              LoadInfoClass
//              SourceOptionClass
//              ExtNameList
//              SourceEmulation
//
//  Author:     Roger Zhang
//
//  Date:       05/12/95
//
//  Modification:
//
//      1. 05/12/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCCOM_
#define _SRCCOM_

#include "zqueue.h"

///////////////////// C Syntax Type /////////////////////////////////////////
enum { CSYN_KEYWORD, CSYN_COMMENT, CSYN_CODE, CSYN_STRING };

/////////////////////////////////////////////////////////////////////////////
//  BrowseModuleList
/////////////////////////////////////////////////////////////////////////////

class BrowseModuleList
{
public:
    enum { MAX_MODULES = 256 };
    int m_nCount;                       
    int m_nIndex;
    int m_nMax;
    unsigned long m_dwModule[MAX_MODULES];    
    
    BrowseModuleList(void) : m_nMax(10), m_nCount(0), m_nIndex(0) {}
    void Clean(void) { m_nCount = 0; m_nIndex = 0; }
    BOOL IsEmpty(void) const { return m_nCount == 0; }
    BOOL IsFull(void) const { return m_nCount == MAX_MODULES; }
    BOOL IsHead(void) const { return m_nIndex == 0; }
    BOOL IsTail(void) const { return m_nIndex == m_nCount - 1; }
    void GotoHead(void);
    void GotoTail(void);
    void GotoPrev(void);
    void GotoNext(void);
    unsigned long operator [] (int i) const { return m_dwModule[i]; }
    unsigned long GetElem(void) const { return m_dwModule[m_nIndex]; }
    BOOL AddTail(unsigned long dwModule);
    BOOL MoveIndex(unsigned long dwModule);
    void SetSize(int nMax);
};                                                                  

extern BrowseModuleList BrsMdl;
extern BrowseModuleList bwsBrsMdl;

/////////////////////////////////////////////////////////////////////////////
//  SourceSearchData
/////////////////////////////////////////////////////////////////////////////
class SourceSearchData 
{
public:
    BOOL    m_isCase;
    BOOL    m_isMatch;
    int     m_nUp;
    CString m_strText;
    CStringQueue  m_StrList;
    
    int     m_nCurLine;
    int     m_nCurCol;
    int     m_nInitLine;
    int     m_nInitCol;
    
    BOOL    m_isFirst;
    
    SourceSearchData(void)
    : m_strText(""), m_isCase(TRUE), m_isMatch(TRUE), m_nUp(1), 
      m_isFirst(FALSE), m_StrList(20)
    {}      
    
    void AddNew(const char * psz);
};

extern SourceSearchData SrcSrchData;       
extern BOOL isSrcSrchDlg;

/////////////////////////////////////////////////////////////////////////////
extern int      nBrowseLine;
extern unsigned uBrowseAddr;                                                 

/////////////////////////////////////////////////////////////////////////////
//  JumpDataClass
/////////////////////////////////////////////////////////////////////////////
                                
class JumpDataClass
{
public:
    BOOL    m_isInitPC;
    long    m_uAddr;
    JumpDataClass(void) : m_isInitPC(FALSE), m_uAddr(0) {}
};
                                
extern JumpDataClass JumpData; 

/////////////////////////////////////////////////////////////////////////////
//  LoadOptionClass
/////////////////////////////////////////////////////////////////////////////
class LoadOptionClass
{
public:
    BOOL    m_isCode;
    BOOL    m_isCpp;
    BOOL    m_isDemand;
    BOOL    m_isStatus;
    BOOL    m_isSymbol;
    BOOL    m_isWarnings;
    LoadOptionClass(void) 
    : m_isCode(TRUE), m_isSymbol(TRUE), m_isDemand(FALSE), 
      m_isCpp(FALSE), m_isWarnings(TRUE), m_isStatus(TRUE)
    {}                  
    BOOL ReadIni(void);
    BOOL WriteIni(void);
};    

extern LoadOptionClass LoadOpt;

/////////////////////////////////////////////////////////////////////////////
//  LoadInfoClass
/////////////////////////////////////////////////////////////////////////////

class LoadInfoClass
{
public:        
    CString m_strFile;
    CString m_strModule;
    unsigned long    m_lBytes;
    unsigned long    m_lModules;
    unsigned long    m_lSymbols;
    unsigned long    m_lTypes;
    unsigned long    m_lFunctions;
    unsigned long    m_lLines;
    unsigned long    m_lPC;
    unsigned long    m_lStackBase;
    unsigned long    m_lStackSize;    
    unsigned long    m_lSP;
    
    BOOL    m_isCancel;
    BOOL    m_isLoadEnd;

    LoadInfoClass(void)
    : m_strFile("None"), m_strModule("Module"),
      m_lBytes(0), m_lModules(0), m_lSymbols(0), m_lTypes(0),
      m_lFunctions(0), m_lLines(0), m_lPC(0),
      m_lStackBase(0), m_lStackSize(0x80L), m_lSP(7),
      m_isCancel(FALSE)
    {}  
};    

extern LoadInfoClass LoadInfo;

/////////////////////////////////////////////////////////////////////////////
//  SourceOptionClass
/////////////////////////////////////////////////////////////////////////////

class SourceOptionClass 
{
public:
    enum { DELIMIT_CR = 0, DELIMIT_LF = 1 };
    enum { MIN_TABWIDTH = 1, MAX_TABWIDTH = 32 };
    enum { MIN_BROWSE = 5, MAX_BROWSE = 20 };
    int m_nLineDelimit;
    int m_nTabWidth;
    int m_nBrowseHist;          
    BOOL m_isTabChanged;
    SourceOptionClass(void) 
    : m_nLineDelimit(0), m_nTabWidth(8), m_nBrowseHist(10),
      m_isTabChanged(FALSE) 
    {} 
    int Str2Tab(const CString &str) const;
    int Str2Hist(const CString &str) const;
};
                      
extern SourceOptionClass SrcOpt;                      

/////////////////////////////////////////////////////////////////////////////
//  ExtNameList
/////////////////////////////////////////////////////////////////////////////

class ExtNameList : public CStringList 
{
public:                    
    ExtNameList(int nBlockSize = 10) : CStringList(nBlockSize)
    {
        AddTail(".C");
        AddTail(".CPP");
        AddTail(".ASM");
    }
};
                     
extern ExtNameList ExtList;                     
/////////////////////////////////////////////////////////////////////////////
extern CStringQueue  SrcPathList;

/////////////////////////////////////////////////////////////////////////////
extern BOOL isLineNo;
extern BOOL isBwsLineNo;
extern BOOL isSymDsm;          

/////////////////////////////////////////////////////////////////////////////
//  SourceEmulation
/////////////////////////////////////////////////////////////////////////////

class SourceEmulation
{
public:           
    enum { EMU_HALT, EMU_RUN, EMU_STEP };

    BOOL    m_isIntoCall;       // or Until Call
    BOOL    m_isOverReturn;     // or Until Return
    
    int     m_nStepCount;       
    int     m_nStepOpt;         // 0:Step Instruction
                                // 1:Step Statement
                                // 2:Step Line
    
    BOOL    m_isRunAccess;                              
    
    BOOL    m_isStatement;
    
    int     m_nEmuStatus;
    
    long    m_lPCAddr;  // > 0xFFFFL --> Invalid
    int     m_nPCLine;  // < 0       --> Invalid
    unsigned long m_dwPCModule;
    int     m_nPCFirst; // First column of PC statement
    int     m_nPCLast;  // Last column of PC statement

    SourceEmulation(void)
    : m_isIntoCall(TRUE), m_isOverReturn(TRUE), m_nStepCount(1),
      m_nStepOpt(0), m_isRunAccess(TRUE), 
      m_nEmuStatus(EMU_HALT), m_lPCAddr(0x10000L), m_nPCLine(-1),
      m_isStatement(FALSE)
    {}             
    BOOL   GetPC(void);
    BOOL   GetModule(void);             
    BOOL   IsPCModule(unsigned long dwModule) const; 
};

extern SourceEmulation  SrcEmu;

/////////////////////////////////////////////////////////////////////////////
//
long Str2Addr(const char * s);
BOOL IsDelimit(char ch);

/////////////////////////////////////////////////////////////////////////////
//  extern global functions
/////////////////////////////////////////////////////////////////////////////
extern long SrcGetPC(void);                                                  
extern int SrcLoadFile(const char * str);
extern int SrcLoadPCModule(void);  
extern int SrcLoadModule(unsigned long dwModule, BOOL isHist = TRUE);  
extern int BwsLoadModule(unsigned long dwModule, BOOL isHist = TRUE);  
extern BOOL SrcInitModule(void);
extern void SrcCleanAsm(void);
extern void SrcCleanMix(void);   
extern void BwsCleanAsm(void);
extern void BwsCleanMix(void);   

extern CString SrcGetModuleFullName(const char * pszModuleName);
extern int SrcModuleName2Index(const char * pszModule, 
                unsigned long & dwModule);
extern int SrcDispMode(void);

// functions from bright
extern BOOL BptSearchBpt(unsigned short addr, BYTE &eFlag);
extern BOOL BptGetOneBpt(short num, unsigned short *addr);
extern BOOL BptAddBptfromWnd(unsigned short addr);
extern BOOL BptClrOneBptfromWnd(unsigned short addr);
extern BOOL BptClrAllBptfromWnd(void);
extern BOOL BptEnableBpt(unsigned short addr); 
extern BOOL BptDisableBpt(unsigned short addr);

// Functions from gates
extern int SymToAddr(char *lpStr, unsigned char* lpType, 
            unsigned long* lpAddr );
extern int SrcIsLoaded(void);
extern int SrcIsStatement(void);
extern int SrcGetStartAddress( unsigned long & addr );
extern int SrcCheckModuleHasLineInfo(unsigned long dwModule);
extern "C" {
extern int SrcGetNextFunc(unsigned long funcDesc,LPSTR funcName,
    unsigned long& nextDesc);
extern int SrcGetFirstFuncIndex(unsigned long moduleDesc,
    unsigned long& funcDesc);
extern int SrcGetLdrStats(LPSTR moduleName,unsigned long *numSymbols,
    unsigned short *numModules, unsigned long *numTypes , 
    unsigned long *numFuncs , unsigned long *linenums, unsigned long *bytes,
    int * percent);
extern int SrcGetLoadPath( CString& str );
extern int SrcAddr2Statement(unsigned long addr, unsigned short& linenum,
    unsigned short& startCol, unsigned short& endCol,
    unsigned long& moduleDesc);
extern int SrcGetModuleRange(unsigned long moduleDesc , unsigned long& start, 
    unsigned long & end);
extern int SrcAddr2Linenum(unsigned long dwAddr, unsigned short & uLinenum,
    unsigned long & dwModuleIdx);
extern int SrcLinenum2Addr(unsigned long dwModuleIdx, 
    unsigned short uLinenum, unsigned long & dwAddr);    
extern int SrcLinenum2Range(unsigned long dwModuleIdx, 
    unsigned short uLinenum, 
    unsigned long & dwStartAddr, unsigned long & dwEndAddr);    
extern int SrcGetModuleName(unsigned long dwModule, LPSTR lpszName);
extern int SrcGetModuleNum(unsigned short & uNum);
extern int SrcGetModuleIndex(unsigned short uNum, unsigned long * pBuf, 
    unsigned short & uRealNum);               
}
#endif
////////////////////////////(EOF)////////////////////////////////////////////                 
                 
