
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SRCFILE.H__   1.13   13 Dec 1996 11:20:20   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SRCFILE.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:20   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:18   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:34   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:32   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:28   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:48   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:38   ZJRD
** PIC/SLD Version 0.92
** 
**    Rev 1.5   09 Oct 1996 13:46:32   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:34   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:48:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:29:54   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:07:40   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:10   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCFILE.H
//
//  Description:The header file for the class: 
//                  SourceAssemble
//                  SourceMixed
//
//  Author:     Roger Zhang
//
//  Date:       06/20/95
//
//  Modification:
//
//      1. 06/20/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCFILE_
#define _SRCFILE_

/////////////////////////////////////////////////////////////////////////////
#define SRCMDL      (MdlInfo.m_Module[MdlInfo.m_nModuleIdx])                    
#define SRCLINES    (int(SRCMDL.m_Src.m_lCount))
#define MIXLINES    (SrcMix.m_AsmList.GetCount() + SrcMix.m_nSrcLines)
#define ASMLINES    (SrcAsm.m_AsmList.GetCount())

#define BWSSRCMDL   (bwsMdlInfo.m_Module[bwsMdlInfo.m_nModuleIdx])                    
#define BWSSRCLINES (int(BWSSRCMDL.m_Src.m_lCount))
#define BWSMIXLINES (BwsMix.m_AsmList.GetCount() + BwsMix.m_nSrcLines)
#define BWSASMLINES (BwsAsm.m_AsmList.GetCount())

/////////////////////////////////////////////////////////////////////////////
//  Assembly Line Element
/////////////////////////////////////////////////////////////////////////////
class AsmLine
{
public:                   
    char             m_chLabel;    // 1:Label, 0:Not Label
    unsigned short   m_uAddr;
    CString          m_strText;
};

/////////////////////////////////////////////////////////////////////////////
// Assembly mode class : SourceAssemble                                     
/////////////////////////////////////////////////////////////////////////////
class SourceAssemble
{
public:
    enum { MAX_CHECK = 3 };
    enum { MAX_RANGE = 256 };   // Address Range
    enum { MAX_PAGE = 128 };    // Address Page
    
    CPtrList    m_AsmList;      
    
    int         m_nOffset;		// the offset to the start address
    int         m_nIndex;       // the index to the start address
    
    long		m_lStartAddr;	// the address of the 1st element in the list
    long		m_lRange;		// the address range of the list
        
    SourceAssemble(void); 
    ~SourceAssemble();
    
    void DeleteList(void);         
    BOOL Dsm(unsigned short uAddr);
    BOOL DsmPrev(void);
    BOOL DsmNext(void);                                   
    AsmLine * GetLine(int nLine) const;
    BOOL CheckAddr(unsigned short uAddr) const;
    int MatchAddr2Line(long lAddr) const;
    int Addr2Line(long lAddr) const;
    long Line2Addr(int nLine) const;
    int MatchAddr2LineL(long lAddr) const;
    int Addr2LineL(long lAddr) const;
    long Line2AddrL(int nLine) const;
    BOOL IsHome(void) const;
    BOOL IsEnd(void) const;
    BOOL IsLabelLine(int nLine);
private:
    BOOL Dsm(unsigned short uAddr, unsigned short uRange);            
    BOOL DsmAddr(unsigned short uStart, unsigned short uChk);
};

extern SourceAssemble SrcAsm;
extern SourceAssemble BwsAsm;
/////////////////////////////////////////////////////////////////////////////     
// Mixed Mode Class : SourceMixed
/////////////////////////////////////////////////////////////////////////////
class SourceMixed
{
public:                   
    enum { MAX_RANGE = 256 };   // Address Range
    enum { MAX_PAGELINE  = 32 };
    enum { MIN_LINES = 128 };      
    
    CPtrList    m_AsmList;      
    
    int         m_nAsmPos[MIN_LINES];    // source line index - offset 
                                         // as array index
    int         m_nSrcStart;	// the line number of the 1st element
    int         m_nSrcLines;    // lines in the list                
    
    int         m_nOffset;      // offset in the list
    int         m_nIndex;		// index in the list
    int         m_bBrowse;
    
    #ifdef _DEBUG
    void DumpFile(const char * pszFileName) const;
    #endif
                
    SourceMixed(BOOL bBrowse);            
    ~SourceMixed();
    void DeleteList(void);
    BOOL GetLineAddr(int nLine, unsigned short &uAddr, 
        unsigned short &uRange); 
    BOOL Dsm(int nLine);
    BOOL DsmPrev(void);
    BOOL DsmNext(void);                                   
    AsmLine * GetLine(int nSrcLine, int nAsmLine) const;
    BOOL IsHome(void) const;
    BOOL IsEnd(void) const;     
    int  Line2Ofs(int nSrc, int nAsm) const;
    int  Ofs2Line(int nOfs, int &nAsm) const;      
    int  Addr2Ofs(unsigned short uAddr) const;
private:    
    BOOL Dsm(unsigned short uAddr, unsigned short uRange);            
    BOOL DsmLine(int nLine);
    BOOL DsmLine(int nLine, int nCount, int nSrcLines);
    int  GetNextAsmLine(int nLine) const;
    int  GetAsmLines(int nLine) const;
};

extern SourceMixed SrcMix;
extern SourceMixed BwsMix;
       

#endif
//////////////////////////(EOF)//////////////////////////////////////////////
