
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SRCLIST.CPP   1.13   13 Dec 1996 11:20:22   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SRCLIST.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:22   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:20   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:36   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:34   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:40   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:52   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:12   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:46   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:32:48   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:46:44   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:27:48   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:06   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:26   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCLIST.CPP
//
//  Description:The implement file for the class: 
//                  SyntaxColorList
//                  TabExpandList
//                  SourceIndexList
//                  SourceList
//
//  Author:     Roger Zhang
//
//  Date:       06/10/95
//
//  Modification:
//
//      1. 06/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "zqueue.h"                                      
#include "srccom.h"                                      
#include "zlist.h"                    
#include "srclist.h"

///////////////////////////////////////////////////////////////////////////// 
// Syntax color list 
/////////////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
void SyntaxColorElement::Dump(void) const
{         
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_nFirstCol = %n, m_nLastCol = %n\n", 
            m_nFirstCol, m_nLastCol);
        if(m_nSyntaxType == CSYN_CODE)
            fprintf(pSListDebug, "Syntax Type : Code\n");    
        else if(m_nSyntaxType == CSYN_KEYWORD)
            fprintf(pSListDebug, "Syntax Type : Keyword\n");    
        if(m_nSyntaxType == CSYN_COMMENT)
            fprintf(pSListDebug, "Syntax Type : Comment\n");    
    #else
        TRACE("m_nFirstCol = %n, m_nLastCol = %n\n", m_nFirstCol, m_nLastCol);
        if(m_nSyntaxType == CSYN_CODE)
            TRACE("Syntax Type : Code\n");    
        else if(m_nSyntaxType == CSYN_KEYWORD)
            TRACE("Syntax Type : Keyword\n");    
        if(m_nSyntaxType == CSYN_COMMENT)
            TRACE("Syntax Type : Comment\n");    
    #endif
}
#endif

#ifdef _DEBUG
void SyntaxColorList::Dump(void) const
{                                
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Syntax Color List--\n");
    #else
        TRACE("--Dump Syntax Color List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SyntaxColorList::AddElement(int nFirst, int nLast, int nType)
{   
    ASSERT(nFirst <= nLast);
    
    SyntaxColorElement * p;
    
    if(IsFull())  return ELIST_FULL;                            
    if(!IsEmpty()) {
        p = (SyntaxColorElement *)(m_pTail->m_pElem);
        if(p->m_nSyntaxType == nType) {
            p->m_nLastCol = nLast;  return ELIST_OK;
        }
    }
    p = new SyntaxColorElement(nFirst, nLast, nType);
    if(!p)  return  ELIST_MEM;
    else    return  AddTail(p);
}                              

///////////////////////////////////////////////////////////////////////////// 
// Tab Expand List 
/////////////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
void TabExpandElement::Dump(void) const
{                            
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_nTabPos = %n, m_nTabAdd = %n\n", 
            m_nTabPos, m_nTabAdd);
    #else
        TRACE("m_nTabPos = %n, m_nTabAdd = %n\n", m_nTabPos, m_nTabAdd);
    #endif
}
#endif

#ifdef _DEBUG
void TabExpandList::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Tab Expand List--\n");
    #else
        TRACE("--Dump Tab Expand List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int TabExpandList::AddElement(int nPos, int nAdd)
{
    if(IsFull())  return ELIST_FULL;
    TabExpandElement * p = new TabExpandElement(nPos, nAdd);
    if(!p)  return  ELIST_MEM;
    else    return  AddTail(p);
}                                   
 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Search nPos in the List
//
//  Input:  
//
//  Output: 
//
//  Return: nTabAdd -- expanded number 
//
/////////////////////////////////////////////////////////////////////////////
int TabExpandList::Search(int nPos) const
{
    if(IsEmpty()) return  0;
    SListNode * p = m_pHead;              
    TabExpandElement * p1;
    do {   
        p1 = (TabExpandElement *)(p->m_pElem);
        if(p1->m_nTabPos == nPos)   return  p1->m_nTabAdd;
    } while((p = p->m_pNext)!=0);                         
    return  0;
}
 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: position after expanded 
//
/////////////////////////////////////////////////////////////////////////////
int TabExpandList::Expand(int nPos) const
{
    if(IsEmpty()) return  nPos;
    SListNode * p = m_pHead;              
    TabExpandElement * p1;
    int n = nPos;
    do {   
        p1 = (TabExpandElement *)(p->m_pElem);
        if(p1->m_nTabPos < nPos) n += p1->m_nTabAdd;   
        else break;
    } while((p = p->m_pNext)!=0);                         
    return  n;
}
                    
///////////////////////////////////////////////////////////////////////////// 
// Source index list 
/////////////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
void SourceIndexElement::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_pSrc = %p, m_nIdx = %ld\n", m_pSrc, m_nIdx);
    #else  
        TRACE("m_pSrc = %p, m_nIdx = %ld\n", m_pSrc, m_nIdx);
    #endif
}
#endif

#ifdef _DEBUG
void SourceIndexList::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Source Index List--\n");
    #else
        TRACE("--Dump Source Index List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceIndexList::AddElement(SListNode * pSrc, int nIdx)
{
    ASSERT(pSrc);
    
    if(IsFull())  return ELIST_FULL;
    SourceIndexElement * p = new SourceIndexElement(pSrc, nIdx);
    if(!p)  return  ELIST_MEM;
    else    return  AddTail(p);
} 

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceIndexElement * SourceIndexList::Search(int nIdx)
{
    SourceIndexElement * p = (SourceIndexElement *)GetFirst();
    while(p) {
        if(nIdx >= p->m_nIdx && nIdx < p->m_nIdx + INDEX_DELTA)
            return p;
        p = (SourceIndexElement *)GetNext();
    }
    return  0;
}

///////////////////////////////////////////////////////////////////////////// 
// Source List 
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceElement::~SourceElement(void)
{
    if(m_nLength)    delete [] m_szLine;
}

#ifdef _DEBUG
void SourceElement::Dump(void) const
{       
    #ifdef _FDEBUG
        if(m_nLength > 0)
            fprintf(pSListDebug, "m_szLine = %s, m_nLength = %n\n", 
                m_szLine, m_nLength);
        else
            fprintf(pSListDebug, "m_szLine = (null), m_nLength = 0\n");
    #else  
        if(m_nLength > 0)
            TRACE("m_szLine = %s, m_nLength = %n\n", m_szLine, m_nLength);
        else
            TRACE("m_szLine = (null), m_nLength = 0\n");
    #endif    
    m_Color.Dump();
    m_Tab.Dump();
}
#endif

#ifdef _DEBUG
void SourceList::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Source List--\n");
    #else
        TRACE("--Dump Source List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceElement * SourceList::Search(SListNode * pIdx, int nDelta)
{
    Set(pIdx);
    SourceElement * p = (SourceElement *)Get();
    while(nDelta--) p = (SourceElement *)GetNext();
    return p;
}
        

/////////////////////////////(EOF)///////////////////////////////////////////
