
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/STKFMT.CPP   1.13   13 Dec 1996 11:20:26   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/STKFMT.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:20:26   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:26   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:40   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:06   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:30   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:18   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:32   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:06   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:50   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:18   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:24   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:46   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:44   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKFMT.CPP
//
//  Description: The implementation file fore class: CStackFormatDialog.
//
//  Author: Chen Jun
//
//  Date: 08/22/95
//
//  Modification:
//      1. 08/22/95, Initial version of the class: CStackFormatDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "stkfmt.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
BOOL bStkShowAddress = TRUE;
BOOL bStkShowEntryPoint = TRUE;
BOOL bStkShowModule = TRUE;
BOOL bStkShowParameters = TRUE;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void StkUpdateStackWindow(BOOL bUpdateStackOnly = FALSE);


/////////////////////////////////////////////////////////////////////////////
// CStackFormatDialog dialog

CStackFormatDialog::CStackFormatDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CStackFormatDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CStackFormatDialog)
    m_bAddress = FALSE;
    m_bEntryPoint = FALSE;
    m_bModule = FALSE;
    m_bParameters = FALSE;
    //}}AFX_DATA_INIT
}

void CStackFormatDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CStackFormatDialog)
    DDX_Check(pDX, IDC_CHECK_STK_FORMAT_ADDRESS, m_bAddress);
    DDX_Check(pDX, IDC_CHECK_STK_FORMAT_ENTRYPOINT, m_bEntryPoint);
    DDX_Check(pDX, IDC_CHECK_STK_FORMAT_MODULE, m_bModule);
    DDX_Check(pDX, IDC_CHECK_STK_FORMAT_PARAMETERS, m_bParameters);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CStackFormatDialog, CDialog)
    //{{AFX_MSG_MAP(CStackFormatDialog)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStackFormatDialog message handlers

BOOL CStackFormatDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Retrieve from the global flags.
    m_bAddress = ::bStkShowAddress;
    m_bEntryPoint = ::bStkShowEntryPoint;
    m_bModule = ::bStkShowModule;
    m_bParameters = ::bStkShowParameters;
    
    // Set the initial value.
    UpdateData(FALSE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CStackFormatDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CStackFormatDialog::OnOK()
{
    // TODO: Add extra validation here
    
    // Set to the global flags.
    UpdateData();

    if ( m_bAddress != ::bStkShowAddress ||
         m_bEntryPoint != ::bStkShowEntryPoint ||
         m_bModule != ::bStkShowModule ||
         m_bParameters != ::bStkShowParameters ) {
        
        // Update flags.
        ::bStkShowAddress = m_bAddress;
        ::bStkShowEntryPoint = m_bEntryPoint;
        ::bStkShowModule = m_bModule;
        ::bStkShowParameters = m_bParameters;
        
        // Update Stack window.
        ::StkUpdateStackWindow(TRUE);
    }
    
    CDialog::OnOK();
}
