
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/STKINIT.H__   1.13   13 Dec 1996 11:20:28   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/STKINIT.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:28   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:28   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:42   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:42   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:36   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:56   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:46   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:00   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:36   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:34:50   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:49:00   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:30:08   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:07:54   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:14   ZJRD
** Initial revision.
** 
****************************************************************************/

#ifndef _STKINIT_H_

#define _STKINIT_H_

struct STKNode {
    int num;
    int flag;
    U32 desc;
    U32 desc1;
    U32 sp;
    U32 addr;
    U32 addr1;
    struct STKNode *next ;
    struct STKNode *prev;

public :
    STKNode() {
        num = 0;
        flag = 0;
        desc = 0L;
        desc1 = 0L;
        sp = addr = addr1 = 0L;
        next = prev = 0;
    }
};

class stkServer {
private :
    struct STKNode *stkListHeader ;
    struct STKNode *curNode ;
    char *m_buff;
    SYM_DESCRIPTOR m_blockDesc ;
    SYM_DESCRIPTOR m_varDesc ;

public:
	int m_nOverflow;	//  0 - normal, 1 -overflow, -1 - underflow
	
public :
    stkServer() {
        stkListHeader = 0;
        curNode = 0;
        m_buff = 0;
        m_blockDesc = NULL_SYMBOL;
        m_varDesc = NULL_SYMBOL;
        m_nOverflow = 0;
    }

public :     
    struct STKNode * GetHeader(void) { return stkListHeader; }
    int buildStack();
    int add(struct STKNode *node);
    void deleteAll();
    void DisplayToShell();
    int IsValidVar(char *command,BOOLEAN& isGlobal,SYM_DESCRIPTOR& symDesc);
    void GetNumber(int& num) {
        if ( curNode ) num = curNode->num + 1;
        else num = 0;
    };                          
    int InitStkLocalVar(int nLevel);
    int GetStkLocalVar(SYM_DESCRIPTOR& desc,CString& name);
};

#endif
