
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SYMCALC.H__   1.13   13 Dec 1996 11:20:42   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SYMCALC.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:42   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:40   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:56   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:56   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:04   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:26   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:14   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:28   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:02   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:42   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:08   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:14   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:38   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:19:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMCALC.H
**
**  Description:
**      C expression calculate basic class : CSymCalc (SYM_TOKEN_NODE)
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   21 March 1996 10:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMCALC_H_
#define _SYMCALC_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symtoken.h"
//#include "symsyn.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

    
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        

class CSymCalc {
//private :
public:
    SYMTOKENTYPE symType ;
    int typeOpt;
    BUILT_IN_TYPE typeValue;
    ExpressionValue result;
    SYM_DESCRIPTOR symDesc;
    ADDRESS_TYPE addr;
	TYPE_INDEX typeIndex;
	BOOLEAN isGlobal;
	int nComplexType;
	int m_nFlag;
	int m_nTkNum;

public :
    CSymCalc() {
        symType = SYMTOKEN_UNKNOWN;
        typeOpt = 0;       
        typeValue = BI_UNKNOWN;
        result.l = 0L;
        symDesc = 0L;
        nComplexType = 0;                 
        m_nFlag = -1;
        m_nTkNum = -1;
    }
    CSymCalc(SYM_TOKEN_NODE *pNode) {
    	symType = pNode->symType;
    	typeOpt = pNode->typeOpt;
    	typeValue = pNode->typeValue;
    	memcpy( &result , &pNode->result , sizeof( ExpressionValue ) );
    	symDesc = pNode->symDesc;    
    	addr.segType = pNode->addr.segType;
    	addr.addr = pNode->addr.addr;      
    	typeIndex = pNode->typeIndex;
    	isGlobal = pNode->isGlobal;
    	nComplexType = pNode->nComplexType;
        m_nFlag = -1;
        m_nTkNum = pNode->nTkNum;
    }
    CSymCalc(CSymCalc *pNode) {
    	symType = pNode->symType;
    	typeOpt = pNode->typeOpt;
    	typeValue = pNode->typeValue;
    	memcpy( &result , &pNode->result , sizeof( ExpressionValue ) );
    	symDesc = pNode->symDesc;    
    	addr.segType = pNode->addr.segType;
    	addr.addr = pNode->addr.addr;      
    	typeIndex = pNode->typeIndex;
    	isGlobal = pNode->isGlobal;
    	nComplexType = pNode->nComplexType;
        m_nFlag = pNode->m_nFlag;
        m_nTkNum = pNode->m_nTkNum;
    }
	~CSymCalc() {
	}

public :
	void AddOneDim(void) {
		typeOpt++;
	}
	int GetDimNum(void) {
		return typeOpt;
	}
	 	
public :
	int ModifyResult(int nResultFlag);
	int CheckValue(void);
	int CheckOneOperate(int nType);
	int CheckTwoOperate(CSymCalc* pNode1,int nType);
	int CheckAssignOperate(CSymCalc *pNode1, int nType);
	int CheckOperate(int nType);
	int Increment(void);
	int Decrement(void);
	int Plus(void);
	int Minus(void);
	int BitNot(void);
	int LogNot(void);
	int operator+(CSymCalc& pNode1);
	int operator-(CSymCalc& pNode1);
	int operator*(CSymCalc& pNode1);
	int operator/(CSymCalc& pNode1);
	int operator%(CSymCalc& pNode1);
	int operator>>(CSymCalc& pNode1);
	int operator<<(CSymCalc& pNode1);
	int operator<(CSymCalc& pNode1);
	int operator>(CSymCalc& pNode1);
	int operator<=(CSymCalc& pNode1);
	int operator>=(CSymCalc& pNode1);
	int operator==(CSymCalc& pNode1);
	int operator!=(CSymCalc& pNode1);
	int operator&(CSymCalc& pNode1);
	int operator^(CSymCalc& pNode1);
	int operator|(CSymCalc& pNode1);
	int operator&&(CSymCalc& pNode1);
	int operator||(CSymCalc& pNode1);           
	int PointValue(void);
	int GetValue(void);
	int CheckStructOpt(CSymCalc* pNode1,int nType);
//	int Struct(CSymCalc* pNode1,int nType);
//	int Struct(CSymCalc* pNode1,int nType,class CSymSyntax *pObj);
	int Struct(CSymCalc* pNode1,int nType,void *pVoid);
	int CheckArrayOperate(CSymCalc* pNode1,int& nType ,unsigned long& ul);
	int CArray(unsigned long ul);	    
	int Omf51Array(unsigned long* pArray , int nDim);
	int Assignment(CSymCalc* pNode1,void* pVoid);
	int SetValue(CSymCalc* pNode1,void* pVoid);
	
	int ConvertValue(unsigned char& uc);
	int ConvertValue(unsigned short& ui);
	int ConvertValue(unsigned long& ul);
	int ConvertValue(char& c);
	int ConvertValue(short& i);
	int ConvertValue(long& l);
	int ConvertValue(float& f);
	int ConvertValue(double& d);
	void Display(void);
	int GetStatus(BOOL& bResult);
	int DisplayValue(char* temp);
};   
                
                
#endif
/******************************** E O F ***********************************/
