
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/SYMCLI.H__   1.13   13 Dec 1996 11:20:42   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/SYMCLI.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:20:42   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 11:01:42   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:48:58   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 13:00:56   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:47:04   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:49:22   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:42:16   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:16:32   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:46:08   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:33:44   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:47:42   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:28:52   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:06:58   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:18:48   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symcli.h
**
**  Description:
**     Prototype for the symbol server CLI parse routines
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/PICSLDV/SRC/LOG/SYMCLI.H__   1.13   13 Dec 1996 11:20:42   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basewind.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


//--------------------------------------------------------------------------
// SendMessageToCli
//--------------------------------------------------------------------------
RETCODE SendMessageToCli(U8 FAR *msgPtr);


/***************************************************************************
** RemoveSymbols
**
** Description: Removes all loaded symbols and reinitializes the symbol
**              table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT RemoveSymbols(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** DisplaySymbols
**
** Description: Prints all symbols in the symbol table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT DisplaySymbols(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// Count
//
// Displays the number of symbols in the various tables
//--------------------------------------------------------------------------
RETCODE EXPORT
Count(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// NameOf
//
// Converts an address into a symbol and displays it
//--------------------------------------------------------------------------
RETCODE EXPORT
NameOf(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// AddressOf
//
// Converts a symbol path and name into an address; uses #mod#func#var
//   naming convention
//--------------------------------------------------------------------------
RETCODE EXPORT
AddressOf(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolOpenFile
//
// Sets symbol output to go to <file>.
// Only one parameter is allowed - the path and filename
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolOpenFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolCloseFile
//
// Closes file opened by SymbolOpenFile
// No parameters are allowed.
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolCloseFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// DisplayTypes
//
// Diplay all types in symbol table.
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT
DisplayTypes(LPSTR cmdString, U32 argc, U32 argv[]);

/****************************************************************************
**
**  TskCheckAbort
**
**  Description:
**    Acts as replacement for Windows API function GetAsyncKeyState(VK_ESCAPE)
**    As such it should match its behavior and return type.
**    This new version only calls when the app is active, as
**    defined by the "appIsActive" flag.  This is a crude
**    indication of focus.
**
**  Parameters:
**     aborted   flag: FALSE if esc not pressed, TRUE if pressed.
**
*****************************************************************************/

RETCODE EXPORT TskCheckAbort(BOOLEAN FAR *abort);

#ifdef __cplusplus
}
#endif

#define _SYMCLI_
#endif
/******************************** E O F ***********************************/
