
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/BMEMVIEW.CPP   1.29   02 Apr 1996 09:26:22   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/BMEMVIEW.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:26:22   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:44   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:24   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:58   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:36   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:30   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:48   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:16   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:42   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:30   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:02   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:10   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:24   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:10   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:58   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:33:10   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:28   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:32   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:38   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:49:02   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:38   Shirley
** EasyPack/SLD Version 0.1f
**
**    Rev 1.4   13 Oct 1995 13:18:26   Shirley
** No change.
**
**    Rev 1.3   29 Sep 1995 09:47:50   Shirley
** No change.
**
**    Rev 1.2   20 Sep 1995 10:58:10   Shirley
** No change.
**
**    Rev 1.1   15 Sep 1995 09:48:48   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:54:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BMEMVIEW.CPP
//
//  Description:The implement file for the class: CBMemoryView
//
//  Author:     Lane Li         &       Daniel Lin
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 10/19/95, Initial version
//              modified function
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// bmemview.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "uicom.h"
#include "xview.h"
#include "bmemwnd.h"
#include "bmemview.h"
#include "grid.h"
#include "nwmemwnd.h"
#include "nwmem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern long MemServerDump(BYTE*, long, long, int);
extern int MemServerFill(long, BYTE, int);

void CBMemoryView::SetMyCaret()
{
        POINT pos = GetScrollPosition();
        pos.x = m_nTextBegin + m_pointCaret.x*m_nDxWidth;
        pos.y = m_pointCaret.y*m_nDxHeight - pos.y + 1;
        SetCaretPos(pos);
}

BOOL CBMemoryView::IsCaretIn()
{
        POINT pos;
        RECT rect;
        int y1,y2;

        pos = GetScrollPosition();
        GetClientRect(&rect);

        if ((pos.y%m_nDxHeight)>0) y1=pos.y/m_nDxHeight + 1;
        else y1 = pos.y/m_nDxHeight;

        y2 = (pos.y+rect.bottom)/m_nDxHeight-1;

        if ((y1<=m_pointCaret.y)&&(m_pointCaret.y<=y2)) return TRUE;
        else return FALSE;
}

void CBMemoryView::SwitchBit(POINT pos)
{
        BYTE value,value2;
        value = m_bBitMem[pos.y*8+pos.x];

        BeginWaitCursor();
/*
        switch (pos.x)
        {
                case 7:
                        if (value&0x1) value-=0x1;
                        else value+=0x1;
                        break;
                case 6:
                        if (value&0x2) value-=0x2;
                        else value+=0x2;
                        break;
                case 5:
                        if (value&0x4) value-=0x4;
                        else value+=0x4;
                        break;
                case 4:
                        if (value&0x8) value-=0x8;
                        else value+=0x8;
                        break;
                case 3:
                        if (value&0x10) value-=0x10;
                        else value+=0x10;
                        break;
                case 2:
                        if (value&0x20) value-=0x20;
                        else value+=0x20;
                        break;
                case 1:
                        if (value&0x40) value-=0x40;
                        else value+=0x40;
                        break;
                case 0:
                        if (value&0x80) value-=0x80;
                        else value+=0x80;
                        break;
                default:
                        break;
        }
*/
        if (value&0x1) value = 0;
        else value = 1;

#ifdef _LANE
        MemServerFill((long)(pos.y*8+pos.x), value, 5);
        MemServerDump(&value2, (long)(pos.y*8+pos.x), 1, 5);
#endif

        m_bBitMem[pos.y*8+pos.x] = value2;
        if (value!=value2) MessageBeep(-1);
        else
        {
                if (isMemOn[0]&&(((CNewMemory *)pMemWnd[0])->m_nSpaceType==3))
                {
                ((CNewMemory *)pMemWnd[0])->m_bGridRedraw=FALSE;
                        pMemWnd[0]->InvalidateRect(NULL,FALSE);
                }
                if (isMemOn[1]&&(((CNewMemory *)pMemWnd[1])->m_nSpaceType==3))
                {
                ((CNewMemory *)pMemWnd[1])->m_bGridRedraw=FALSE;
                        pMemWnd[1]->InvalidateRect(NULL,FALSE);
                }
                if (isMemOn[2]&&(((CNewMemory *)pMemWnd[2])->m_nSpaceType==3))
                {
                ((CNewMemory *)pMemWnd[2])->m_bGridRedraw=FALSE;
                        pMemWnd[2]->InvalidateRect(NULL,FALSE);
                }
        }
        EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
// CBMemoryView

IMPLEMENT_DYNCREATE(CBMemoryView, CScrollView)

CBMemoryView::CBMemoryView()
{
        m_pParent = NULL;
        m_nTextBegin = 30;
        m_nDxWidth = 15;
        m_nDxHeight = 15;
        m_pointCaret.x = 0;
        m_pointCaret.y = 0;

        m_bBitMem = new BYTE[0xff];
        int i;
        for(i=0;i<0xff;i++)
                m_bBitMem[i]=0;
}

CBMemoryView::~CBMemoryView()
{
        delete m_bBitMem;
}

BEGIN_MESSAGE_MAP(CBMemoryView, CScrollView)
        //{{AFX_MSG_MAP(CBMemoryView)
        ON_WM_CREATE()
        ON_WM_SIZE()
        ON_WM_LBUTTONDOWN()
        ON_WM_VSCROLL()
        ON_WM_KEYDOWN()
        ON_WM_KEYUP()
        ON_WM_LBUTTONDBLCLK()
        ON_WM_RBUTTONDOWN()
        ON_COMMAND(ID_EDIT_BIT, OnEditBit)
        ON_UPDATE_COMMAND_UI(ID_EDIT_BIT, OnUpdateEditBit)
        ON_WM_SETFOCUS()
        ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBMemoryView drawing

void CBMemoryView::OnInitialUpdate()
{
        CScrollView::OnInitialUpdate();

        CSize sizeTotal;
        // TODO: calculate the total size of this view
        RECT rect;
        SIZE size1,size2;

        sizeTotal.cx = 0;
        sizeTotal.cy = m_nDxHeight*31;
        size1.cx = 0;
        size1.cy = m_nDxHeight*3;
        size2.cx = 0;
        size2.cy = m_nDxHeight;
        SetScrollSizes(MM_TEXT, sizeTotal,size1, size2);

        m_pParent=GetParent();
        ((CBMemoryWindow *)m_pParent)->m_pView = this;
        m_pParent->GetWindowRect(&rect);
        m_pParent->MoveWindow(rect.left,
                rect.top,
                rect.right-rect.left+1,
                rect.bottom-rect.top+1);
/*        m_pParent->SetWindowPos(NULL,
                rect.left,
                rect.top,
                rect.right-rect.left+1,
                rect.bottom-rect.top+1,
                SWP_NOZORDER|SWP_NOMOVE);
*/                

#ifdef _LANE
        MemServerDump(m_bBitMem, 0, 0xf8, 5);
#endif

        InvalidateRect(NULL,TRUE);
}

void CBMemoryView::OnDraw(CDC* pDC)
{
        CDocument* pDoc = GetDocument();
        // TODO: add draw code here
        int i,j,addr;
        BYTE byte;
        WORD value;
        char buf[20];
        RECT rect1,rect2;
        int lpDxWidths[7];
        RECT rect;
        
        pDC->SetMapMode(MM_TEXT);
        pDC->SelectStockObject(ANSI_FIXED_FONT);

        pDC->MoveTo(m_nTextBegin-4,0);
        pDC->LineTo(m_nTextBegin-4,m_nDxHeight*31);

        for(i=0;i<=6;i++)
                lpDxWidths[i]=m_nDxWidth;

        addr = 0;
        rect1.left = 0;
        rect1.top = 0;
        rect1.right = m_nTextBegin-5;
        rect1.bottom = m_nDxHeight;

        GetClientRect(&rect2);
        rect2.left = m_nTextBegin;
        rect2.top = 0;
        rect2.bottom = m_nDxHeight;
        for(i=0;i<31;i++)
        {
                sprintf(buf,"%02X",(i*8));
            pDC->ExtTextOut(rect1.left+5,rect1.top,
            ETO_CLIPPED|ETO_OPAQUE,
                &rect1,
                buf,
                2,
                NULL);
        rect1.top+=m_nDxHeight;
        rect1.bottom+=m_nDxHeight;

        value = 0;
                for(j=0;j<=7;j++)
                {
                        byte = m_bBitMem[i*8+j];
                        byte <<= (7-j);
                        value = value + byte;
                }
//              value <<= 8;
                value |= 0x100;
        _itoa(value,buf,2);
            pDC->ExtTextOut(rect2.left,rect2.top,
            ETO_CLIPPED|ETO_OPAQUE,
                &rect2,
                buf+1,
                8,
                lpDxWidths);
        rect2.top+=m_nDxHeight;
        rect2.bottom+=m_nDxHeight;
        }
//      SetCaretPos(m_pointCaret);
}

/////////////////////////////////////////////////////////////////////////////
// CBMemoryView message handlers


int CBMemoryView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
        if (CScrollView::OnCreate(lpCreateStruct) == -1)
                return -1;

        // TODO: Add your specialized creation code here
        CreateSolidCaret(2,11);
        ShowCaret();

        POINT pos;
        pos.x = m_nTextBegin + m_pointCaret.x*m_nDxWidth;
        pos.y = m_pointCaret.y*m_nDxHeight + 1;
        SetCaretPos(pos);

        return 0;
}

void CBMemoryView::OnSize(UINT nType, int cx, int cy)
{
        CScrollView::OnSize(nType, cx, cy);

        // TODO: Add your message handler code here
        if (m_pParent!=NULL)
                m_pParent->InvalidateRect(NULL,TRUE);
}

void CBMemoryView::OnLButtonDown(UINT nFlags, CPoint point)
{
        // TODO: Add your message handler code here and/or call default
        POINT pos;

        if (point.x>=(int)m_nTextBegin)
                m_pointCaret.x = (point.x-m_nTextBegin+(m_nDxWidth/4))/m_nDxWidth;

    pos = GetScrollPosition();
        m_pointCaret.y = (point.y+pos.y)/m_nDxHeight;

        if (m_pointCaret.x<0) m_pointCaret.x = 0;
        if (m_pointCaret.x>7) m_pointCaret.x = 7;
        if (m_pointCaret.y<0) m_pointCaret.y = 0;
        if (m_pointCaret.y>30) m_pointCaret.y = 30;

        pos.x = m_nTextBegin + m_pointCaret.x*m_nDxWidth;
        pos.y = m_pointCaret.y*m_nDxHeight - pos.y + 1;
        SetCaretPos(pos);

        CScrollView::OnLButtonDown(nFlags, point);
}

void CBMemoryView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
        // TODO: Add your message handler code here and/or call default
        //UINT pos;
        switch (nSBCode)
        {
                case SB_THUMBTRACK:
                        break;
                case SB_THUMBPOSITION:
//                      m_pointCaret.y-=nPos;
//                      SetCaretPos(m_pointCaret);
                        break;
                default:
                        break;
        }

        CScrollView::OnVScroll(nSBCode, nPos, pScrollBar);
}

void CBMemoryView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
        // TODO: Add your message handler code here and/or call default
        POINT pos;
        BOOL bIn;

        switch (nChar)
        {
                case VK_RIGHT:
//                      m_pointCaret.x+=nRepCnt;
                        m_pointCaret.x++;
                        if (m_pointCaret.x>7) m_pointCaret.x = 7;
                        if (!IsCaretIn())
                        {
                                pos.x = 0;
                                pos.y = m_pointCaret.y * m_nDxHeight;
                                ScrollToPosition(pos);
                        }
                        break;
                case VK_LEFT:
//                      m_pointCaret.x-=nRepCnt;
                        m_pointCaret.x--;;
                        if (m_pointCaret.x<0) m_pointCaret.x = 0;
                        if (!IsCaretIn())
                        {
                                pos.x = 0;
                                pos.y = m_pointCaret.y * m_nDxHeight;
                                ScrollToPosition(pos);
                        }
                        break;
                case VK_UP:
//                      m_pointCaret.y-=nRepCnt;
                        bIn = IsCaretIn();
                        m_pointCaret.y--;
                        if (m_pointCaret.y<0) m_pointCaret.y = 0;
                        if (bIn)
                        {
                                if (!IsCaretIn())
                                {
                                        pos = GetScrollPosition();
                                        pos.y -= m_nDxHeight;
                                        if (pos.y<0) pos.y=0;
                                        ScrollToPosition(pos);
                                }
                        }
                        else
                        {
                                if (!IsCaretIn())
                                {
                                        pos.x = 0;
                                        pos.y = m_pointCaret.y * m_nDxHeight;
                                        ScrollToPosition(pos);
                                }
                        }
                        break;
                case VK_DOWN:
//                      m_pointCaret.y+=nRepCnt;
                        bIn = IsCaretIn();
                        m_pointCaret.y++;
                        if (m_pointCaret.y>30) m_pointCaret.y = 30;
                        if (bIn)
                        {
                                if (!IsCaretIn())
                                {
                                        pos = GetScrollPosition();
                                        pos.y += m_nDxHeight;
                                        ScrollToPosition(pos);
                                }
                        }
                        else
                        {
                                if (!IsCaretIn())
                                {
                                        pos.x = 0;
                                        pos.y = m_pointCaret.y * m_nDxHeight;
                                        ScrollToPosition(pos);
                                }
                        }
                        break;
                case VK_PRIOR:
                        bIn = IsCaretIn();
                        pos = GetScrollPosition();
                        m_pointCaret.y-=3;
                        if (m_pointCaret.y<0)
                        {
                                m_pointCaret.y=0;
                                pos.y = 0;
                                ScrollToPosition(pos);
                        }
                        else
                        {
                                pos.y-=3*m_nDxHeight;
                                ScrollToPosition(pos);
                        }

                        if (bIn)
                        {
                                if (!IsCaretIn())
                                {
                                        pos = GetScrollPosition();
                                        pos.y -= m_nDxHeight*3;
                                        if (pos.y<0) pos.y=0;
                                        ScrollToPosition(pos);
                                }
                        }
                        else
                        {
                                if (!IsCaretIn())
                                {
                                        pos.x = 0;
                                        pos.y = m_pointCaret.y * m_nDxHeight;
                                        ScrollToPosition(pos);
                                }
                        }
                        break;
                case VK_NEXT:
                        bIn = IsCaretIn();
                        pos = GetScrollPosition();
                        m_pointCaret.y+=3;
                        if (m_pointCaret.y>30)
                        {
                                m_pointCaret.y=30;
                                pos.y = 30*m_nDxHeight;
                                ScrollToPosition(pos);
                        }
                        else
                        {
                                pos.y+=3*m_nDxHeight;
                                ScrollToPosition(pos);
                        }

                        if (bIn)
                        {
                                if (!IsCaretIn())
                                {
                                        pos = GetScrollPosition();
                                        pos.y += m_nDxHeight*3;
                                        ScrollToPosition(pos);
                                }
                        }
                        else
                        {
                                if (!IsCaretIn())
                                {
                                        pos.x = 0;
                                        pos.y = m_pointCaret.y * m_nDxHeight;
                                        ScrollToPosition(pos);
                                }
                        }
                        break;
                default:
                        break;
        }
        SetMyCaret();

        CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CBMemoryView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
        // TODO: Add your message handler code here and/or call default
        POINT pos;
        switch (nChar)
        {
                case VK_SPACE:
                        if (!IsCaretIn())
                        {
                                pos.x = 0;
                                pos.y = m_pointCaret.y * m_nDxHeight;
                                ScrollToPosition(pos);
                        }

                        SwitchBit(m_pointCaret);
                        InvalidateRect(NULL,FALSE);
				        ::RepaintCPU();
				        ::RepaintPeri();
                        break;
                default:
                        break;
        }

        CScrollView::OnKeyUp(nChar, nRepCnt, nFlags);
}

void CBMemoryView::OnLButtonDblClk(UINT nFlags, CPoint point)
{
        // TODO: Add your message handler code here and/or call default
        if (point.x >= (int)m_nTextBegin)
        {
                SwitchBit(m_pointCaret);
                InvalidateRect(NULL,FALSE);
                UpdateWindow();
		        ::RepaintCPU();
		        ::RepaintPeri();
        }

        CScrollView::OnLButtonDblClk(nFlags, point);
}

void CBMemoryView::OnRButtonDown(UINT nFlags, CPoint point)
{
        // TODO: Add your message handler code here and/or call default
    LPARAM lParam;
    lParam = (WORD)point.y + 20;
    lParam <<= 16;
    lParam += (WORD)point.x;
    GetParent()->SendMessage(WM_RBUTTONDOWN, nFlags, lParam);

        CScrollView::OnRButtonDown(nFlags, point);
}

void CBMemoryView::OnEditBit()
{
        // TODO: Add your command handler code here
        POINT pos;
        if (!IsCaretIn())
        {
                pos.x = 0;
                pos.y = m_pointCaret.y * m_nDxHeight;
                ScrollToPosition(pos);
        }

        SwitchBit(m_pointCaret);
        InvalidateRect(NULL,FALSE);
        ::RepaintCPU();
        ::RepaintPeri();
}

void CBMemoryView::OnUpdateEditBit(CCmdUI* pCmdUI)
{
        // TODO: Add your command update UI handler code here
        pCmdUI->Enable(TRUE);
}

void CBMemoryView::OnSetFocus(CWnd* pOldWnd)
{
        CScrollView::OnSetFocus(pOldWnd);

        // TODO: Add your message handler code here
        CreateSolidCaret(2,11);
        ShowCaret();
        SetMyCaret();
}

void CBMemoryView::OnViewRefresh()
{
        // TODO: Add your command handler code here
#ifdef _LANE
        MemServerDump(m_bBitMem, 0, 0xf8, 5);
#endif

        InvalidateRect(NULL,TRUE);
//        ::RepaintCPU();
//        ::RepaintPeri();
}
