
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/BMEMWND.CPP   1.29   02 Apr 1996 09:30:52   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/BMEMWND.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:52   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:52:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:52   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:36   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:20   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:00   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:08   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:24   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:46   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:54   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:31:46   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:36   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:48   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:10   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:24   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:18   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:08   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:24   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:54   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BMEMWND.CPP
//
//  Description:The implement file for the class: CBMemoryWindow
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// bmemwnd.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"    
#include "uicom.h"
#include "bmemview.h"
#include "bmemwnd.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                  
void BMemOpenWindow(CMDIFrameWnd * pParentWnd)
{
    if (isBMemOn) return;
    pBMemDocTemplate->OpenDocumentFile(NULL);
}                  
/////////////////////////////////////////////////////////////////////////////
// CBMemoryWindow

IMPLEMENT_DYNCREATE(CBMemoryWindow, CMDIChildWnd)

CBMemoryWindow::CBMemoryWindow()
{                    
    isBMemOn = TRUE;
    pBMemWnd = this;
    m_pView = NULL;
}

CBMemoryWindow::~CBMemoryWindow()
{  
    isBMemOn = FALSE;
}

BEGIN_MESSAGE_MAP(CBMemoryWindow, CMDIChildWnd)
    //{{AFX_MSG_MAP(CBMemoryWindow)
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_PAINT()
    ON_WM_GETMINMAXINFO()
    ON_WM_RBUTTONDOWN()
    ON_WM_SETCURSOR()
    ON_WM_MDIACTIVATE()
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBMemoryWindow message handlers

         
int CBMemoryWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here
    return 0;
}

void CBMemoryWindow::OnSize(UINT nType, int cx, int cy)
{
    CMDIChildWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here
    if (m_pView!=NULL)
    { 
        m_pView->SetWindowPos(NULL, 0, 20, cx, cy-20, SWP_NOZORDER);
    }        
}

void CBMemoryWindow::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    RECT rect;    
    int lpDxWidths[7];
    int i;
    
    GetClientRect(&rect);
    rect.bottom = 20;                     
    
    for(i=0;i<=6;i++)
        lpDxWidths[i]=((CBMemoryView *)m_pView)->m_nDxWidth;
    
	dc.SelectStockObject(ANSI_FIXED_FONT);
	
    dc.ExtTextOut((((CBMemoryView *)m_pView)->m_nTextBegin+1),5, 
        ETO_CLIPPED | ETO_OPAQUE, 
        &rect, 
        "01234567", 
        8, 
        lpDxWidths);
    
    m_pView->SendMessage(WM_COMMAND,ID_VIEW_REFRESH,0);	
    // Do not call CMDIChildWnd::OnPaint() for painting messages
}

void CBMemoryWindow::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
    // TODO: Add your message handler code here and/or call default
//  (lpMMI->ptMaxTrackSize).x=180;
//  (lpMMI->ptMinTrackSize).y=70;
    
    CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}


void CBMemoryWindow::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    CMenu * pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );

    pLocalMenu->CreatePopupMenu();
	pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
	pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_BIT, "&Switch Bit");

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
    delete pLocalMenu;
    
    CMDIChildWnd::OnRButtonDown(nFlags, point);
}

BOOL CBMemoryWindow::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    if(message == WM_RBUTTONDOWN)   
        return FALSE;
    return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}


void CBMemoryWindow::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
    CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
    
    // TODO: Add your message handler code here
    if(bActivate && pActivateWnd == this)
        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
            LONG(WID_BMEM));
    else if(!bActivate && !pActivateWnd)
        AfxGetApp()->m_pMainWnd->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 
    
}

void CBMemoryWindow::OnViewRefresh()
{
	// TODO: Add your command handler code here
	if (m_pView != NULL)
	  m_pView->SendMessage(WM_COMMAND,ID_VIEW_REFRESH,0);	
}
