
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/BTNBAR.CPP   1.29   02 Apr 1996 09:21:50   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/BTNBAR.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:21:50   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:46:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:01:24   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:26:50   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:12   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:10:48   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:11:38   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:11:58   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:31:22   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:21:42   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:09:52   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:07:42   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:28:46   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:40   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:21:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:27:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:26   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:06   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:44:44   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:02   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:32   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:36   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:18:30   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:47:54   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:22   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:47:26   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:54   Shirley
** Initial revision.
**
****************************************************************************/
#include "hwtip.h"
/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BTNBAR.CPP
//
//  Description:The implement file for the class: CButtonBar
//
//  Author:     Roger Zhang
//
//  Date:       04/14/95
//
//  Modification:
//
//      1. 04/14/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "xview.h"

#include "zqueue.h"                   
#include "uicom.h"                   
#include "srccom.h"
#include "btnbar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


extern CStringList* pStkSearchPatternList;  // Defined in VARSRCH.CPP
extern CStringList* pVarSearchPatternList;  // Defined in VARSRCH.CPP


/////////////////////////////////////////////////////////////////////////////
//  Toolbar button index

enum {
    BTN_MODULE = 0,
    BTN_PREV_MODULE,
    BTN_NEXT_MODULE,
    BTN_LOAD,
    BTN_SEARCH,
    BTN_SRC_MODE,
    BTN_MIX_MODE,
    BTN_BUS_MODE,
    BTN_INS_MODE,
    BTN_BP,
    BTN_GO,
    BTN_HALT,
    BTN_RESET,
    BTN_STEPI,
    BTN_STEPO,
    BTN_GO_OVER,
    BTN_GO_UNTIL,
    BTN_WATCH,
    BTN_STATEMENT,
    BTN_INST,
    BTN_LOCAL_VAR,
    BTN_FRAME1,
    BTN_FRAMEn,
    BTN_FRAME,
    BTN_ADD_VAR,
    BTN_DEL_VAR,
    BTN_HELP
};    
    
/////////////////////////////////////////////////////////////////////////////
// CButtonBar

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::CButtonBar
//
//  Description: Constructor of the class CButtonBar
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CButtonBar::CButtonBar()
 : nActiveId(WID_MAIN)
{
//  m_pTip = new CVBControl;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::~CButtonBar
//
//  Description: Destructor of the class CButtonBar
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CButtonBar::~CButtonBar()
{                           
//  m_pTip->DestroyWindow();
//  delete m_pTip;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::CreateBar
//
//  Description: Create the tool bar 
//
//  Input:  
//      pOwner -- the owner of the toolbar
//
//  Output: None
//
//  Return: TRUE -- Success
//          FALSE -- Failed
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::CreateBar(CWnd       *pOwner)
{           
    if(!Create(pOwner,TWS_TIPS) || 
       !LoadBitmap(IDR_MAINFRAME)     || 
       !NewMain())
    {
        TRACE("Failed to create button bar\n");
        return FALSE;
    }             
    
//    m_pTip->Create("MHTIP.VBX;MhTip;MhTip1", NULL, CRect(0, 0, 50, 20),
//      this, IDC_MHTIP1);
    return TRUE;
}                                        

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::Del
//
//  Description: Delete controls when the toolbar inactive
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CButtonBar::Del(void)
{                        
    m_isCmbSrch = FALSE;
    switch(nActiveId) {
        case WID_TRACE:
            m_cmbSrch.DestroyWindow();
            break;
        case WID_SOURCE:
            m_cmbSrch.DestroyWindow();
            break;
        case WID_VARIABLE:
            m_cmbSrch.DestroyWindow();
            break;
        case WID_STACK:
            m_cmbSrch.DestroyWindow();
            break;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::NewMain
//
//  Description: Make toolbar of main window active
//
//  Input:  None
//
//  Output: None
//
//  Return: TRUE -- Success
//          FALSE -- Failed
//
/////////////////////////////////////////////////////////////////////////////

BOOL CButtonBar::NewMain(void)//modify by carl all SetButtonInfo func
{
    BOOL is = SetButtons(NULL, 12);
    if(is) {    
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE );
        
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET );
        
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
       
        SetButtonInfo(6, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        
        SetButtonInfo(7, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        
        SetButtonInfo(8, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        
        SetButtonInfo(9, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        
        SetButtonInfo(10, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(11, ID_HELP, TBBS_BUTTON, BTN_HELP);

        Invalidate();
        nActiveId = WID_MAIN;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewSource(void)//modify by carl all SetButtonInfo func
{
    BOOL is = SetButtons(NULL, 21);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        
        SetButtonInfo(1, ID_FILE_PREVMODULE, TBBS_BUTTON, BTN_PREV_MODULE); 
        
        SetButtonInfo(2, ID_FILE_NEXTMODULE, TBBS_BUTTON, BTN_NEXT_MODULE);
        
        SetButtonInfo(3, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        
        SetButtonInfo(4, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(5, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        
        SetButtonInfo(6, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(7, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH);
        
        SetButtonInfo(8, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(9, ID_VIEW_SOURCEONLY, TBBS_BUTTON, BTN_SRC_MODE);
        
        SetButtonInfo(10, ID_VIEW_MIXED, TBBS_BUTTON, BTN_MIX_MODE );
        
        SetButtonInfo(11, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(12, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET); 
        
        SetButtonInfo(13, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        
        SetButtonInfo(14, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        
        SetButtonInfo(15, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        
        //SetButtonInfo(16, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_WATCH);
        SetButtonInfo(16, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        
        SetButtonInfo(17, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        
        SetButtonInfo(18, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        
        SetButtonInfo(19, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        /*SetButtonInfo(20, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(21, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(22, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(20, ID_HELP, TBBS_BUTTON, BTN_HELP);

        CRect rect;
        GetItemRect(5, &rect);
        rect.top = 3;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;                 
        
        POSITION pos = SrcSrchData.m_StrList.GetTailPosition();
        while(pos) {
            m_cmbSrch.AddString(SrcSrchData.m_StrList.GetPrev(pos));
        }
        m_cmbSrch.SetCurSel(0);

        Invalidate();
        nActiveId = WID_SOURCE;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewVariable(void)//modify by carl all SetButtonInfo func
{
    BOOL is = SetButtons(NULL, 19);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET); 
                      
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        
        SetButtonInfo(6, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        
        SetButtonInfo(7, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI); 
        
        SetButtonInfo(8, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        
        SetButtonInfo(9, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        
        SetButtonInfo(10, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(11, ID_VARIABLE_ADD, TBBS_BUTTON, BTN_ADD_VAR);
        
        SetButtonInfo(12, ID_VARIABLE_DELETE, TBBS_BUTTON, BTN_DEL_VAR); 
        
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(14, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        
        SetButtonInfo(15, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(16, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH );
        SetButtonInfo(17, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(18, ID_HELP, TBBS_BUTTON, BTN_HELP);

        CRect rect;
        GetItemRect(14, &rect);
        rect.top = 3;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;                 
        
        if ( !::pVarSearchPatternList->IsEmpty() ) {
            m_cmbSrch.ResetContent();
            POSITION posHead = ::pVarSearchPatternList->GetHeadPosition();
            while ( posHead ) {
                CString str = 
                    (CString)(::pVarSearchPatternList->GetNext(posHead));
                m_cmbSrch.AddString(str);
            }
        }
        m_cmbSrch.SetCurSel(0);

        Invalidate();
        nActiveId = WID_VARIABLE;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewStack(void)
{
    BOOL is = SetButtons(NULL, 18);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6); 
        
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET); 
        
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        
        SetButtonInfo(6, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        
        SetButtonInfo(7, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        
        SetButtonInfo(8, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        
        SetButtonInfo(9, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        
        SetButtonInfo(10, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(11, ID_EDIT_SELECTLOCALVARIABLES, TBBS_BUTTON, 
                            BTN_LOCAL_VAR);
                            
        SetButtonInfo(12, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(13, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        
        SetButtonInfo(14, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(15, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH);
        
        SetButtonInfo(16, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(17, ID_HELP, TBBS_BUTTON, BTN_HELP);

        CRect rect;
        GetItemRect(13, &rect);
        rect.top = 3;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;                 
        
        if ( !::pStkSearchPatternList->IsEmpty() ) {
            m_cmbSrch.ResetContent();
            POSITION posHead = ::pStkSearchPatternList->GetHeadPosition();
            while ( posHead ) {
                CString str = 
                    (CString)(::pStkSearchPatternList->GetNext(posHead));
                m_cmbSrch.AddString(str);
            }
        }
        m_cmbSrch.SetCurSel(0);

        Invalidate();
        nActiveId = WID_STACK;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewCpu(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_CPU;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewPeri(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_PERI;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewMemory(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_MEMORY;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewShell(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_SHELL;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewBMem(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_BMEM;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewTrace(void)
{
    BOOL is = SetButtons(NULL, 19);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        
        SetButtonInfo(6, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        
        SetButtonInfo(7, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        
        SetButtonInfo(8, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        
        SetButtonInfo(9, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        
        SetButtonInfo(10, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(11, ID_EDIT_GOTOSTARTFRAME, TBBS_BUTTON, BTN_FRAME1);
        
        SetButtonInfo(12, ID_EDIT_GOTOENDFRAME, TBBS_BUTTON, BTN_FRAMEn);
        
        SetButtonInfo(13, ID_EDIT_GOTOFRAME, TBBS_BUTTON, BTN_FRAME);
        
        SetButtonInfo(14, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        SetButtonInfo(15, ID_VIEW_BUS, TBBS_BUTTON, BTN_BUS_MODE);
        
        SetButtonInfo(16, ID_VIEW_INSTRUCTION, TBBS_BUTTON, BTN_INS_MODE);
        
        SetButtonInfo(17, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        
        /*SetButtonInfo(21, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        SetButtonInfo(22, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(23, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH);
        SetButtonInfo(24, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(18, ID_HELP, TBBS_BUTTON, BTN_HELP);

/*        CRect rect;
        GetItemRect(21, &rect);
        rect.top = 1;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;     
            
        m_cmbSrch.AddString("abcd");
        m_cmbSrch.AddString("efgh");
        m_cmbSrch.AddString("1234");
        m_cmbSrch.AddString("5678");
        m_cmbSrch.AddString("AGBCD");
        m_cmbSrch.AddString("ORI R UET UITU");
        m_cmbSrch.SetCurSel(0);*/
        
        Invalidate();
        nActiveId = WID_TRACE;
        return TRUE;
    } else  return FALSE;
}                   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::AddSrchText
//
//  Description: Add search text to the search combobox
//
//  Input:  
//      str -- the search text
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CButtonBar::AddSrchText(const char * str)
{
    if(!m_isCmbSrch)    return;
    CString strTemp;
    if(m_cmbSrch.GetCount()) {
        m_cmbSrch.GetLBText(0, strTemp);
        if(strTemp == str)  return;
    }    
    m_cmbSrch.InsertString(0, str);
    m_cmbSrch.SetCurSel(0);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CString CButtonBar::GetSrchText(void)
{
    ASSERT(nActiveId == WID_SOURCE || nActiveId == WID_TRACE);
    
    if(!m_isCmbSrch)    return  "";
    int nSel = m_cmbSrch.GetCurSel();
    if(nSel == CB_ERR)  return  "";
    CString str;
    m_cmbSrch.GetLBText(nSel, str);
    return  str;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CString CButtonBar::GetSrchEditText(void)
{                
    CString str;
    m_cmbSrch.GetWindowText(str);
    return  str;
}

BEGIN_MESSAGE_MAP(CButtonBar, CTipToolBar)
    //{{AFX_MSG_MAP(CButtonBar)
        // NOTE - the ClassWizard will add and remove mapping macros here.
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()
//  ON_VBXEVENT(VBN_SETCAPTION, IDC_MHTIP1, OnSetcaptionMhtip1)

/////////////////////////////////////////////////////////////////////////////
// CButtonBar message handlers
/*void CButtonBar::OnSetcaptionMhtip1(UINT, int, CWnd*, LPVOID lpParams)
{
    
    char StrBuff[256];
    int StrBuffLen;
        
    StrBuffLen = ::GetWindowText((HWND)AFX_NUM_EVENTPARAMINDEX(int, lpParams, 3), StrBuff, 255);
    
    m_pTip->SetStrProperty("Caption", "ifuodiufg"StrBuff);
    m_pTip->ShowWindow(SW_SHOW);    
}
*/
////////////////////////////////////(EOF)////////////////////////////////////
