// calcexp.h : header file
//

#ifdef _CHEN_

#ifndef _CALCEXP_H_
#define _CALCEXP_H_

#include "syntest.h"

/////////////////////////////////////////////////////////////////////////////
// CExpression

class CExpression : public CSyntaxTest
{
// Construction & Destruction
public:
    CExpression();
    ~CExpression();
    
// Attributes
public:
    CString m_strInput;
    CString m_strOutput;
    
private:
    enum { maxToken = 0x0FF };
    char m_pszToken[maxToken+1];
    char* m_pszProg;

    enum { undefine = 0, delimiter = 1, variable = 2, number = 3 };
    char m_chTokenType;
    
    enum { noError = 0, syntaxError = 1, dividedByZero = 2 };
    int m_nErrorID;

// Overrides

// Implementation
public:
    void ExpAction(int nArgc, char* pszArgv[]);
    
private:
    void CalcExp(const CString strInput, CString& strOutput);
    void SkipWhiteSpace(CString& strInput);
    void GetToken(void);
    BOOL IsWhite(const char ch);
    BOOL IsDelimiter(const char ch, char* psz);

    void GetExp(double& dResult);
    void Level1(double& dResult);
    void Level2(double& dResult);
    void Level3(double& dResult);
    void Level4(double& dResult);
    void Level5(double& dResult);
    void Level6(double& dResult);
    
    void Primitive(double& dResult);
    void Arith(char op, double& dResult, double& dHold);
    void Unary(char op, double& dResult);
    
    void DisplayErrorMessage(void);
};

#endif  // _CALCEXP_H_
#endif  // _CHEN_
