
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/CPUSERVE.CPP   1.29   02 Apr 1996 09:27:40   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/CPUSERVE.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:27:40   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:49:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:04:38   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:04   Shirley
** EasyPack/SLD Version 0.36
** 
**    Rev 1.24   01 Feb 1996 10:10:40   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:11:30   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:11:48   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:31:14   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:21:34   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:09:46   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:07:36   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:28:38   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:34   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:10   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:27:46   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:27:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:04   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:01:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:44:38   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:42:56   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:25:26   Shirley
** EasyPack/SLD Version 0.1f
**
**    Rev 1.5   18 Oct 1995 14:46:28   Shirley
** EasyPack/SLD Version 0.1e
**
**    Rev 1.4   13 Oct 1995 13:18:22   Shirley
** No change.
**
**    Rev 1.3   29 Sep 1995 09:47:46   Shirley
** EasyPack/SLD Version 0.1c
**
**    Rev 1.1   15 Sep 1995 09:44:38   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:53:20   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : CPUSERVE.CPP
** Author:BRIGHT CHEN  ,  JOHN CHOW
** Description:
**
**
**    Finished date: 1995.9.1   V 0.1
**    UPDATE DATE  : 1995.9.8   V 0.1A
**                  Modify the void ResetCmd(int nArgc, char* pszArgv[]),
**                  because v0.1 don't support the string "P:xxxx" or
**                  "X:xxxx";
**                    1995.9.26  V 0.1B
**                  Modify BOOL CCpuServer::GetRegFromFile()
**                  to fix bug no.116
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

//////////////////////////////////////
//regserve.cpp
//Bright Cheng
//95/4
//////////////////////////////////////

///////////////////////////////NOTES//////////////////////////////
/********************************************************************
NOTES TO HOW TO ADD DIFFERENT:
STEP 1:
     ADD CPU NAME INT THE "enum CPU_MODULE_LIST " AREA LIKE OTHERS.
     PLEASE KEEP THE SEQUENCE OF THE CPU NAME AND AT SAME TIME THE
     ORDER MUST BE KEPT WITH THE ABI TABLE;
STEP 2:
     ADD REG TABLE IN THE END OF FILE LIKE OTHERS THOUGH THE ORDER
     OF REG TABLE IS NO USE.
     THE REG IN "enum COMMON_REG" AREA HAS NO NEED TO BE ADDED TO
     THE REG TABLE.
     THE REG SEQUENCE MUST BE KEPT WITH ABI TABLE.
STEP 3:
     UPDATE THE DAD REG TABLE AT THE SAME TIME, THIS MEANS THE EP-SLD
     MUST BE REBUILDED.
                                                       John.chow 95.8
*************************************************************************/

#include "stdafx.h"
#include "string.h"
#include "stdlib.h"

#include "abibase.h"
#include "cpucom.h"
#include "cpuserve.h"

void GetCpuName(CString& strName);

//STATUS AbiSetRegNumber(UINT nCpuNumber);
extern STATUS AbiGetAllReg(unsigned int* );
extern STATUS AbiSetReg(REG_ID,UINT);
extern STATUS AbiReset(ADDR addr);
extern STATUS AbiGetCpuId(UINT *nCpuId);
extern STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId);
extern STATUS AbiClrAllBp();
extern void DisplayErrorMessageBox(int);
extern int StrtoHex(unsigned char *InputStr,unsigned short *Output);//from dad
STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId);
STATUS AbiGetTargetSupport(UINT *wCpuNum, UINT* wCpuType);

extern unsigned char gEPModule;//suport dad to define cpu
extern char szAppPath[];

static CCpuServer CpuSrv;

//added by john 96.1 to support 320 trace list
UINT GetCpuId()
{ 
 return CpuSrv.GetCpuId();
 }

//notes:in this function anything needing initiation about cpu , dad
int InitCpu(int iRoger)
{
  return(CpuSrv.Initialize(iRoger));

}

void CpuShowOneRegToWnd(int reg_id)
{
    CpuSrv.ShowOneRegToWnd(reg_id);
}

void CpuShowAllRegToWnd()
{
    CpuSrv.ShowAllRegToWnd();
}

BOOL CpuSetRegfromWnd(int reg_id,UINT content)
{
    return(CpuSrv.SetRegfromWnd(reg_id,content));
}

BOOL CpuGetAllReg()
{
    CpuSrv.m_nErrorID = CpuSrv.GetAllReg();
    if(ICE_OK == CpuSrv.m_nErrorID)
        return(TRUE);
    else
    {
        CpuSrv.DisplayErrorMessageBox();
        return(FALSE);
    }
}

void RegisterCmd(int nArgc,char* pszArgv[])
{
REG_ID  reg_id;
UINT    regval;
char*   stop_at;

    if(1==nArgc)
        CpuSrv.ShowAllRegToShell();
    if(3==nArgc)
    {
        CString str = strupr(pszArgv[1]);
        for(int i = 0;i < nMaxReg; i++)
        {
            if(str == RegName[i])
            {
                reg_id = i;
                break;
            }
        }
        regval = (UINT)strtoul(pszArgv[2],&stop_at,16);
        CpuSrv.SetRegfromShell(reg_id,regval);
    }
}

void ResetCmd(int nArgc, char* pszArgv[])
{
char* stop_at;
WORD  addr;

    switch(nArgc)
    {
        case 1:
            CpuSrv.ResetbyShell(GetLoadPC());
            break;
        case 2:
            char *tmpPoint;
            tmpPoint= (char *)(&(pszArgv[1][0]));
            if('X' == toupper(pszArgv[1][0]))
             {
              ShowLine("Syntax error???");
              return;
              }
            if('P' == toupper(pszArgv[1][0]))
              tmpPoint= (char *)(&(pszArgv[1][2]));
            addr = (WORD)strtoul(tmpPoint,&stop_at,16);
            CpuSrv.ResetbyShell(addr);
            break;
        default:
            ShowLine("Syntax error???");
    }
}

BOOL CpuReset(WORD addr)
{
    return(CpuSrv.ResetbyWnd(addr));
}

// supported by Mr Xiao to define how to show all registers in shell
// the max number of registers in a line is defined by MAXALINE BY JOHN.CHOW 95.6
// the max number of lines in shell is defined by MAXLINES BY JOHN.CHOW 95.6

//for 8031 CPU

/*
   >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 IP=12 SCON=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12
    TCON=12 T2CON=12 P0=12 P1=12 P2=12 P3=12
   >
// for 8032 CPU
   >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 TCON=12  T2CON=12 IP=12 SCON=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12 TH2=12 TL2=12
    RCAP2H=12 RCAP2L=12 P0=12 P1=12 P2=12 P3=12
   >
//for 8051FA CPU
/* >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 TCON=12 T2CON=12 IP=12 SCON=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12 CCON=12 CH=12 CL=12 CMOD=12
    CCAP0H=12 CCAP1H=12 CCAP2H=12 CCAP3H=12 CCAP4H=12
    CCAP0L=12 CCAP1L=12 CCAP2L=12 CCAP3L=12 CCAP4L=12
    CCAPM0=12 CCAPM1=12 CCAPM2=12 CCAPM3=12 CCAPM4=12
    RACAP2H=12 RACAP2L=12 SADDR=12 SADEN=12 T2MOD=12
    TH2=12 TL2=12 PCON=12 P0=12 P1=12 P2=12 P3=12
   >
// for 8044 CPU
   >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 TCON=12 IP=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12
    SMD=12 STS=12 NSNR=12 STAD=12 TBS=12 TBL=12 TCB=12
    RBS=12 RBL=12 RFL=12 RCB=12 DMACNT=12 FIFO0=12 FIFO1=12
    SIUST=12 P0=12 P1=12 P2=12 P3=12
   >
// for 80652 CPU
   >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 TCON=12 IP=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12
    S0CON=12 S1CON=12 S1STA=12 S1ADR=12
    RFL=12 RCB=12 FIFO0=12 FIFO1=12 SIUST=12
    PCON=12 P0=12 P1=12 P2=12 P3=12
   >
// for 80528 CPU
   >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 TCON=12 T2CON=12 IP=12 SCON=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12 TH2=12 TL2=12
    RCAP2H=12 RCAPL=12 WDCON=12 S1SCS=12 S1BIT=12 S1INT=12
    T3=12 P0=12 P1=12 P2=12 P3=12
   >
 // for 80154 CPU
   >REGISTER
    PC=1234 DPTR=1234 ACC=12 B=12 SP=12 PSW=12
    R0=12 R1=12 R2=12 R3=12 R4=12 R5=12 R6=12 R7=12
    IE=12 TCON=12 T2CON=12 IP=12 SCON=12 TMOD=12
    TH0=12 TL0=12 TH1=12 TL1=12 TH2=12 TL2=12
    RCAP2H=12 RCAPL=12 IOCON=12
    PCON=12 P0=12 P1=12 P2=12 P3=12
   >
 */

//ONLY USED FOR SHOWING REGS IN SHELL
static struct CPUModule
{
    char cpuName[MAXCPUNAMELEN];
    Reg_Name_ID RegNameID[MAX_REGISTERS];
    int nMaxReg;
} cpuModule =
   {
        "Single Chip",              //cpu name
        "PC",         0,     0  ,  0   ,
        "DPTR",       1,     0  ,  1   ,
        "ACC",        2,     0  ,  2   ,
        "B",          3,     0  ,  3   ,
        "SP",         4,     0  ,  4   ,
        "PSW",        5,     0  ,  5   ,
        "R0",         6,     1  ,  0   ,
        "R1",         7,     1  ,  1   ,
        "R2",         8,     1  ,  2   ,
        "R3",         9,     1  ,  3   ,
        "R4",         10,    1  ,  4   ,
        "R5",         11,    1  ,  5   ,
        "R6",         12,    1  ,  6   ,
        "R7",         13,    1  ,  7   ,
        "IE",         14,    2  ,  0   ,
        "IP",         15,    2  ,  1   ,
        "SCON",       16,    2  ,  2   ,
        "TMOD",       17,    2  ,  3   ,
        "TH0",        18,    3  ,  0   ,
        "TL0",        19,    3  ,  1   ,
        "TH1",        20,    3  ,  2   ,
        "TL1",        21,    3  ,  3   ,
        "TCON",       22,    4  ,  0   ,
        "T2CON",      23,    4  ,  1   ,
        "P0",         24,    4  ,  2   ,
        "P1",         25,    4  ,  3   ,
        "P2",         26,    4  ,  4   ,
        "P3",         27,    4  ,  5   ,
        "",           28,    0  ,  0   ,
        "",           29,    0  ,  0   ,
        "",           30,    0  ,  0   ,
        "",           31,    0  ,  0   ,
        "",           32,    0  ,  0   ,
        "",           33,    0  ,  0   ,
        "",           34,    0  ,  0   ,
        "",           35,    0  ,  0   ,
        "",           36,    0  ,  0   ,
        "",           37,    0  ,  0   ,
        "",           38,    0  ,  0   ,
        "",           39,    0  ,  0   ,
        "",           40,    0  ,  0   ,
        "",           41,    0  ,  0   ,
        "",           42,    0  ,  0   ,
        "",           43,    0  ,  0   ,
        "",           44,    0  ,  0   ,
        "",           45,    0  ,  0   ,
        "",           46,    0  ,  0   ,
        "",           47,    0  ,  0   ,
        "",           48,    0  ,  0   ,
        "",           49,    0  ,  0   ,
        "",           50,    0  ,  0   ,
        "",           51,    0  ,  0   ,
        "",           52,    0  ,  0   ,
        "",           53,    0  ,  0   ,
        "",           54,    0  ,  0   ,
        "",           55,    0  ,  0   ,
        "",           56,    0  ,  0   ,
        "",           57,    0  ,  0   ,
        "",           58,    0  ,  0   ,
        "",           59,    0  ,  0   ,
        "",           60,    0  ,  0   ,
        "",           61,    0  ,  0   ,
        "",           62,    0  ,  0   ,
        "",           63,    0  ,  0   ,
        14                    //MAX_REG
    };

void CCpuServer::ShowAllRegToShell()
{

    m_nErrorID = GetAllReg();

    if(ICE_OK == m_nErrorID)
    {
     ShowAllRegByArray();
    }
    else
        DisplayErrorMessage();
} //end of ::ShowAllRegToShell()
//edit by JOHN.CHOW 95.6

STATUS CCpuServer::GetAllReg()
{
    return(AbiGetAllReg(&RegValue[0]));
}

void CCpuServer::ShowOneRegToShell(REG_ID reg_id)
{
char DisplayStr[20];
//UINT content;

    if (reg_id >= nMaxReg)
    {
        ShowLine("This register does not exist.");
        return;
    }

//    ret = AbiGetReg(reg_id,&content);
    m_nErrorID = GetAllReg();

    if(ICE_OK == m_nErrorID)
    {
//      RegValue[reg_id]= content;
        if((0==reg_id)||(1==reg_id))
            wsprintf(DisplayStr,"%s = %04X",RegName[reg_id],RegValue[reg_id]);
        else
            wsprintf(DisplayStr,"%s = %02X",RegName[reg_id],RegValue[reg_id]);
        ShowLine(DisplayStr);
    }
    else
        DisplayErrorMessage();
}//end of ::ShowOneRegToShell()


void CCpuServer::ShowOneRegToWnd(REG_ID reg_id)
{
UINT RegVal;

    if (reg_id >= nMaxReg)
    {
        AfxMessageBox("This register does not exist.");
        return;
    }

    RegVal = RegValue[reg_id];
//    status = AbiGetReg(reg_id, &content);
    m_nErrorID = GetAllReg();

    if(ICE_OK == m_nErrorID)
    {
        if (RegVal!=RegValue[reg_id])
        {
//          REGISTER[reg_id] = *content;
//          RegValue[reg_id]= content;
            CpuShowRegValue(reg_id);
        }
    }
    else
        DisplayErrorMessageBox();
}

void CCpuServer::ShowAllRegToWnd()
{
int i;

    m_nErrorID = GetAllReg();

    if(ICE_OK == m_nErrorID)
    {
        for(i=0;i<nMaxReg;i++)
            CpuShowRegValue(i);
    }
    else
        DisplayErrorMessageBox();
}

BOOL CCpuServer::SetRegfromWnd(REG_ID reg_id, UINT content)
{
int i;

    if((0 != reg_id)&&(1 != reg_id))
        if(content> 0xff)
        {
            AfxMessageBox("Error! Register value overflow ");
            return(FALSE);
        }

    m_nErrorID = AbiSetReg(reg_id,content);

    if(ICE_OK == m_nErrorID)
    {
        if (content!=RegValue[reg_id])
        {
            RegValue[reg_id] = content;
            CpuShowRegValue(reg_id);
// if PSW changed, all R0-R7 value may be changed either.
            if(reg_id==5)
            {
                m_nErrorID = GetAllReg();
                if(ICE_OK == m_nErrorID)
                    for( i=6;i<14;i++)
                        CpuShowRegValue(i);
                else
                {
                    DisplayErrorMessageBox();
                    return(FALSE);
                }
            }
        }
        return(TRUE);
    }
    else
    {
        DisplayErrorMessageBox();
        return(FALSE);
    }
    return(TRUE);
}

void CCpuServer::SetRegfromShell(REG_ID reg_id, UINT content)
{
char DisplayStr[20];

    if((0!= reg_id)&&(1!= reg_id))
        if(content > 0xff)
        {
            ShowLine(" Error! Register value overflow ");
            return;
        }

    m_nErrorID = AbiSetReg(reg_id,content);

    if(ICE_OK == m_nErrorID)
    {   
        m_nErrorID = GetAllReg();
        if(ICE_OK == m_nErrorID)
        {        
        if((0==reg_id)||(1==reg_id))
            wsprintf(DisplayStr,"%s = %04X",RegName[reg_id],RegValue[reg_id]);
        else
            wsprintf(DisplayStr,"%s = %02X",RegName[reg_id],RegValue[reg_id]);
        ShowLine(DisplayStr);
        CpuShowRegValue(reg_id);
        }
        else  
         DisplayErrorMessage();
    }
    else
        DisplayErrorMessage();
}//end of ::CpuSetRegfromShell();

//added to support set cpu module 95.10.25
BOOL CCpuServer::GetCpuListFromFile()
{
 //get file path and create file full name
 CString tblFileName = "",fileBuf;
 int result=-1;
 tblFileName += szAppPath;
 tblFileName += "REGTBL.DAT";
 //open the file
 CStdioFile tblFile;
 if( !tblFile.Open( (const char *)tblFileName,
           CFile::modeRead | CFile::typeText ) )
  {
   //AfxMessageBox((const char *)(tblFileName+" not found!"));
   return FALSE;
   }
 //get cpu name
 do
  {
   if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300))
    { fileBuf.ReleaseBuffer(); return FALSE; }
   fileBuf.ReleaseBuffer();
   result=fileBuf.Find("CPU_MODULE_LIST");
   } while(result==-1);

 for(UINT i=0; i<MAXCPUNUM; i++)
  {
   if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300))
    { fileBuf.ReleaseBuffer(); return FALSE; }
   fileBuf.ReleaseBuffer();           
   result=fileBuf.Find("COMMON_REG");
   if(result!=-1) break;
   result=fileBuf.Find("EP");
   if(result==-1) break; 
   result+=2;  int tmp0=0;
   if(fileBuf.Find("SUPPORT")!=-1) 
    {
     while(fileBuf[result]!=' ' && fileBuf[result]!=',' && fileBuf[result]!=0)
      (cpuNameList[sMaxCpuNum])[tmp0++]=fileBuf[result++];
     (cpuNameList[sMaxCpuNum])[tmp0++]=0;  
     cpuIDList[sMaxCpuNum] =(short) i;
     sMaxCpuNum++;
     }
   }         
   
 return TRUE;
}

BOOL CCpuServer::GetRegFromFile()
{
 //get file path and create file full name
 CString tblFileName = "",fileBuf;
 int result=-1;
 tblFileName += szAppPath;
 tblFileName += "REGTBL.DAT";
 //open the file
 CStdioFile tblFile;
 if( !tblFile.Open( (const char *)tblFileName,
           CFile::modeRead | CFile::typeText ) )
  {
   //AfxMessageBox((const char *)(tblFileName+" not found!"));
   return FALSE;
   }
 //get cpu name
 do
  {
   if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300))
    { fileBuf.ReleaseBuffer(); return FALSE; }
   fileBuf.ReleaseBuffer();
   result=fileBuf.Find("CPU_MODULE_LIST");
   } while(result==-1);

 for(UINT i=0; i<CpuModule+1; i++)
  {
   if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300))
    { fileBuf.ReleaseBuffer(); return FALSE; }
   fileBuf.ReleaseBuffer();
   }

 result=fileBuf.Find("EP");
 if(result==-1) return FALSE;
 result+=2;  int tmp0=0;
 while(fileBuf[result]!=' ' && fileBuf[result]!=',' && fileBuf[result]!=0)
  cpuModule.cpuName[tmp0++]=fileBuf[result++];
 cpuModule.cpuName[tmp0++]=0;
 //get common reg
 int tmpY=0,tmpX=0,tmpNo=0; char *tmpPoint;
 do
  {
   if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300))
    { fileBuf.ReleaseBuffer(); return FALSE; }
   fileBuf.ReleaseBuffer();
   result=fileBuf.Find("COMMON_REG");
   } while(result==-1);

 while(TRUE)
 {
 tmpPoint=fileBuf.GetBuffer(300);
 if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
 if(NULL!=strstr(tmpPoint,"COMMON_END")) break;

 while(tmpPoint!=NULL)
  {
   tmpPoint=strstr(tmpPoint,"REG_");
   if(tmpPoint==NULL) break;
   tmpPoint+=4;
   tmp0=0;
   while(tmpPoint[tmp0]!=' ' && tmpPoint[tmp0]!=',' && tmpPoint[tmp0]!=0)
    {
     cpuModule.RegNameID[tmpNo].Name[tmp0]=tmpPoint[tmp0];
     tmp0++;
     }
   cpuModule.RegNameID[tmpNo].Name[tmp0]=0;
   cpuModule.RegNameID[tmpNo].locY=tmpY;
   cpuModule.RegNameID[tmpNo].locX=tmpX++;
   cpuModule.RegNameID[tmpNo].ID=(unsigned char)tmpNo;
   tmpNo++;
   }
 tmpX=0; tmpY++;
 fileBuf.ReleaseBuffer();
 }//WHILE(TRUE)

 //get reg
 do
  {
   if(NULL==tblFile.ReadString(fileBuf.GetBuffer(300),300))
    { fileBuf.ReleaseBuffer(); return FALSE; }
   fileBuf.ReleaseBuffer();
   result=fileBuf.Find(cpuModule.cpuName);
   } while(result==-1);

 while(TRUE)
 {
 tmpPoint=fileBuf.GetBuffer(300);
 if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
 if(NULL!=strstr(tmpPoint,"REG_END")) break;

 while(tmpPoint!=NULL)
  {
   tmpPoint=strstr(tmpPoint,"REG_");
   if(tmpPoint==NULL) break;
   tmpPoint+=4;
   tmp0=0;
   while(tmpPoint[tmp0]!=' ' && tmpPoint[tmp0]!=',' && tmpPoint[tmp0]!=0)
    {
     cpuModule.RegNameID[tmpNo].Name[tmp0]=tmpPoint[tmp0];
     tmp0++;
     }
   cpuModule.RegNameID[tmpNo].Name[tmp0]=0;
   cpuModule.RegNameID[tmpNo].locY=tmpY;
   cpuModule.RegNameID[tmpNo].locX=tmpX++;
   tmpNo++;
   }
 tmpX=0; tmpY++;
 fileBuf.ReleaseBuffer();
 }//WHILE(TRUE)

 cpuModule.nMaxReg=tmpNo;

 //GET CPU MEMORY INFORMATION
 //GET PDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if((tmpPoint=strstr(tmpPoint,"PDATA"))==NULL) return FALSE;

   tmpPoint+=5;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.pMin))!=0)
    return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.pMax))!=0)
    return FALSE;
   fileBuf.ReleaseBuffer();
  }

 //GET XDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"XDATA"))) return FALSE;

   tmpPoint+=5;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 &&tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.xMin))!=0)
    return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.xMax))!=0)
    return FALSE;
   fileBuf.ReleaseBuffer();
  }

 //GET IDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==(tmpPoint=tblFile.ReadString(tmpPoint,300))) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"IDATA"))) return FALSE;

   tmpPoint+=5;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.iMin))!=0)
    return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.iMax))!=0)
    return FALSE;
   fileBuf.ReleaseBuffer();
  }

 //GET RDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"RDATA"))) return FALSE;

   tmpPoint+=5;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.rMin))!=0)
    return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.rMax))!=0)
    return FALSE;
   fileBuf.ReleaseBuffer();
  }

 //GET BDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"BDATA"))) return FALSE;

   tmpPoint+=5;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.bMin))!=0)
    return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>5) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(cpuMemoryRange.bMax))!=0)
    return FALSE;
   fileBuf.ReleaseBuffer();
  }

 //GET BDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"RESET"))) return FALSE;

   tmpPoint+=5;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>1) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(controlOption.controlReset))!=0)
    return FALSE;

  }

 //GET BDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"EA"))) return FALSE;

   tmpPoint+=2;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>1) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(controlOption.controlEa))!=0)
    return FALSE;

  }

 //GET BDATA
 {
   tmpPoint=fileBuf.GetBuffer(300);
   if(NULL==tblFile.ReadString(tmpPoint,300)) return FALSE;
   if(NULL==(tmpPoint=strstr(tmpPoint,"EBEN"))) return FALSE;

   tmpPoint+=4;
   if(tmpPoint==NULL) return FALSE;

   while ((*tmpPoint)==' ' || (*tmpPoint)==',') tmpPoint++;
   char strTmpDo[8];  char iTmpDo=0;
   while (tmpPoint[iTmpDo]!=' ' && tmpPoint[iTmpDo]!=','
          && tmpPoint[iTmpDo]!=0 && tmpPoint[iTmpDo]!='\n')
    {
     strTmpDo[iTmpDo]=tmpPoint[iTmpDo];
     iTmpDo++;
     if(iTmpDo>1) return FALSE;
     }
   tmpPoint=&(tmpPoint[iTmpDo]); strTmpDo[iTmpDo]=0;
   if(StrtoHex((unsigned char *)(&(strTmpDo[0])),&(controlOption.controlEben))!=0)
    return FALSE;

  }

 return TRUE;
 }
char ** PreCpuInitialize(int &iRoger)              
{ 
 return CpuSrv.PreCpuInitialize(iRoger);
 }
//added to support set cpu module 95.10.25
char ** CCpuServer::PreCpuInitialize(int &iRoger)             
{               
 UINT CpuId;                
 int tmp0;
 tmp0=0;
 if (CpuSrv.GetCpuListFromFile()==FALSE) return 0;//initial error,quit
 UINT wCpuNum;
 UINT wCpuType[40];
 m_nErrorID=AbiGetTargetSupport(&wCpuNum,wCpuType);
 if(ICE_OK!=m_nErrorID) return 0;
 if(wCpuNum == 0) return 0;
 
 for(UINT tmp=0;tmp<wCpuNum;tmp++)
  { 
   for(UINT tmp2=0;tmp2<CpuSrv.sMaxCpuNum;tmp2++)
    { 
     if(cpuIDList[tmp2] == wCpuType[tmp])  
      {
       cpuIDValid[tmp0] = cpuIDList[tmp2];
       int tmp3;
       tmp3=0;
       while(cpuNameList[tmp2][tmp3] != 0)
        {
         cpuNameValid[tmp0][tmp3] = cpuNameList[tmp2][tmp3];
         tmp3++;
         }
       cpuNameValid[tmp0][tmp3]=0;
       tmp0++;
       }
     }
   }
 
 strcat(cpuNameValid[0]," (Default)");
 
 sMaxCpuValid = iRoger = tmp0;
 return (char **)CpuSrv.cpuNameValid;
 }
//return FALSE: initial error,quit
//return TURE: OK             
BOOL CCpuServer::Initialize(int iRoger)
{
UINT CpuId;
int i;
    
    if(iRoger>=sMaxCpuNum) return FALSE;
    
    if(iRoger==-1)  
     {
      m_nErrorID = AbiGetCpuId(&CpuId);
      if(ICE_OK!=m_nErrorID) return FALSE;
      }
     else
      CpuId=cpuIDValid[iRoger];
    
    UINT tmpRoger;   
    m_nErrorID = AbiSetCpuId((UINT) CpuId, &tmpRoger);
    if(m_nErrorID!=ICE_OK || CpuId!=tmpRoger) 
     { 
      m_nErrorID = AbiGetCpuId(&CpuId);
      if(ICE_OK!=m_nErrorID) return FALSE;
      AfxMessageBox("Cpu Module setting error!\nNow it is using the default one");
      }
    
    if(TRUE)
    {   
        #ifdef _320
        CpuId = 50;
        #endif
        switch (CpuId)//suport dad
        {
         case  8:  //EP80C152JA
         case  9:  //EP83C152JA
         case 12:  //EP80C152JC
         case 13:  //EP83C152JC
                   gEPModule=8; break;

         case 10:  //EP80C152JB
         case 11:  //EP83C152JB
         case 14:  //EP80C152JD
         case 15:  //EP83C152JD
                   gEPModule=10; break;
         case 16:  //80c51fa,fb,fc
         case 17:  //83c51fa,fb,fc
                   gEPModule = 16;  //added by john 96.2
                   break;       
         default:  gEPModule=(unsigned char)CpuId;  break;
         }

        CpuModule = CpuId;
        if(FALSE==GetRegFromFile()) //added by john 95.8
         //AfxMessageBox("Register Table Loading Error!");
         return FALSE;
        CpuName = cpuModule.cpuName;
        nMaxReg = cpuModule.nMaxReg;
        //AbiSetRegNumber((UINT) nMaxReg);

        for(i=0;i<MAX_REGISTERS;i++)
        {
            RegName[i]= cpuModule.RegNameID[i].Name;
        }
    return TRUE;
    }
    else  { /*DisplayErrorMessageBox();*/ return FALSE; }
}

void GetCpuName(CString& strName)
{
    strName = CpuSrv.CpuName;
}


/*void CCpuServer::ShowModule()
{
UINT CpuId;
int i;
char DisplayStr[30];
    m_nErrorID = AbiGetCpuId(&CpuId);
    if(ICE_OK==m_nErrorID)
    {
        if(CpuId!=CpuModule)
        {
            CpuModule = CpuId;
            CpuName = cpuModule[CpuId].cpuName;
            nMaxReg = cpuModule[CpuId].nMaxReg;

            for(i=0;i<nMaxReg;i++)
            {
                RegName[i]= cpuModule[CpuId].RegNameID[i].Name;
            }
            ShowAllRegToWnd();
        }
        wsprintf(DisplayStr,"The Cpu module is %s",CpuName) ;
        ShowLine(DisplayStr);
    }
} */

/*void CCpuServer::SetModule(UINT CpuId)
{
char DisplayStr[30];
int i;

    if(bCpuSetFlag)
    {
        ShowLine("The cpu module has already been set!");
        return;
    }

    if(CpuId!=CpuModule)
    {
        if(ICE_OK==AbiSetCpuId(CpuId,&CpuId))
        {
            CpuModule = CpuId;
            CpuName = cpuModule[CpuId].cpuName;
            nMaxReg = cpuModule[CpuId].nMaxReg;

            for(i=0;i<nMaxReg;i++)
            {
                RegName[i]= cpuModule[CpuId].RegNameID[i].Name;
            }
            ShowAllRegToWnd();
            bCpuSetFlag = 1;
        }
        else return;       //time out
    }
    wsprintf(DisplayStr,"The Cpu module is %s",CpuName);
    ShowLine(DisplayStr);
} */

BOOL CCpuServer::ResetbyWnd(WORD addr)
{
ADDR address;
    address.addrType = 1;
    address.addr = addr;
    m_nErrorID = AbiReset(address);

    if(ICE_OK == m_nErrorID)
    {
        ShowAllRegToWnd();
        //send message to all windows
        return(TRUE);
    }
    else
    {
        DisplayErrorMessageBox();
        return(FALSE);
    }
}

void CCpuServer::ResetbyShell(WORD addr)
{
ADDR address;
    address.addrType = 1;
    address.addr = addr;
    m_nErrorID = AbiReset(address);

    if(ICE_OK == m_nErrorID)
    {
        ShowAllRegToWnd();
        //send message to all windows
    }
    else
        DisplayErrorMessage();
}

void CCpuServer::DisplayErrorMessage(void) const
{

  //FOR  Display the ABI error message using
    char* pszAbiError[] = {
        "",
        "ICE_FAIL_STEP",                  //target cannot step
        "ICE_FAIL_MEM_WRITE",             //memory write failure
        "ICE_FAIL_MAP_INCLUDE",           //map status not included
        "ICE_FAIL_MAP_BOUNDARY",          //map address boundary error
        "ICE_NOT_FOUND"       ,
        "ICE_FOUND",
        "ICE_TIME_OUT",
        "ICE_PARA_ERROR",
        "ICE_ERROR_NO.9",
        "ICE_ERROR_NO.a",
        "ICE_ERROR_NO.b",
        "ICE_ERROR_NO.c",
        "ICE_ERROR_NO.d",
        "ICE_ERROR_NO.e",
        "ICE_ERROR_NO.f",
        "ICE_EP_RUNNING",
        "ICE_TRACE_RUNNING",
        "ICE_TRACE_READ_OVER",
        "ICE_COMMAND_INVALID"
    };
  if(m_nErrorID<=0x13)
    ShowLine(pszAbiError[m_nErrorID]);
    else
     {
      char tmp[20];
      sprintf(tmp,"ICE_ERROR_NO.%x",m_nErrorID);
      ShowLine(tmp);
      }
}   // End of CCpuServer::DisplayErrorMessage().

void CCpuServer::DisplayErrorMessageBox(void) const
{
   //FOR  Display the ABI error message using
    char *pszAbiError[] = {
        "",
        "ICE_FAIL_STEP",                  //target cannot step
        "ICE_FAIL_MEM_WRITE",             //memory write failure
        "ICE_FAIL_MAP_INCLUDE",           //map status not included
        "ICE_FAIL_MAP_BOUNDARY",          //map address boundary error
        "ICE_NOT_FOUND"       ,
        "ICE_FOUND",
        "ICE_TIME_OUT",
        "ICE_PARA_ERROR",
        "ICE_ERROR_NO.9",
        "ICE_ERROR_NO.a",
        "ICE_ERROR_NO.b",
        "ICE_ERROR_NO.c",
        "ICE_ERROR_NO.d",
        "ICE_ERROR_NO.e",
        "ICE_ERROR_NO.f",
        "ICE_EP_RUNNING",
        "ICE_TRACE_RUNNING",
        "ICE_TRACE_READ_OVER",
        "ICE_COMMAND_INVALID"
    };
   if(m_nErrorID<=0x13)
    AfxMessageBox(pszAbiError[m_nErrorID]);
    else
    {
     char tmp[20];
     sprintf(tmp,"ICE_ERROR_NO.%x",m_nErrorID);
     AfxMessageBox(tmp);
     }

}   // End of CCpuServer::DisplayErrorMessageBox().

//editted by John.Chow 95.6 to add a private routine to show all reg in shell
void CCpuServer::ShowAllRegByArray()//only used in ShowAllRegToShell()
{
 int i,k1,k2,k3;
 char DisplayStr[20];
 char DisplayWholeStr[100];
 /*char (*tmpBuffer)[MAXLINES][MAXALINE];
 tmpBuffer=new char[MAXCHARS][MAXLINES][MAXALINE];*/
 char *tmpBuffer[MAXLINES][MAXALINE];
 for(k1=0;k1<MAXLINES;k1++)
  for(k2=0;k2<MAXALINE;k2++)
   tmpBuffer[k1][k2]=new char[MAXCHARS];

        for(k1=0;k1<MAXLINES;k1++)
         for(k2=0;k2<MAXALINE;k2++)
          for(k3=0;k3<MAXCHARS;k3++)
          tmpBuffer[k1][k2][k3]=0;

        i=0;
        while ( i<nMaxReg )
        {
           if(( 0==i )||( 1==i ))
              wsprintf(DisplayStr,"%s=%04X",RegName[i],RegValue[i]);
              else
              wsprintf(DisplayStr,"%s=%02X",RegName[i],RegValue[i]);

           if(cpuModule.RegNameID[i].locY>=MAXLINES) break;
           strcat(tmpBuffer[cpuModule.RegNameID[i].locY]
                           [cpuModule.RegNameID[i].locX],
                  DisplayStr);
           i++;
           }//while

           for(k1=0;k1<MAXLINES;k1++)
            {
             DisplayWholeStr[0]=0;
             for(k2=0;k2<MAXALINE;k2++)
              {
               if(tmpBuffer[k1][k2][0]!=0)
                {
                 strcat(DisplayWholeStr,tmpBuffer[k1][k2]);
                 strcat(DisplayWholeStr," ");
                 }
               }
             if(DisplayWholeStr[0]!=0) ShowLine(DisplayWholeStr);
             }
                                        
 for(k1=0;k1<MAXLINES;k1++)
  for(k2=0;k2<MAXALINE;k2++)
   delete []tmpBuffer[k1][k2];
 //delete []tmpBuffer;     
 }

//these two routines are added to give cpu information
int GetMemoryRange(CPUMEMORYRANGE *stRange)
{
 memcpy(stRange,&(CpuSrv.cpuMemoryRange),sizeof(CPUMEMORYRANGE));
 return 0;
 }

int GetControlOption(CString &strReset,CString &strEa,CString &strEben)
{
 if(CpuSrv.controlOption.controlReset==1) strReset="RESET"; else strReset="";
 if(CpuSrv.controlOption.controlEa==1) strEa="EA"; else strEa="";
 if(CpuSrv.controlOption.controlEben==1) strEben="EBEN"; else strEben="";
 return 0;
 }

//added to support the set cpu module 95.10.25
//initial the cpuserver
CCpuServer::CCpuServer()
{                      
  bCpuSetFlag=0;
  CpuModule=1;
  CpuName="8032";            
  sMaxCpuNum = 0;   
  
  typedef char * PCHAR;
  
  cpuNameList = new PCHAR [MAXCPUNUM];
  for(int i = 0; i < MAXCPUNUM; i ++) {
	cpuNameList[i] = new char [MAXCPUNAMELENGTH];  }
	
  cpuNameValid = new PCHAR [MAXCPUNUM];
  for(i = 0; i < MAXCPUNUM; i ++) {
	cpuNameValid[i] = new char [MAXCPUNAMELENGTH];  }


 }

CCpuServer::~CCpuServer()
{
  for(int i = 0; i < MAXCPUNUM; i ++)	delete [] cpuNameList[i];
  delete []cpuNameList;        
  
  for(i = 0; i < MAXCPUNUM; i ++)	delete [] cpuNameValid[i];
  delete []cpuNameValid;        
}
///////////////////////////////(EOF)////////////////////////////////


