
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/DADTRACE.CPP   1.29   02 Apr 1996 09:30:08   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/DADTRACE.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:08   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:30   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:18   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:12   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:04   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:50   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:13:14   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:15:06   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:30   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:02   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:48   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:16   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:44   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:49:08   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:42   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:58   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.3   29 Sep 1995 09:52:48   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:42   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:48   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:26   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : dadtrace.p
** Author:John Zhou
** Description:
**    Functions defined in this file are prepared for the using of others.
**
**
**    Finished date: 1995.4.21
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include "dad.h"
#ifdef BRIGHT
#include "dadtbl.h"
#include <string.h>           

extern unsigned char gEPModule;
extern unsigned long CpuModule_H,CpuModule_L;  //only used in DAD ,eg:CM31--8031
extern unsigned char WherePlace; //used in GetSymbol to decide the code area or xdata are


extern int DAOne (unsigned char *Code,//point to the first bytes being disassembled
                  unsigned short Addr,//code address used in disassembly
                  unsigned int Num,   //how many bytes shoud be disassembled in this struction
                  OneInstructionPlus *OneInstr//the result shoud be contain in this
                  );
                  
void CodeHextoText(char *Hex,char *textbuff,int num);
                  

//**********************************************************************
//FOLLOWING FUNCTIONS ARE DEFINED FOR OTHER GROUP MEMBERS TO INTERFACE WITH ME

//This function is defined for Bright to get the len of codes in one instruction
//refering to it's first code                                
unsigned char TRCGetInstLen(unsigned char code)                                
{                                     
  return  CMd_51[code].ByteNum;
  }
 
                                
//This function is defined for Bright using(disassembly) and it needn't to get bytes
//from ABI,because it get bytes from the input data *BRIGHTCode.
//It return 0 for ok and <0 for wrong(at this time BRIGHTByteNum==0 and BRIGHTResult is invalid.
int TRCGetInst(unsigned short BRIGHTAddr,//designed for BRIGHT(disassembly)
               unsigned char *BRIGHTCode,
               unsigned char len,
               unsigned char *BRIGHTResult)
{
 int i;
 OneInstructionPlus MyOneInstruction;
 unsigned char *OPCODE;
 unsigned int BRIGHTByteNum;
 
 if(gEPModule>63) return -3;                         

//convert the cpu module to own definition
 if(gEPModule<32)
   {
    CpuModule_L=1;  CpuModule_H=0;
    CpuModule_L<<=gEPModule;
    }                            
    else
     { 
      CpuModule_L=0;  CpuModule_H=1;
      CpuModule_H<<=(gEPModule-32);
      }

 BRIGHTByteNum=CMd_51[*BRIGHTCode].ByteNum;
 if (len!=BRIGHTByteNum) return -1;
 
 WherePlace=ABI_CODE_ADDR_JOHN;
 i=DAOne(BRIGHTCode,BRIGHTAddr,BRIGHTByteNum,&MyOneInstruction);
 if(i<0) { BRIGHTByteNum=0; return i;}

 BRIGHTResult[0]=0;
 CodeHextoText((char *)(&(MyOneInstruction.InstrString[6])),(char *)BRIGHTResult,
               BRIGHTByteNum);//insert obj code
 strcat((char *)BRIGHTResult,"    ");              
 strcat((char *)BRIGHTResult,(char *)(&(MyOneInstruction.InstrString[14])));
 strcat((char *)BRIGHTResult," ");
 OPCODE=&(MyOneInstruction.InstrString[STARTOPCODEINDEX]);
 while(*OPCODE!=0)
  {
   strcat((char *)BRIGHTResult,(char *)OPCODE);strcat((char *)BRIGHTResult,",");
   OPCODE+=strlen((char *)OPCODE)+1;
   }
 BRIGHTResult[(strlen((char *)BRIGHTResult)>0)?strlen((char *)BRIGHTResult)-1:0]=0;
 return 0;//refer to ok!
 }

#endif//BRIGHT
/********************** THE END OF FILE ***********************************/
