
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/EMUGO.CPP   1.29   02 Apr 1996 09:29:28   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/EMUGO.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:29:28   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:55:00   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:14   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:44   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:02   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:38   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:32   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:40   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:24   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:44   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:48   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:08   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:02   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:32   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:25:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:48   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:36   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:06   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:08:30   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:58   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:04   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:22   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:50:52   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:10   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:54:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:34   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:38   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUGO.CPP
//
//  Description: The implementation file for the class: CEmulationGo.
//
//  Author: Chen Jun
//
//  Date: 05/06/95
//
//  Modification:
//      1. 05/06/95, Initial version of the class: CEmulationGo.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "emugo.h"
#include "emupatch.h"

#include "uicom.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern CPatchData PatchData;    // Defined in EMUPATCH.CPP
BOOL bGoInPatch = FALSE;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void GoCmd(int nArgc, char* pszArgv[]);
void EmuServerGo(int nMode, unsigned short uAddr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiGo(FLAG runFlag, ADDR fromAddr, ADDR tillAddr);
    extern STATUS AbiGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr);
    extern STATUS AbiSetBp(ADDR addr);
    extern STATUS AbiClrBp(ADDR addr);
    extern STATUS AbiGetCpuStatus(UINT *uCpuStatus);
    extern STATUS AbiGetOneReg(int iRegId, UINT* uRegValue); 
    extern STATUS AbiAbort();
#endif  // _SERVER_NO_ABI
int GetSourceAddr(ADDR& addr);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   GoCmd().
//
//  Description: The main control routine of Go command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void GoCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 1 && nArgc <= 6 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Go command.
    CEmulationGo* pEmulationGo = new CEmulationGo;
    if ( !pEmulationGo ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationGo->GoAction(nArgc, pszArgv);
        delete pEmulationGo;
    }
    
//    CEmulationGo objGo;
//    objGo.GoAction(nArgc, pszArgv);

}   // End of GoCmd().


// Emulation Go server.
void EmuServerGo(int nMode, unsigned short uAddr)
{
    // Assertion of the input parameters.
    // nMode:   1 - Go
    //          2 - Go From Addr
    //          3 - Go Till Addr
    ASSERT( 1 == nMode || 2 == nMode || 3 == nMode );
    
    // Go server for the Source window.
    CEmulationGo* pEmulationGo = new CEmulationGo;
    if ( !pEmulationGo ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationGo->EmuServerGo(nMode, uAddr);
        delete pEmulationGo;
    }

}   // End of EmuServerGo().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationGo.

// Construction.
CEmulationGo::CEmulationGo()
{
    // Assertion of the input parameters.
    
    // Initial BP store.
    InitPatchBP();
    
    // Set Patch BP.
    PatchProcess();

    m_nMonitorTimer = 0;
    m_bStartTimer = FALSE;

}   // End of CEmulationGo::CEmulationGo().


// Destruction.
CEmulationGo::~CEmulationGo()
{
    // Assertion of the input parameters.
    
    // Restore Patch BP.
    RestorePatchBP();

}   // End of CEmulationGo::~CEmulationGo().


// Emulation Go command.
void CEmulationGo::GoAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 1 && nArgc <= 5 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Set the parameters.
    switch ( nArgc ) {
        case 1:
            // Go
            SetRunFlag(0);
            SetAddrVar(MEM_UNDEFINE, 0, m_FromAddr);
            SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            break;
        case 2:
            // Go Run
            SetRunFlag(1);
            SetAddrVar(MEM_UNDEFINE, 0, m_FromAddr);
            SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            break;
        case 3:
            // Go [From adr1] | [Till adr2] | Monitor count
            SetRunFlag(0);
            if ( 0 == stricmp(pszArgv[1], "FROM") ) {
                SetAddrVar(pszArgv[2], m_FromAddr);
                SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            }
            else if ( 0 == stricmp(pszArgv[1], "TILL") ) {
                SetAddrVar(MEM_UNDEFINE, 0, m_FromAddr);
                SetAddrVar(pszArgv[2], m_TillAddr);
            }
            else {
                SetMonitorTimer(pszArgv[2]);
                SetAddrVar(MEM_UNDEFINE, 0, m_FromAddr);
                SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            }
            break;
        case 4:
            // Go Run [From adr1]
            SetRunFlag(1);
            SetAddrVar(pszArgv[3], m_FromAddr);
            SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            break;
        case 5:
            // Go From adr1 Till adr2
            SetRunFlag(0);
            SetAddrVar(pszArgv[2], m_FromAddr);
            SetAddrVar(pszArgv[4], m_TillAddr);
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Go kernel.
    GoKernel();

}   // End of CEmulationGo::GoAction().


// Set the Run flag.
void CEmulationGo::SetRunFlag(unsigned char uchRunFlag)
{
    // Assertion of the input parameters.
    ASSERT( 0 == uchRunFlag || 1 == uchRunFlag );
    
    // Set the Run flag.
    m_uchRunFlag = uchRunFlag;

}   // End of CEmulationGo::SetRunFlag().


// Go kernel routine.
void CEmulationGo::GoKernel(void)
{
    // Assertion of the input parameters.
    
    // Test parameters.
    //DumpVar(m_uchRunFlag);
    //DumpVar((unsigned long)m_FromAddr.m_uAddr);
    //DumpVar((unsigned long)m_TillAddr.m_uAddr);
    
    // Call the ABI function.
    m_nErrorID = AbiGo(m_uchRunFlag, (ADDR&)m_FromAddr, (ADDR&)m_TillAddr);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return;
    }
    else {
        ShowLine("Program is running.");
    }

    // Break if Go Run status.
    if ( 1 == m_uchRunFlag ) {
        // Show prompt message.
    /*
        extern int nShellPrompt;    // Defined in SHLCOM.CPP
        if ( 1 == m_uchRunFlag ) {
            ::nShellPrompt = 1;
        }
        else {
            ::nShellPrompt = 0;
        }
    */    
        ShowLine("Program is free running.");
        return;
    }

    // Test the EP status.
    do {
        // ESC to cancel Go command.
        if ( EscapeAbort() ) {
            m_nErrorID = AbiAbort();
            if ( 0 != m_nErrorID ) {
                DisplayErrorMessage();
            }
            else {
				if ( 0 == ::GetSourceAddr((ADDR&)(m_TillAddr)) ) {
				    // Call the ABI function.
				    m_uchRunFlag = 0;
				    m_FromAddr.m_uchType = MEM_UNDEFINE;
    				m_nErrorID = AbiGo(m_uchRunFlag,(ADDR&)m_FromAddr,(ADDR&)m_TillAddr);
				    if ( ICE_OK != m_nErrorID ) {
				        DisplayErrorMessage();
				    }
				    else {
					    // Get CPU status.
					    UINT uCpuStatus;
					    int nCount = 0;
					    do {
					    	AbiGetCpuStatus(&uCpuStatus);
					    	nCount++;
					    } while (  0x40==(uCpuStatus & 0x070) && nCount < 10 );
				    }
                }
            }
            break;
        }
        
        // Start monitor timer.
        if ( m_nMonitorTimer > 0 && !m_bStartTimer ) {
            m_bStartTimer = TRUE;
            m_nTimerCount = 0;
        }
        
        // On monitor timer.
        if ( m_bStartTimer ) {
            if ( (++m_nTimerCount) == m_nMonitorTimer * 4 ) {
                m_nErrorID = AbiAbort();
                if ( 0 != m_nErrorID ) {
                    DisplayErrorMessage();
                    break;
                }
                UpdateAllWindows();
                m_bStartTimer = FALSE;
                m_nErrorID = AbiGo(m_uchRunFlag, 
                                   (ADDR&)m_FromAddr, (ADDR&)m_TillAddr);
                if ( 0 != m_nErrorID ) {
                    DisplayErrorMessage();
                    break;
                }
            }
        }

        // Detect if EP is stopped.
        if ( DetectEPStop() ) {
            if ( !MatchPatch() ) {
                ShowLine("Program is stopped.");
                break;
            }
            else {
                m_nErrorID =
                AbiGo(m_uchRunFlag, (ADDR&)m_FromAddr, (ADDR&)m_TillAddr);
                if ( ICE_OK != m_nErrorID ) {
                    DisplayErrorMessage();
                    break;
                }
            }
        }
    } while ( TRUE );

}   // End of CEmulationGo::GoKernel().

void CEmulationGo::SetMonitorTimer(char* pszTimer)
{
    StrToVar(pszTimer);
    m_nMonitorTimer = (int)m_ulVar;
}


// Set the Patch parameters.
void CEmulationGo::PatchProcess(void)
{
    // Assertion of the input parameters.
    
    // Get the Patch data.
    GetPatchRecord();
    if ( NO_PATCH == m_nPatchID ) {
        return;
    }

    // Process the Patch setting.
    if ( !GetPatchBP() ) {
        DisplayErrorMessage();
        return;
    }
    
    if ( !SetPatchBP() ) {
        DisplayErrorMessage();
        return;
    }

}   // End of CEmulationGo::PatchProcess().


// Get the Patch data.
void CEmulationGo::GetPatchRecord(void)
{
    // Assertion of the input parameters.
    
    // Get the Patch data.
    ::PatchData.GetPatchData(m_Addr[0], m_Addr[1], m_Addr[2], m_Addr[3]);
    if ( MEM_UNDEFINE == m_Addr[0].m_uchType ) {
        m_nPatchID = NO_PATCH;
    }
    else if ( MEM_UNDEFINE == m_Addr[1].m_uchType ) {
        m_nPatchID = INS_PATCH;
    }
    else if ( MEM_UNDEFINE == m_Addr[2].m_uchType ) {
        m_nPatchID = DEL_PATCH;
    }
    else {
        m_nPatchID = REP_PATCH;
    }
    
}   // End of CEmulationGo::GetPatchRecord().


// Get BP according to the Patch data.
BOOL CEmulationGo::GetPatchBP(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nPatchID >= DEL_PATCH && m_nPatchID <= REP_PATCH );

    // Decide index.
    int nCount;
    switch ( m_nPatchID ) {
        case DEL_PATCH:
            nCount = 1;
            break;
        case INS_PATCH:
            nCount = 2;
            break;
        case REP_PATCH:
            nCount = 2;
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    // Call ABI routine.
    for ( int i = 0, j = 0; i < nCount; i++, j += 3 ) {
        m_nErrorID = 
            AbiGetBp((ADDR&)m_Addr[j],(ADDR&)m_Addr[j],&(ADDR&)m_BPAddr[i]);

        if ( ICE_NOT_FOUND == m_nErrorID ) {
            m_BPAddr[i].m_uchType = MEM_UNDEFINE;
        }
        else if ( ICE_FOUND == m_nErrorID ) {
            m_BPAddr[i].m_uchType = MEM_PROGRAM;
        }
        else {
            return (FALSE);
        }
    }
        
    // Return.
    return (TRUE);
    
}   // End of CEmulationGo::GetPatchBP().


// Set BP according to the Patch data.
BOOL CEmulationGo::SetPatchBP(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nPatchID >= DEL_PATCH && m_nPatchID <= REP_PATCH );

    // Decide index.
    int nCount;
    switch ( m_nPatchID ) {
        case DEL_PATCH:
            nCount = 1;
            break;
        case INS_PATCH:
            nCount = 4;
            break;
        case REP_PATCH:
            nCount = 4;
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    // Call ABI routine.
    for ( int i = 0; i < nCount; i += 3 ) {
        m_nErrorID = AbiSetBp((ADDR&)m_Addr[i]);
        if ( ICE_OK != m_nErrorID ) {
            return (FALSE);
        }
    }
        
    // Return.
    return (TRUE);
    
}   // End of CEmulationGo::SetPatchBP().


// Initialize the Patch BP.
void CEmulationGo::InitPatchBP(void)
{
    // Assertion of the input parameters.
    
    // Initial Patch BP.
    for ( int i = 0; i <= 1; i++ ) {
        m_BPAddr[i].m_uchType = MEM_UNDEFINE;
    }
    
    //m_isInPatch = FALSE;
    m_isInPatch = ::bGoInPatch;

}   // End of CEmulationGo::InitPatchBP().


// Restore the Patch BP.
void CEmulationGo::RestorePatchBP(void)
{
    // Assertion of the input parameters.
    
    // Clear the Patch BP and Set the old BP.
    for ( int i = 0, j = 0; i <= 1; i++, j += 3 ) {
        if ( MEM_PROGRAM == m_Addr[j].m_uchType && 
             MEM_UNDEFINE == m_BPAddr[i].m_uchType ) {
            m_nErrorID = AbiClrBp((ADDR&)m_Addr[j]);
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }
        }
    }

}   // End of CEmulationGo::RestorePatchBP().


// Detect if EP is stopped.
BOOL CEmulationGo::DetectEPStop(void)
{
    // Assertion of the input parameters.

/*    
    // Set EV3 to detect.
    BUS_EVENT BusEvent;
    memset(&BusEvent, 0, sizeof(BUS_EVENT));
    BusEvent.qlfyType[0] = 3;
    BusEvent.qlfyType[9] = 1;
    BusEvent.extrn = 0;
    
    m_nErrorID = AbiSetEvent(BusEvent);
    if ( ICE_OK == m_nErrorID ) {
        return (TRUE);
    }
    else if ( ICE_EP_RUNNING == m_nErrorID ) {
        return (FALSE);
    }
    else {
        DisplayErrorMessage();
        return (TRUE);
    }
*/
    
    // Delay one second.
//    DelayOneSecond();
                            
    // Get CPU status.
    UINT uCpuStatus;
    m_nErrorID = AbiGetCpuStatus(&uCpuStatus);
    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
        return (TRUE);
    }

    // Detect if EP is running.
    return ( 0x40 == (uCpuStatus & 0x070) ) ? FALSE : TRUE;

}   // End of CEmulationGo::DetectEPStop().


BOOL CEmulationGo::MatchPatch(void)
{
    // Assertion of the input parameters.
    
    // Check Patch setting.
    switch ( m_nPatchID ) {
        case NO_PATCH:
            return (FALSE);
        case DEL_PATCH:
            m_nErrorID = AbiGetOneReg(PC, &(unsigned int&)m_uPC);
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return (FALSE);
            }
            else if ( m_Addr[0] == m_uPC ) {
                m_FromAddr = m_Addr[1];
                return (TRUE);
            }
            else {
                return (FALSE);
            }
            break;
        case INS_PATCH:
            m_nErrorID = AbiGetOneReg(PC, &(unsigned int&)m_uPC);
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return (FALSE);
            }
            else if ( m_Addr[0] == m_uPC ) {
                if ( m_Addr[2] == m_Addr[3] ) {
                    m_FromAddr = m_Addr[0];
                    m_isInPatch = FALSE;
                    ::bGoInPatch = m_isInPatch;
                }
                else {
                    m_FromAddr = m_Addr[2];
                    m_isInPatch = TRUE;
                    ::bGoInPatch = m_isInPatch;
                }
                return (TRUE);
            }
            else if ( m_Addr[3] == m_uPC ) {
                if ( TRUE == m_isInPatch ) {
                    m_FromAddr = m_Addr[0];
                    m_isInPatch = FALSE;
                    ::bGoInPatch = m_isInPatch;
                }
                else {
                    m_FromAddr = m_Addr[3];
                }
                return (TRUE);
            }
            else {
                return (FALSE);
            }
            break;
        case REP_PATCH:
            m_nErrorID = AbiGetOneReg(PC, &(unsigned int&)m_uPC);
            if ( ICE_OK != m_nErrorID ) {
                DisplayErrorMessage();
                return (FALSE);
            }
            else if ( m_Addr[0] == m_uPC ) {
                if ( m_Addr[2] == m_Addr[3] ) {
                    m_FromAddr = m_Addr[1];
                    m_isInPatch = FALSE;
                    ::bGoInPatch = m_isInPatch;
                }
                else {
                    m_FromAddr = m_Addr[2];
                    m_isInPatch = TRUE;
                    ::bGoInPatch = m_isInPatch;
                }
                return (TRUE);
            }
            else if ( m_Addr[3] == m_uPC ) {
                if ( TRUE == m_isInPatch ) {
                    m_FromAddr = m_Addr[1];
                    m_isInPatch = FALSE;
                    ::bGoInPatch = m_isInPatch;
                }
                else {
                    m_FromAddr = m_Addr[3];
                }
                return (TRUE);
            }
            else {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
    }

}   // End of CEmulationGo::MatchPatch().


// Go server.
void CEmulationGo::EmuServerGo(int nMode, unsigned short uAddr)
{
    // Assertion of the input parameters.
    ASSERT( 1 == nMode || 2 == nMode || 3 == nMode );
    // nMode:   1 - Go
    //          2 - Go From Addr
    //          3 - Go Till Addr

    // Dispatch the different mode.
    switch ( nMode ) {
        case 1:
            // Go
            SetRunFlag(0);
            SetAddrVar(MEM_UNDEFINE, 0, m_FromAddr);
            SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            break;
        case 2:
            // Go From Addr
            SetRunFlag(0);
            m_FromAddr = CMemoryAddr(uAddr, MEM_PROGRAM);
            SetAddrVar(MEM_UNDEFINE, 0, m_TillAddr);
            break;
        case 3:
            // Go Till Addr
            SetRunFlag(0);
            SetAddrVar(MEM_UNDEFINE, 0, m_FromAddr);
            m_TillAddr = CMemoryAddr(uAddr, MEM_PROGRAM);
            break;
        default:
            ASSERT( FALSE );
            return;
            break;
    }
    
    // Call the Go kernel.
    m_isServer = TRUE;
    GoKernel();

}   // End of CEmulationGo::EmuServerGo().

// Update all the windows.
void CEmulationGo::UpdateAllWindows(void)
{
    // Assertion of the input parameters.

    // Repaint all the windows.
    ::OnEmulation();

    // Update the related window at once.
//    if ( ::isShellOn ) {
//        ::pShellWnd->UpdateWindow();
//    }
    if ( ::isSourceOn ) {
        ::pSourceWnd->UpdateWindow();
    }
    if ( ::isVariableOn ) {
        ::pVariableWnd->UpdateWindow();
    }
    if ( ::isStackOn ) {
        ::pStackWnd->UpdateWindow();
    }
    if ( ::isCpuOn ) {
        ::pCpuWnd->UpdateWindow();
    }
    if ( ::isTraceOn ) {
        ::pTraceWnd->UpdateWindow();
    }
    if ( ::isPeriOn ) {
        ::pPeriWnd->UpdateWindow();
    }
    if ( ::isBMemOn ) {
        ::pBMemWnd->UpdateWindow();
    }
    for ( int i = 0; i <= 2; i++ ) {
        if ( ::isMemOn[i] ) {
            ::pMemWnd[i]->UpdateWindow();
        }
    }
}

//////////////////////////////// End of File ////////////////////////////////
