
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/EMUGO.H__   1.29   02 Apr 1996 09:23:46   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/EMUGO.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:23:46   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:51:38   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:06   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:38   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:52   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:13:28   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:17:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:02   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:34   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:48   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:50   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:50   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:06   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:54   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:08   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:38   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:10   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:08:32   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:00   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:24   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:50:56   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:12   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:10   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:36   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUGO.H
//
//  Description: The header file for the class: CEmulationGo.
//
//  Author: Chen Jun
//
//  Date: 05/06/95
//
//  Modification:
//      1. 05/06/95, Initial version of the class: CEmulationGo.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _EMUGO_
#define _EMUGO_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CEmulationGo class.
class CEmulationGo : public CMemoryBase
{
// Construction & Destruction.
public:
    CEmulationGo();
    ~CEmulationGo();
    
// Member variables.
private:
    CMemoryAddr m_FromAddr, m_TillAddr;
    unsigned char m_uchRunFlag;
    
    enum { NO_PATCH = 0, DEL_PATCH, INS_PATCH, REP_PATCH } m_nPatchID;
    CMemoryAddr m_Addr[4], m_BPAddr[2];
    BOOL m_isInPatch;

    enum { PC = 0 };
    unsigned short m_uPC;
    
    int m_nMonitorTimer;
    BOOL m_bStartTimer;
    int m_nTimerCount;
    
protected:

public:

// Implementations.
private:
    void SetRunFlag(unsigned char uchRunFlag);
    void GoKernel(void);
    void PatchProcess(void);
    void InitPatchBP(void);
    void GetPatchRecord(void);
    BOOL GetPatchBP(void);
    BOOL SetPatchBP(void);
    BOOL DetectEPStop(void);
    void RestorePatchBP(void);
    BOOL MatchPatch(void);
    
    void SetMonitorTimer(char* pszTimer);
    void UpdateAllWindows(void);

protected:

public:
    void GoAction(int nArgc, char* pszArgv[]);

    void EmuServerGo(int nMode, unsigned short uAddr);

};  // End of class: CEmulationGo.

#endif
//////////////////////////////// End of File ////////////////////////////////
