
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/EMUHALT.CPP   1.29   02 Apr 1996 09:24:32   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/EMUHALT.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:24:32   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:53:08   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:54   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:18   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:34   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:48   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:52   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:46   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:02   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:29:46   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:34   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:58   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:34   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:50   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:38   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:08   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:08:30   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:58   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:22   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:50:54   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:10   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:10   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:36   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: EMUHALT.CPP
//
//  Description: The implementation file for the class: CEmulationHalt.
//
//  Author: Chen Jun
//
//  Date: 05/08/95
//
//  Modification:
//      1. 05/08/95, Initial version of the class: CEmulationHalt.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "emuhalt.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void HaltCmd(int nArgc, char* pszArgv[]);
void EmuServerHalt(void);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiAbort();
#endif  // _SERVER_NO_ABI



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   HaltCmd().
//
//  Description: The main control routine of Halt command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void HaltCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Execute Halt command.
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationHalt->HaltAction(nArgc, pszArgv);
        delete pEmulationHalt;
    }
    
//    CEmulationHalt objHalt;
//    objHalt.HaltAction(nArgc, pszArgv);

}   // End of HaltCmd().


// Halt server routine for Source window.
void EmuServerHalt(void)
{
    // Assertion of the input parameters.
    
    // Execute Halt command.
    CEmulationHalt* pEmulationHalt = new CEmulationHalt;
    if ( !pEmulationHalt ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pEmulationHalt->EmuServerHalt();
        delete pEmulationHalt;
    }
    
}   // End of HaltCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CEmulationHalt.

// Construction.
CEmulationHalt::CEmulationHalt()
{

}   // End of CEmulationHalt::CEmulationHalt().


// Destruction.
CEmulationHalt::~CEmulationHalt()
{

}   // End of CEmulationHalt::~CEmulationHalt().


// Emulation Halt command.
void CEmulationHalt::HaltAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Call the Halt kernel.
    HaltKernel();

}   // End of CEmulationHalt::HaltAction().


// Halt kernel routine.
void CEmulationHalt::HaltKernel(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI function.
    m_nErrorID = AbiAbort();
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
    else {
        ShowLine("Target CPU halted.");
    }

}   // End of CEmulationHalt::HaltKernel().


// Halt server.
void CEmulationHalt::EmuServerHalt(void)
{
    // Assertion of the input parameters.

    // Call the Halt kernel.
    m_isServer = TRUE;
    HaltKernel();

}   // End of CEmulationHalt::EmuServerHalt().


//////////////////////////////// End of File ////////////////////////////////
