
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/EPSETUP/COMMUNIC.CPP   1.4   02 Apr 1996 09:33:42   Shirley  $  
**
**    $Log:   C:/EPSLDV1/SRC/LOG/EPSETUP/COMMUNIC.CPP  $
** 
**    Rev 1.4   02 Apr 1996 09:33:42   Shirley
** No change.
** 
**    Rev 1.3   15 Feb 1996 09:00:50   Shirley
** No change.
** 
**    Rev 1.2   12 Feb 1996 14:12:52   Shirley
** No change.
** 
**    Rev 1.1   06 Feb 1996 15:39:04   Shirley
** No change.
** 
**    Rev 1.0   06 Feb 1996 13:53:34   Shirley
** Initial revision.
** 
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  COMMUNIC.CPP
//
//  Description:The implement file of the class CCommunicationDialog
//
//  Author:     Roger Zhang
//  Date:       02/01/96
//
//  Modification:
//
//      1. 02/01/96, Ver 0.1
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "communic.h"
#include <ctype.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
extern BOOL SetupCommunication(UINT pData);
extern BOOL SetCommType(int nTempCommType);
extern int OpenAbiComDlg(int);

/////////////////////////////////////////////////////////////////////////////
void ExitEpsld(void)
{
    AfxMessageBox("Communication Failure!!!");
    //AfxGetApp()->m_pMainWnd->SendMessage(WM_QUIT);
    AfxAbort();
}

/////////////////////////////////////////////////////////////////////////////
static char * SkipHeadWS(char * psz)
{
    while(isspace(*psz))    ++ psz;
    return psz;
}              

static void CutTailWS(char * psz)
{
    int l = strlen(psz);
    if(!l)  return;     
    psz += l - 1;
    while(isspace(*psz))    -- psz;
    *(psz+1) = '\0';
}                

static BOOL Dec2Num(char * psz, DWORD & dwVal)
{
    char * p = psz;
                   
    int l = strlen(p);
    if(l == 0)  return FALSE;
                              
    DWORD dw = 1;                              
    dwVal = 0;      
    p += l - 1;
    for(int i = 0; i < l; i ++, p --, dw *= 10) {
        if(*p < '0' || *p > '9')    return FALSE;
        dwVal += (*p - '0') * dw;
    }
    return TRUE;    
}

static BOOL Hex2Num(char * psz, DWORD & dwVal)
{
    char * p = psz;
                   
    int l = strlen(p);
    if(l == 0)  return FALSE;
                              
    DWORD dw = 1;                              
    dwVal = 0;      
    p += l - 1;
    for(int i = 0; i < l; i ++, p --, dw *= 16) {
        if(*p >= '0' && *p <= '9')  dwVal += (*p - '0') * dw;
        else if(*p >= 'a' && *p <= 'f') dwVal += (*p - 'a' + 10) * dw;
        else if(*p >= 'A' && *p <= 'F') dwVal += (*p - 'A' + 10) * dw;
        else    return FALSE;
    }
    return TRUE;    
}

BOOL Str2Num(char * psz, DWORD & dwVal)
{
    char * p = SkipHeadWS(psz);

    CutTailWS(p);                   
                 
    if(*p == '0' && (*(p+1) == 'x' || *(p+1) == 'X')) {
        p += 2;
        return  Hex2Num(p, dwVal);
    }                               
    else return Dec2Num(p, dwVal);
}

/////////////////////////////////////////////////////////////////////////////
int nPortAddr = 0x300;         
int nPortType = 0; // 0 -> Parallel(PCE)
                   // 1 -> LPT1
                   // 2 -> LPT2
                   // 3 -> LPT3          
                   // 4 -> COM1
                   // 5 -> COM2
                   // 6 -> COM3
                   // 7 -> COM4

char * PortAddr[8] = {
    "0x300",  //PCE
    "0x378",  //LPT1
    "0x278",  //LPT2
    "0x3BC",  //LPT3
    "0x3F8",  //COM1
    "0x2F8",  //COM2
    "0",    //COM3
    "0"     //COM4
};                                  


#define FNAME	"EPSLD52F.INI"     

void ReadCommInfo(void)
{
    nPortType = GetPrivateProfileInt("COMM", "Type", 0, FNAME);
    if(nPortType < 0 || nPortType > 2) {
        nPortType = 0;
    }
                                
	char szBuf[100];                                
    GetPrivateProfileString("COMM", "Addr", PortAddr[nPortType], szBuf,
    	sizeof(szBuf), FNAME);
    sscanf(szBuf, "%x", &nPortAddr);
}

void WriteCommInfo(void)
{   
    char szBuf[100];
    wsprintf(szBuf, "%d", nPortType);
    WritePrivateProfileString("COMM", "Type", szBuf, FNAME);
    wsprintf(szBuf, "%X", nPortAddr);
    WritePrivateProfileString("COMM", "Addr", szBuf, FNAME);
}                    

BOOL SetComm(void)
{   
    BOOL bOK;
    
    // Set communication type
    if ( nPortType == 0 )     // PCE
         bOK = SetCommType(1);
    else if ( nPortType > 0 && nPortType <= 3 )     // LPT1->LPT3
         bOK = SetCommType(2);

    if ( bOK == TRUE) {
        // Set port address
        bOK = SetupCommunication(nPortAddr);
    }

    return bOK;
}                    

/////////////////////////////////////////////////////////////////////////////
void CommDlg(void)
{
 	CCommunicationDialog dlg;
 	if(dlg.DoModal() == IDOK) {
 	 	AfxMessageBox("Setup communication Ok");
 	} else {
 	 	AfxMessageBox("Setup communication failed");
 	}
}

/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog dialog


CCommunicationDialog::CCommunicationDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CCommunicationDialog::IDD, pParent)
{                       
	::ReadCommInfo();
    //{{AFX_DATA_INIT(CCommunicationDialog)
    m_nType = ::nPortType;
    //}}AFX_DATA_INIT
          
	char * pEnd;
	for(int i = 0; i < 8; i ++) {          
    	m_nPortAddr[i] = (int)strtol(::PortAddr[i], &pEnd, 16);
    }                                               
    m_nPortAddr[::nPortType] = ::nPortAddr;
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", ::nPortAddr);
    m_strAddr.ReleaseBuffer();
}

void CCommunicationDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CCommunicationDialog)
    DDX_Radio(pDX, IDC_COMM_PCE, m_nType);
    DDX_Text(pDX, IDC_COMM_EDIT, m_strAddr);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCommunicationDialog, CDialog)
    //{{AFX_MSG_MAP(CCommunicationDialog)
    ON_BN_CLICKED(IDC_COMM_LPT1, OnCommLpt1)
    ON_BN_CLICKED(IDC_COMM_LPT2, OnCommLpt2)
    ON_BN_CLICKED(IDC_COMM_LPT3, OnCommLpt3)
	ON_BN_CLICKED(ID_DETAIL, OnDetail)
	ON_BN_CLICKED(IDC_COMM_PCE, OnCommPce)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog message handlers

void CCommunicationDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData();                    
    
    DWORD dw;
    BOOL is = ::Str2Num(m_strAddr.GetBuffer(10), dw);
    m_strAddr.ReleaseBuffer();
    
    if(!is || dw > 0xFFF) {
        AfxMessageBox("Address Error!");
        return;
    }                                
                
    ::nPortType = m_nType;
    ::nPortAddr = int(dw);
    
    AfxGetApp()->DoWaitCursor(1);
    is = ::SetComm();
    AfxGetApp()->DoWaitCursor(-1);

    if(!is) {
     	AfxMessageBox("Setup communication error");
    } else {
    	::WriteCommInfo();
	    CDialog::OnOK();
	}    
}

void CCommunicationDialog::OnCommLpt1()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];              
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt2()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt3()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

BOOL CCommunicationDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCommunicationDialog::OnDetail()
{
	// TODO: Add your control notification handler code here
	int nDummy;
	nDummy = ::OpenAbiComDlg(0);
}

void CCommunicationDialog::OnCommPce()
{
	// TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}
