     
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/FLDDLG.CPP   1.27   02 Apr 1996 09:24:38   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/FLDDLG.CPP  $
** 
**    Rev 1.27   02 Apr 1996 09:24:38   Shirley
** No change.
** 
**    Rev 1.26   15 Feb 1996 08:53:16   Shirley
** No change.
** 
**    Rev 1.25   12 Feb 1996 14:10:02   Shirley
** No change.
** 
**    Rev 1.24   06 Feb 1996 15:36:24   Shirley
** No change.
** 
**    Rev 1.23   06 Feb 1996 13:50:40   Shirley
** EasyPack/SLD Version 0.36
** 
**    Rev 1.16   15 Jan 1996 16:16:20   Shirley
** No change.
** 
**    Rev 1.15   04 Jan 1996 11:08:26   Shirley
** No change.
** 
**    Rev 1.14   30 Nov 1995 09:09:02   Shirley
** No change.
** 
**    Rev 1.13   28 Nov 1995 15:31:48   Shirley
** EasyPack/SLD Version 0.32
** 
**    Rev 1.11   13 Nov 1995 09:24:22   Shirley
** No change.
** 
**    Rev 1.10   12 Nov 1995 11:32:32   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.9   08 Nov 1995 16:30:56   Shirley
** No change.
** 
**    Rev 1.8   08 Nov 1995 12:45:32   Shirley
** EasyPack/SLD Version 0.22
** 
**    
** 
** 
**
**
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  FLDDLG.CPP
//
//  Description:The Implementation file of dialog box for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "xview.h"
#include "flddlg.h"
#include "listcol.h"
#include "mylist.h"   
#include "spin.h"
#include "abibase.h"
#include "cpucom.h"
#include "cpuserve.h" 
#include "uicom.h"   

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern UINT cpuid; 
extern HINSTANCE hPerLib; 
extern STATUS AbiGetOneReg(REG_ID,UINT*);
extern STATUS AbiSetReg(REG_ID,UINT); 
extern STATUS AbiGetCpuId(UINT*);
extern  int Hex2Dec(char *); 
extern REGISTER RegVal[MAXRANGE];
extern int ITEMRANGE;   
extern int START_ID; 
extern BOOL CheckString(CString string);
#define  TWIPS_PER_INCH 1440
int ColWidth;
/////////////////////////////////////////////////////////////////////////////
// CFldDlg dialog




CFldDlg::CFldDlg(CWnd* pParent /*=NULL*/,int index)
    : CDialog(CFldDlg::IDD, pParent)
{   
     m_pParent=pParent; 
     m_nIndex=index;  
     m_nFldMax=1;
    //{{AFX_DATA_INIT(CFldDlg)
    m_pGrid=NULL  ;
    m_nFldVal = "";
    m_RegVal = "";  
    
    //}}AFX_DATA_INIT  

    
}

void CFldDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CFldDlg)
    DDX_VBControl(pDX, IDC_GRID, m_pGrid);
    DDX_Text(pDX, IDC_FIELD_VAL, m_nFldVal);
    DDX_Text(pDX, IDC_REG_VAL, m_RegVal);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFldDlg, CDialog)
    //{{AFX_MSG_MAP(CFldDlg)
    ON_LBN_SELCHANGE(IDC_FIELD_LIST, OnSelchangeFieldList)
    ON_BN_CLICKED(IDC_NEXT_BUTT, OnNextButt)
    ON_BN_CLICKED(IDC_PREV_BUTT, OnPrevButt)
    ON_BN_CLICKED(IDC_CLOSE_BUTT, OnCloseButt)
    ON_BN_CLICKED(IDC_WRI_BUTT, OnWriButt)
    ON_WM_VSCROLL()
	ON_EN_SETFOCUS(IDC_REG_VAL, OnSetfocusRegVal)
	ON_LBN_SETFOCUS(IDC_FIELD_LIST, OnSetfocusFieldList)
	ON_EN_SETFOCUS(IDC_FIELD_VAL, OnSetfocusFieldVal)
	ON_WM_DESTROY()
    ON_EN_KILLFOCUS(IDC_REG_VAL,OnRegValKillFocus)    
    ON_EN_KILLFOCUS(IDC_FIELD_VAL,OnFieldValKillFocus)  
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFldDlg message handlers

BOOL CFldDlg::OnInitDialog()
{
    CDialog::OnInitDialog();  
    
  //SetWindowPlacement
    m_bCanClose=TRUE; 
    HFONT hFont;
    hFont=(HFONT)GetStockObject(ANSI_FIXED_FONT);
    CFont Font; 
    GetDlgItem(IDC_FIELD_LIST)->SetFont(Font.FromHandle(hFont));
//    GetDlgItem(IDC_RO_EDIT)->SetFont(Font.FromHandle(hFont));
    ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->SetHorizontalExtent(1400);   
    
    
    char szBuff[256]="";
    char sztemp[256]="";
    DWORD dw,regdata;
    int reg_index;           
        
    dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(m_nIndex); 
    
    int bitplace=LOBYTE( LOWORD(dw) );
    reg_index=m_nIndex-LOBYTE( LOWORD(dw) );   
    
    regdata=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(reg_index);
    ::LoadString(hPerLib,HIWORD(regdata),sztemp,64); 
    SetWindowText(sztemp);
    
    m_nRegid=HIBYTE(LOWORD(dw));   
    
    
    //SET register value
    m_nRegVal=RegVal[m_nRegid].value;

    SetDlgList(m_nRegid);   
    GridInit(m_nRegid);
    
    if (bitplace) 
         bitplace=bitplace-1;
    else bitplace=0;
    ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->SetCurSel(bitplace);
    SetEdit(bitplace);      
    
///////////////////////added on 2/5/1996 by jerry///////////////
//  Width=m_pGrid->GetNumProperty("Width");
    ColWidth=(int) (m_pGrid->GetNumProperty("ColWidth",0) );
    
	CPoint ptSize=FindCellPosition((int)m_pGrid->GetNumProperty("Rows"),
									(int)m_pGrid->GetNumProperty("Cols") );
	if (ptSize.x != (int)m_pGrid->GetNumProperty("Width") ||
		ptSize.y != (int)m_pGrid->GetNumProperty("Height"))
	{
		CRect rect;
		rect.left   = (int)m_pGrid->GetNumProperty("Left");
		rect.top    = (int)m_pGrid->GetNumProperty("Top");
		rect.right  = rect.left + ptSize.x;
		rect.bottom = rect.top  + ptSize.y; 
		m_pGrid->Move(rect);							
     }
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFldDlg::OnSelchangeFieldList()
{   
    int  cursel;                                                    
    // set field value      
    cursel=((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetCurSel();      
    
    SetEdit(cursel);
    
}







void CFldDlg::OnNextButt()
{      
    m_bCanClose=TRUE;
    m_nRegid=(m_nRegid+1)%ITEMRANGE; 
        
    // change m_nIndex;
    DWORD dw;
    int count;
    count=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetCount();
    m_nIndex=(m_nIndex+1)%count; 
    dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(m_nIndex); 
    while(dw&(0x0ff))
    { 
      m_nIndex=(m_nIndex+1)%count;
      dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(m_nIndex); 
      
     }
    /////////////////////////////////////////////////////////////////// 
    
    char sztemp[64];    
    ::LoadString(hPerLib,m_nRegid*32+START_ID,sztemp,63);  
    SetWindowText(sztemp);
    m_nRegVal=RegVal[m_nRegid].value;

    SetDlgList(m_nRegid); 
    GridInit(m_nRegid); 
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(0);
    SetEdit(0); 
}
             
             
void CFldDlg::SetDlgList(int regid)
{ 
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->ResetContent();
    int i;
    int Noteid=START_ID+32*regid;
    int Addrid;                                     
    int regval,regvaltemp; 
    
    if( (cpuid==2) || (cpuid==3) )
        Addrid=START_ID+1100+regid;
    else
        Addrid=START_ID+1000+regid;
        
         
 //   regval=RegVal[regid].value;                                
 //   m_nRegVal=regval;
    regval=m_nRegVal;                            
    char sztemp[256]; 
    if(regval<0x0f)
    	sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
    else	
    	sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);	
    UpdateData(FALSE); 
    m_RegVal.ReleaseBuffer();

    
    ::LoadString(hPerLib,Addrid,sztemp,255); 
    
    //set field listbox        
    char *szaddr;
    szaddr=strtok(sztemp,",");  
    szaddr=strtok(NULL,",");
    
    char szBuff[256]="";
    int len,curid,power=1;
    int n,m=0; 
    int id=Noteid;
    while( szaddr)
    {  
       n=0;                       
       id++;
       curid=id;

       len=strlen(szaddr);   
       power=1;
       regvaltemp=regval>>(atoi(szaddr));
       for(i=0;i<(len+1)/2;i++)
          { 
            n+=((regvaltemp&(0x1))<<i);
            regvaltemp=regvaltemp>>1;
            power=power*2;
            
           }                        
       regvaltemp=regval ; 
       id=id+power;    

//////////////////////////////////////////////////////////////////           
       ::LoadString(hPerLib,curid+1+n,szBuff,255); 
       ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->AddString(szBuff); 
       DWORD d=0;
       d=curid;  
       d=d<<16;
       d=d+Addrid;      
       ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->SetItemData( m,d);
       szaddr=strtok(NULL,",");  
       m++;
     }  
          
}             


void CFldDlg::SetEdit(int cursel)
{                               
    DWORD dw;
    char sztemp[256]="";
    dw=((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetItemData(cursel);
    ::LoadString(hPerLib,LOWORD(dw),sztemp,31); 
    
    int i;
    char *addr; 
    addr=strtok(sztemp,",");  
    
    for (i=0;i<=cursel;i++)
        addr=strtok(NULL,",");
    
    int len;
    len=(strlen(addr)+1)/2    ;
    
    char q[2];
    q[0]=addr[0]; 
    
    int regval=m_nRegVal;
    regval=regval>>atoi(q);
    
    int n=0,power=1;       
    m_nFldMax=1;
    for (i=0;i<len;i++)
        {
         
         n+= (regval&0x1)*power;
         regval=regval>>1; 
         m_nFldMax*=2;
         power=power*2;
         }
    
////////////////////////////////////////////////////////////////////
    ((CSpinControl*)GetDlgItem(1995))->SetRange(0,m_nFldMax);   
    
/////////////////////////////////////////////////////////////////////   
    if(n<0x0f)
	    sprintf(m_nFldVal.GetBuffer(7),"0x0%X",n);
    else
     	sprintf(m_nFldVal.GetBuffer(7),"0x%X",n);

    UpdateData(FALSE);
    m_nFldVal.ReleaseBuffer();
    //set notes 
    char szBuff[256]="";
    sprintf(szBuff,"%s:",addr);
    ////////////////////////////////////////////////////
    GetDlgItem(IDC_RO_EDIT0)->SetWindowText(szBuff);
////////////////////////////////////////////////////////    
    ::LoadString(hPerLib,HIWORD(dw),sztemp,255); 
    
    strncpy(szBuff,&sztemp[12],127);
    len=strlen(szBuff);
    
   
    GetDlgItem(IDC_RO_EDIT1)->SetWindowText(szBuff);
//  ret=pdc->ExtTextOut(0,0,ETO_CLIPPED,&rect,szBuff,len,NULL);
  

    if( ( ( ( (cpuid==48)||(cpuid==49) )&&(m_nRegid==14) )||
          ( ( (cpuid>43 )&&(cpuid<48 ) )&&(m_nRegid==13) )||
          ( ( (cpuid==42)||(cpuid==43) )&&(m_nRegid==9 ) ) )&&
          ( ( cursel==0)||(cursel==1)||(cursel==7) )  )
     { 
      int addtmp;
      addtmp=( (m_nRegVal&0x80)!=0)?4:0;
      addtmp+=(m_nRegVal&0x03); 
      ::LoadString(hPerLib,100+addtmp,szBuff,255);
      }
    else
     {          
    	::LoadString(hPerLib,HIWORD(dw)+n+1,sztemp,255);  
    	strncpy(szBuff,&sztemp[12],128);   
      }
    SetDlgItemText(IDC_RO_EDIT2,szBuff); 
    SetGrid(m_nRegVal);
}              



void CFldDlg::OnPrevButt()
{
    m_bCanClose=TRUE;
    if(m_nRegid==0)
       m_nRegid=ITEMRANGE-1;
    else   
       m_nRegid=m_nRegid-1; 
    char sztemp[64]   ;
    ::LoadString(hPerLib,m_nRegid*32+START_ID,sztemp,63);  
    SetWindowText(sztemp);   
    
    // change m_nIndex;
    DWORD dw; 
    if(m_nIndex!=0)    
    {
      dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(m_nIndex); 
      m_nIndex=m_nIndex-(int)(dw&(0x0ff))-1;
    }
    else
      m_nIndex=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetCount()-1;
    
    dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(m_nIndex); 
    m_nIndex=m_nIndex-(int)(dw&(0x0ff));
    
    ///////////////////////////////////////////////////////////////////
    m_nRegVal=RegVal[m_nRegid].value;

    SetDlgList(m_nRegid); 
    GridInit(m_nRegid);
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(0);
    SetEdit(0);
}



void CFldDlg::OnCloseButt()
{
      m_bCanClose=TRUE;
  //  if(m_bCanClose)
      CDialog::OnCancel();
 
}



void CFldDlg::OnWriButt()
{
    int regval;                            
    if(GetFocus()!=GetDlgItem(IDC_WRI_BUTT) )
       GetDlgItem(IDC_WRI_BUTT)->SetFocus();
    if(m_bCanClose)                          
     {
    	
    	regval=Hex2Dec(m_RegVal.GetBuffer(7));
    	RegVal[m_nRegid].value=regval; 
////////////////////////////////////////////////////////////
    	AbiSetReg(RegVal[m_nRegid].id,RegVal[m_nRegid].value); 
    	AbiGetOneReg( RegVal[m_nRegid].id,&(RegVal[m_nRegid].value));
//////////////////////////////////////////////////////////////
    	regval=RegVal[m_nRegid].value; 
    	if(regval<0x0f)                              
    	    sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
    	else
    		sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    	UpdateData(FALSE); 
    	m_RegVal.ReleaseBuffer(); 
    
    	DWORD dw;
    	dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(m_nIndex); 
    	int reg_index; 
    	reg_index=m_nIndex-(int)(dw&(0x0ff));   
	         
     	char szBuff[256]="";
    	((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetText(reg_index,szBuff);    
    	int k=0; 
    	int DataLength;
    	DataLength=m_RegVal.GetLength();
    	for(k=0;k<DataLength;k++ )
    	{  
	        szBuff[k+COLUMN2+COLUMN1]=m_RegVal[k];
     	}      
    	k=m_RegVal.GetLength()+COLUMN1+COLUMN2; 
    	while (szBuff[k]!=' ')
    	{
       	   szBuff[k]=' ';
       	   k++;
     	 }     
    
	    DWORD dwdata;
	    dwdata=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(reg_index);
	    ((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->DeleteString(reg_index);
    	((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->InsertString(reg_index,szBuff) ;
    	((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->SetItemData(reg_index,dwdata);
    	if( szBuff[2]=='-') 
    	{
        	dw=((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->GetItemData(reg_index);
        	((CMyList*)(m_pParent->GetDlgItem(IDC_LIST1)))->DeleteBitItem(reg_index,dwdata);
        	((CMyList*)(m_pParent->GetDlgItem(IDC_LIST1)))->InsertBitItem(reg_index,dwdata);    
    	}  
    
    	RepaintCPU();
		RepaintMemory();
		RepaintBMemory();
	
		RepaintStack();
		RepaintVariable(); 
    	CDialog::OnOK(); 
   	   }
//   	   else
//   	   {  
//            AfxMessageBox("Your input is not valible!",MB_OK);
//        }
   	m_bCanClose=TRUE;    
}


void CFldDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    int fldval; 
    int regval;
    int sign; 
    char Buff[8]="";  
    char sztemp[256];
    
    if(pScrollBar==(CScrollBar*)GetDlgItem(1995))
    {
       if(nSBCode==SB_LINEUP)
       {
      	 sign=Hex2Dec(m_nFldVal.GetBuffer(7))    ;
    	 fldval=(sign+1)%m_nFldMax; 
    	 sign=fldval-sign;
         if(fldval<0x0f)
            sprintf(m_nFldVal.GetBuffer(7),"0x0%X",fldval);
         else                                             
         	sprintf(m_nFldVal.GetBuffer(7),"0x%X",fldval);
    	 UpdateData(FALSE);   
         GetDlgItemText(IDC_RO_EDIT0,Buff,7);
    	 char* token;
    	 token=strtok(Buff,":");
         regval=Hex2Dec(m_RegVal.GetBuffer(7));
    	 m_RegVal.ReleaseBuffer();
    	 if(sign>0)
        	regval+=(abs(sign)<< atoi(token));
    	 else regval-=(abs(sign)<< atoi(token)); 
    
    	 m_nRegVal=regval;
    	 if(regval<0x0f)
			sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);    	 
    	 else
    	    sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    	 UpdateData(FALSE);
    	 m_RegVal.ReleaseBuffer(); 
////////////////////////////////////////   
    //SendMessage(WM_COMMAND,IDC_FIELD_VAL, MAKELONG(GetDlgItem(IDC_FIELD_VAL)->m_hWnd,EN_CHANGE));
       }  
       else
       {
         sign=Hex2Dec(m_nFldVal.GetBuffer(7));  
         if(sign==0)
            fldval=m_nFldMax-1;
         else   
            fldval=(abs(sign-1))%m_nFldMax;          
    	 sign=fldval-sign;
         if(fldval<0x0f)
            sprintf(m_nFldVal.GetBuffer(7),"0x0%X",fldval);
         else
          	sprintf(m_nFldVal.GetBuffer(7),"0x%X",fldval);   
    	 UpdateData(FALSE);  
         GetDlgItemText(IDC_RO_EDIT0,Buff,7);
    	 char* token;
    	 token=strtok(Buff,":");
         regval=Hex2Dec(m_RegVal.GetBuffer(7)); 
    	 m_RegVal.ReleaseBuffer();
    	 if(sign>0)
        	regval+=(abs(sign)<< atoi(token));
    	 else regval-=(abs(sign)<< atoi(token));
    	 m_nRegVal=regval;
   		 if(regval<0x0f)
   		   	sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
   		 else
   		 	sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    	 UpdateData(FALSE); 
   		 m_RegVal.ReleaseBuffer(); 
    
    //SendMessage(WM_COMMAND,IDC_FIELD_VAL, MAKELONG(GetDlgItem(IDC_FIELD_VAL)->m_hWnd,EN_CHANGE));
        }      
  	    SetGrid(regval); 
        int cursel;
	    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();
        DWORD dw;
    	dw=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetItemData(cursel);
    	::LoadString(hPerLib,HIWORD(dw)+1+fldval,sztemp,255);
    	m_nFldVal.ReleaseBuffer();
    	((CListBox*)GetDlgItem(IDC_FIELD_LIST))->InsertString(cursel,sztemp);
    	((CListBox*)GetDlgItem(IDC_FIELD_LIST))->DeleteString(cursel+1);
	    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetItemData(cursel,dw); 
    	((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(cursel);

    	char szBuff[256]="";
    	if((( ( (cpuid==48)||(cpuid==49) )&&(m_nRegid==14) )||
        	( ( (cpuid>43 )&&(cpuid<48 ) )&&(m_nRegid==13) )||
       		( ( (cpuid==42)||(cpuid==43) )&&(m_nRegid==9 ) ) )&&
       		( ( cursel==0)||(cursel==1)||(cursel==7) ) )
    	{ 
      		int addtmp;
      		addtmp=( (m_nRegVal&0x80)!=0)?4:0;
      		addtmp+=(m_nRegVal&0x03); 
      		::LoadString(hPerLib,100+addtmp,szBuff,255);
      	}
   		else
	        strncpy(szBuff,&sztemp[12],128);   
   		SetDlgItemText(IDC_RO_EDIT2,szBuff);

   }   
  ///////////////////////////////////////////////////
    
    CDialog::OnVScroll(nSBCode, nPos, pScrollBar);
} 







void CFldDlg::GridInit(int regid)
{ 
	int j, i,nCol=0;
	char sztemp[64]="";
	char Buffer[256]="";
	char buf[16]="";              
	char tem[8]="";
	int Addrid;
	
	
	if( (cpuid==2) || (cpuid==3) )
        Addrid=START_ID+1100+regid;
    else
        Addrid=START_ID+1000+regid;	   
        
	::LoadString(hPerLib,Addrid,sztemp,255); 
	int ColWid,t,width;
	char *szaddr;
	int len,n,count=0; 
//  int Default_ColWidth=375; Default_Width=675;
//	t= m_pGrid->GetNumProperty("Width");

//	m_pGrid->SetNumProperty("Width",Default_Width);

	for(i=0;i<8;i++)
	   m_pGrid->SetNumProperty( "ColWidth",ColWidth,i);
    
    CPoint ptSize=FindCellPosition((int)m_pGrid->GetNumProperty("Rows"),
									(int)m_pGrid->GetNumProperty("Cols") );
	if (ptSize.x != (int)m_pGrid->GetNumProperty("Width") ||
		ptSize.y != (int)m_pGrid->GetNumProperty("Height"))
	{
		CRect rect;
		rect.left   = (int)m_pGrid->GetNumProperty("Left");
		rect.top    = (int)m_pGrid->GetNumProperty("Top");
		rect.right  = rect.left + ptSize.x;
		rect.bottom = rect.top  + ptSize.y; 
		m_pGrid->Move(rect);							
     }
    
	szaddr=strtok(sztemp,",");  
	
	m_pGrid->SetNumProperty("Row", 0);  
	
	for(i=0;i<8;i++)
	  {
		m_pGrid->SetNumProperty("Col", 7-i);
		m_pGrid->SetStrProperty("Text","-");
	   } 
	   
	
	   
	while(nCol<8)
	 {   
		szaddr=strtok(NULL,","); 
		if(szaddr!=NULL)
		{
		    len=strlen(szaddr); 
		    nCol=atoi(szaddr);
		 //   if( (atoi(szaddr)==nCol) && (len==1) )  
		    if( (len==1) )
		    {
			    
			    
			    ((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetText(count,Buffer); 
			    strncpy(buf,Buffer,7);
				
				int c=0;
				while(buf[c]!=' ') c++;             
				
				if(c>4)  
				    {
				      m_pGrid->SetNumProperty( "ColWidth",ColWidth+110*(c-4),7-nCol);
				      
    			      ptSize=FindCellPosition((int)m_pGrid->GetNumProperty("Rows"),
									(int)m_pGrid->GetNumProperty("Cols") );
				 	  if (ptSize.x != (int)m_pGrid->GetNumProperty("Width") ||
						  ptSize.y != (int)m_pGrid->GetNumProperty("Height"))
						{
						  CRect rect;
						  rect.left   = (int)m_pGrid->GetNumProperty("Left");
						  rect.top    = (int)m_pGrid->GetNumProperty("Top");
		 				  rect.right  = rect.left + ptSize.x;
						  rect.bottom = rect.top  + ptSize.y;
                          m_pGrid->Move(rect);
     					}

				      
				      
				     // width= m_pGrid->GetNumProperty( "Width");
                     // m_pGrid->SetNumProperty( "Width",width+110*(c-4)/14);
                     }
				m_pGrid->SetNumProperty("Col", 7-nCol);
				m_pGrid->SetStrProperty("Text", buf); 
				nCol++; 
				
				//nCol++;
			 }
			 else
			 { 			 		  	
			        j=0;
			 	 	n=(len+1)/2;
			 	 	((CListBox*)(GetDlgItem(IDC_FIELD_LIST)))->GetText(count,Buffer); 
			   		strncpy(buf,Buffer,15);
			   		
			   		while (buf[j]!='-')
			   			j++;    
			   		strncpy(tem,buf,j);	
			   		
			   		if(j>4)  
				       { m_pGrid->SetNumProperty( "ColWidth",ColWidth+110*(j-4),7-nCol);
				         
    			         ptSize=FindCellPosition((int)m_pGrid->GetNumProperty("Rows"),
									(int)m_pGrid->GetNumProperty("Cols") );
				 	     if (ptSize.x != (int)m_pGrid->GetNumProperty("Width") ||
						   ptSize.y != (int)m_pGrid->GetNumProperty("Height"))
						 {
						   CRect rect;
						   rect.left   = (int)m_pGrid->GetNumProperty("Left");
						   rect.top    = (int)m_pGrid->GetNumProperty("Top");
		 				   rect.right  = rect.left + ptSize.x;
						   rect.bottom = rect.top  + ptSize.y;
                           m_pGrid->Move(rect);
     					  }

				         
				         
//				         width= m_pGrid->GetNumProperty( "Width");
 
//				        m_pGrid->SetNumProperty( "Width",width+(j-4)*110/14);
                        }
			   		
			   		for(i=0;i<n;i++)
			   		{	
				   		if(buf[j-1]=='0')       //added on 18/Jan.
				   		  tem[j-1]=( '0' + i); 
				   		else
				   		  tem[j-1]=(buf[j-1]-i);
				   		  
				   		tem[j]='\0';
                		m_pGrid->SetNumProperty("Col", 7-nCol);
						m_pGrid->SetStrProperty("Text", tem); 	    
			 		    nCol++;
			 		  } 
			 		 
			 
			 	//	 nCol=nCol+n+1;  
			 }
		}
		else nCol=8;		
		count++;		       		
	 }	
				
			 
	 
}
                 
                 
                 
                 
                 
                 
                 
void CFldDlg::SetGrid(int regvalue)
{
        int nCol;  
        char buf[2]="";
        int n;
        
        m_pGrid->SetNumProperty("Row", 1);
		for ( nCol = 0; nCol < 8; nCol++)
		{   
		    n=regvalue%2;
		    regvalue=regvalue>>1;
		    buf[0]=n?'1':'0';
			m_pGrid->SetNumProperty("Col",7- nCol);
			m_pGrid->SetStrProperty("Text", buf);
		}
}


void CFldDlg::OnRegValKillFocus()
{
    int tem, cursel;
    tem=m_nRegVal;  
    
    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();    
    UpdateData(TRUE); 
    AnsiUpper(m_RegVal.GetBuffer(7)); 
    m_RegVal.ReleaseBuffer(); 
    
    if(!CheckString(m_RegVal) )  
        {
          m_bCanClose=FALSE;
          AfxMessageBox("Your input is not valible!",MB_OK);
           
       	  if(tem<0x0f)
       	  	sprintf(m_RegVal.GetBuffer(7),"0x0%X",tem);
       	  else
       	  	sprintf(m_RegVal.GetBuffer(7),"0x%X",tem);	
          UpdateData(FALSE);
            
            
           // GetFocus()->PostMessage(WM_LBUTTONUP); 
          GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN);
          GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 

         } 
     else{
    
    	  m_nRegVal=Hex2Dec(m_RegVal.GetBuffer(7));
    	  m_RegVal.ReleaseBuffer();
    	  UpdateData(FALSE);
    	  if(tem!=m_nRegVal)
   		   {
    			SetDlgList(m_nRegid); 
   				GridInit(m_nRegid); 
       			((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(cursel);
   	    		SetEdit(cursel); 
   		    }          
   	      }
}   


void CFldDlg::OnFieldValKillFocus()
{
	int  cursel;
    CString tem;
    tem=m_nFldVal;  
    
    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();    
    UpdateData(TRUE); 
    AnsiUpper(m_nFldVal.GetBuffer(16)); 
    m_nFldVal.ReleaseBuffer(); 
    int tint=Hex2Dec(m_nFldVal.GetBuffer(7));
    m_nFldVal.ReleaseBuffer();
    if(!(CheckString(m_nFldVal)&&(tint<m_nFldMax)) )  
      {
          m_bCanClose=FALSE;
          AfxMessageBox("Your input is not valible!",MB_OK);
           
          m_nFldVal=tem;
          UpdateData(FALSE);            
           
           //GetFocus()->SetCapture();
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN); 
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 

      } 
    
    else
     {
       if( tint>=m_nFldMax) 
        {
            m_bCanClose=FALSE;
            AfxMessageBox("The value is too large!",MB_OK);
            m_nFldVal=tem;
            UpdateData(FALSE);
           //GetFocus()->PostMessage(WM_LBUTTONUP);
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONDOWN);
            GetDlgItem(IDC_FIELD_LIST)->PostMessage(WM_LBUTTONUP); 
         }  
       else
         {
    		UpdateData(FALSE);
    	//	OnChangeFieldVal();
        	char Buff[8];
    		GetDlgItemText(IDC_RO_EDIT0,Buff,7);
    		char* token;
    		token=strtok(Buff,":");
            int regval,sign;
            sign=Hex2Dec(m_nFldVal.GetBuffer(7))-Hex2Dec(tem.GetBuffer(7));
    		m_nFldVal.ReleaseBuffer();
    		tem.ReleaseBuffer(); 
            regval=Hex2Dec(m_RegVal.GetBuffer(7)); 
   		    m_RegVal.ReleaseBuffer();
   			if(sign>0)
      		 	regval+=(abs(sign)<< atoi(token));
   			else regval-=(abs(sign)<< atoi(token));
   			m_nRegVal=regval;
   			if(regval<0x0f)
   				sprintf(m_RegVal.GetBuffer(7),"0x0%X",regval);
   			else	
   				sprintf(m_RegVal.GetBuffer(7),"0x%X",regval);
    		UpdateData(FALSE); 
   			m_RegVal.ReleaseBuffer(); 
  	        SetGrid(m_nRegVal);	  
   		  }	
      } 
    char sztemp[256];
    cursel=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetCurSel();
    DWORD dw;
    dw=((CListBox*)GetDlgItem(IDC_FIELD_LIST))->GetItemData(cursel);
    ::LoadString(hPerLib,HIWORD(dw)+1+Hex2Dec(m_nFldVal.GetBuffer(7)),sztemp,255);
    m_nFldVal.ReleaseBuffer();
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->InsertString(cursel,sztemp);
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->DeleteString(cursel+1);
   
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetItemData(cursel,dw); 
    ((CListBox*)GetDlgItem(IDC_FIELD_LIST))->SetCurSel(cursel);

    char szBuff[256]="";
    if((( ( (cpuid==48)||(cpuid==49) )&&(m_nRegid==14) )||
        ( ( (cpuid>43 )&&(cpuid<48 ) )&&(m_nRegid==13) )||
        ( ( (cpuid==42)||(cpuid==43) )&&(m_nRegid==9 ) ) )&&
        ( ( cursel==0)||(cursel==1)||(cursel==7) ) )
    { 
      int addtmp;
      addtmp=( (m_nRegVal&0x80)!=0)?4:0;
      addtmp+=(m_nRegVal&0x03); 
      ::LoadString(hPerLib,100+addtmp,szBuff,255);
      }
   else
      strncpy(szBuff,&sztemp[12],128);   
   SetDlgItemText(IDC_RO_EDIT2,szBuff);
}				         

void CFldDlg::OnSetfocusRegVal()
{
	m_bCanClose=TRUE;
}

void CFldDlg::OnSetfocusFieldList()
{
	m_bCanClose=TRUE;
}

void CFldDlg::OnSetfocusFieldVal()
{
  m_bCanClose=TRUE;
}

void CFldDlg::OnDestroy()
{
	(m_pParent->GetDlgItem(IDC_LIST1) )->SendMessage(WM_LBUTTONDOWN); 
   (m_pParent->GetDlgItem(IDC_LIST1) )->SendMessage(WM_LBUTTONUP);
   ((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->SetCurSel(m_nIndex);
  
	CDialog::OnDestroy();
	
//((CListBox*)(m_pParent->GetDlgItem(IDC_LIST1)))->SetCurSel(m_nIndex);
}


CPoint CFldDlg::FindCellPosition(int nRow, int nCol)
{
	ASSERT(nRow >= 0 && nRow <= m_pGrid->GetNumProperty("Rows"));
	ASSERT(nCol >= 0 && nCol <= m_pGrid->GetNumProperty("Cols"));

	CPoint ptPos(0, 0);

	// Get left edge of requested cell by summing widths of previous cells
	int nLeftCol = (int)m_pGrid->GetNumProperty("LeftCol");
	int nLeftFix = (int)m_pGrid->GetNumProperty("FixedCols");

	for (int i = 0; i < nCol; i++)
	{
		if (i < nLeftFix || i >= nLeftCol)  // only count displayed cells
			ptPos.x += (int)m_pGrid->GetNumProperty("ColWidth", i);
	}

	// Get top edge of requested cell by summing Heights of previous cells
	int nTopRow = (int)m_pGrid->GetNumProperty("TopRow");
	int nTopFix = (int)m_pGrid->GetNumProperty("FixedRows");
	for (i = 0; i < nRow; i++)
	{
		if (i < nTopFix || i >= nTopRow)    // only count displayed cells
			ptPos.y += (int)m_pGrid->GetNumProperty("RowHeight", i);
	}

	// ptPos is now in LOGICAL TWIPs
	// Convert to pixels

	CClientDC dc(this);

	ptPos.x = MulDiv(ptPos.x, dc.GetDeviceCaps(LOGPIXELSX), TWIPS_PER_INCH);
	ptPos.y = MulDiv(ptPos.y, dc.GetDeviceCaps(LOGPIXELSY), TWIPS_PER_INCH);

	ptPos.x += nCol;        // add one pixel per column for gap
	ptPos.y += nRow;        // add one pixel per row    for gap

	return ptPos;
}
