// HWTIP.H : Contains HWTIP.DLL implementation and initialization
//             code.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1995 HW FOX WORKSHOP
// All rights reserved.
//
/////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "tipcore.h"
#include "hwtip.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

static AFX_TIP_DATA afxdata;
/////////////////////////////////////////////////////////////////////////////
// CTipToolBar


CTipToolBar::CTipToolBar()   
            
{
   m_pTip=0; 
   m_bDelay=0;
   m_nDelayTime=15;
   m_nTimeCount=0;   
   m_bInWnd=0;
   m_BtnID=0; 
   m_OldBtnID=0; 
}

CTipToolBar::~CTipToolBar()
{
}


void CTipToolBar::FilterTipMessage(MSG *pMsg)
{                                   
  if(m_dwStyle==TWS_TIPS)
    { 
	  if(pMsg->message==WM_MOUSEMOVE||
	     pMsg->message==WM_NCMOUSEMOVE
	    ){ 
	       if(pMsg->message==WM_MOUSEMOVE)   
              {                           
                CPoint p;
                p.x=LOWORD(pMsg->lParam);
                p.y=HIWORD(pMsg->lParam);
                ::ClientToScreen(pMsg->hwnd,&p);
                m_BtnID=OnCmdHitTest(p);
                    if(m_BtnID>0)
                      {
                       if(m_BtnID!=m_OldBtnID || !m_pTip->IsWindowVisible())
                         TipProcess(p);
                       return;
                      }   
                       
              }
              
	       if(pMsg->hwnd!=m_hWnd)
	          ReleaseTip(TRUE);
	     }
	          
	  else
	  if(pMsg->message==WM_KEYDOWN||
	     pMsg->message==WM_SYSKEYDOWN||
	     pMsg->message==WM_LBUTTONDOWN||
	     pMsg->message==WM_MBUTTONDOWN||
	     pMsg->message==WM_RBUTTONDOWN||
	     pMsg->message==WM_LBUTTONUP||
	     pMsg->message==WM_MBUTTONUP||
	     pMsg->message==WM_RBUTTONUP)
	        ReleaseTip();
   }  
}

 
BOOL CTipToolBar::Create( CWnd *pParent, UINT ex_Style)
{                        
  m_dwStyle=ex_Style;
  return CToolBar::Create(pParent);
}

void CTipToolBar::SetBackColor(COLORREF colorRef)
{                               
  if(afxdata.g_Brush.GetSafeHandle())
     afxdata.g_Brush.DeleteObject();

  afxdata.g_Brush.CreateSolidBrush(colorRef);   
}
                     
void CTipToolBar::SetDelayTime(int nTimes)
{
  m_nDelayTime=nTimes;
}   

void CTipToolBar::SetTipFont(LOGFONT *logFont)
{                                    
  if(afxdata.g_Font.GetSafeHandle()&&logFont)
     afxdata.g_Font.DeleteObject();           
  if(logFont)                           
    afxdata.g_Font.CreateFontIndirect(logFont);

}                 

void CTipToolBar::ReleaseTip(BOOL bOut/*=0*/)
{                 
	 if(bOut)
	    m_bInWnd=0;

	 m_nTimeCount=0;
	 if(m_bDelay)
	   {
	     KillTimer(m_TimerID);      
	     m_bDelay=0;
	   }
	     
	 if(m_pTip)
	    if(m_pTip->IsWindowVisible())
	       m_pTip->ShowWindow(SW_HIDE);
	 
	 CWnd *pWnd=(AfxGetApp()->m_pMainWnd)->GetDlgItem(AFX_IDW_STATUS_BAR);
	 if(pWnd)
	    pWnd->SetWindowText(" ");
}
inline AFX_TBBUTTON* CTipToolBar::GetButtonPtr(int nIndex) const
{
	ASSERT(nIndex >= 0 && nIndex < m_nCount);
	ASSERT(m_pData != NULL);
	return ((AFX_TBBUTTON*)m_pData) + nIndex;
}

BEGIN_MESSAGE_MAP(CTipToolBar, CToolBar)
	ON_WM_MOUSEMOVE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTipToolBar message handlers                
void CTipToolBar::OnTimer(UINT )
{            
 m_nTimeCount++;    
 POINT point;
 CRect rect;
 GetWindowRect(&rect);
 GetCursorPos(&point);
 if(!rect.PtInRect(point))
    {
     m_nTimeCount=0;
     m_bDelay=0;
     KillTimer(m_TimerID);  
    }
 else   
 if(m_nTimeCount>m_nDelayTime)
   { 
     KillTimer(m_TimerID);  
  	 ShowTipCard(m_BtnID,m_Point);
     m_nTimeCount=0;
     m_bDelay=0;
   } 
}

void CTipToolBar::OnMouseMove(UINT nFlags,CPoint point)
{                              
  int nHit;
  if(m_dwStyle!=TWS_TIPS)
    {
     goto _mouse_end;
    } 
    
  ClientToScreen(&point);

  if(m_Point == point)
    {
     goto _mouse_end;
    } 
     
  //PostMessage(BT_PROC,0,MAKELONG(point.x,point.y));   
  nHit=HitTipTest(point);
  
  switch(nHit){
     case HITTYPE_TIP_SUCCESS: 
          TipProcess(point);
          break;
          
     case HITTYPE_TIP_OUTSIDE:
          m_bInWnd=0;
     case HITTYPE_TIP_INACTIVE:
     case HITTYPE_TIP_DISABLED:
     default:
          ReleaseTip();
          break;
   } 
         
 _mouse_end:
 
  ScreenToClient(&point);
  CToolBar::OnMouseMove(nFlags,point);

}                                          

void CTipToolBar::TipProcess(CPoint point)
{
          m_Point   = point; 
          if(m_OldBtnID==m_BtnID && m_pTip->IsWindowVisible())   
             return;
          else
             m_OldBtnID=m_BtnID;
              
		  if(m_bInWnd)
		    { 
		       m_pTip->ShowWindow(SW_HIDE);
		       m_nTimeCount=m_nDelayTime-1;
		    }             
		   if(m_bDelay) 
             {
              KillTimer(m_TimerID);
              m_bDelay=0;
             }           
             
		   if(SetTimer(m_TimerID,55,NULL)==NULL)
	         {
	             ShowTipCard(m_BtnID,m_Point);   
	             return;
	         }//if((SetTimer(m_TimerID,100,NULL)==NULL))
	        else
	         {
	           m_bDelay=1;
	           return;
             }
             
} 
                                         
int CTipToolBar::HitTipTest(CPoint point/*screen postion*/)
{
    m_BtnID=(UINT)-1;
    
	if (GetActiveWindow()!=AfxGetApp()->m_pMainWnd)
		return HITTYPE_TIP_INACTIVE;

	CWnd* pParent = GetTopLevelParent();
	if (!pParent->IsWindowEnabled())
		return HITTYPE_TIP_DISABLED;
        
	HWND hWnd = ::WindowFromPoint(point);
	if (hWnd == NULL || (hWnd != m_hWnd && !::IsChild(m_hWnd, hWnd)))
		return HITTYPE_TIP_OUTSIDE;


//	m_BtnID = OnCmdHitTest(point);                                       
//	if(m_BtnID != 0)
//	   return HITTYPE_TIP_SUCCESS;

	ScreenToClient(&point);
	   
    int nHit=HitTest(point);
    if(nHit >= 0)
      {
        AFX_TBBUTTON* pTBB = GetButtonPtr(nHit);
	    m_BtnID= pTBB->nID;
        return HITTYPE_TIP_SUCCESS;
      }  

     return HITTYPE_TIP_NOTHING;
	// finally do the hit test on the items within the control bar
}

UINT CTipToolBar::OnCmdHitTest(CPoint point)
{
	ASSERT_VALID(this);

	// check child windows first by calling CControlBar
//	::ClientToScreen(m_hWnd, &point);

	// walk through all child windows
	//  (don't use WindowFromPoint, because it ignores disabled windows)
	HWND hWndChild = ::GetWindow(m_hWnd, GW_CHILD);
	while (hWndChild != NULL)
	{
	 //if (GetWindowLong(hWndChild, GWL_STYLE) & WS_VISIBLE)
		{
			// see if point is inside window rect of child
			CRect rect;
			::GetWindowRect(hWndChild, &rect);
			if (rect.PtInRect(point))
			{
				// return positive hit if control ID isn't -1
				UINT nHit = ::GetDlgCtrlID(hWndChild);
				if (nHit > 0)
				{
					return nHit;
				}
			}
		}
	  hWndChild = ::GetWindow(m_hWnd, GW_HWNDNEXT);
	}

	return 0;    // not found
	
}


void CTipToolBar::ShowTipCard(UINT ID,POINT point)  
{    
   POINT p;
   CRect rect;
   GetWindowRect(&rect);
   GetCursorPos(&p);
   if(!rect.PtInRect(p))
      return;
                                                      
   if(::GetActiveWindow()!=AfxGetApp()->m_pMainWnd->m_hWnd || ID==0) 
      return;

  m_bInWnd=1;  
  CString string;
  CString stringText;

  if(string.LoadString(ID))
    { 
    
      int nIdx=string.Find('\n');  
      
      if(nIdx>=0)
         stringText=string.Mid(0,nIdx);
      else
         return;
         
      CWnd *pWnd=(AfxGetApp()->m_pMainWnd)->GetDlgItem(AFX_IDW_STATUS_BAR);
      if(pWnd && stringText.GetLength())
         pWnd->SetWindowText((const char *)stringText);
     
      if(nIdx>=0)
        {           
          stringText=string.Mid(nIdx+1,string.GetLength()-nIdx);
          if(stringText.GetLength())
             DrawContent(stringText,point); 
          else
             return;
        } 
    }  
                                   
}  


void CTipToolBar::DrawContent(LPCSTR lpText,POINT point)
{                  
  
  //char      szText[256];
  //lstrcpy(szText,lpText);
  ASSERT_VALID(this);
  ASSERT_VALID(m_pTip);
  CClientDC dc(m_pTip);
  CFont     font;   

  dc.SelectObject(&afxdata.g_Font);  
  int nWidth=dc.GetTextExtent(lpText,lstrlen(lpText)).cx+15;
  int nHeight=dc.GetTextExtent(lpText,lstrlen(lpText)).cy+4;

  CRect rect,rectWin;
  GetWindowRect(&rect);
  GetParent()->GetWindowRect(&rectWin);
  int y=rect.bottom;//+2; 
  
  int x=point.x-nWidth/2+4;
  if(x<0)x=0;                               
  
/////////////////////////////////////////////  
  CRect rectTip,rectFrame,r;/////////////////         
  int cx = GetSystemMetrics(SM_CXSCREEN);
  int cy = GetSystemMetrics(SM_CYSCREEN);
  GetParent()->GetClientRect(&rectFrame);
  GetParent()->ClientToScreen(&rectFrame);
  rectFrame.left=rectFrame.left>=0 ? rectFrame.left : 0;
  rectFrame.right=rectFrame.right<=cx ? rectFrame.right : cx;
  rectFrame.bottom = rectFrame.bottom<=cy ? rectFrame.bottom : cy;
  
  rectTip.SetRect(x,y,x+nWidth,y+nHeight);

  r=rectTip;
  if(rectTip.left<rectFrame.left)
    { rectTip.left=rectFrame.left;
      rectTip.right=rectTip.left+r.Width();}

  if(rectTip.right>rectFrame.right)
    { rectTip.right=rectFrame.right;
      rectTip.left=rectTip.right-r.Width();}
   
  if(rectTip.bottom>rectFrame.bottom)
    {rectTip.bottom=rectFrame.bottom;
     rectTip.top=rectTip.bottom-r.Height()-rect.Height();}

  rectTip.top+=2;   
   
//////////////////////////////////////////    
  m_pTip->SetWindowText(lpText);//////////
  m_pTip->SetWindowPos(NULL,//&wndTopMost,
                       rectTip.left,rectTip.top,nWidth,
                       nHeight,
                       SWP_SHOWWINDOW|SWP_NOACTIVATE|SWP_NOZORDER);
                         
}

int CTipToolBar::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CToolBar::OnCreate(lpCreateStruct) == -1)
		return -1;
		
    LOGFONT logFont;
    _fmemset(&logFont,0,sizeof(LOGFONT));
    logFont.lfHeight=14;
    logFont.lfWidth=7;
    logFont.lfWeight=100;
    lstrcpy(logFont.lfFaceName,"System");//"Arail");
                                                  
    CRect rect(0,0,0,0);                                              
	m_pTip = new CTipWnd();
    ((CTipWnd *)m_pTip)->CreateTipWnd(this);

	SetBackColor(RGB(255,255,128));
    SetTipFont(&logFont);
	return 0;
}

void CTipToolBar::OnDestroy()
{                         
	m_pTip->DestroyWindow();
	delete m_pTip;
    if(afxdata.g_Brush.GetSafeHandle())
       afxdata.g_Brush.DeleteObject();
    if(afxdata.g_Font.GetSafeHandle())
       afxdata.g_Font.DeleteObject();           

	CToolBar::OnDestroy();
} 
                        

/////////////////////////////////////////////////////////////////////////////
// CTipStstic

CTipWnd::CTipWnd()
{ 
}

CTipWnd::~CTipWnd()
{ 
}
      
BOOL CTipWnd::CreateTipWnd(CWnd *pParent)
{       
 ASSERT(pParent && pParent->m_hWnd); 
 return 
 CreateEx(NULL,
          AfxRegisterWndClass(CS_SAVEBITS|CS_HREDRAW),
          NULL,
          WS_POPUP|WS_BORDER,
	      0,0,0,0,pParent->m_hWnd,0);  

}      

BEGIN_MESSAGE_MAP(CTipWnd, CWnd)
	//{{AFX_MSG_MAP(CTipStstic)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
/////////////////////////////////////////////////////////////////////////////
// CTStstic message handlers
void CTipWnd::OnPaint()
{
  CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here 
  GetWindowText(m_stringText);	
  CRect rect;
  dc.SaveDC();
  dc.SelectObject(&afxdata.g_Font);
  GetClientRect(&rect);
  dc.FillRect(&rect,&afxdata.g_Brush);      
  dc.SetBkMode(TRANSPARENT);
  dc.DrawText((const char *)m_stringText,m_stringText.GetLength(),
              &rect,DT_CENTER|DT_VCENTER);
  dc.RestoreDC(-1);

}

