// HWTIP.H : Contains HWTIP.DLL implementation and initialization
//             code.
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1995 HW FOX WORKSHOP
// All rights reserved.
//
/////////////////////////////////////////////////////////////////////
#ifndef _HW_TIP_TOOLBAR
#define _HW_TIP_TOOLBAR

#define  TWS_TIPS                0x0010
#define  TWS_NO_TIPS             0x0000

struct AFX_TBBUTTON
{
	UINT nID;        // Command ID that this button sends
	UINT nStyle;    // TBBS_ styles
	int iImage;     // index into mondo bitmap of this button's picture
						// or size of this spacer
};


/////////////////////////////////////////////////////////////////////////////
// CTipToolBar window

class CTipToolBar : public CToolBar
{
// Construction
public:
	CTipToolBar();
    BOOL Create( CWnd *pParent, UINT ex_Style=TWS_NO_TIPS);    
    void FilterTipMessage(MSG *pMsg);                              
    
// Attributes
public:
    void SetBackColor(COLORREF);
    void SetDelayTime(int nTimes);//nTimes * 55ms
    void SetTipFont(LOGFONT *logFont);

private:
   CWnd       *m_pTip; 
   BOOL       m_bDelay;
   BOOL       m_bInWnd;    
   UINT       m_dwStyle;  
   int        m_nDelayTime;
   int        m_nTimeCount;
   UINT       m_BtnID;
   UINT       m_OldBtnID;
   CPoint     m_Point;
   enum { m_TimerID = 1300 };
     
public:
// Operations
protected:
void TipProcess(CPoint point);

private:                  
void ShowTipCard(UINT ID,POINT point);
void DrawContent(LPCSTR lpText,POINT point);
void ReleaseTip(BOOL bOut=FALSE);
int  HitTipTest(CPoint point/*screen postion*/);
UINT OnCmdHitTest(CPoint point);

// Implementation
public:
	virtual ~CTipToolBar();
protected:
   inline AFX_TBBUTTON* GetButtonPtr(int nIndex) const;

protected:
	// Generated message map functions

	//{{AFX_MSG(CTipToolBar)
	afx_msg void OnMouseMove(UINT nFlags,CPoint point);
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
#endif
/////////////////////////////////////////////////////////////////////////////
