
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/INDEXTBL.H__   1.29   02 Apr 1996 09:29:48   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/INDEXTBL.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:29:48   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:57:28   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:10:26   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:18   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:56   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:48   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:40   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:20   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:18   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:18   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:14   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:38   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:30   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:02   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:52   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:40   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:46   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:40   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:18   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:38   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:52   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:44   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:42   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:04   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:58   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:54   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: indextbl.h
**
** Title: Index Table
**
** Purpose:
**  Supports the creation of a Base Index Table and Type Index Table and
**  provides methods for adding an index and retrieving an offset for an index
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   C:/EPSLDV1/SRC/LOG/INDEXTBL.H__   1.29   02 Apr 1996 09:29:48   Shirley  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _INDEXTBL_
                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#include "memmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef U32 TABLE_INDEX;                     // may be large numbers of types


                  /*********************************************
                   *                                           *
                   *   MEMBER FUNCTION PROTOTYPES AND INLINES  *
                   *                                           *
                   *********************************************/

class IndexTable : public Table {

private:
   U32 entryCount;            // number of entries in the table

protected:
   U32 maxIndex;              // largest index allowed

public:
//---------------------------------------------------------------------------
// IndexTable
//
// Purpose:
//    Initialize index table variables to default values.
//    Does not create the table or fix up the size (SetIndexTableSize)
//      because a constructor cannot return a parameter, and there can
//      be an out-of-memory error resulting from creation of table.
//---------------------------------------------------------------------------
IndexTable();    // constructor


//---------------------------------------------------------------------------
// GetEntryCount
//
// Purpose:
//    FOR TESTING.
//    Return the value of the variable holding the index entries put into the
//    table so far.
//---------------------------------------------------------------------------
U32 GetEntryCount() { return entryCount; };


//---------------------------------------------------------------------------
// AddIndex
//
// Purpose:
//    Add an index into the index table with its offset to the item.
//
// Input parameters:
//    index: TABLE_OFFSET index into index table.
//    itemOffset: offset into the symbol table to be stored at table[index]
//
// Output parameters: None
//
// Error:
//    Reports ER_INDEX_ALREADY_EXISTS if the index already has a legitimate
//    value in the index location in the table.
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       the maximum table size
//------------------------------------------------------------------------
RETCODE AddIndex(TABLE_INDEX index, TABLE_OFFSET itemOffset);


//---------------------------------------------------------------------------
// GetOffset
//
// Purpose:
//    Retrieve offset of item in symbol table given the index to the index
//    table.
//
// Input parameters:
//    index: TABLE_OFFSET index into index table.
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       the table size
//------------------------------------------------------------------------
RETCODE GetOffset(TABLE_INDEX index, TABLE_OFFSET& itemOffset);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// SetMaxIndex
//
// Purpose:
//    Set the maximum index value <maxIndex>
//------------------------------------------------------------------------
VOID SetMaxIndex(U32 index)  { maxIndex = index; };


//---------------------------------------------------------------------------
// UpdateOffset
//
// Purpose:
//    Updates the table offset of the type index specified.  This is to
//    be used by the type table manager when creating new types.  If a 
//    type extends past a 64k boundary the type offset needs to be modified.
//
// Input parameters:
//    index: TABLE_OFFSET index into index table.
//    newOffset: TABLE_OFFSET to be inserted in place of the existing value.
//
// Output parameters:
//    none:
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       the table size
//------------------------------------------------------------------------
RETCODE UpdateOffset(TABLE_INDEX index, TABLE_OFFSET newOffset);

};
#define _INDEXTBL_
#endif
/******************************** E O F *************************************/
