
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/LABELDLG.CPP   1.29   02 Apr 1996 09:28:40   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/LABELDLG.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:28:40   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:14   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:40   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:32   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:28   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:04   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:58   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:58   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:18   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:08   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:44   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:12   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:24   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:12   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:33:28   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:12   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:00   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:40   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:02   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:00   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:32   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:32   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:40   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:22   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:04   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:26   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  LABELDLG.CPP
//
//  Description:The implement file for the class: CLabelDialog
//
//  Author:     Roger Zhang
//
//  Date:       08/17/95
//
//  Modification:
//
//      1. 08/17/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include "dibapi.h"
#include "labeldlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLabelDialog dialog


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLabelDialog::CLabelDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CLabelDialog::IDD, pParent)
{
    m_hDIB = NULL;
    m_palDIB = NULL;
    //{{AFX_DATA_INIT(CLabelDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    Create(CLabelDialog::IDD, pParent);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLabelDialog::~CLabelDialog()
{
    if (m_hDIB != NULL)     ::GlobalFree((HGLOBAL) m_hDIB);
    if (m_palDIB != NULL)   delete m_palDIB;
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::InitDIBData()
{
    if (m_hDIB == NULL) return;
    
    LPSTR lpDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
    if (::DIBWidth(lpDIB) > INT_MAX ||::DIBHeight(lpDIB) > INT_MAX) {
        ::GlobalUnlock((HGLOBAL) m_hDIB);
        ::GlobalFree((HGLOBAL) m_hDIB);
        m_hDIB = NULL;
        AfxMessageBox("DIB is too large");
        return;
    }
    ::GlobalUnlock((HGLOBAL) m_hDIB);
    // Create copy of palette
    m_palDIB = new CPalette;
    if (m_palDIB == NULL) {
        // we must be really low on memory
        ::GlobalFree((HGLOBAL) m_hDIB);
        m_hDIB = NULL;
        return;
    }
    if (::CreateDIBPalette(m_hDIB, m_palDIB) == NULL) {
        // DIB may not have a palette
        delete m_palDIB;
        m_palDIB = NULL;
        return;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output:                                          
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLabelDialog::OpenDIB(const char* pszPathName)
{
    CFile file;
    CFileException fe;
    if(!file.Open(pszPathName, CFile::modeRead|CFile::shareDenyWrite, &fe)) {
        AfxMessageBox("Open DIB error!");
        return FALSE;
    }

    // replace calls to Serialize with ReadDIBFile function
    TRY
    {
        m_hDIB = ::ReadDIBFile(file);
    }
    CATCH (CFileException, eLoad)
    {
        file.Abort(); // will not throw an exception
        AfxMessageBox("Read DIB error!");
        m_hDIB = NULL;
        return FALSE;
    }
    END_CATCH

    InitDIBData();

    if (m_hDIB == NULL) {
        // may not be DIB format
        AfxMessageBox("Couldn't load DIB");
        return FALSE;
    }
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
LRESULT CLabelDialog::OnDoRealize(WPARAM wParam, LPARAM)
{
    ASSERT(wParam != NULL);
    if (m_hDIB == NULL)
        return 0L;  

    if (m_palDIB != NULL) {
        CClientDC dc(this);
        CPalette* oldPalette = 
            dc.SelectPalette(m_palDIB, ((HWND)wParam) != m_hWnd);

        if (oldPalette != NULL) {
            UINT nColorsChanged = dc.RealizePalette();
            dc.SelectPalette(oldPalette, TRUE);
        } else {
            TRACE0("\tSelectPalette failed\n");
        }
    }

    return 0L;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CLabelDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLabelDialog, CDialog)
    //{{AFX_MSG_MAP(CLabelDialog)
    ON_WM_PAINT()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLabelDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLabelDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    CenterWindow();
    SetWindowPos(&wndTopMost, 0, 0, 10, 10, SWP_NOMOVE|SWP_NOSIZE);

	extern char szAppPath[];
	char szName[260];                   
	strcpy(szName, szAppPath);
	strcat(szName, "label.bmp");
	
    /*GetModuleFileName(AfxGetApp()->m_hInstance, szName, sizeof(szName));

    char path_buffer[_MAX_PATH];
    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];
    _splitpath(szName, drive, dir, NULL, NULL);
    _makepath(szName, drive, dir, "label", "bmp" );*/
    
    OpenDIB(szName/*"label.bmp"*/);
    OnDoRealize((WPARAM)m_hWnd, 0);   // same as SendMessage(WM_DOREALIZE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    if (m_hDIB != NULL) {
        LPSTR lpDIB = (LPSTR) ::GlobalLock((HGLOBAL) m_hDIB);
        int cxDIB = (int) ::DIBWidth(lpDIB);         // Size of DIB - x
        int cyDIB = (int) ::DIBHeight(lpDIB);        // Size of DIB - y
        ::GlobalUnlock((HGLOBAL) m_hDIB);
        CRect rcDIB;
        rcDIB.top = rcDIB.left = 0;
        rcDIB.right = cxDIB;
        rcDIB.bottom = cyDIB;
        CRect rcDest = rcDIB;
        ::PaintDIB(dc.m_hDC, &rcDest, m_hDIB, &rcDIB, m_palDIB);
    }
    
    // Do not call CDialog::OnPaint() for painting messages
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::OnOK()
{
    // TODO: Add extra validation here
}   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLabelDialog::OnCancel()
{
    // TODO: Add extra validation here
}   

////////////////////////////////(EOF)////////////////////////////////////////
