
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/LANECOM.CPP   1.29   02 Apr 1996 09:25:54   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/LANECOM.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:25:54   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:57:14   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:34   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:20   Shirley
** EasyPack/SLD Version 0.36
** 
**    Rev 1.24   01 Feb 1996 10:15:22   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:52   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:38   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:44   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:24   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:54   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:08   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:14   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:10   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:44:44   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:58   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:50   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:10   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:42   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:24   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:06   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:28   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  LANECOM.CPP
//
//  Description:Define public varible and function
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "trcserve.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

char searchContent[129];
UINT nPrevGotoFrameNo = 0;

extern void MemServerSetMap(const unsigned short uStart, const unsigned short uEnd,
    const unsigned char uchType, const char chMapAttr);
extern BOOL MemServerGetMap(unsigned short& uStart, unsigned short& uEnd,
    unsigned char& uchType, char& chMapAttr);

extern STATUS AbiSetEvent(BUS_EVENT);
extern STATUS AbiSetTrigLevel(int,TRIGGER_LEVEL);
extern STATUS AbiSetTrigLogic(TRIGGER_LOGIC);
extern STATUS AbiSetQualify(QUALIFY);

extern class CBusEvent ev1;
extern class CBusEvent ev2;
extern class CExtEvent ev3;
extern class CLevel Le1;
extern class CLevel Le2;
extern class CTrigger Trig;
extern class CQualify qlfy;

void SaveConfig(LPCSTR filename, int option)
{
unsigned short startAddress,endAddress;
unsigned char space;
char attribute;
int count;
WORD w;
CFile file;
BOOL b;
int i,j;

    b = file.Open(filename,CFile::modeCreate|CFile::modeWrite);
    if (!b) 
    {
        file.Abort();
        MessageBox(NULL,"Error Open Map File",NULL,MB_OK|MB_ICONHAND|MB_ICONSTOP);
        return;
    }
    CArchive ar(&file,CArchive::store);

	w = (WORD)option;
    ar << w;
    
    if (option&0x1)
    {
    	// save map
	    space = 1;
	    startAddress=0;
	    endAddress=0xffff;
	    count = 0;
	    do{
	        MemServerGetMap(startAddress,endAddress,space,attribute);
	        startAddress=endAddress+1;
	        count++;
	    }while(endAddress<0xffff);         
	    
	    space = 2;
	    startAddress=0;
	    endAddress=0xffff;
	    do{
	        MemServerGetMap(startAddress,endAddress,space,attribute);
	        startAddress=endAddress+1;
	        count++;
	    }while(endAddress<0xffff);
	    
	    w = (WORD)count;
	    ar << w;
	    
	    space = 1;
	    startAddress=0;
	    endAddress=0xffff;
	    count = 0;
	    do{
	        MemServerGetMap(startAddress,endAddress,space,attribute);
	        w = (WORD)startAddress;
	        ar << w;
	        w = (WORD)endAddress;
	        ar << w;
	        w = (WORD)space;
	        ar << w;
	        w = (WORD)attribute;
	        ar << w;
	        
	        startAddress=endAddress+1;
	        count++;
	    }while(endAddress<0xffff);         
	
	    space = 2;
	    startAddress=0;
	    endAddress=0xffff;
	    count = 0;
	    do{
	        MemServerGetMap(startAddress,endAddress,space,attribute);
	        w = (WORD)startAddress;
	        ar << w;
	        w = (WORD)endAddress;
	        ar << w;
	        w = (WORD)space;
	        ar << w;
	        w = (WORD)attribute;
	        ar << w;
	        
	        startAddress=endAddress+1;
	        count++;
	    }while(endAddress<0xffff);         
    }
    
    if (option&0x2)
    {
    	// save event
    	ar << ev1.m_eventID;
    	ar << (WORD)(ev1.m_nClearflag);
    	ar << ev1.m_busEv.setMode;
    	for(i=0;i<12;i++)
    	{
    		ar << ev1.m_busEv.qlfyType[i];
    	}
    	ar << ev1.m_busEv.data1;
    	ar << ev1.m_busEv.data2;
    	ar << ev1.m_busEv.status;
    	ar << ev1.m_busEv.extrn;
    	ar << ev1.m_busEv.extMask;
    	ar << ev1.m_busEv.count;
    	ar << ev1.m_busEv.RES[0];
    	ar << ev1.m_busEv.RES[1];
    	ar << ev1.m_busEv.RES[2];
    	ar << ev1.m_busEv.addrCount;
    	for(i=0;i<10;i++)
    		for (j=0;j<4;j++)
    			ar << ev1.m_busEv.addr[i][j];
    	
    	ar << ev2.m_eventID;
    	ar << (WORD)(ev2.m_nClearflag);
    	ar << ev2.m_busEv.setMode;
    	for(i=0;i<12;i++)
    	{
    		ar << ev2.m_busEv.qlfyType[i];
    	}
    	ar << ev2.m_busEv.data1;
    	ar << ev2.m_busEv.data2;
    	ar << ev2.m_busEv.status;
    	ar << ev2.m_busEv.extrn;
    	ar << ev2.m_busEv.extMask;
    	ar << ev2.m_busEv.count;
    	ar << ev2.m_busEv.RES[0];
    	ar << ev2.m_busEv.RES[1];
    	ar << ev2.m_busEv.RES[2];
    	ar << ev2.m_busEv.addrCount;
    	for(i=0;i<10;i++)
    		for (j=0;j<4;j++)
    			ar << ev2.m_busEv.addr[i][j];

//    	ar << ev3.m_eventID;
    	ar << (WORD)(ev3.m_nClearflag);
    	ar << ev3.m_extEv.setMode;
    	for(i=0;i<12;i++)
    	{
    		ar << ev3.m_extEv.qlfyType[i];
    	}
    	ar << ev3.m_extEv.data1;
    	ar << ev3.m_extEv.data2;
    	ar << ev3.m_extEv.status;
    	ar << ev3.m_extEv.extrn;
    	ar << ev3.m_extEv.extMask;
    	ar << ev3.m_extEv.count;
    	ar << ev3.m_extEv.RES[0];
    	ar << ev3.m_extEv.RES[1];
    	ar << ev3.m_extEv.RES[2];
    	ar << ev3.m_extEv.addrCount;
    	for(i=0;i<10;i++)
    		for (j=0;j<4;j++)
    			ar << ev3.m_extEv.addr[i][j];
    }                
    
    if (option&0x4)
    {
    	// save trigger
    	ar << (WORD)(Le1.m_nLevelID);
    	ar << Le1.m_levelStructSave.TraceFlg;
    	ar << Le1.m_levelStructSave.TimerFlg;
    	ar << Le1.m_levelStructSave.Condition;

    	ar << (WORD)(Le2.m_nLevelID);
    	ar << Le2.m_levelStructSave.TraceFlg;
    	ar << Le2.m_levelStructSave.TimerFlg;
    	ar << Le2.m_levelStructSave.Condition;
    	
    	ar << Trig.m_nOnOffFlg;
    	ar << Trig.m_trig.TrigFlg;
    	ar << Trig.m_trig.RunFlg;
    	ar << Trig.m_trig.DlayCnt;
    	ar << Trig.m_trig.LevelCount;
    	ar << Trig.m_trig.LevelID[0];
    	ar << Trig.m_trig.LevelID[1];
    	ar << Trig.m_trig.LevelID[2];
    	ar << Trig.m_trig.LevelID[3];
    }
	
    ar.Close();
    file.Close();
}

void LoadConfig(LPCSTR filename, int option)
{
unsigned short startAddress,endAddress;
unsigned char space;
char attribute;
int count;
int i,j;
WORD w;
CFile file;
BOOL b;
int option2;
int nErrorID;
TRIGGER_LEVEL trigLevel;
TRIGGER_LOGIC trig;
    

    b = file.Open(filename,CFile::modeRead);
    if (!b) 
    {
        file.Abort();
        MessageBox(NULL,"Error Open Map File",NULL,MB_OK|MB_ICONHAND|MB_ICONSTOP);
        return;
    }

    CArchive ar(&file,CArchive::load);

	ar >> w;
	option2 = (int)w;
	
	if (option2&0x1)
	{
		// load map
	    ar >> w;
	    count = (int)w;
	
	    for(i=1;i<=count;i++)
	    {
	        ar >> w;
	        startAddress = (unsigned short)w;
	        ar >> w;
	        endAddress = (unsigned short)w;
	        ar >> w;
	        space = (unsigned char)w;
	        ar >> w;
	        attribute = (char)w;
	        
#ifdef _LANE
			if (option&0x1)
	        MemServerSetMap(startAddress,endAddress,space,attribute);
#endif  
	    }
	}
	
	if (option2&0x2)
	{
		// load event
    	ar >> ev1.m_eventID;
    	ar >> w;
    	ev1.m_nClearflag = (int)w;
    	ar >> ev1.m_tmpBusEv.setMode;
    	for(i=0;i<12;i++)
    	{
    		ar >> ev1.m_tmpBusEv.qlfyType[i];
    	}
    	ar >> ev1.m_tmpBusEv.data1;
    	ar >> ev1.m_tmpBusEv.data2;
    	ar >> ev1.m_tmpBusEv.status;
    	ar >> ev1.m_tmpBusEv.extrn;
    	ar >> ev1.m_tmpBusEv.extMask;
    	ar >> ev1.m_tmpBusEv.count;
    	ar >> ev1.m_tmpBusEv.RES[0];
    	ar >> ev1.m_tmpBusEv.RES[1];
    	ar >> ev1.m_tmpBusEv.RES[2];
    	ar >> ev1.m_tmpBusEv.addrCount;
    	for(i=0;i<10;i++)
    		for (j=0;j<4;j++)
    			ar >> ev1.m_tmpBusEv.addr[i][j];
    	
    	ar >> ev2.m_eventID;
    	ar >> w;
    	ev2.m_nClearflag = (int)w;
    	ar >> ev2.m_tmpBusEv.setMode;
    	for(i=0;i<12;i++)
    	{
    		ar >> ev2.m_tmpBusEv.qlfyType[i];
    	}
    	ar >> ev2.m_tmpBusEv.data1;
    	ar >> ev2.m_tmpBusEv.data2;
    	ar >> ev2.m_tmpBusEv.status;
    	ar >> ev2.m_tmpBusEv.extrn;
    	ar >> ev2.m_tmpBusEv.extMask;
    	ar >> ev2.m_tmpBusEv.count;
    	ar >> ev2.m_tmpBusEv.RES[0];
    	ar >> ev2.m_tmpBusEv.RES[1];
    	ar >> ev2.m_tmpBusEv.RES[2];
    	ar >> ev2.m_tmpBusEv.addrCount;
    	for(i=0;i<10;i++)
    		for (j=0;j<4;j++)
    			ar >> ev2.m_tmpBusEv.addr[i][j];

    	ar >> w;
    	ev3.m_nClearflag = (int)w;
    	ar >> ev3.m_tmpExtEv.setMode;
    	for(i=0;i<12;i++)
    	{
    		ar >> ev3.m_tmpExtEv.qlfyType[i];
    	}
    	ar >> ev3.m_tmpExtEv.data1;
    	ar >> ev3.m_tmpExtEv.data2;
    	ar >> ev3.m_tmpExtEv.status;
    	ar >> ev3.m_tmpExtEv.extrn;
    	ar >> ev3.m_tmpExtEv.extMask;
    	ar >> ev3.m_tmpExtEv.count;
    	ar >> ev3.m_tmpExtEv.RES[0];
    	ar >> ev3.m_tmpExtEv.RES[1];
    	ar >> ev3.m_tmpExtEv.RES[2];
    	ar >> ev3.m_tmpExtEv.addrCount;
    	for(i=0;i<10;i++)
    		for (j=0;j<4;j++)
    			ar >> ev3.m_tmpExtEv.addr[i][j];
	}
	
	if (option2&0x4)
	{
		// load trigger
    	ar >> w;
    	Le1.m_nLevelID = (int)w;
    	ar >> Le1.m_levelStruct.TraceFlg;
    	ar >> Le1.m_levelStruct.TimerFlg;
    	ar >> Le1.m_levelStruct.Condition;

    	ar >> w;
    	Le2.m_nLevelID = (int)w;
    	ar >> Le2.m_levelStruct.TraceFlg;
    	ar >> Le2.m_levelStruct.TimerFlg;
    	ar >> Le2.m_levelStruct.Condition;
    	
    	ar >> Trig.m_nOnOffFlg;
    	ar >> Trig.m_tmpTrig.TrigFlg;
    	ar >> Trig.m_tmpTrig.RunFlg;
    	ar >> Trig.m_tmpTrig.DlayCnt;
    	ar >> Trig.m_tmpTrig.LevelCount;
    	ar >> Trig.m_tmpTrig.LevelID[0];
    	ar >> Trig.m_tmpTrig.LevelID[1];
    	ar >> Trig.m_tmpTrig.LevelID[2];
    	ar >> Trig.m_tmpTrig.LevelID[3];
	}

	if (option&0x1)
	{
		// set map
		if (!(option2&0x1))
		{
	        MessageBox(NULL,"Not Found Map Information!",NULL,MB_OK|MB_ICONQUESTION);
		}
	}
	
	if (option&0x2)
	{
		// set event
		if (!(option2&0x2))
		{
	        MessageBox(NULL,"Not Found Event Information!",NULL,MB_OK|MB_ICONQUESTION);
		}
		else
		{
			if(!ev1.m_nClearflag)
				{
				 nErrorID = AbiSetEvent(ev1.m_tmpBusEv);
				 if (ICE_OK==nErrorID)
					{
				 	 memcpy(&(ev1.m_busEv),&(ev1.m_tmpBusEv),sizeof(BUS_EVENT));
					}
				 else
					{
					 MessageBox(NULL,"EV1 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
					}	
                }
             else
                {
				 nErrorID = AbiClrEvent(1);
				 if(ICE_OK != nErrorID)
					{
					 MessageBox(NULL,"EV1 Clear Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
					}	
                }
			if(!ev2.m_nClearflag)
				{
				 nErrorID = AbiSetEvent(ev2.m_tmpBusEv);
				 if (ICE_OK==nErrorID)
					{
				 	 memcpy(&(ev2.m_busEv),&(ev2.m_tmpBusEv),sizeof(BUS_EVENT));
					}
				 else
					{
					 MessageBox(NULL,"EV2 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
					}	
                }
             else
                {
				 nErrorID = AbiClrEvent(2);
				 if(ICE_OK != nErrorID)
					{
					 MessageBox(NULL,"EV2 Clear Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
					}	
                }
            if(!ev3.m_nClearflag)
				{
				 nErrorID = AbiSetEvent(ev3.m_tmpExtEv);
				 if (ICE_OK==nErrorID)
					{
				 	 memcpy(&(ev3.m_extEv),&(ev3.m_tmpExtEv),sizeof(BUS_EVENT));
					}
				 else
					{
					 MessageBox(NULL,"EV3 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
					}	
                }
             else
                {
				 nErrorID = AbiClrEvent(3);
				 if(ICE_OK != nErrorID)
					{
					 MessageBox(NULL,"EV3 Clear Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
					}	
                }
		}
	}
	
	if (option&0x4)
	{
		// set trigger
		if (!(option2&0x4))
		{
	        MessageBox(NULL,"Not Found Trigger Information!",NULL,MB_OK|MB_ICONQUESTION);
		}
		else
		{
			memcpy(&trigLevel,&(Le1.m_levelStruct),sizeof(TRIGGER_LEVEL));
			nErrorID=AbiSetTrigLevel(1,trigLevel);
			if (ICE_OK==nErrorID)
			{
				memcpy(&(Le1.m_levelStructSave),&(Le1.m_levelStruct),sizeof(TRIGGER_LEVEL));
			}
			else
			{
				MessageBox(NULL,"Level1 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
			}

			memcpy(&trigLevel,&(Le2.m_levelStruct),sizeof(TRIGGER_LEVEL));
			nErrorID=AbiSetTrigLevel(2,trigLevel);
			if (ICE_OK==nErrorID)
			{
				memcpy(&(Le2.m_levelStructSave),&(Le2.m_levelStruct),sizeof(TRIGGER_LEVEL));
			}
			else
			{
				MessageBox(NULL,"Level2 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
			}

			memcpy(&trig,&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
			nErrorID=AbiSetTrigLogic(trig);
			nErrorID|=AbiSetTrigStatus(FLAG(Trig.m_nOnOffFlg));
			if (ICE_OK==nErrorID)
			{
				memcpy(&(Trig.m_trig),&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
			}
			else
			{
				MessageBox(NULL,"Trigger Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
			}
		}
	}

    ar.Close();
    file.Close();
}
