
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/LDR.H__   1.29   02 Apr 1996 09:29:44   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/LDR.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:29:44   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:30   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:02   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:54   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:48   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:42   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:30   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:36   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:30   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:36   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:48   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:34   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:06   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:18   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:14   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:08   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:48   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:32:04   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:47:54   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:12   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:44   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:26   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:08   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:30   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  LDR.H
**
**  Description:
**      All OMF API's (external entry points) have the prefix: Ldr
**      Major header file used by Loader.
**
**  Status:  CODED
**
**    Rev 1.0   1 Sept. 1995 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _LDR_H_
#define _LDR_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* Loadfile Complier type */
typedef enum {
   LFILE_UNKNOWN,    /* Unrecognizable loadfile */
   LFILE_UBROF,      /* UBROF (default) */
   LFILE_OMF51,      /* OMF51 */
   LFILE_2500AD,     /* 2500AD Microtek Format */
   LFILE_2500AD_E,   /* 2500AD Extended Microtek Format */
   LFILE_HEX,        /* intel hex format */
   LFILE_IEEE695,    /* IEEE 695 */
   LFILE_UPLOAD      /* Upload defined extended intel hex format */
}  LFILE_TYPE;

typedef enum {
    LOAD_FROM_SHELL,    /* Load from shell command */
    LOAD_FROM_DIALOG    /* Load from dialog */
}   LOAD_WINDOW;

#define ARGLEN    256        /* command-line argument length */
#define LDR_BUFSIZE 4096

/* processor id values */
#define CPU_8051  1
#define CPU_8052  2
#define CPU_8031  3
#define CPU_8032  4

//#define GOOD  0

#define LDR_DEFAULT     0xF /* symbol,code,process,warning and nomangle */
#define LDR_SYMBOL      0x1
#define LDR_CODE        0x2
#define LDR_STATUS      0x4
#define LDR_WARNING     0x8
#define LDR_MANGLE      0x10
#define LDR_TODATA      0x20
#define LOAD_SYM(flags)     ((flags) & LDR_SYMBOL)
#define LOAD_CODE(flags)    ((flags) & LDR_CODE)
#define LOAD_STATUS(flags)  ((flags) & LDR_STATUS)
#define LOAD_WARNING(flags) ((flags) & LDR_WARNING)
#define LOAD_MANGLE(flags)  ((flags) & LDR_MANGLE)
#define LOAD_TODATA(flags)  ((flags) & LDR_TODATA)
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
/**********************************************************************
*                                                                     *
*    The Loader use this struct to generate a tree , every node will  *
*                                                                     *
*  save enough information . So Loader can call symbol server routine *
*                                                                     *
*  SymAddFuncCreate() at one module end .                             *
*                                                                     *
**********************************************************************/                        
struct SEC_INFO {
   char     *str;                /* section name */
   U32      sindex;              /* section index */
   U16      type;                /* type (absolute/relocatable) */
   U16      modifier;            /* modifier (code/ROM/data) */
   U16      align;               /* alignment */
   U32      size;                /* size */
   U32      offset;              /* section base offset */
   SEGMENTTYPE segType;
   struct   SEC_INFO *next;
public :
    SEC_INFO() {
        str = 0;
        sindex = 0;
        type = 0;      
        modifier = 0;
        align = 0;
        size = 0L;
        offset = 0L;
        segType = SEG_UNTYPED;
        next = 0;
    }
};

struct BlockBlock {
    LPSTR funcName;         // function name , if len = 0 , it is block
    U32 stacksize;          
    ADDR_RANGE_TYPE codeaddr; // function or block code range                
    SOURCE_RANGE_TYPE srcRange; // source range
    TYPE_INDEX typeIndex;   // function return type
    U32 localsymno;         // local symbol number
    U32 offset;             // local symbol at symbol temp file position
    int scope;              // block scope
    struct BlockBlock far *next; // next node , <same scope>
    struct BlockBlock far *son;  // son node , <nest block node>
    struct BlockBlock far *father; // father node 

public :
    BlockBlock() {
        funcName = 0;
        localsymno = 0;
        offset = 0;
        scope = 0;  
        next = 0;
        son = 0;
        father = 0;
        typeIndex = 0;
    };
};

/***********************************************************************
*                                                                      *
*    The Loader use the struct to save enough information for a module *
*                                                                      *
*  , So loader can call symbol server routine SymAddModuleCreate() at  *
*                                                                      *
*  one module end .                                                    *
*                                                                      *
***********************************************************************/                        
struct ModuleBlock {
    LPSTR  name;        // module name 
    TIMESTAMP_TYPE time; // module time
    ADDR_RANGE_TYPE codeaddr; // module code range
    U32 offset;     // module starter at load file position <offset>
    U32 symno;      // module symbol number
    U32 blkcnt;     // module block and function number
    U32 linecnt;    // module linenum record number
    int scope;      // block scope
    U32 tfileoffset; // TFILE record at load file position , Only UBROF used
    struct BlockBlock far *lpblock; // This module function and block tree
    
public :
    ModuleBlock() {
        name = 0;
        offset = 0;
        symno = 0;
        blkcnt = 0;
        linecnt = 0;              
        scope = 0;
        tfileoffset = 0;
        lpblock = 0;
    };
};
        
/////////////////////////////////////////////////////////////////
// Loader Server main frame
/////////////////////////////////////////////////////////////////
class LoaderServer {
public :
    LoaderServer();
    ~LoaderServer();
        
// Attributes       
private :
    HFILE m_loaderFile ;        // load file handle
    long m_fileLen;             // file length
    LFILE_TYPE m_compilerUser ;  // 0 --- unknowns
    BOOL m_IsLoaded ;           // symbol loaded flag
    int m_addrunit; 
    int m_absflag;              // 0 --- MSB , LSB
                                // 1 --- LSB , MSB
    U32 m_typeDelta;
    U32 m_typeNum;          
    U32 m_startaddress ;
    U8 *m_lpBuffer;
    U32 m_uBufInFilePos;
    U16 m_uBufSize;
    U16 m_uBufPos;                              
    LOAD_WINDOW m_window;       
    int m_ldrFlags;             // Load option flag
    int m_version;              // compiler version
    LPSTR m_lpFileName;         // load file name
    LPSTR m_lpFileRef;          // load file reference
    LPSTR m_lpModuleName;       // load module name
    LPSTR m_lpModuleRef;        // load module reference 
    BOOL m_onDemand;            // onDamand flag
    TIMESTAMP_TYPE m_time;      // load file OMF time
    ModuleBlock m_modNode;      // current module information node
                           
// loader information
    U32 m_symbolNo;             // total symbol number
    U32 m_typeNo;               // total type number
    U32 m_moduleNo;             // total module number

    struct SEC_INFO *m_pSec;
    struct SEC_INFO *m_pCurrentSec;                               

public:
    void GetFileLength(long& l) { l = m_fileLen ; }
    void GetFileCurPos(long& l) { l = (long) (m_uBufInFilePos+m_uBufPos) ; } 
    void GetStartAddress(U32& addr) { addr = m_startaddress; };
    BOOL IsSymbolLoaded(void) { return m_IsLoaded;  };
    int GetCompilerUser(void) { return m_compilerUser; }
    int GetldrFlags(void) { return m_ldrFlags; }
    BOOL IsOnDemand(void) { return m_onDemand; }
    void SetldrFlags(int flag) {    m_ldrFlags = flag;    }
    void SetOnDemand(BOOL isOK) {   m_onDemand = isOK;    }
    BOOL IsUbrof(void) { 
        if ( m_compilerUser == LFILE_UBROF ) return TRUE;
        else return FALSE;
    }
    BOOL IsIEEE(void) { 
        if ( m_compilerUser == LFILE_IEEE695 ) return TRUE;
        else return FALSE;
    }
    
// Operations
public:
    void LoadCmd(int argc, char *argv[]);      
    int LdrLoadProcess(LPSTR filename,BOOL onDemandFlag, int loaderFlags );
    int LdrLoadModuleByDesc(U32 offset , SYM_DESCRIPTOR moduleDesc);
    
private: // in LDR.CPP
    int DistinguishCompiler(void);
    int ClearUpSec(void);
    int ClearUp(void);    
    int ClearUpModuleBlock(void);
    int ClearUpBlockBlock(struct BlockBlock far *node);
    int LdrProcessArgs(int argc, char *argv[]);
    int GetFileName(LPSTR lpFileRef, int mode);
    int LdrLoadModuleOnly(void);        // no use
    int LdrLoadModule(void);            // no use
    int LdrShowProcess(void);
    int LdrShowProcessDone(void);
    void Warning(char *str);

//private: // in LDRSRV.CPP             
public: // in LDRSRV.CPP             
    U16 BinToU16(U8 *s);
    U32 BinToU32(U8 *s);
    int UngetOneByte();
    int GetOneByte(U8 *ch);
    int GetBytes(U8 *ch , int num);
    unsigned char *GetName(void);
    int OpenLoadFile(void);
    int CloseLoadFile(void);
    int SeekLoadFile(long off , int nOrg);
    int ModuleNodeInit(void);
    void LoadInit(void);   
public :    
    int GetLpFileRef( CString& str );

public : // in LDRSRV1.CPP
    int MatchRecord(U16 rtype);
    int Match2Record(U16 rtype,U16 rtype1);
    int SkipOver(U32 blockPos, U32 blockSize, U16 blockType);
    int SyncTo(U16 rtype, long *pfilePos);
    int Get695Number(U16 *pn);
    int Get695Offset(U32 *lAddr);
    int Get695Idn(char* &str);
    int Get695Nrecord(U32 *pIndex, LPSTR& name);
    int Get695Srecord(U32 *pIndex, U32 *pValue);
    int ProcessATN(U32 *pIndex, U32 *pType, U16 *n3);
    int Get695Time(TIMESTAMP_TYPE *pts);
    int ProcessASN(U32 *pType, U32 *pValue);
    int ProcessATI(U32 *pIndex, U32 *pType, U16 *pAttr,U16 *pNumber);
    LPSTR StripName(LPSTR lpn1);
    int Get695BB(U32 *pblockSize,LPSTR& lpblockName,U16 *blockType);
    int ProcessTY(U32 *ptindex,U32 typeOffset, U32 *pnindex, U16 *pstype);
    int ProcessATN16(U32 *nValue, LPSTR& defName);
    int PBBFunction(U32 *pnstack, U32 *prtn_type, U32 typeOffset,
                    U32 *poffset);
    int ProcessATN7(U16 *pline, U16 *pcol);
    int ProcessATN62(U32 *ptypeid, U32 typeOffset, U16 *pnrecs); 
    int IsValid695Offset(U8* pBuffer, U16 len, U32 *pAddr); 
    int getBlockEndAddress(U32 endBlockPos,
                    U32 fStartOffset, U32 *fEndOffset); 
    int Get695STrecord(U16 *pattr, U16 *stType);
                       
// for IEEE695 loader
private: // in LDR695.cpp
    int Ldr695LoadProcess(void);
    int Ldr695LoadModuleOnly(void);
    int Ldr695LoadModuleByDesc( U32 offset );
    int Ldr695LoadModule(void);
    int Ldr695LoadStarter(void);
    int Ldr695EnvPart(void);
    int Ldr695ExtPart(void);
    int Ldr695DataPart(U32 *bytesLoaded);
    int Ldr695TrailPart(void);
    int Ldr695DebugPart(void);
    int Ldr695LoadTypes(void); 
    int Ldr695GetModule(U32 blockPos ,BOOL onDemandFlag);
    int Ldr695GetBB3(U32 modulePos , LPSTR& moduleName ,
            U32 moduleSize , BOOL onDemandFlag );
    int ProcessDbgGlobals(U32 typeOffset, BOOLEAN addsym);
    int ProcessDbgFunctions(U16 blockType, U32 blockPos,
                            U32 blockSize, LPSTR& fnname,
                            U32 typeOffset, BOOL onDemandFlag);
    int ProcessDbgLocals(U32 typeOffset); 
    int ProcessDbgLines(U32 *nextBlockPos, U32 *nextBlockSize,
                                BOOL onDemandFlag );
    int ProcessDbgAsmBlock(U32 blockSize, LPSTR& moduleName,
                           BOOL createAsm, BOOL updateModule );
    int ProcessDbgAsmSection(U16 *psectionType,
                             U16 *psectionIndex, U32 *pmoduleAddress,
                             U32 *pmoduleSize);

    int GetTypePtr(U32 tindexParent, U16 stype, U32 toffset);
    int GetType6E(U32 tindexParent, U16 stype, U32 toffset,
        TYPE_HEADER_TYPE& typeHdrInfo);
    int GetTypeTypedef(U32 tindexParent,
                       TYPE_HEADER_TYPE *parentTypehdr,
                       U32 toffset); 
    int MapTypeVoid(U32 tindexParent);
    int GetTypeSU(U32 tindexParent, U16 stype, U32 toffset);
    int GetTypeEnum(U32 tindexParent);
    int GetTypeProc(U32 tindex, U32 toffset);
    int GetTypeBit(U32 tindexParent,TYPE_HEADER_TYPE *parentTypehdr);
    int GetTypeArr(U32 tindexParent, U32 toffset,
                   TYPE_HEADER_TYPE *parentTypeHdr);
    int Ldr695SectionPart(void); 
    int GetSectionInfo(SEC_INFO *psection); 
    int FindOneSection(U32 num,struct SEC_INFO *& pSec);
    int GetExpression(ADDRESS_TYPE& addr);
    int GetSegType(U32 secNum, SEGMENTTYPE& type);
                           
// for UBROF loader
private: // in LDRUBROF.CPP
    int LdrUbrofLoadProcess(void);
    int LdrUbrofLoadModuleOnly(void);
    int LdrUbrofLoadModuleByDesc(U32 offset);
    int LdrUbrofLoadModule(void);
    int LdrUbrofLoadStarter(void);
    int LdrUbrofLoadTypes(void);
    int LdrUbrofGetModule(  U8 keyword,BOOL onDemandFlag);
    int UbrofProcessModSym(void);
    int UbrofProcessBlockSym(void);
    void UbrofMatchFuncType(char *str , TYPE_INDEX& typeIndex);
    void UbrofMatchAttrType(U16& uType);
//  int UbrofProcessBlock( struct BlockBlock far *blocknode);
                          
// for 2500AD loader ( include intel hex format )                         
private: // in LDR2500.CPP                       
    int Ldr2500ADLoadProcess(void);
    int Ldr2500ADLoadModule(void);
    int LdrIntelHexDownload(void);
    void displayPC(U16 addr);
         
// for omf51 loader          
private: // in LDROMF51.CPP
    int LdrOmf51LoadProcess(void);
    int LdrOmf51LoadModuleOnly(void);
    int LdrOmf51LoadModuleByDesc(U32 offset);
    int LdrOmf51LoadModule(void);
    int LdrOmf51LoadFuncType(U16 ui , U16& len ,TYPE_HEADER_TYPE& typeHdrInfo);
    int LdrOmf51LoadTypes(U16 len);
    int LdrOmf51GetModule(U16 recLen,BOOL onDemandFlag);
    int Omf51ProcessModSym(void);
//  int Omf51ProcessBlockSym(void);
//  int Omf51ProcessBlock( struct BlockBlock far *blocknode);
    int GetOmf51Symbol(U16 len , U8 mode);      
    int GetOmf51LineInfo(U16 len);      
    void Omf51TypeConv(U16& ui);
    void Omf51MatchFuncType(char *str , TYPE_INDEX& typeIndex);
};

extern BOOL SrcInitModule(void);
extern void ShowLine(char *);
extern void ShlReShowLine(char * , int);
extern int nErrorNum;
extern char *strErrMsg[];
extern void prn_err( int number );

struct StoreExtendVar {
    U8 SymDefInfo[51];
    struct StoreExtendVar *next;
public :
    StoreExtendVar() {
        next = 0;
    }
};

extern void TestMessage(void);
extern BOOL IsLoadCanceled(void);
extern void SetLoadEnd(void);
    
#endif
/******************************** E O F ***********************************/
