
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/LOADDLG.CPP   1.29   02 Apr 1996 09:26:18   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/LOADDLG.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:26:18   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:38   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:20   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:52   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:54   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:02   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:56   Shirley
** EasyPack/SLD Version 0.35
** 
**    Rev 1.21   24 Jan 1996 10:35:40   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:26:28   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:15:06   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:14   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:14:20   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:14:34   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:06   Shirley
** EasyPack/SLD Version 0.32
** 
**    Rev 1.14   21 Nov 1995 11:21:18   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:14   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:34   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:16   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:52:28   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:56   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:52:14   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:40   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:22   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:36   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  LOADDLG.CPP
//
//  Description:The implement file for the class: CLoadDialog
//
//  Author:     Roger Zhang
//
//  Date:       07/12/95
//
//  Modification:
//
//      1. 07/12/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
                    
#include "uicom.h"                    
#include "srcgrp.h"
#include "loaddlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLoadDialog dialog


static char BASED_CODE szFilter[] = 
    "OMF File(*.omf)|*.omf|UBROF File(*.dbg)|*.dbg|IEEE695 File(*.abs)|*.abs|"
    "Hex File(*.hex)|*.hex|2500AD File(*.sym)|*.sym|Load File(*.*)|*.*||";
    
static char * ExtName[] = { 
    "*.omf", "*.dbg", "*.abs", "*.hex", "*.sym", "*.*"
} ;
                                    
// return 1 -- 6 indicates the initial file extension                                    
static int GetFilterIndex(const char * pszExt)
{
    for(int i = 0; i < 6; i ++) {
        if(_stricmp(pszExt, ExtName[i]) == 0)   return  i + 1;
    }                                                         
    return  1;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CLoadDialog::CLoadDialog()
: CFileDialog(TRUE, NULL, 
    AfxGetApp()->GetProfileString("LoadOption","LoadExt", "*.omf"),
  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, ::szFilter, NULL)
{
    m_ofn.lpstrTitle = "Load"; 
    m_ofn.nFilterIndex = ::GetFilterIndex(
        AfxGetApp()->GetProfileString("LoadOption","LoadExt", "*.omf"));
    
    m_nIDHelp = IDD_LOAD;
    //{{AFX_DATA_INIT(CLoadDialog)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadDialog::DoDataExchange(CDataExchange* pDX)
{
    CFileDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CLoadDialog)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLoadDialog, CFileDialog)
    //{{AFX_MSG_MAP(CLoadDialog)
    ON_BN_CLICKED(IDC_LOAD_OPTION, OnLoadOption)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CLoadDialog message handlers

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CLoadDialog::OnInitDialog()
{
    CFileDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
                          
    // Add "Options..." button
    CRect rect;

    GetDlgItem(IDCANCEL)->GetWindowRect(rect);
    ScreenToClient(&rect);
    rect.OffsetRect(0, rect.Height() + 50);
    
    m_btnOption.Create("&Options...",WS_VISIBLE|WS_TABSTOP|WS_CHILD|WS_GROUP
        |BS_PUSHBUTTON, rect, this, IDC_LOAD_OPTION);
    m_btnOption.SetFont(GetFont(), TRUE);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
                                               
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CLoadDialog::OnLoadOption()
{
    CSourceGroup    dlg(0, this);
    dlg.DoModal();
}                 

void CLoadDialog::OnOK()
{
    // TODO: Add extra cleanup here
    CFileDialog::OnOK();    
    
    if(m_ofn.nFilterIndex > 0) {
        AfxGetApp()->WriteProfileString("LoadOption", "LoadExt", 
            ::ExtName[m_ofn.nFilterIndex - 1]);
    } else {
        AfxGetApp()->WriteProfileString("LoadOption", "LoadExt", 
            ::ExtName[0]);
    }       
}

/////////////////////////////////(EOF)///////////////////////////////////////
                              
