
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MAINFRM.CPP   1.29   02 Apr 1996 09:22:38   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MAINFRM.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:22:38   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:53:48   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.27   12 Feb 1996 14:09:06   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:30   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:48   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:16   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:20:10   Shirley
** EasyPack/SLD Version 0.35a
** 
**    Rev 1.22   25 Jan 1996 13:20:04   Shirley
** EasyPack/SLD Version 0.35
** 
**    Rev 1.21   24 Jan 1996 10:38:56   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:44   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:58   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:11:30   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:08:56   Shirley
** EasyPack/SLD Version 0.33
** 
**    Rev 1.15   28 Nov 1995 15:31:44   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:24   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:24:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:14   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:30:38   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:42   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:22   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:46:20   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:40   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.6   25 Oct 1995 14:28:18   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:52:30   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:56   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:52:16   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:42   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:22   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:36   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MAINFRM.CPP
//
//  Description:The implement file for the class: CMainFrame
//
//  Author:     Roger Zhang
//
//  Date:       03/05/95
//
//  Modification:
//
//      1. 03/05/95, Initial version 0.1
//
//      2. 09/08/95  0.1a
//
//         2.1 Fixed bug No.18 
//              Modify function: DoJump, OnRunJump
//
//         2.2 Fixed bug No.21
//              Modify function: OnSetCursor
//
//      3. 10/10/95  0.1d
//
//         3.1 Delete Step Option Selection
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "zqueue.h"
#include "uicom.h"
#include "srccom.h"
#include "zlist.h"
#include "srclist.h"
#include "srcmdl.h"
#include "srcfile.h"
#include "meter.h"
#include "srcdlg1.h"
#include "btnbar.h"
#include "savecfg.h"
#include "trcgrpdi.h"
#include "srcgrp.h"
#include "mainfrm.h"
#include "loaddlg.h"
#include "tabdll11.h"   //lane
#include "tabvbmfc.h"
#include "memdlg.h"
#include "grid.h"
#include "nwmemwnd.h"
#include "nwmem.h" // lane
#include "myedit2.h"
#include "spin.h"
#include "mapdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


extern HHOOK hookStkKeyFilter;


extern void SaveConfig(LPCSTR filename, int option);
extern void LoadConfig(LPCSTR filename, int option);

extern void SrcPreStep(void);
extern BOOL CpuReset(WORD addr);
extern void ShlStopAsm(void);
extern void ShlRunInclude(const char * pszFileName);
    
extern void EmuServerGo(int nMode, unsigned short uAddr);
extern void EmuServerStepOver(long lCount);
extern void EmuServerHalt(void);
extern void EmuServerJump(unsigned short uAddr);
extern void EmuServerStep(long lCount);
    
/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CMDIFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CMDIFrameWnd)
    //{{AFX_MSG_MAP(CMainFrame)
    ON_MESSAGE(XM_MDIACTIVE, OnXMMDIActive)
    ON_WM_CREATE()
    ON_UPDATE_COMMAND_UI(ID_INDICATOR_OVR, OnUpdateInsert)
    ON_COMMAND(ID_TOGGLE_INSERT, OnToggleInsert)
    ON_COMMAND(ID_FILE_INCLUDE, OnFileInclude)
    ON_WM_SETCURSOR()
    ON_COMMAND(ID_FILE_LOAD, OnFileLoad)
    ON_COMMAND(ID_FILE_SAVECONFIGURATION, OnFileSaveconfiguration)
    ON_COMMAND(ID_FILE_RESTORECONFIGURATION, OnFileRestoreconfiguration)
    ON_COMMAND(ID_GROUP_TRACE, OnGroupTrace)
    ON_COMMAND(ID_GROUP_MEMORY, OnGroupMemory)
    ON_COMMAND(ID_FILE_BROWSEMODULE, OnFileBrowsemodule)
    ON_UPDATE_COMMAND_UI(ID_FILE_BROWSEMODULE, OnUpdateFileBrowsemodule)
    ON_COMMAND(ID_RUN_BREAKPOINT, OnRunBreakpoint)
    ON_COMMAND(ID_RUN_GO, OnRunGo)
    ON_COMMAND(ID_RUN_GOUNTILCALL, OnRunGountilcall)
    ON_UPDATE_COMMAND_UI(ID_RUN_GOUNTILCALL, OnUpdateRunGountilcall)
    ON_COMMAND(ID_RUN_GOUNTILRETURN, OnRunGountilreturn)
    ON_UPDATE_COMMAND_UI(ID_RUN_GOUNTILRETURN, OnUpdateRunGountilreturn)
    ON_COMMAND(ID_RUN_HALT, OnRunHalt)
    ON_UPDATE_COMMAND_UI(ID_RUN_HALT, OnUpdateRunHalt)
    ON_COMMAND(ID_RUN_JUMP, OnRunJump)
    ON_COMMAND(ID_RUN_RESET, OnRunReset)
    ON_COMMAND(ID_RUN_RESETANDGO, OnRunResetandgo)
    ON_COMMAND(ID_RUN_STEPINTO, OnRunStepinto)
    ON_COMMAND(ID_RUN_STEPINTOCONTINUOUSLY, OnRunStepintocontinuously)
    ON_COMMAND(ID_RUN_STEPOVER, OnRunStepover)
    ON_COMMAND(ID_RUN_STEPOVERCONTINUOUSLY, OnRunStepovercontinuously)
    ON_COMMAND(ID_OPTIONS_LOADOPTIONS, OnOptionsLoadoptions)
    ON_COMMAND(ID_GROUP_SOURCE, OnGroupSource)
    ON_COMMAND(ID_OPTIONS_INTOCALL, OnOptionsIntocall)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_INTOCALL, OnUpdateOptionsIntocall)
    ON_COMMAND(ID_OPTIONS_OVERRETURN, OnOptionsOverreturn)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_OVERRETURN, OnUpdateOptionsOverreturn)
    ON_COMMAND(ID_OPTIONS_UNTILCALL, OnOptionsUntilcall)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_UNTILCALL, OnUpdateOptionsUntilcall)
    ON_COMMAND(ID_OPTIONS_UNTILRETURN, OnOptionsUntilreturn)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_UNTILRETURN, OnUpdateOptionsUntilreturn)
    ON_COMMAND(ID_OPTIONS_RUNACCESS, OnOptionsRunaccess)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_RUNACCESS, OnUpdateOptionsRunaccess)
    ON_COMMAND(IDM_STEP_STATEMENT, OnStepStatement)
    ON_UPDATE_COMMAND_UI(IDM_STEP_STATEMENT, OnUpdateStepStatement)
    ON_COMMAND(IDM_STEP_INSTRUCTION, OnStepInstruction)
    ON_UPDATE_COMMAND_UI(IDM_STEP_INSTRUCTION, OnUpdateStepInstruction)
    ON_WM_CLOSE()
    ON_COMMAND(ID_OPTIONS_SAVELAYOUTNOW, OnOptionsSavelayoutnow)
    ON_COMMAND(ID_OPTIONS_SAVELAYOUTONEXIT, OnOptionsSavelayoutonexit)
    ON_UPDATE_COMMAND_UI(ID_OPTIONS_SAVELAYOUTONEXIT, OnUpdateOptionsSavelayoutonexit)
    ON_COMMAND(ID_WINDOW_BITMEMORY, OnWindowBitmemory)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_BITMEMORY, OnUpdateWindowBitmemory)
    ON_COMMAND(ID_WINDOW_CPU, OnWindowCpu)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_CPU, OnUpdateWindowCpu)
    ON_COMMAND(ID_WINDOW_MEMORY1, OnWindowMemory1)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY1, OnUpdateWindowMemory1)
    ON_COMMAND(ID_WINDOW_MEMORY2, OnWindowMemory2)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY2, OnUpdateWindowMemory2)
    ON_COMMAND(ID_WINDOW_MEMORY3, OnWindowMemory3)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_MEMORY3, OnUpdateWindowMemory3)
    ON_COMMAND(ID_WINDOW_SHELL, OnWindowShell)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_SHELL, OnUpdateWindowShell)
    ON_COMMAND(ID_WINDOW_SOURCE, OnWindowSource)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_SOURCE, OnUpdateWindowSource)
    ON_COMMAND(ID_WINDOW_STACK, OnWindowStack)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_STACK, OnUpdateWindowStack)
    ON_COMMAND(ID_WINDOW_TRACE, OnWindowTrace)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_TRACE, OnUpdateWindowTrace)
    ON_COMMAND(ID_WINDOW_VARIABLE, OnWindowVariable)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_VARIABLE, OnUpdateWindowVariable)
    ON_COMMAND(ID_WINDOW_CLOSEALL, OnWindowCloseall)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_CLOSEALL, OnUpdateWindowCloseall)
    ON_COMMAND(ID_GROUP_MAP, OnGroupMap)
    ON_COMMAND(ID_WINDOW_PERIPHERAL, OnWindowPeripheral)
    ON_UPDATE_COMMAND_UI(ID_WINDOW_PERIPHERAL, OnUpdateWindowPeripheral)
    ON_WM_ACTIVATE()
    ON_WM_ENTERIDLE()
    //}}AFX_MSG_MAP
    // Global help commands
    ON_COMMAND(ID_HELP_INDEX, CMDIFrameWnd::OnHelpIndex)
    ON_COMMAND(ID_HELP_USING, CMDIFrameWnd::OnHelpUsing)
    ON_COMMAND(ID_HELP, CMDIFrameWnd::OnHelp)
    ON_COMMAND(ID_CONTEXT_HELP, CMDIFrameWnd::OnContextHelp)
    ON_COMMAND(ID_DEFAULT_HELP, CMDIFrameWnd::OnHelpIndex)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// arrays of IDs used to initialize status bars

static UINT BASED_CODE indicators[] =
{
    ID_SEPARATOR,           // status line indicator
//    ID_SEPARATOR,
    ID_INDICATOR_OVR,
    ID_INDICATOR_CAPS,
    ID_INDICATOR_NUM,
    ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CMainFrame::CMainFrame()
{
    // TODO: add member initialization code here
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CMainFrame::~CMainFrame()
{
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   PreCreateWindow
//
//  Description: Delete the auto add title style
//
//  Input:  CREATESTRUCT
//  
//  Output: CREATESTRUCT
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::PreCreateWindow(CREATESTRUCT & cs)
{                                                  
    if(cs.style & FWS_ADDTOTITLE)   cs.style ^= FWS_ADDTOTITLE;
    return CMDIFrameWnd::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIFrameWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
                                
                      
    // Create Status Bar                      
    if (!m_wndStatusBar.Create(this) ||
        !m_wndStatusBar.SetIndicators(indicators,
          sizeof(indicators)/sizeof(UINT))) {
        TRACE("Failed to create status bar\n");
        return -1;      
    }
  //  m_wndStatusBar.SetPaneText(1, "abcd");
  //  m_wndStatusBar.SetPaneInfo(1, ID_SEPARATOR, 0, 40);
    
    // Create Tool Bar                // modify by carl                
    if (!m_wndToolBar.CreateBar(this)) {
        TRACE("Failed to create tool bar");
        return -1;
    }       
    m_wndToolBar.SetHeight(30);
    void TstIdentify(CString &, CString &, CString &, CString &, CString &);
    CString strDos, strWindows, strVer, strFWVer, strCPU;
                                                      
    TstIdentify(strCPU, strFWVer, strVer, strDos, strWindows);
    strDos = "EasyPack/SLD 52F";
//    strDos += strVer;
    strDos += " -- ";
    strDos += strCPU;    
    SetWindowText(strDos);
    
  /*  m_wndStatusBar.SetPaneInfo(1, ID_CPUTYPE, SBPS_NORMAL, 100);
    m_wndStatusBar.SetPaneText(1, "qqq");                               
    m_wndStatusBar.Invalidate();
    m_wndStatusBar.UpdateWindow();*/
    
/*    // Create Menu Check Bitmap
    if (!CreateMenuCheckBMP()) {
        TRACE("Failed to create Menu Check Bitmap");
        return -1;
    }             
    
    // Set Main Menu Check Bitmap    
    CMenu * menu = GetMenu();
    ASSERT(menu);
    SetMainMenuCheck(*menu);     */
    
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
    CMDIFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
    CMDIFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

/////////////////////////////////////////////////////////////////////////////
// Toggle Insert Status
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateInsert(CCmdUI* pCmdUI)
{
    pCmdUI->Enable(!isInsertOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnToggleInsert()
{
    isInsertOn = !isInsertOn;
}

/////////////////////////////////////////////////////////////////////////////
// Tool Bar Message Handler
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnStepStatement()
{
    if(SrcDispMode() == MODE_SOURCE && SrcEmu.m_isStatement) {
        if(SrcEmu.m_nStepOpt == STEP_STATEMENT)  
            SrcEmu.m_nStepOpt = STEP_LINE;
        else    SrcEmu.m_nStepOpt = STEP_STATEMENT;
    } 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateStepStatement(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck(SrcEmu.m_nStepOpt == STEP_STATEMENT);
    pCmdUI->Enable(SrcDispMode() == MODE_SOURCE && 
        SrcEmu.m_isStatement);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnStepInstruction()
{
    if(SrcDispMode() == MODE_SOURCE) {
        if(SrcEmu.m_nStepOpt == STEP_INSTRUCTION)  
            SrcEmu.m_nStepOpt = STEP_LINE;
        else    SrcEmu.m_nStepOpt = STEP_INSTRUCTION;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateStepInstruction(CCmdUI* pCmdUI)
{
    pCmdUI->SetCheck(SrcEmu.m_nStepOpt == 0);
    pCmdUI->Enable(SrcDispMode() == MODE_SOURCE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Close Window
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnClose()
{
    // TODO: Add your message handler code here and/or call default
    
    // Save Window Placement
    if(AfxMessageBox(IDS_PRM_EXIT, MB_YESNO) == IDYES) {
        if(isSaveLayoutOnExit) SaveWindowPlacement();
    
        // Delete Menu Check Bitmap    
        //DeleteMenuCheckBMP();
    
        CMDIFrameWnd::OnClose();               
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Update Tool Bar
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
LONG CMainFrame::OnXMMDIActive(UINT wParam, LONG lParam)
{                              
    // Delete Old Tool Bar
    m_wndToolBar.Del();   
    
    // Add New Tool Bar
    if(wParam) {
        switch(lParam) {
            case WID_SOURCE:
                m_wndToolBar.NewSource();
                break;
            case WID_CPU:
                m_wndToolBar.NewCpu();
                break;
            case WID_PERI:
                m_wndToolBar.NewPeri();
                break;
            case WID_SHELL:
                m_wndToolBar.NewShell();
                break;               
            case WID_BMEM:
                m_wndToolBar.NewBMem();
                break;               
            case WID_TRACE:
                m_wndToolBar.NewTrace();
                break;               
            case WID_STACK:
                m_wndToolBar.NewStack();
                break;               
            case WID_MEMORY:
                m_wndToolBar.NewMemory();
                break;               
            case WID_VARIABLE:
                m_wndToolBar.NewVariable();
                break;               
            default:
                m_wndToolBar.NewMain();
                break;               
        }                                  
    } else m_wndToolBar.NewMain();
    
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Do local menu
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMainFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    if(pWnd != this &&
        nHitTest == HTCLIENT && message == WM_RBUTTONDOWN) {
        CMenu * pLocalMenu = new CMenu;
        ASSERT( NULL != pLocalMenu );

        pLocalMenu->CreatePopupMenu();
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_CPU,
                            "CP&U");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_MEMORY1,
                            "&Memory1");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_MEMORY2,
                            "M&emory2");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_MEMORY3,
                            "Memor&y3");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_SHELL,
                            "S&hell");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_SOURCE,
                            "S&ource");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_STACK,
                            "Stac&k");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_TRACE,
                            "T&race");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_VARIABLE,
                            "&Variable");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_BITMEMORY,
                            "&BitMemory");
        pLocalMenu->AppendMenu(MF_STRING, ID_WINDOW_PERIPHERAL,
                            "&Peripheral");
        pLocalMenu->AppendMenu(MF_SEPARATOR);
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_TOOLBAR,
                            "&Toolbar");
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_STATUS_BAR,
                            "&Status Bar");

        CRect rect;
        pWnd->GetClientRect(&rect);
        CPoint pt(rect.left + 200, rect.top + 80);
        GetCursorPos(&pt);
        //ClientToScreen(&pt);
        pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, pt.x, pt.y, this);

        delete pLocalMenu;
        return TRUE;
    } else return CMDIFrameWnd::OnSetCursor(pWnd, nHitTest, message);
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- File Submenu
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
class CIncludeDialog : public CFileDialog
{
public:                         
    CIncludeDialog( BOOL bOpenFileDialog, LPCSTR lpszDefExt = NULL, 
        LPCSTR lpszFileName = NULL, 
        DWORD dwFlags = OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
        LPCSTR lpszFilter = NULL, CWnd* pParentWnd = NULL )
    : CFileDialog(bOpenFileDialog, lpszDefExt, lpszFileName, dwFlags,
        lpszFilter, pParentWnd)
    { m_nIDHelp = IDD_INCLUDE; }        

    virtual BOOL OnInitDialog()
    {
        CFileDialog::OnInitDialog();
        CenterWindow();
        return TRUE;  // return TRUE  unless you set the focus to a control
    }
};


void CMainFrame::OnFileInclude()
{
    // TODO: Add your command handler code here  
    CString strFilter;
    strFilter.LoadString(IDS_INC_FILTER);
    CIncludeDialog dlgInc(TRUE, NULL, "*.inc", 
        OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, strFilter);
    dlgInc.m_ofn.lpstrTitle = "Include";
    if(dlgInc.DoModal() == IDOK) {
        strIncludeFile = dlgInc.GetPathName();
//        AfxMessageBox(strIncludeFile);
        if(!isShellOn)  ShlOpenWindow(this, FALSE);
        else pShellWnd->BringWindowToTop();
        //ShlStopAsm();
        ShlRunInclude(strIncludeFile);
    }
}

// Load Source File

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void LoadSourceFile(CString strFileName)
{     
    LoadInfo.m_strFile = strFileName;

    if(LoadOpt.m_isStatus) {
        CLoadProgDialog dlg;             
        dlg.DoModal();
    } else {    
        SrcLoadFile(strFileName);       
    }    
    
    void SrcPostLoad(void);
    
    SrcPostLoad();
    RepaintCPU();
    RepaintMemory();
    RepaintBMemory();
    RepaintStack();
    RepaintVariable();
}
                   
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void DoFileLoad(void)
{
    CLoadDialog dlgLoad;
    CString strLoadFile;
    if(dlgLoad.DoModal() == IDOK) {
        strLoadFile = dlgLoad.GetPathName();
        AfxGetApp()->DoWaitCursor(1);
        LoadSourceFile(strLoadFile);
        AfxGetApp()->DoWaitCursor(-1);
    }
}
                   
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileLoad()
{
    // TODO: Add your command handler code here
    DoFileLoad();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileSaveconfiguration()
{
    // TODO: Add your command handler code here
    int i;
    
    CSavecfgDialog dlgCfg(TRUE);
    i = 0;
    if(dlgCfg.DoModal() == IDOK) {
        CString str = dlgCfg.GetPathName();
        if(dlgCfg.m_nMap)       i+=1;
        if(dlgCfg.m_nEvent)     i+=2;
        if(dlgCfg.m_nTrigger)   i+=4;
        BeginWaitCursor();
        SaveConfig(str,i);
        EndWaitCursor();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileRestoreconfiguration()
{
    // TODO: Add your command handler code here
    int i;
    
    CSavecfgDialog dlgCfg(FALSE);
    i = 0;
    if(dlgCfg.DoModal() == IDOK) {
        i = 0;
        CString str = dlgCfg.GetPathName();
        if(dlgCfg.m_nMap)       i+=1;
        if(dlgCfg.m_nEvent)     i+=2;
        if(dlgCfg.m_nTrigger)   i+=4;
        BeginWaitCursor();
        LoadConfig(str,i);
        EndWaitCursor();
    }    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void DoBrowseModule(CSourceGroup &dlg)
{                                   
    unsigned long dwModule;
    if(dlg.m_nTab == 1) { // Browse module
        if(dlg.m_strMdl_2 != "") {
            if(SrcGetModuleFullName(dlg.m_strMdl_2) == "" ||
                SrcModuleName2Index(dlg.m_strMdl_2, dwModule) == -1 ||
                SrcLoadModule(dwModule) == SRC_LOAD_ERROR) {
                CString str("Can't open module: ");
                str += dlg.m_strMdl_2;
                AfxMessageBox(str);
                return;
            }
            int n = SrcEmu.m_nStepOpt;
            if(!isSourceOn) {
                SrcOpenWindow(FALSE, 
                    (CMDIFrameWnd *)(AfxGetApp()->m_pMainWnd));
            } else SrcResetView();    
            SrcEmu.m_nStepOpt = n;
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnFileBrowsemodule()
{
    // TODO: Add your command handler code here
    CSourceGroup    dlg(1, this);
/*    if(SrcOpt.m_isTabChanged) {
        SrcOpt.m_isTabChanged = FALSE;
        MdlInfo.Reload();        
    }*/
    if(dlg.DoModal() == IDOK) {
        DoBrowseModule(dlg);
    }   
    RepaintSource();   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateFileBrowsemodule(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(MdlInfo.m_uModules == 0) {
     	pCmdUI->Enable(FALSE);
    } else {
     	for(int i = 0; i < int(MdlInfo.m_uModules); i ++) {
			if(SrcCheckModuleHasLineInfo(MdlInfo.m_pModule[i]) == 0) {
		     	pCmdUI->Enable(TRUE);
		     	return;
			}    		 	
     	}
    }
    pCmdUI->Enable(FALSE);    
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- Group Submenu
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupTrace()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this);
    dlg.DoModal();    
    if(isTraceOn&&dlg.m_bDisplayChange)
        pTraceWnd->SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupMemory()
{
    // TODO: Add your command handler code here
    CMemDlg memoryDlg(this);
    memoryDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupSource()
{
    // TODO: Add your command handler code here
    CSourceGroup    dlg(0, this);
    if(dlg.DoModal() == IDOK) {
        DoBrowseModule(dlg); 
    }    
    RepaintSource();   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnGroupMap()
{
    // TODO: Add your command handler code here
    HINSTANCE hLib;
    int i = 1;
    if ((hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
        AfxMessageBox("Can't find MUSCROLL.DLL");
        i = 0;
    }
    CMapDlg dlg(this);
    int result = dlg.DoModal();
    if(i) FreeLibrary(hLib);
    
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- Run Submenu
/////////////////////////////////////////////////////////////////////////////
void DoBreakPoint(CWnd * pParent)
{
    CSourceGroup    dlg(5, pParent);
    if(dlg.DoModal() == IDOK) {    
        DoBrowseModule(dlg);
    }    
    RepaintSource();   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunBreakpoint()
{
    // TODO: Add your command handler code here
    DoBreakPoint(this);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunGo()
{
    // TODO: Add your command handler code here
    BeginWaitCursor();
    EmuServerGo(1, 0);
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunGountilcall()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    if(SrcEmu.m_isIntoCall) EmuServerStepOver(-3);
    else EmuServerStepOver(-1);   
        
    OnEmulation();
    EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateRunGountilcall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(SrcEmu.m_isIntoCall) pCmdUI->SetText("Go Into C&all");    
    else    pCmdUI->SetText("Go Until &Call");
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunGountilreturn()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    if(SrcEmu.m_isOverReturn) EmuServerStepOver(-4);
    else EmuServerStepOver(-2);   
        
    OnEmulation();
    EndWaitCursor();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateRunGountilreturn(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    if(SrcEmu.m_isOverReturn) pCmdUI->SetText("Go Over Retur&n");    
    else    pCmdUI->SetText("Go &Until Return\tF6");
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunHalt()
{
    // TODO: Add your command handler code here
    EmuServerHalt();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateRunHalt(CCmdUI* /*pCmdUI*/)
{
    // TODO: Add your command update UI handler code here
    
}                      

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL DoJump(CWnd * pParent)
{
    CJumpDialog dlg(pParent);
    if(dlg.DoModal() == IDOK) {
        if(!JumpData.m_isInitPC)
            EmuServerJump((unsigned short)(JumpData.m_uAddr));
        else {
            EmuServerJump((unsigned short)(LoadInfo.m_lPC));
        }
        return TRUE;
    } else return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunJump()
{
    // TODO: Add your command handler code here
    BeginWaitCursor();
    if(DoJump(this)) {
        OnEmulation();    
    }
    EndWaitCursor();
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void DoReset(void)
{
    CpuReset((WORD)(LoadInfo.m_lPC));
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunReset()
{
    // TODO: Add your command handler code here
    if(AfxMessageBox("Confirm reset operation?", MB_YESNO|MB_ICONQUESTION)
        == IDNO)    
        return;
        
    BeginWaitCursor();
    DoReset();
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunResetandgo()
{
    // TODO: Add your command handler code here
    if(AfxMessageBox("Confirm reset operation?", MB_YESNO|MB_ICONQUESTION)
        == IDNO)    
        return;
        
    BeginWaitCursor();

    CpuReset(WORD(LoadInfo.m_lPC));
    EmuServerGo(1, 0);

    EndWaitCursor();

    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepinto()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStep(SrcEmu.m_nStepCount);
    EndWaitCursor();

    OnEmulation();
    
    /*static int i = 0;
    if(i)   m_wndStatusBar.SetPaneText(1, "abcd");
    else    m_wndStatusBar.SetPaneText(1, "ABCD");
    i = i ? 0 : 1;*/
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepintocontinuously()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStep(0);
    EndWaitCursor();

    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepover()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStepOver(SrcEmu.m_nStepCount);
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnRunStepovercontinuously()
{
    // TODO: Add your command handler code here
    SrcPreStep();
    
    BeginWaitCursor();
    EmuServerStepOver(0);
    EndWaitCursor();
    OnEmulation();
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- Options Submenu
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*void CMainFrame::OnOptionsStepoptions()
{
    // TODO: Add your command handler code here
    CStepOptionDialog dlg(this);
    dlg.DoModal();    
}*/

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsLoadoptions()
{
    // TODO: Add your command handler code here
    CSourceGroup dlg(0, this);
    if(dlg.DoModal() == IDOK) {
        DoBrowseModule(dlg); 
    }    
    RepaintSource();   
}


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsIntocall()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isIntoCall = TRUE; 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsIntocall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(SrcEmu.m_isIntoCall);  
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsOverreturn()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isOverReturn = TRUE;   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsOverreturn(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(SrcEmu.m_isOverReturn);    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsUntilcall()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isIntoCall = FALSE;    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsUntilcall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(!SrcEmu.m_isIntoCall); 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsUntilreturn()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isOverReturn = FALSE;  
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsUntilreturn(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetRadio(!SrcEmu.m_isOverReturn);   
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsRunaccess()
{
    // TODO: Add your command handler code here
    SrcEmu.m_isRunAccess = SrcEmu.m_isRunAccess ? FALSE : TRUE; 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsRunaccess(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(SrcEmu.m_isRunAccess); 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsSavelayoutnow()
{
    // TODO: Add your command handler code here
    SaveWindowPlacement();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnOptionsSavelayoutonexit()
{
    // TODO: Add your command handler code here
    isSaveLayoutOnExit = isSaveLayoutOnExit ? FALSE : TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateOptionsSavelayoutonexit(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isSaveLayoutOnExit);    
}

/////////////////////////////////////////////////////////////////////////////
// Open/Close Child Windows
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowBitmemory()
{
    // TODO: Add your command handler code here
    if(!isBMemOn) {
        BeginWaitCursor();
        BMemOpenWindow(this);   
        EndWaitCursor();
    } else pBMemWnd->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowBitmemory(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isBMemOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowCpu()
{
    // TODO: Add your command handler code here
    if(!isCpuOn) {
        BeginWaitCursor();
        CpuOpenWindow(this);
        EndWaitCursor();
    } else pCpuWnd->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowCpu(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isCpuOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowMemory1()
{
    // TODO: Add your command handler code here
    if(!isMemOn[0]) {
        BeginWaitCursor();
        NewMemoryOpenWindow(this,0);
        EndWaitCursor();
    } else pMemWnd[0]->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowMemory1(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isMemOn[0]);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowMemory2()
{
    // TODO: Add your command handler code here
    if(!isMemOn[1]) {
        BeginWaitCursor();
        NewMemoryOpenWindow(this,1);
        EndWaitCursor();
    } else pMemWnd[1]->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowMemory2(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isMemOn[1]);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowMemory3()
{
    // TODO: Add your command handler code here
    if(!isMemOn[2]) {
        BeginWaitCursor();
        NewMemoryOpenWindow(this,2);
        EndWaitCursor();
    } else pMemWnd[2]->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowMemory3(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isMemOn[2]);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowShell()
{
    // TODO: Add your command handler code here
    if(!isShellOn) {
        BeginWaitCursor();
        ShlOpenWindow(this);
        EndWaitCursor();
    } else pShellWnd->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowShell(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isShellOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowSource()
{
    // TODO: Add your command handler code here
    if(!isSourceOn) {
        BeginWaitCursor();         
        SrcLoadPCModule();
        SrcOpenWindow(/*FALSE*/TRUE, this);
        EndWaitCursor();
    } else pSourceWnd->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowSource(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isSourceOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowStack()
{
    // TODO: Add your command handler code here
    if(!isStackOn) {
        BeginWaitCursor();
        StkOpenWindow(this);
        EndWaitCursor();
    } else StkCloseWindow();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowStack(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isStackOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowTrace()
{
    // TODO: Add your command handler code here
    if(!isTraceOn) {
        BeginWaitCursor();
        TrcOpenWindow(this);
        EndWaitCursor();
    } else pTraceWnd->SendMessage(WM_CLOSE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowTrace(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isTraceOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowVariable()
{
    // TODO: Add your command handler code here
    if(!isVariableOn) {
        BeginWaitCursor();
        VarOpenWindow(this);
        EndWaitCursor();
    } else VarCloseWindow();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowVariable(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isVariableOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowPeripheral()
{
    // TODO: Add your command handler code here
    if(!isPeriOn) {
        BeginWaitCursor();
        PeriOpenWindow(this);
        EndWaitCursor();
    } else pPeriWnd->SendMessage(WM_CLOSE);
    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowPeripheral(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->SetCheck(isPeriOn);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Close All Child Windows
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnWindowCloseall()
{
    // TODO: Add your command handler code here          
    CMDIChildWnd * pWnd;
    
    for (;;) {
        pWnd = MDIGetActive();        
        if(pWnd) {  
            if(pWnd->SendMessage(WM_CLOSE) != 0)    break;
        } else    break;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMainFrame::OnUpdateWindowCloseall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(MDIGetActive() != 0);
}

/////////////////////////////////////////////////////////////////////////////
// Menu handler -- View Submenu
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*void CMainFrame::OnViewRefresh()
{
    // TODO: Add your command handler code here
    RepaintSource();
    RepaintCPU();
    RepaintMemory();
    RepaintBMemory();
    RepaintTrace();
    RepaintStack();
    RepaintVariable();    
}
*/
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
/*void CMainFrame::OnUpdateViewRefresh(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(isCpuOn||isSourceOn||isVariableOn||isStackOn||
        isMemOn[0]||isMemOn[1]||isMemOn[2]||isBMemOn||isTraceOn);
}
*/

///////////////////////////////////(EOF)/////////////////////////////////////



void CMainFrame::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized)
{
    CMDIFrameWnd::OnActivate(nState, pWndOther, bMinimized);
    
    // TODO: Add your message handler code here
    //m_wndStatusBar.SetPaneText(1, "qqq");
    
}


////////////////////////////////////////////////////////////////////////
// Added by Chen Jun.
void CMainFrame::OnEnterIdle(UINT nWhy, CWnd* pWho)
{
    CMDIFrameWnd::OnEnterIdle(nWhy, pWho);
    
    // TODO: Add your message handler code here
    
    // Remove the hook function from the hook chain.
    if ( ::hookStkKeyFilter ) {
        UnhookWindowsHookEx(::hookStkKeyFilter);
        ::hookStkKeyFilter = 0;
    }
}
