
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MAPDLG.CPP   1.29   02 Apr 1996 09:22:28   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MAPDLG.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:22:28   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:10   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.27   12 Feb 1996 14:02:00   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:52   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:28   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:12:02   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:42   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:04   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:07:30   Shirley
** EasyPack/SLD Version 0.34b
** 
**    Rev 1.18   15 Jan 1996 16:16:22   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:28   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:04   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:50   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:10   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:50   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:06   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:32:06   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:58   Shirley
** EasyPack/SLD Version 0.22
**
**    Rev 1.4   13 Oct 1995 13:20:56   Shirley
** No change.
**
**    Rev 1.3   29 Sep 1995 09:51:42   Shirley
** No change.
**
**    Rev 1.2   20 Sep 1995 10:56:14   Shirley
** No change.
**
**    Rev 1.1   15 Sep 1995 09:45:10   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:54:38   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MAPDLG.CPP
//
//  Description:The implement file for the class: CMapDlg
//
//  Author:     Lane Li  &   Daniel Lin
//
//  Date:       09/10/95
//  Modification:
//      1. 1/29/96, 0.35 version          Daniel Lin
//                   Modified function 		OnInitialize()		// Fix the bug by Gary Wang
//		
//
//      1. 10/19/95, 0.1d version          Daniel Lin
//                   Modified function CMapDlg::OnMapAdd()
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// mapdlg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "xview.h"
#include "myedit2.h"
#include "spin.h"
#include "mapdlg.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern void MemServerSetMap(const unsigned short uStart,
                                                        const unsigned short uEnd,
                                                const unsigned char uchType,
                                                const char chMapAttr);
extern BOOL MemServerGetMap(unsigned short& uStart,
                                                        unsigned short& uEnd,
                                                    unsigned char& uchType,
                                                    char& chMapAttr);

extern void SaveConfig(LPCSTR filename, int option);
extern void LoadConfig(LPCSTR filename, int option);
extern int GetMemoryRange(CPUMEMORYRANGE *stRange);

char  strSelectItem[100];
char  *strPosition;
char  strStartAddress[10];
char  strEndAddress[10];
char  strLength[10];
char  strAttrib[30];
char  strSpace[40];

/////////////////////////////////////////////////////////////////////////////
// CMapDlg dialog

CMapDlg::CMapDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CMapDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CMapDlg)
	//}}AFX_DATA_INIT
}

void CMapDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CMapDlg)
	DDX_Control(pDX, IDC_MAP_LIST1, m_ListBox);
	DDX_Control(pDX, IDC_MAP_COMBO2, m_Combo2);
	DDX_Control(pDX, IDC_MAP_COMBO1, m_Combo1);
	//}}AFX_DATA_MAP
}

void CMapDlg::GetMap()
{
        unsigned short startAddress,endAddress;
        unsigned char space;
        long length;
        char attribute;
        char buf[100];
        char *p;
        CWnd* ctrl;
        CFont font;
        int i;

    ctrl = GetDlgItem(IDC_MAP_LIST1);
    ((CListBox *)ctrl)->ResetContent();
    font.Attach(::GetStockObject(ANSI_FIXED_FONT));
    ctrl->SetFont(&font,FALSE);

    space = 1;
    startAddress=/*pMin;*/0;
    endAddress=/*pMax;*/0xffff;
    do{
        for(i=0;i<100;i++)
            buf[i]=' ';
        buf[99]='\0';

        MemServerGetMap(startAddress,endAddress,space,attribute);
        length = (long)endAddress-(long)startAddress + 1;
/*
        sprintf(buf,"0x%X, 0x%X, 0x%lX",
            startAddress,endAddress,length);
        i = strlen(buf);
        buf[i]=' ';
*/
        p=buf;
        sprintf(p,"0x%X,",startAddress);
        i = strlen(buf);
        buf[i]=' ';

        p=buf+7;
        sprintf(p,"0x%X,",endAddress);
        i = strlen(buf);
        buf[i]=' ';

        p=buf+14;
        sprintf(p,"0x%lX,",length);
        i = strlen(buf);
        buf[i]=' ';

        p = buf+22;
        switch(attribute)
        {
            case 0:
                strcpy(p,"Internal Read/Write,");
                break;
            case 1:
                strcpy(p,"Internal Read Only,");
                break;
            case 2:
                strcpy(p,"External Read/Write,");
                break;
            case 3:
                strcpy(p,"External Read Only,");
                break;
            case 4:
                strcpy(p,"Combination Read/Write,");
                break;
            case 5:
                strcpy(p,"Combination Read Only,");
                break;
            case 6:
                strcpy(p,"Guard,");
                break;
        }
        i = strlen(buf);
        buf[i]=' ';

        p=buf+45;
        strcpy(p,"Program");
        i = strlen(buf);
        buf[i]='\0';

        ((CListBox *)ctrl)->AddString(buf);
        startAddress=endAddress+1;
    }while(endAddress</*pMax*/0xffff);

    space = 2;
    startAddress=/*xMin;*/0;
    endAddress=/*xMax;*/0xffff;
    do{
        for(i=0;i<100;i++)
            buf[i]=' ';
        buf[99]='\0';

        MemServerGetMap(startAddress,endAddress,space,attribute);
        length = (long)endAddress-(long)startAddress + 1;
        p=buf;
        sprintf(p,"0x%X,",startAddress);
        i = strlen(buf);
        buf[i]=' ';

        p=buf+7;
        sprintf(p,"0x%X,",endAddress);
        i = strlen(buf);
        buf[i]=' ';

        p=buf+14;
        sprintf(p,"0x%lX,",length);
        i = strlen(buf);
        buf[i]=' ';

        p = buf+22;
        switch(attribute)
        {
            case 0:
                strcpy(p,"Internal Read/Write,");
                break;
            case 1:
                strcpy(p,"Internal Read Only,");
                break;
            case 2:
                strcpy(p,"External Read/Write,");
                break;
            case 3:
                strcpy(p,"External Read Only,");
                break;
            case 4:
                strcpy(p,"Combination Read/Write,");
                break;
            case 5:
                strcpy(p,"Combination Read Only,");
                break;
            case 6:
                strcpy(p,"Guard,");
                break;
        }
        i = strlen(buf);
        buf[i]=' ';

        p=buf+45;
        strcpy(p,"Data");
        i = strlen(buf);
        buf[i]='\0';

        ((CListBox *)ctrl)->AddString(buf);
        startAddress=endAddress+1;
    }while(endAddress</*xMax*/0xffff);
}

BEGIN_MESSAGE_MAP(CMapDlg, CDialog)
    //{{AFX_MSG_MAP(CMapDlg)
    ON_BN_CLICKED(IDC_MAP_RADIO1, OnMapRadio1)
    ON_BN_CLICKED(IDC_MAP_RADIO2, OnMapRadio2)
    ON_BN_CLICKED(IDC_MAP_ADD, OnMapAdd)
    ON_BN_CLICKED(IDC_MAP_CLOSE, OnMapClose)
    ON_BN_CLICKED(IDC_MAP_RESTORE, OnMapRestore)
    ON_BN_CLICKED(IDC_MAP_SAVE, OnMapSave)
	ON_LBN_SELCHANGE(IDC_MAP_LIST1, OnSelchangeMapList1)
	ON_WM_CREATE()
	ON_CBN_SELCHANGE(IDC_MAP_COMBO1, OnSelchangeMapCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMapDlg message handlers

BOOL CMapDlg::OnInitDialog()
{
    CDialog::OnInitDialog();
    CenterWindow();

    // TODO: Add extra initialization here
    RECT rect, editrect;
    CWnd* ctrl;
    CPUMEMORYRANGE stRange;

    GetMemoryRange( &stRange );         // Get the current cpu memory

    pMin = stRange.pMin;
    pMax = stRange.pMax;
    xMin = stRange.xMin;
    xMax = stRange.xMax;

    SetDlgItemText(IDC_MAP_EDIT1,"0x0");
    SetDlgItemText(IDC_MAP_EDIT2,"0x7f");
/*
    rect.left = 227;
    rect.top = 44;
    rect.right = 242;
    rect.bottom = 64;
*/    
    m_edit1.SubclassEdit(IDC_MAP_EDIT1,this,PES_NUMBERS);
    m_edit1.SetRange(0,0xFFFF);	// Should be changed
    m_edit1.m_uWhichEdit = 1;
    m_edit1.m_uAddOrLen = 0;
    
	m_edit1.GetWindowRect(&editrect);
	ScreenToClient(&editrect);
	rect.left = editrect.right + 1;
	rect.right = rect.left + 15;
	rect.top = editrect.top;
	rect.bottom = editrect.bottom;
	    
    m_spin1.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT1);
    m_spin1.SetAssociate(&m_edit1);

/*
    rect.left = 227;
    rect.top = 83;
    rect.right = 242;
    rect.bottom = 103;
*/    
    m_edit2.SubclassEdit(IDC_MAP_EDIT2,this,PES_NUMBERS);
    m_edit2.SetRange(0,0xFFFF);	// Should be changed
    m_edit2.m_uWhichEdit = 2;
	m_edit2.m_uAddOrLen = 0;    
	
	m_edit2.GetWindowRect(&editrect);
	ScreenToClient(&editrect);
	rect.left = editrect.right + 1;
	rect.right = rect.left + 15;
	rect.top = editrect.top;
	rect.bottom = editrect.bottom;
	
    m_spin2.Create(WS_VISIBLE|WS_CHILD|MSS_VERTICAL,rect,this,IDC_MAP_EDIT2);
    m_spin2.SetAssociate(&m_edit2);

    ctrl=GetDlgItem(IDC_MAP_COMBO1);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl=GetDlgItem(IDC_MAP_COMBO2);
    ((CComboBox *)ctrl)->SetCurSel(2);

    CheckRadioButton(IDC_MAP_RADIO1,IDC_MAP_RADIO2,IDC_MAP_RADIO1);
    if (pMax == 0 && pMin == 0) {
       GetDlgItem(IDC_MAP_RADIO1)->EnableWindow(FALSE);
    }
    if (xMax == 0 && xMin == 0) {
           GetDlgItem(IDC_MAP_RADIO2)->EnableWindow(FALSE);
    }

    GetMap();
    m_ListBox.SetCurSel(0);
	OnSelchangeMapList1();
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMapDlg::OnMapRadio1()
{
    // TODO: Add your control notification handler code here
    CWnd* ctrl;
    int count;
    int sel;

    ctrl=GetDlgItem(IDC_MAP_COMBO2);
    count = ((CComboBox *)ctrl)->GetCount();
    if (count==7)
    {
        sel = ((CComboBox *)ctrl)->GetCurSel();
        if ((sel==5)||(sel==6))
            ((CComboBox *)ctrl)->SetCurSel(2);
        ((CComboBox *)ctrl)->DeleteString(5);
        ((CComboBox *)ctrl)->DeleteString(5);
    }
}

void CMapDlg::OnMapRadio2()
{
    // TODO: Add your control notification handler code here
    CWnd* ctrl;
    int count;

    ctrl=GetDlgItem(IDC_MAP_COMBO2);
    count = ((CComboBox *)ctrl)->GetCount();
    if (count==5)
    {
        ((CComboBox *)ctrl)->AddString("Combination Read/Write");
        ((CComboBox *)ctrl)->AddString("Combination Read Only");
    }
}

void CMapDlg::OnMapAdd()
{
    // TODO: Add your control notification handler code here
    long startAddress;
    long endAddress;
    int attribute;
    int space;

    unsigned short uStart;
    unsigned short uEnd;
    unsigned char uchType;
    char chMapAttr;

    char buf[25];
    //char buf2[25];
    char convert[25];
    long value;
    int i, j;
    CWnd* ctrl;

    long lvalue;
    BOOL bOk;

    buf[24]='\0';
    // Initial string array
    for (j = 0; j< 25; j++) {
       buf[j] = '\0';
       convert[j] = '\0';
    }
    GetDlgItemText(IDC_MAP_EDIT1,buf,20);
    // Clear all space char
    j = 0;
    for (i = 0; i < 20; i++ ) {
        if (buf[i] != ' ') {
           convert[j] = buf[i];
           j++;
        }
    }
    convert[j] = '\0';
    strcpy ( buf, convert );
    if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
    {
        j = 2;
        while (buf[j] != '\0') {
          if ((buf[j] == 'x') || (buf[j] == 'X')) {
             MessageBeep(-1);
             MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MAP_EDIT1);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
          }
          j++;
        }
        
        lvalue = strtol(buf,NULL,16);

        if ((lvalue>0xffff)||(lvalue<0)) bOk = FALSE;
        else bOk = TRUE;
        
            //ltoa(lvalue,buf2 , 16);
            // (lstrcmpi(buf2,buf+2)!=0)
            //Ok = FALSE;
        value = lvalue;
    }
    else
    {
       j = 0;
       while (buf[j] != '\0') {
          if ((buf[j] < '0') || (buf[j] > '9')) {
             MessageBeep(-1);
             MessageBox("Input Error.", NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MAP_EDIT1);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
          }
          j++;
        }
        lvalue = strtol(buf,NULL,10);
        if ((lvalue>0xffff)||(lvalue<0)) bOk = FALSE;
        else bOk = TRUE;        
                //_ultoa(lvalue,buf2 , 10);
                //if (lstrcmpi(buf2,buf)!=0)
                //      bOk = FALSE;
                //if (bOk)
        value = lvalue;
    }
    if (!bOk)
    {
        MessageBeep(-1);
        MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
        ctrl = GetDlgItem(IDC_MAP_EDIT1);
        ((CEdit *)ctrl)->SetFocus();
        ((CEdit *)ctrl)->SetSel(0,-1);
        return;
    }

    buf[24]='\0';
    startAddress = value;

    GetDlgItemText(IDC_MAP_EDIT2,buf,20);

    // Clear all space char
    j = 0;
    for (i = 0; i < 20; i++ ) {
        if (buf[i] != ' ') {
           convert[j] = buf[i];
           j++;
        }
    }
    convert[j] = '\0';

    if (lstrcmpi("0x10000",buf)==0)
    {
            ctrl = GetDlgItem(IDC_MAP_COMBO1);
            i=((CComboBox *)ctrl)->GetCurSel();
            if (i==1) value = 0x10000;
            else bOk=FALSE;
    }
    else if (lstrcmpi("65536",buf)==0)
    {
            ctrl = GetDlgItem(IDC_MAP_COMBO1);
            i=((CComboBox *)ctrl)->GetCurSel();
            if (i==1) value = 0x10000;
            else bOk=FALSE;
    }
    else if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
    {
        j = 2;
        while (buf[j] != '\0') {
          if ((buf[j] == 'x') || (buf[j] == 'X')) {
             MessageBeep(-1);
             MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MAP_EDIT2);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
          }
          j++;
        }
        lvalue = strtol(buf,NULL,16);
        if ((lvalue>0xffff)||(lvalue<0)) bOk = FALSE;
        else bOk = TRUE;        
                //_ultoa(lvalue, buf2 , 16);
                //if (lstrcmpi(buf2,buf+2)!=0)
                //        bOk = FALSE;
                //if (bOk)
        value = lvalue;
    }
    else
    {
       j = 0;
       while (buf[j] != '\0') {
          if ((buf[j] < '0') || (buf[j] > '9')) {
             MessageBeep(-1);
             MessageBox("Input Error.", NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MAP_EDIT2);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
          }
          j++;
        }
        lvalue = strtol(buf,NULL,10);
        if ((lvalue>0xffff)||(lvalue<0))
           bOk = FALSE;
		else bOk = TRUE;           
                //_ultoa(lvalue,buf2 , 10);
                //if (lstrcmpi(buf2,buf)!=0)
                //      bOk = FALSE;
                //if (bOk)
        value = lvalue;
    }
    if (!bOk)
    {
        MessageBeep(-1);
        MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
        ctrl = GetDlgItem(IDC_MAP_EDIT2);
        ((CEdit *)ctrl)->SetFocus();
        ((CEdit *)ctrl)->SetSel(0,-1);
        return;
    }

    ctrl = GetDlgItem(IDC_MAP_COMBO1);
    i=((CComboBox *)ctrl)->GetCurSel();
    if (i==0) endAddress = value;
    else endAddress = startAddress + value - 1;
    if (endAddress<startAddress)
    {
        MessageBeep(-1);
        MessageBox("End address must be greater than start address.",
                   NULL,MB_OK|MB_ICONEXCLAMATION);
        ((CEdit *)(GetDlgItem(IDC_MAP_EDIT2)))->SetFocus();
        ((CEdit *)(GetDlgItem(IDC_MAP_EDIT2)))->SetSel(0,-1);
        return;
    }

    ctrl = GetDlgItem(IDC_MAP_COMBO2);
    i = ((CComboBox *)ctrl)->GetCurSel();
    switch (i)
    {
        case 0:
            attribute = 0;
            break;
        case 1:
            attribute = 1;
            break;
        case 2:
            attribute = 6;
            break;
        case 3:
            attribute = 2;
            break;
        case 4:
            attribute = 3;
            break;
        case 5:
            attribute = 4;
            break;
        case 6:
            attribute = 5;
            break;
    }

    i = GetCheckedRadioButton(IDC_MAP_RADIO1,IDC_MAP_RADIO2);
    if (i==IDC_MAP_RADIO1) space = 1;
    else space = 2;

//#ifdef _LANE
    uStart = (unsigned short)startAddress;
    uEnd = (unsigned short)endAddress;
    uchType = (unsigned char)space;
    chMapAttr = (char)attribute;

    MemServerSetMap(uStart,uEnd,uchType,chMapAttr);

    GetMap();
    ::RepaintMemory();
    ::RepaintBMemory();
    ::RepaintStack();
    ::RepaintVariable();

//#endif
}

void CMapDlg::OnMapClose()
{
    // TODO: Add your control notification handler code here
    EndDialog(0);
}

void CMapDlg::OnMapRestore()
{
    // TODO: Add your control notification handler code here
    unsigned short startAddress,endAddress;
    unsigned char space;
    char attribute;
    int count;
    int i;
    WORD w;
    CFile file;
    BOOL b;

	char exefilename[125];
		
    ::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
    int pp = 0;
    for (pp = strlen(exefilename); pp > 0; pp--) {
    	if (exefilename[pp] == '\\')
    		break;
	}    		
    
    exefilename[pp+1] = '\0';
    strcat(exefilename, "map.sav");

    b = file.Open(exefilename, CFile::modeRead);
    if (!b)
    {
        file.Abort();
        MessageBox("Error Open Map File",NULL,MB_OK|MB_ICONHAND|MB_ICONSTOP);
        return;
    }

    CArchive ar(&file,CArchive::load);

    BeginWaitCursor();

    ar >> w;
    count = (int)w;

    for(i=1;i<=count;i++)
    {
        ar >> w;
        startAddress = (unsigned short)w;
        ar >> w;
        endAddress = (unsigned short)w;
        ar >> w;
        space = (unsigned char)w;
        ar >> w;
        attribute = (char)w;

//#ifdef _LANE
        MemServerSetMap(startAddress,endAddress,space,attribute);
//#endif
    }

    GetMap();

    EndWaitCursor();
    ar.Close();
    file.Close();
}

void CMapDlg::OnMapSave()
{
    // TODO: Add your control notification handler code here
        unsigned short startAddress,endAddress;
        unsigned char space;
        char attribute;
        int count;
        WORD w;

    space = 1;
    startAddress=0;
    endAddress=0xffff;
    count = 0;
    do{
        MemServerGetMap(startAddress,endAddress,space,attribute);
        startAddress=endAddress+1;
        count++;
    }while(endAddress<0xffff);

    space = 2;
    startAddress=0;
    endAddress=0xffff;
    do{
        MemServerGetMap(startAddress,endAddress,space,attribute);
        startAddress=endAddress+1;
        count++;
    }while(endAddress<0xffff);

	char exefilename[125];
		
    ::GetModuleFileName(AfxGetInstanceHandle(), exefilename, 125);
    int pp = 0;
    for (pp = strlen(exefilename); pp > 0; pp--) {
    	if (exefilename[pp] == '\\')
    		break;
	}    		
    
    exefilename[pp+1] = '\0';
    strcat(exefilename, "map.sav");
    CFile file(exefilename, CFile::modeCreate|CFile::modeWrite);
    CArchive ar(&file,CArchive::store);

    BeginWaitCursor();
    w = (WORD)count;
    ar << w;

    space = 1;
    startAddress=0;
    endAddress=0xffff;
    count = 0;
    do{
        MemServerGetMap(startAddress,endAddress,space,attribute);
        w = (WORD)startAddress;
        ar << w;
        w = (WORD)endAddress;
        ar << w;
        w = (WORD)space;
        ar << w;
        w = (WORD)attribute;
        ar << w;

        startAddress=endAddress+1;
        count++;
    }while(endAddress<0xffff);

    space = 2;
    startAddress=0;
    endAddress=0xffff;
    count = 0;
    do{
        MemServerGetMap(startAddress,endAddress,space,attribute);
        w = (WORD)startAddress;
        ar << w;
        w = (WORD)endAddress;
        ar << w;
        w = (WORD)space;
        ar << w;
        w = (WORD)attribute;
        ar << w;

        startAddress=endAddress+1;
        count++;
    }while(endAddress<0xffff);
    EndWaitCursor();

    ar.Close();
    file.Close();
}
 
// 
// Modified to fixed the bug by 12/28/95 fax
//
void CMapDlg::OnSelchangeMapList1()
{
   // TODO: Add your control notification handler code here
   UINT  iCount;
   
   memset(strSelectItem, 0, 100);
   memset(strStartAddress, 0, 10);   
   memset(strEndAddress, 0, 10);   
   memset(strLength, 0, 10);   
   memset(strAttrib, 0, 30);   
   memset(strSpace, 0, 40);      
//   CWnd *ctrl;
//   ctrl = GetDlgItem(IDC_MAP_LIST1);
   /*((CListBox *)ctrl)*/
   m_ListBox.GetText(m_ListBox.GetCurSel(), strSelectItem);
   strPosition = strSelectItem;
   strncpy(strStartAddress, strPosition, 7);
   strncpy(strEndAddress, strPosition+7, 7);
   strncpy(strLength, strPosition+14, 7);
   strncpy(strAttrib, strPosition+22, 23);
   strncpy(strSpace, strPosition+45, 40);   
   
   for (iCount = 7; iCount > 0; iCount--) {
      if (',' == strStartAddress[iCount]) {
         strStartAddress[iCount] = '\0';
         break;
      }
   }
   for (iCount = 7; iCount > 0; iCount--) {
      if (',' == strEndAddress[iCount]) {
         strEndAddress[iCount] = '\0';
         break;
      }
   }
   for (iCount = 7; iCount > 0; iCount--) {
      if (',' == strLength[iCount]) {
         strLength[iCount] = '\0';
         break;
      }
   }
   for (iCount = 23; iCount > 0; iCount--) {
      if (',' == strAttrib[iCount]) {
         strAttrib[iCount] = '\0';
         break;
      }
   }
   for (iCount = 40; iCount > 0; iCount--) {
      if (',' == strSpace[iCount]) {
         strSpace[iCount] = '\0';
         break;
      }
   }
   
   SetDlgItemText(IDC_MAP_EDIT1, strStartAddress);
   //SetDlgItemText(IDC_MAP_COMBO1, "EndAddress\0");
   m_Combo1.SetCurSel(0);  // Set EndAddress select
   SetDlgItemText(IDC_MAP_EDIT2, strEndAddress);
   //SetDlgItemText(IDC_MAP_COMBO2, strAttrib);
   if (0 == strcmp(strSpace, "Program")) {
      CheckRadioButton(IDC_MAP_RADIO1, IDC_MAP_RADIO2, IDC_MAP_RADIO1);
      OnMapRadio1();
   }      
   else {
      if (0 == strcmp(strSpace, "Data")) {
         CheckRadioButton(IDC_MAP_RADIO1, IDC_MAP_RADIO2, IDC_MAP_RADIO2);            
         OnMapRadio2();
      }   
   }	         
         
   int iAttribIndex = 0;        
   if (0 == strcmp(strAttrib, "Internal Read/Write")) {
      iAttribIndex = 0;
	  goto SETSEL;
   }		      
   if (0 == strcmp(strAttrib, "Internal Read Only")) {
      iAttribIndex = 1;
	  goto SETSEL;
	}		      
   if (0 == strcmp(strAttrib, "Guard")) {
      iAttribIndex = 2;
	  goto SETSEL;
	}		      
   if (0 == strcmp(strAttrib, "External Read/Write")) {
      iAttribIndex = 3;
	  goto SETSEL;
	}		      
   if (0 == strcmp(strAttrib, "External Read Only")) {
      iAttribIndex = 4;
	  goto SETSEL;
	}		      
   if (0 == strcmp(strAttrib, "Combination Read/Write")) {
      iAttribIndex = 5;
	  goto SETSEL;
	}		      
   if (0 == strcmp(strAttrib, "Combination Read Only")) {
      iAttribIndex = 6;
	  goto SETSEL;
	}		      
SETSEL:	
   m_Combo2.SetCurSel(iAttribIndex);   
}

/*
void CMapDlg::OnDblclkMapList1()
{
	// TODO: Add your control notification handler code here
}
*/

int CMapDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
//    m_ListBox.SetCurSel(0);
	return 0;
}

void CMapDlg::OnSelchangeMapCombo1()
{
	// TODO: Add your control notification handler code here
	int Select = 0;
	
	Select = m_Combo1.GetCurSel();
	if (0 == Select) {	// Address
		m_edit2.m_uAddOrLen = 0;		
	}
	else
	  if (1 == Select) {	// Length
		m_edit2.m_uAddOrLen = 1;			  
	  }
	switch(Select) {
		case	0:
				SetDlgItemText(IDC_MAP_EDIT2, strEndAddress);		
				break;
		case	1:
				SetDlgItemText(IDC_MAP_EDIT2, strLength);
				break;
	}				
}
