
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MEMADDR.H__   1.29   02 Apr 1996 09:24:12   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MEMADDR.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:24:12   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:52:48   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:36   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:06   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:46   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:40   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:16   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:18   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:12   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:28   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:20   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:00   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:50   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:38   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:44   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:46   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:26   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:26   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:44   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:24   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:00   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:18   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:46   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:12   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMADDR.H
//
//  Description: The header file for the class: CMemoryAddr.
//
//  Author: Chen Jun
//
//  Date: 04/21/95
//
//  Modification:
//      1. 04/21/95, Initial version of the class: CMemoryAddr.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMADDR_
#define _MEMADDR_


/////////////////////////////////////////////////////////////////////////////
// CMemoryAddr class.
class CMemoryAddr
{
// Contruction & Destruction.
public:
    CMemoryAddr();
    CMemoryAddr(unsigned short uAddr, unsigned char uchType);
    ~CMemoryAddr();
        
// Member variables.
public:
    unsigned char m_uchType;
    unsigned short m_uAddr;
    
// Operator member functions.
public:
    CMemoryAddr operator+(const CMemoryAddr& Addr);
    CMemoryAddr operator+(const unsigned short& uSize);
    
    CMemoryAddr operator-(const CMemoryAddr& Addr);
    CMemoryAddr operator-(const unsigned short& uSize);
    
    void operator=(const CMemoryAddr& Addr);
    void operator=(const unsigned short& uNewAddr);
    
    BOOL operator==(const CMemoryAddr& Addr);
    BOOL operator==(const unsigned short& uNewAddr);

    BOOL operator!=(const CMemoryAddr& Addr);
    BOOL operator!=(const unsigned short& uNewAddr);
    
    BOOL operator>(const CMemoryAddr& Addr);
    BOOL operator>(const unsigned short& uNewAddr);
    
    BOOL operator<(const CMemoryAddr& Addr);
    BOOL operator<(const unsigned short& uNewAddr);

    BOOL operator>=(const CMemoryAddr& Addr);
    BOOL operator>=(const unsigned short& uNewAddr);

    BOOL operator<=(const CMemoryAddr& Addr);
    BOOL operator<=(const unsigned short& uNewAddr);

};  // End of class: CMemoryAddr.

#endif
//////////////////////////////// End of File ////////////////////////////////
