
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MEMFILL.H__   1.29   02 Apr 1996 09:26:08   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MEMFILL.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:26:08   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:28   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:08   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:28:02   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:34   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:04   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:02   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:08:46   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:38   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:00   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:34   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:22   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:00   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:14   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:04   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:16   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:32   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:02:24   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:20   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:22   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:40   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:52   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:28   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:48   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:45:58   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:48   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMFILL.H
//
//  Description: The header file for the class: CMemoryFill.
//
//  Author: Chen Jun
//
//  Date: 04/26/95
//
//  Modification:
//      1. 04/26/95, Initial version of the class: CMemoryFill.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _MEMFILL_
#define _MEMFILL_

#include "membase.h"


/////////////////////////////////////////////////////////////////////////////
// CMemoryFill class.
class CMemoryFill : public CMemoryBase
{
// Construction & Destruction.
public:
    CMemoryFill();
    ~CMemoryFill();
    
// Member variables.
private:
    CMemoryAddr m_StartAddr, m_EndAddr, m_FailAddr;
    
    enum { MAX_FILL_SIZE = 32 };
    char m_pchFill[MAX_FILL_SIZE+1];
    
    unsigned int m_uPatternLen;
    
// Implementations.
private:
    void SetPattern(char* pszPattern);
    void MemoryFillKernel(void);

public:
    void FillAction(int nArgc, char* pszArgv[]);

    int MemServerFill(WORD wAddr, BYTE bValue, int nType);
    void MemServerFill(const unsigned short uStart, const unsigned short uEnd,
                       const unsigned char uchType, char* pszPattern);

};  // End of class: CMemoryFill.

#endif
//////////////////////////////// End of File ////////////////////////////////
