
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MEMGTDLG.CPP   1.29   02 Apr 1996 09:28:12   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MEMGTDLG.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:28:12   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:49:46   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:14   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:30   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:00   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:50   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:30   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:16   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:02   Shirley
** EasyPack/SLD Version 0.34b
** 
**    Rev 1.18   15 Jan 1996 16:16:18   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:50   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:28   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:02   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:16   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:24   Shirley
** EasyPack/SLD Version 0.24
**
**    Rev 1.11   08 Nov 1995 16:32:50   Shirley
** No change.
**
**    Rev 1.10   08 Nov 1995 12:42:12   Shirley
** EasyPack/SLD Version 0.22
**
**    Rev 1.4   13 Oct 1995 13:20:14   Shirley
** No change.
**
**    Rev 1.3   29 Sep 1995 09:49:32   Shirley
** No change.
**
**    Rev 1.2   20 Sep 1995 10:55:50   Shirley
** No change.
**
**    Rev 1.1   15 Sep 1995 09:45:58   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:54:48   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMGTDLG.CPP
//
//  Description:The implement file for the class: CMemGtDlg
//
//  Author:     Lane Li & Daniel Lin
//
//  Modification:
//
//      1. 10/31/95, 0.1g version.              Daniel Lin
//                 modify function:     OnMemGotoButton1()
//      1. 10/24/95, 0.1d version.      Daniel Lin
//                 modify function:     OnMemGotoButton1()
//      1. 10/18/95, 0.1d version.      Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// memgtdlg.cpp : implementation file

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"
#include "resource.h"
#include "xview.h"
#include "memgtdlg.h"
#include "errno.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern int GetMemoryRange(CPUMEMORYRANGE *stRange);

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

extern long linLastStartAddr;
extern unsigned char    linLastCheck;
                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/////////////////////////////////////////////////////////////////////////////
// CMemGtDlg dialog

/****************************************************************************
**  Name:
**
**
**  Description:
**
**
**
**  Parameters:
**     input:
**
**
**     output:
**
**
*****************************************************************************/
CMemGtDlg::CMemGtDlg(CWnd* pParent /*=NULL*/)
        : CDialog(CMemGtDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CMemGtDlg)
          m_memdt_edit = "";
        //}}AFX_DATA_INIT
}

/****************************************************************************
**  Name:
**
**
**  Description:
**
**
**
**  Parameters:
**     input:
**
**
**     output:
**
**
*****************************************************************************/
void CMemGtDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CMemGtDlg)
        DDX_Text(pDX, IDC_MEM_GOTO_EDIT1, m_memdt_edit);
        DDV_MaxChars(pDX, m_memdt_edit, 10);
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemGtDlg, CDialog)
        //{{AFX_MSG_MAP(CMemGtDlg)
        ON_BN_CLICKED(IDC_MEM_GOTO_BUTTON1, OnMemGotoButton1)
        ON_BN_CLICKED(IDC_MEM_GOTO_BUTTON2, OnMemGotoButton2)
        ON_UPDATE_COMMAND_UI(IDC_MEM_GOTO_RADIO1, OnUpdateRadio1)
        ON_UPDATE_COMMAND_UI(IDC_MEM_GOTO_RADIO2, OnUpdateRadio2)
        ON_UPDATE_COMMAND_UI(IDC_MEM_GOTO_RADIO3, OnUpdateRadio3)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/****************************************************************************
**
**  CMemGtDlg :: OnInitDialog
**
**  Description:
**     Initial the dialog box
**
**  Parameters:
**     input:
**        none
**
**     output:
**        BOOL:
**
*****************************************************************************/

BOOL CMemGtDlg::OnInitDialog()
{
// In this routine, it should be added into some other routine that is what
//    data's address range the cpu supported.
    CPUMEMORYRANGE stRange;

    CDialog::OnInitDialog();
    CenterWindow();

    //stRange = new( sizeof( CPUMEMORYRANGE ) );
    GetMemoryRange( &stRange );         // Get the current cpu memory
    pMin = stRange.pMin;
    pMax = stRange.pMax;
    xMin = stRange.xMin;
    xMax = stRange.xMax;
    iMin = stRange.iMin;
    iMax = stRange.iMax;

    // TODO: Add extra initialization here
    char text[20];

    //m_lAddress = linLastStartAddr;
    //m_nSpace = linLastCheck;

    switch (m_nSpace) {
      case 1:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,IDC_MEM_GOTO_RADIO3,
                            IDC_MEM_GOTO_RADIO1);
           break;
      case 2:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,IDC_MEM_GOTO_RADIO3,
                            IDC_MEM_GOTO_RADIO2);
           break;
      case 3:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,IDC_MEM_GOTO_RADIO3,
                            IDC_MEM_GOTO_RADIO3);
           break;
      default:
           break;
    }
    sprintf(text,"0x%X",m_lAddress);
    SetDlgItemText(IDC_MEM_GOTO_EDIT1,text);
    CWnd* ctrl;
    ctrl=GetDlgItem(IDC_MEM_GOTO_EDIT1);
    ((CEdit *)ctrl)->SetFocus();
    ((CEdit *)ctrl)->SetSel(0,-1);
    // if the are has a map, remarked by Daniel Lin on 11/10/95
    
    if (pMax == 0 && pMin == 0) {
       GetDlgItem(IDC_MEM_GOTO_RADIO1)->EnableWindow(FALSE);
    }
    if (xMax == 0 && xMin == 0) {
           GetDlgItem(IDC_MEM_GOTO_RADIO2)->EnableWindow(FALSE);
    }
    if (iMax == 0 && iMin == 0) {
       GetDlgItem(IDC_MEM_GOTO_RADIO3)->EnableWindow(FALSE);
    }
    
    return FALSE;  // return TRUE  unless you set the focus to a control
}

/****************************************************************************
**
**  CMemGtDlg :: OnMemGotoButton1
**
**  Description:
**     Deal the OK button
**
**  Parameters:
**     input:
**        none
**
**     output:
**        none
**
*****************************************************************************/

void CMemGtDlg::OnMemGotoButton1()
{
        // TODO: Add your control notification handler code here
        char text[25];
        //char text2[25];
        char error[60];
        char value[10];
        char convert[25];
        int  j = 0, i = 0;
        long lvalue;
        int iWhichButton;
        //BOOL bOk;
        CWnd* ctrl;

        // Initial string array;
        for (i = 0; i< 25; i++) {
          text[i] = '\0';
          convert[i] = '\0';
        }

        strcpy( error, "Input Error! The value range is " );
        iWhichButton = GetCheckedRadioButton(IDC_MEM_GOTO_RADIO1,IDC_MEM_GOTO_RADIO3);
        switch ( iWhichButton ) {
          case IDC_MEM_GOTO_RADIO1:
                   m_nSpace = 1;
                   linLastCheck = 1;
                   break;
          case IDC_MEM_GOTO_RADIO2:
                   m_nSpace = 2;
                   linLastCheck = 2;
                   break;
          case IDC_MEM_GOTO_RADIO3:
                   m_nSpace = 3;
                   linLastCheck = 3;
                   break;
          default:
                   break;
        }
        GetDlgItemText( IDC_MEM_GOTO_EDIT1, text, 20 );

        // Clear All Space Char
        for (i = 0; i < 20; i++ ) {
          if (text[i] != ' ') {
            convert[j] = text[i];
            j++;
          }
        }
        convert[j] = '\0';
        strcpy ( text, convert );

        if ((text[0]=='0')&&((text[1]=='x')||(text[1]=='X'))) {
           i = 2;
           while (text[i] != '\0') {
             if ((text[i] == 'x') || (text[i] == 'X')) {
                MessageBeep(-1);
                MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
                ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                ((CEdit *)ctrl)->SetFocus();
                ((CEdit *)ctrl)->SetSel(0,-1);
                return;
             }
             if (toupper(text[i]) > 'F') {
                MessageBeep(-1);
                MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
                ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                ((CEdit *)ctrl)->SetFocus();
                ((CEdit *)ctrl)->SetSel(0,-1);
                return;
             }
             i++;
           }
           //convert[i-1] = '\0';
           //strcpy (text, convert);

           if ( strlen( text ) == 2) {
             //bOk = FALSE;
             MessageBeep(-1);
             MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
           }
           if ( strlen( text ) > 6) {
             //bOk = FALSE;
             MessageBeep(-1);
             MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
           }
           
          /*
           convert[0] = text[0];
           convert[1] = text[1];

           i = 2;
           while((text[i] != '0') && (i < 20)) {
             convert[i] = text[i];
             i++;
           }
           convert[i] = '\0';
           */
           lvalue = strtol(text,NULL,16);
   //        if ((lvalue>0xffff)||(lvalue<0)) bOk = FALSE;
           switch( m_nSpace ) {
             case 1:
                  itoa( pMin, value, 16 );
                  strcat( error, "0x" );
                  strcat( error, value );
                  strcat( error, "..0x" );
                  itoa( pMax, value, 16 );
                  strcat( error, value );

                  if (strlen(text) > 20) {
                     MessageBeep(-1);
                     MessageBox(error,
                                    /*"Input Error. The value range is 0..0xFFFF"*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }

                  if ((lvalue > (long)pMax)||(lvalue < (long)pMin)) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFFFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }
                  break;
             case 2:
                  itoa( xMin, value, 16 );
                  strcat( error, "0x" );
                  strcat( error, value );
                  strcat( error, "..0x" );
                  itoa( xMax, value, 16 );
                  strcat( error, value );

                  if (strlen(text) > 20) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFFFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }

                  if ((lvalue > (long)xMax)||(lvalue < (long)xMin)) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFFFF",*/
                                 NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }
                  break;
             case 3:
                  itoa( iMin, value, 16 );
                  strcat( error, "0x" );
                  strcat( error, value );
                  strcat( error, "..0x" );
                  itoa( iMax, value, 16 );
                  strcat( error, value );

                  if (strlen(text) > 20) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }

                  if ((lvalue > (long)iMax)||(lvalue < (long)iMin)) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFF",*/
                                 NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }
                  break;
           }
           /*_ultoa(lvalue, text2, 16);
           if (lstrcmpi(text2, convert+2)!=0)
              MessageBeep(-1);
              MessageBox("Input Error.",
                         NULL,MB_OK|MB_ICONEXCLAMATION);
              ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                  ((CEdit *)ctrl)->SetFocus();
              ((CEdit *)ctrl)->SetSel(0,-1);
              return;
           }
           */
           m_lAddress = lvalue;
           linLastStartAddr = lvalue;
        }
        else {
          if (strlen( text ) == 0 ) {
             //bOk = FALSE;
             MessageBeep(-1);
             MessageBox("Input Error.", NULL,MB_OK|MB_ICONEXCLAMATION);
             //bOk = FALSE;     modified by Daniel Lin
             ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
          }
          i = 0;
          while(text[i] != '\0') {
          //for (i = 0; i < 20; i++) {
            if ((text[i] < '0') || (text[i] > '9')) {
               MessageBeep(-1);
               MessageBox("Input Error.", NULL,MB_OK|MB_ICONEXCLAMATION);
               ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
               ((CEdit *)ctrl)->SetFocus();
               ((CEdit *)ctrl)->SetSel(0,-1);
               return;
            }
            i++;
          }
          /*
          i = 0;
          while((text[i] != '0') && (i < 20)) {
            convert[i] = text[i];
            i++;
          }
          convert[i] = '\0';
          */
          lvalue = strtol(text,NULL,10);
//        if ((lvalue>0xffff)||(lvalue<0)) bOk = FALSE;
          switch( m_nSpace ) {
            case 1:
                  itoa( pMin, value, 10 );
                  strcat( error, value );
                  strcat( error, ".." );
                  _ultoa( (unsigned long)pMax, value, 10 );
                  strcat( error, value );

                  if (strlen(text) > 20) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFFFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }

                 if ((lvalue > (long)pMax)||(lvalue < (long)pMin)) {
                    MessageBeep(-1);
                    MessageBox(error,
                                   /*"Input Error. The value range is 0..0xFFFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                    //bOk = FALSE;    // modified by Daniel Lin
                    ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                        ((CEdit *)ctrl)->SetFocus();
                    ((CEdit *)ctrl)->SetSel(0,-1);
                    return;
                 }
                 break;

            case 2:
                  itoa( xMin, value, 10 );
                  strcat( error, value );
                  strcat( error, ".." );
                  itoa( xMax, value, 10 );
                  strcat( error, value );

                  if (strlen(text) > 20) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*      "Input Error. The value range is 0..0xFFFF",*/
                                 NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }

                 if ((lvalue > (long)xMax)||(lvalue < (long)xMin)) {
                    MessageBeep(-1);
                    MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFFFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                    //bOk = FALSE;    // modified by Daniel Lin
                    ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                        ((CEdit *)ctrl)->SetFocus();
                    ((CEdit *)ctrl)->SetSel(0,-1);
                    return;
                 }
                 break;
            case 3:
                  itoa( iMin, value, 10 );
                  strcat( error, value );
                  strcat( error, ".." );
                  itoa( iMax, value, 10 );
                  strcat( error, value );

                  if (strlen(text) > 20) {
                     MessageBeep(-1);
                     MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFF",*/
                                 NULL,MB_OK|MB_ICONEXCLAMATION);
                     //bOk = FALSE;     modified by Daniel Lin
                     ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                             ((CEdit *)ctrl)->SetFocus();
                         ((CEdit *)ctrl)->SetSel(0,-1);
                         return;
                  }

                 if ((lvalue > (long)iMax)||(lvalue < (long)iMin)) {
                    MessageBeep(-1);
                    MessageBox(error,
                                        /*"Input Error. The value range is 0..0xFF",*/
                                NULL,MB_OK|MB_ICONEXCLAMATION);
                    ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                        ((CEdit *)ctrl)->SetFocus();
                    ((CEdit *)ctrl)->SetSel(0,-1);
                    return;
                    //bOk = FALSE;    modified by Daniel Lin
                 }
                 break;
          }
          /*
          _ultoa(lvalue,text2 , 10);
          if (lstrcmpi(text2,convert+2)!=0)
             MessageBeep(-1);
             MessageBox("Input Error.",
                        NULL,MB_OK|MB_ICONEXCLAMATION);
             ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
             ((CEdit *)ctrl)->SetFocus();
             ((CEdit *)ctrl)->SetSel(0,-1);
             return;
          }
          */
          m_lAddress = lvalue;
          linLastStartAddr = lvalue;
        }
/*
        if (!bOk) {
           MessageBeep(-1);
           MessageBox("Input Error",NULL,MB_OK|MB_ICONEXCLAMATION);
           ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
           ((CEdit *)ctrl)->SetFocus();
           ((CEdit *)ctrl)->SetSel(0,-1);
           return;
        }
        else
*/
        EndDialog(1);
}

/****************************************************************************
**
**  CMemGtDlg :: OnMemGotoButton2
**
**  Description:
**     Deal the Cancel button
**
**  Parameters:
**     input:
**        none
**
**     output:
**        none
**
*****************************************************************************/
void CMemGtDlg::OnMemGotoButton2()
{
    // TODO: Add your control notification handler code here
    EndDialog(0);
}

void CMemGtDlg :: OnUpdateRadio1(CCmdUI *pCmdUI)
{
        pCmdUI -> Enable(FALSE);
}

void CMemGtDlg :: OnUpdateRadio2(CCmdUI *pCmdUI)
{
        pCmdUI -> Enable(FALSE);
}

void CMemGtDlg :: OnUpdateRadio3(CCmdUI *pCmdUI)
{
        pCmdUI -> Enable(FALSE);
}
