
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MEMVERI.CPP   1.29   02 Apr 1996 09:29:32   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MEMVERI.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:29:32   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:55:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:16   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:08   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:44   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:30   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:15:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:14   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:36   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:20   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:38   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:54   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:48   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:12   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:38   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:06   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:42   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:32   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:48   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMVERI.CPP
//
//  Description: The implementation file for the class: CMemoryVerify.
//
//  Author: Chen Jun
//
//  Date: 05/29/95
//
//  Modification:
//      1. 05/29/95, Initial version of the class: CMemoryVerify.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memveri.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
unsigned char uchMemVerifyFlag = 0;


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void VerifyCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetVerify(FLAG uVerifyFlag);
#endif  // _SERVER_NO_ABI


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   VerifyCmd().
//
//  Description: The main control routine of Verify command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void VerifyCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Verify EMM contents.
    CMemoryVerify* pMemoryVerify = new CMemoryVerify;
    if ( !pMemoryVerify ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pMemoryVerify->VerifyAction(nArgc, pszArgv);
        delete pMemoryVerify;
    }

//    CMemoryVerify objVerify;
//    objVerify.MemoryVerify(nArgc, pszArgv);

}   // End of VerifyCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryVerify.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryVerify::CMemoryVerify().
//
//  Description: The construction of the class: CMemoryVerify.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryVerify::CMemoryVerify()
{

}   // End of CMemoryVerify::CMemoryVerify().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryVerify::~CMemoryVerify().
//
//  Description: The destruction of the class: CMemoryVerify.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryVerify::~CMemoryVerify()
{

}   // End of CMemoryVerify::~CMemoryVerify().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryVerify::VerifyAction().
//
//  Description: Verify for EMM accessing.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryVerify::VerifyAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Verify command kernel.
    if ( 1 == nArgc ) {
        // Verify
        DisplayVerify();
    }
    else if ( 2 == nArgc ) {
        if ( !stricmp(pszArgv[1], "ON") ) {
            // Verify ON
            SetVerifyOn();
        }
        else if ( !stricmp(pszArgv[1], "OFF") ) {
            // Verify OFF
            SetVerifyOff();
        }
        else {
            return;
        }
    }
    else {
        return;
    }
    
}   // End of CMemoryVerify::VerifyAction().


// Set Verify On.
void CMemoryVerify::SetVerifyOn(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI routine.
    m_nErrorID = AbiSetVerify(1);
    if ( ICE_OK == m_nErrorID ) {
        uchMemVerifyFlag = 1;
    }
    else {
        DisplayErrorMessage();
    }
    
}   // End of CMemoryVerify::SetVerifyOn().


// Set Verify Off.
void CMemoryVerify::SetVerifyOff(void)
{
    // Assertion of the input parameters.
    
    // Call the ABI routine.
    m_nErrorID = AbiSetVerify(0);
    if ( ICE_OK == m_nErrorID ) {
        uchMemVerifyFlag = 0;
    }
    else {
        DisplayErrorMessage();
    }
    
}   // End of CMemoryVerify::SetVerifyOff().


// Display the current Verify status.
void CMemoryVerify::DisplayVerify(void)
{
    // Assertion of the input parameters.
    ASSERT( 0 == uchMemVerifyFlag || 1 == uchMemVerifyFlag );
    
    // Display the Verify status.
    if ( 1 == uchMemVerifyFlag ) {
        ShowLine("Verify is: ON.");
    }
    else if ( 0 == uchMemVerifyFlag ) {
        ShowLine("Verify is: OFF.");
    }
    else {
        return;
    }

}   // End of CMemoryVerify::DisplayVerify().


//////////////////////////////// End of File ////////////////////////////////
