         
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/MYLIST.CPP   1.27   02 Apr 1996 09:28:00   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/MYLIST.CPP  $
** 
**    Rev 1.27   02 Apr 1996 09:28:00   Shirley
** No change.
** 
**    Rev 1.26   15 Feb 1996 08:49:32   Shirley
** No change.
** 
**    Rev 1.25   12 Feb 1996 14:05:00   Shirley
** No change.
** 
**    Rev 1.24   06 Feb 1996 15:31:34   Shirley
** No change.
** 
**    Rev 1.23   06 Feb 1996 13:46:26   Shirley
** No change.
** 
**    Rev 1.22   01 Feb 1996 10:19:56   Shirley
** No change.
** 
**    Rev 1.21   26 Jan 1996 09:16:48   Shirley
** No change.
** 
**    Rev 1.20   25 Jan 1996 13:16:42   Shirley
** No change.
** 
**    Rev 1.19   24 Jan 1996 10:34:36   Shirley
** No change.
** 
**    Rev 1.18   23 Jan 1996 11:25:24   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.16   15 Jan 1996 16:16:24   Shirley
** No change.
** 
**    Rev 1.15   04 Jan 1996 11:08:30   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.11   13 Nov 1995 09:24:10   Shirley
** No change.
** 
**    Rev 1.10   12 Nov 1995 11:32:20   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.9   08 Nov 1995 16:30:44   Shirley
** No change.
** 
**    Rev 1.8   08 Nov 1995 12:45:20   Shirley
** No change.
** 
**    Rev 1.7   02 Nov 1995 10:05:42   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.1   29 Sep 1995 09:53:14   Shirley
** No change.
** 
**    Rev 1.0   20 Sep 1995 10:56:42   Shirley
** Initial revision.
** 
**    
** 
** 
**
**
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MYLIST.CPP
//
//  Description:The implementation file of main list for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////


#include "stdafx.h" 
#include "malloc.h"
#include "resource.h"
#include "xview.h"
#include "mylist.h" 
#include "flddlg.h" 
#include "listcol.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                 
extern UINT cpuid;  
extern  int Hex2Dec(char* reg_value);  
extern STATUS AbiGetCpuId(UINT*);
extern REGISTER RegVal[MAXRANGE];  
extern int ITEMRANGE;
extern int START_ID;  
extern HINSTANCE hPerLib;
/////////////////////////////////////////////////////////////////////////////
// CMyList

CMyList::CMyList(CWnd* parent):CListBox()
{ 
    
    CRect rect(1,1,100,100);  
    Create(WS_VSCROLL|WS_HSCROLL|LBS_NOINTEGRALHEIGHT|WS_VISIBLE|LBS_NOTIFY|WS_CHILD,rect, parent, IDC_LIST1); 
    
    HFONT hFont;
    hFont=(HFONT)GetStockObject(ANSI_FIXED_FONT);
    CFont Font; 
    SetFont(Font.FromHandle(hFont));
 
    InitList();
    SetHorizontalExtent(1400);          
}      








void CMyList::InitList()
{
   DWORD itemdata; 
    int   index;
    
    DWORD i;
    int   addrid=START_ID+1000; 
    int n;
    char szBuff[256]=" [+]    ";
    for(n=COLUMN1;n<255;n++)
       szBuff[n]=' '; 

    char sztemp[256];
    for(index=0;index<ITEMRANGE; index++)
       { 
         i=START_ID+index*32;
         itemdata=0;   //
         itemdata+=i<<16;   // high word of itemdata is set to be the 
                            // id of the string of notes.
         itemdata+=index<<8;
         
         ::LoadString(hPerLib,addrid,sztemp,255);   
         char *szaddr;
         szaddr=strtok(sztemp,",");
         
         int len;
         len=strlen(szaddr);  

         for(n=0;n<len;n++)
            szBuff[COLUMN1+n]=szaddr[n]; 
         n=COLUMN1+len;   
         while(szBuff[n]!=' ')
            {
              szBuff[n]=' ';    
              n++;
             } 
             
         //GetRegValue();     
         int regval; 
         regval=RegVal[index].value;
         if(regval<0x0f) 
            sprintf(sztemp,"0x0%X",regval);
         else   
         	sprintf(sztemp,"0x%X", regval);
         len=strlen(sztemp);  

         for(n=0;n<len;n++)
            szBuff[COLUMN1+COLUMN2+n]=sztemp[n]; 
         n=COLUMN1+COLUMN2+len;   
         while(szBuff[n]!=' ')
            {
              szBuff[n]=' ';    
              n++;
             } 
         szBuff[COLUMN1+COLUMN2+COLUMN3]='\0';
         ::LoadString(hPerLib,HIWORD(itemdata),sztemp,COLUMN4);
         strncat(szBuff,sztemp,COLUMN4 );
         AddString(szBuff); 
         SetItemData(index, itemdata); 
         addrid++;  
         
       }                  
}      

CMyList::~CMyList()
{
}

BEGIN_MESSAGE_MAP(CMyList, CListBox)
    //{{AFX_MSG_MAP(CMyList)
    ON_WM_LBUTTONUP()   
	ON_WM_LBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMyList message handlers

     
void CMyList::OnLButtonUp(UINT nFlags,CPoint point)
{
    CWnd::OnLButtonUp(nFlags,point);
                                                     
    char szBuff[256]="";           
    DWORD dw;
    
    if((1<point.x) &&(point.x<40))
       { 
         int cursel;
         cursel=GetCurSel();   
         dw=GetItemData(cursel);
         
         int  p=LOWORD(dw);  
         int  q=LOBYTE(p);
                  
         if ( !q )        
            { 
              GetText(cursel,szBuff);
               
              if( szBuff[2]=='+'  )
                { 
                  szBuff[2]='-';
                  DeleteString(cursel);
                  InsertString(cursel,szBuff);
                  SetItemData(cursel,dw);
                  
                  InsertBitItem(cursel,dw);
                 }
              else
                { 
                  szBuff[2]='+';       
                  DeleteString(cursel);
                  InsertString(cursel,szBuff);
                  SetItemData(cursel,dw);
                  DeleteBitItem(cursel,dw);   
                }             
            } 
          SetCurSel(cursel);      
       }
      //////////modify by jerry/11/9/95/////////////       
      // CWnd::OnLButtonUp(nFlags, point );
} 



void CMyList::InsertBitItem(int reg_index,DWORD dw)
{
    char sztemp[64]="";  
    char szBuff[256]="";
    int regval; 
    int Addrid;
    Addrid=LOWORD(dw);
    Addrid=HIBYTE(Addrid);
    regval=RegVal[Addrid].value ; 
    
        
    if( (cpuid==2) || (cpuid==3) )
        Addrid+=START_ID+1100;
    else
        Addrid+=START_ID+1000;
                                   
    ::LoadString(hPerLib,Addrid,sztemp,255); 

    //set field listbox        
    char *szaddr;
    szaddr=strtok(sztemp,",");  
    szaddr=strtok(NULL,",");
    
    int len;
    int n; 
    int i,m=reg_index+1; 
    int id=HIWORD(dw);
    
    char szval[256]="";
    
    
    for(i=0;i<255;i++)
       szval[i]=' '; 

    int curid,power=1;   
    int  regvaltemp; 
    
    while( szaddr)
    {  
       
       n=0;                       
       id++;
       curid=id;

       len=strlen(szaddr);   
      
       regvaltemp=regval>>(atoi(szaddr));  
       power=1;
       for(i=0;i<(len+1)/2;i++)
          { 
            n+=(regvaltemp&(0x1))*power;
            regvaltemp=regvaltemp>>1;
                                  
            power=power*2;
           }
       id=id+power;                            
       regvaltemp=regval ; 
           
       for(i=0;i<len;i++)    
          szval[COLUMN1+i]=szaddr[i];
       i=COLUMN1+len;
       while(szval[i]!=' ')
           {  szval[i]=' ';
              i++;
            }  
           
       char val[4]="";     
       sprintf(val,"%x",n);
       len=strlen(val);
          
       for(i=0;i<len;i++)
          szval[COLUMN1+COLUMN2+i]=val[i];
       i=COLUMN1+COLUMN2+len;
       while(szval[i]!=' ')
           {  szval[i]=' ';
              i++;
            }  
   
       szval[COLUMN1+COLUMN2+COLUMN3]='\0';      
       ::LoadString(hPerLib,curid+1+n,szBuff,255); 
       strncat(szval,szBuff,255);
       InsertString(m,szval); 
       DWORD d=0;
       d=curid;  
       d=d<<16;   
       int p=(int)HIBYTE( LOWORD(dw) );
       d+=((p<<8)+m-reg_index);  
       SetItemData(m,d);
       szaddr=strtok(NULL,",");  
       m++;              
     }       
}        



void CMyList::DeleteBitItem(int reg_index,DWORD dw)
{      
    char sztemp[256]="" ;
    int Addrid; 
    Addrid=LOWORD(dw);
    Addrid=HIBYTE(Addrid);
/////////////////////////////////////////    
//    Addrid+=START_ID+1000;           //
///////////////////////////////////////// 
    
    if( (cpuid==2) || (cpuid==3) )
        Addrid+=START_ID+1100;
    else
        Addrid+=START_ID+1000;  
///////////////////////////////////////////
        
    ::LoadString(hPerLib,Addrid,sztemp,255); 
     
    char *szaddr;
    szaddr=strtok(sztemp,",");  
    int i=0;
    while(szaddr)
    {
        szaddr=strtok(NULL,",");
        i++;
     } 
    int n;     
    for (n=reg_index+1;n<reg_index+i;n++)
       DeleteString(reg_index+1);  
}


//////////////////Modified by Jerry  5/10/95  //////////////
       
void CMyList::OnLButtonDblClk(UINT nFlags, CPoint point)
{
	OnLButtonUp(nFlags,point);	
	//CListBox::OnLButtonDblClk(nFlags, point);
}

void CMyList::OnRButtonDown(UINT nFlags, CPoint point)
{
    GetParent()->SendMessage(WM_RBUTTONDOWN,0,MAKELONG(point.x,point.y));
}    