
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/PER6VIEW.CPP   1.27   02 Apr 1996 09:23:58   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/PER6VIEW.CPP  $
** 
**    Rev 1.27   02 Apr 1996 09:23:58   Shirley
** No change.
** 
**    Rev 1.26   15 Feb 1996 08:51:50   Shirley
** No change.
** 
**    Rev 1.25   12 Feb 1996 14:06:18   Shirley
** No change.
** 
**    Rev 1.24   06 Feb 1996 15:32:50   Shirley
** No change.
** 
**    Rev 1.23   06 Feb 1996 13:47:04   Shirley
** No change.
** 
**    Rev 1.22   01 Feb 1996 10:13:38   Shirley
** No change.
** 
**    Rev 1.21   26 Jan 1996 09:17:52   Shirley
** No change.
** 
**    Rev 1.20   25 Jan 1996 13:17:46   Shirley
** No change.
** 
**    Rev 1.19   24 Jan 1996 10:37:12   Shirley
** No change.
** 
**    Rev 1.18   23 Jan 1996 11:22:40   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.16   15 Jan 1996 16:10:30   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.14   30 Nov 1995 09:13:10   Shirley
** No change.
** 
**    Rev 1.13   28 Nov 1995 15:35:30   Shirley
** No change.
** 
**    Rev 1.12   21 Nov 1995 11:24:42   Shirley
** No change.
** 
**    Rev 1.11   13 Nov 1995 09:25:36   Shirley
** No change.
** 
**    Rev 1.10   12 Nov 1995 11:28:34   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.9   08 Nov 1995 16:29:20   Shirley
** No change.
** 
**    Rev 1.8   08 Nov 1995 12:39:50   Shirley
** No change.
** 
**    Rev 1.7   02 Nov 1995 10:08:14   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.1   29 Sep 1995 09:53:14   Shirley
** No change.
** 
**    Rev 1.0   20 Sep 1995 10:56:44   Shirley
** Initial revision.
** 
**    
** 
** 
**
**
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  PER6VIEW.CPP
//
//  Description:The implementation file of the CPer6View class for Peripheral window
//
//  Author:     Jerry Yan
//
//  Date:       09/18/95
//
//  Modification:
//
//      1. 09/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// per6view.cpp : implementation of the CPer6View class
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"

#include "per6doc.h"
#include "per6view.h"
#include "flddlg.h"

#include "mylist.h" 
#include "listcol.h"   
#include "spin.h" 
#include "perwin.h"
#include "abibase.h"    
#include "uicom.h"
//#include "cpucom.h"
//#include "cpuserve.h"
 
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif  

extern STATUS AbiGetCpuId(UINT*);
extern STATUS AbiGetOneReg(REG_ID,UINT*);


int ITEMRANGE; 
int START_ID;
UINT cpuid; 
REGISTER  RegVal[MAXRANGE];
HINSTANCE hPerLib;
/////////////////////////////////////////////////////////////////////////////
// CPer6View

IMPLEMENT_DYNCREATE(CPer6View, CView)

BEGIN_MESSAGE_MAP(CPer6View, CView)
    //{{AFX_MSG_MAP(CPer6View)
        ON_WM_CREATE()  
    ON_WM_SIZE()
    ON_LBN_DBLCLK(IDC_LIST1, OnDblclkList1)
    ON_COMMAND(IDR_FRESH, OnFresh)
    ON_UPDATE_COMMAND_UI(IDR_FRESH, OnUpdateFresh)
    ON_COMMAND(IDR_VIEW_COMPRESS, OnViewCompress)
    ON_COMMAND(IDR_VIEW_EXPAND, OnViewExpand)
	ON_WM_RBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
    //ON_COMMAND(IDR_FILE_EXIT, OnFileExit)

/////////////////////////////////////////////////////////////////////////////
// CPer6View construction/destruction

CPer6View::CPer6View()
{     
     m_Expanded=FALSE;   
        
    
}

CPer6View::~CPer6View()
{ 

	FreeLibrary(hPerLib);
}

/////////////////////////////////////////////////////////////////////////////
// CPer6View drawing

void CPer6View::OnDraw(CDC* pDC)
{
    CPer6Doc* pDoc = GetDocument();
    ASSERT_VALID(pDoc);

    // TODO: add draw code for native data here
}

/////////////////////////////////////////////////////////////////////////////
// CPer6View diagnostics

#ifdef _DEBUG
void CPer6View::AssertValid() const
{
    CView::AssertValid();
}

void CPer6View::Dump(CDumpContext& dc) const
{
    CView::Dump(dc);
}

CPer6Doc* CPer6View::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CPer6Doc)));
    return (CPer6Doc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CPer6View message handlers
int CPer6View::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CView::OnCreate(lpCreateStruct) == -1)
        return -1;
              
    
    char buffer[64]="";
 /////////////////////////////////////////////////      
     AbiGetCpuId(&cpuid); 
 //////////////////////////////////////////
    char szcupid[8]="";
     _itoa(cpuid,szcupid,10);
    
     ITEMRANGE=AfxGetApp()->GetProfileInt(szcupid,"Number",1);
     
     if(ITEMRANGE==1)
     {
        AfxMessageBox("Not Support this CPU!");
        return -1;
      }
      
     CString str =AfxGetApp()->GetProfileString(szcupid,"reg_order","NO");  
    
     strcpy(buffer, str);   
    
     START_ID= AfxGetApp()->GetProfileInt(szcupid,"start_id",1);
     
   
   //GetRegValue;      
    char*token;         
    token=strtok(buffer,",");
    int i; 
    
    
    for (i=0;i<ITEMRANGE;i++)                
      {
//        RegVal[i].value=i+10;   //will be deleted
        
        RegVal[i].id=atoi(token);  // the hardware register id
        AbiGetOneReg(RegVal[i].id,&(RegVal[i].value) );
        token=strtok(NULL,",");
      }
    
    LPSTR lpDLLName; 
    
    switch (cpuid)  {
           case 0:  
           case 1:
           case 2:
           case 3:
           case 4:
           case 5:
           case 6: 
           case 16:
           case 17: 
           case 24:
           case 25:
               lpDLLName="ice_cbl1.DLL";
               break; 
           case 8:
           case 9:
           case 10:
           case 11:
           case 12:
           case 13:
           case 14:
           case 15:
           
               lpDLLName="ice_cbl4.DLL";  
               break;               
           case 18:
           case 19:
               lpDLLName="ice_cbl2.DLL";
               break;
           case 22:
           case 23:
           case 40:
           case 41:
           case 38:
           case 39:
                lpDLLName="ice_cbl3.DLL";
               break; 
           case 34:
           case 35:
           case 42:
           case 43:
           case 44:
           case 45:
           case 46:
           case 47:
                lpDLLName="ice_cbl5.DLL";
                break;
           case 48:
           case 49:
                lpDLLName="ice_cbl6.DLL";
                break; 
           case 50:
                lpDLLName="ice_cbl8.DLL"; 
                break;    
           case 28:
           case 29:
                lpDLLName="ice_cbl7.DLL";
                break;          
           default :
               AfxMessageBox("No Information for this CPU!",MB_OK);
               return -1;
           }
               
    if ((hPerLib= LoadLibrary(lpDLLName)) < HINSTANCE_ERROR)
	{

		AfxMessageBox("No Information for this CPU!",MB_OK);
		return -1;
	 }  
    
    
      
    CMyList* pList;
    pList=new CMyList(this);
    
    pList->ShowWindow(SW_SHOW);
   
    return 0;
}


void CPer6View::OnSize(UINT nType, int cx, int cy)
{   
	
    CView::OnSize(nType, cx, cy);
    
    CRect rect(0,0,0,0);   
   	GetClientRect(&rect) ;                  
  	
	rect.InflateRect(::GetSystemMetrics(SM_CXBORDER),::GetSystemMetrics(SM_CYBORDER)); 
	GetDlgItem(IDC_LIST1)->MoveWindow(&rect,TRUE);
  
    
}

void CPer6View::OnDblclkList1()
{
    int cursel;
    cursel=( (CListBox*)GetDlgItem(IDC_LIST1) )->GetCurSel(); 
    
    
    HINSTANCE hLibrary;
    if ((hLibrary = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
        int k;
        k=0;
        AfxMessageBox("Can not do this test without custom control library",MB_OK);
     } 
                                                   
    CFldDlg *bitdlg  ; 
 
    bitdlg=new CFldDlg(this,cursel); 
   
    bitdlg->DoModal();
    FreeLibrary(hLibrary);
}

void CPer6View::OnFresh()
{   
    int i;
    for (i=0;i<ITEMRANGE;i++) 
    { 
        AbiGetOneReg(RegVal[i].id,&(RegVal[i].value) );
     }
        
    ((CMyList*)GetDlgItem(IDC_LIST1))->ResetContent(); 
    ((CMyList*)GetDlgItem(IDC_LIST1))->InitList();
    
}

void CPer6View::OnUpdateFresh(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
}



void CPer6View::OnViewCompress()
{                                 
    m_Expanded=FALSE;
    int i;
    i=((CListBox*)(GetDlgItem(IDC_LIST1)))->GetCount();
    DWORD dw;   
    
    char szBuff[256]="";
    while (i)
    { 
      i--;
      dw=((CListBox*)(GetDlgItem(IDC_LIST1)))->GetItemData(i);
      if(!( LOBYTE(LOWORD(dw)) )) 
         {
            ((CListBox*)(GetDlgItem(IDC_LIST1)))->GetText(i,szBuff);
            if( szBuff[2]=='-'  )
               { 
                   szBuff[2]='+';
                  ((CListBox*)GetDlgItem(IDC_LIST1))->DeleteString(i);
                  ((CListBox*)GetDlgItem(IDC_LIST1))->InsertString(i,szBuff);
                  ((CListBox*)GetDlgItem(IDC_LIST1))->SetItemData(i,dw);
                  ((CMyList*)(GetDlgItem(IDC_LIST1)))->DeleteBitItem(i,dw);
                }
         } 
    } 
    ((CListBox*)GetDlgItem(IDC_LIST1))->SetCurSel(0);   
}

void CPer6View::OnViewExpand()
{
    m_Expanded=TRUE;
    int i;
    i=((CListBox*)(GetDlgItem(IDC_LIST1)))->GetCount();
    DWORD dw;
    char* pdest;     
    int result;
    char szBuff[256]="";
    while (i)
    { 
      i--;
      dw=((CListBox*)(GetDlgItem(IDC_LIST1)))->GetItemData(i);
      if(!(dw&(0x0ff)) ) 
         {
            ((CListBox*)(GetDlgItem(IDC_LIST1)))->GetText(i,szBuff);
                          
              if( ( pdest=strchr(szBuff,'+') )!=NULL  )
                { 
                  result=pdest-szBuff;
                  szBuff[result]='-';
                  ((CListBox*)GetDlgItem(IDC_LIST1))->DeleteString(i);
                  ((CListBox*)GetDlgItem(IDC_LIST1))->InsertString(i,szBuff);
                  ((CListBox*)GetDlgItem(IDC_LIST1))->SetItemData(i,dw);
                  ((CMyList*)(GetDlgItem(IDC_LIST1)))->InsertBitItem(i,dw);
                 }
           }
     }                 
}


/*
void CPer6View::OnFileExit()
{
    CDocument* pDoc;
    pDoc=GetDocument();
    pDoc->OnCloseDocument(); 
//  DestroyWindow();
}
*/



void CPer6View::OnRButtonDown(UINT nFlags, CPoint point) 
{

    CMenu m_menu;
    m_menu.CreatePopupMenu() ;  
    m_menu.AppendMenu(MF_STRING	,IDR_VIEW_COMPRESS,"&Compress All");	
    m_menu.AppendMenu(MF_STRING	,IDR_VIEW_EXPAND,"&Expand All");
	
//	m_menu.SetMenuItemBitmaps(IDR_VIEW_COMPRESS,MF_BYCOMMAND, 
//                     &bmpMenuUncheck, &bmpMenuCheck);
//	m_menu.SetMenuItemBitmaps(IDR_VIEW_EXPAND,MF_BYCOMMAND, 
//                     &bmpMenuUncheck, &bmpMenuCheck);
	
	ClientToScreen(&point);
    m_menu.TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
	m_menu.DestroyMenu();
}
