
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SHLEDIT.CPP   1.29   02 Apr 1996 09:29:34   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SHLEDIT.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:29:34   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:55:06   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:18   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:08   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:38   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:46   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:32   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:18   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:54   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:34   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:16   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:56   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:42   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:28   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:24   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:36   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:30   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:20   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:06   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:46   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:58   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT.CPP
//
//  Description:The implement file for the class: ShellEditor
//
//  Author:     Roger Zhang
//
//  Date:       03/25/95
//
//  Modification:
//
//      1. 03/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
       
#include "shlcom.h"       
#include "shledit.h"

/////////////////////////////////////////////////////////////////////////////
//  Set new line to edit
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Set a new line buffer to edit
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void ShellEditor::SetNew(char * pch, int nMax)
{
    ASSERT(pch);
    ASSERT(nMax > 0);
    
    m_pchText = pch;
    m_nLength = 0;
    m_nPos = 0;
    if(nMax > 0)    m_nMaxLen = nMax;
}
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to previous char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoPrev(void)
{
    if(m_nPos == 0)   return FALSE;
    -- m_nPos;
    return TRUE;
}        
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to next char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoNext(void)
{
    if(m_nPos == m_nLength) return FALSE;
    ++ m_nPos;
    return TRUE;
}     

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the first char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoHome(void)
{
    if(m_nPos == 0)   return FALSE;
    m_nPos = 0;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the next position of the last buffer
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoEnd(void)
{
    if(m_nPos == m_nLength) return FALSE;
    m_nPos = m_nLength;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the specified position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::SetPos(int nIdx)
{
    if(m_nPos == nIdx)    return FALSE;
    if(nIdx < 0)    m_nPos = 0;
    else if(nIdx > m_nLength) m_nPos = m_nLength;
    else m_nPos = nIdx;
    return TRUE;
}   
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Insert caret at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::InsChar(char ch)
{           
    if(m_nPos == m_nMaxLen) return FALSE;
    if(m_nLength < m_nMaxLen)   ++ m_nLength;
    if(m_nPos < m_nMaxLen - 1) 
        memmove(m_pchText + m_nPos + 1, m_pchText + m_nPos, 
            m_nMaxLen - m_nPos - 1);
    * (m_pchText + m_nPos++) = ch;
    return TRUE;
}
                
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Overwrite a char at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::OvrChar(char ch)
{           
    if(m_nPos == m_nMaxLen) return FALSE;
    if(m_nPos == m_nLength) ++ m_nLength;
    * (m_pchText + m_nPos++) = ch;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the char at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::DelChar(void)
{           
    if(m_nPos == m_nLength) return FALSE;
    -- m_nLength;
    memmove(m_pchText + m_nPos, m_pchText + m_nPos + 1,
        m_nMaxLen - m_nPos - 1);
    return TRUE;
}               

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the char before the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::BackChar(void)
{
    if(!GotoPrev())   return FALSE;
    return DelChar();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Insert a string at the caret caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::InsString(char * pch, int nLen)
{    
    ASSERT(pch);
    
    for(int i = 0; i < nLen; i ++)
        if(InsChar(*pch++) == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Overwrite a string at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::OvrString(char * pch, int nLen)
{    
    ASSERT(pch);
    
    for(int i = 0; i < nLen; i ++)
        if(OvrChar(*pch++) == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete a string at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::DelString(int nLen)
{    
    for(int i = 0; i < nLen; i ++)
        if(DelChar() == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the string before the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::BackString(int nLen)
{    
    for(int i = 0; i < nLen; i ++)
        if(BackChar() == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete all the chars
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::Clear(void)
{
    if(m_nLength == 0)    return FALSE;
    m_nLength = 0;
    m_nPos = 0;
    return TRUE;
}

///////////////////////////////////(EOF)/////////////////////////////////////                                  
                
