
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SHLEDIT1.CPP   1.12   02 Apr 1996 09:26:42   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SHLEDIT1.CPP  $
** 
**    Rev 1.12   02 Apr 1996 09:26:42   Shirley
** No change.
** 
**    Rev 1.11   15 Feb 1996 08:49:38   Shirley
** No change.
** 
**    Rev 1.10   12 Feb 1996 14:02:06   Shirley
** No change.
** 
**    Rev 1.9   06 Feb 1996 15:27:20   Shirley
** No change.
** 
**    Rev 1.8   06 Feb 1996 13:42:58   Shirley
** No change.
** 
**    Rev 1.7   01 Feb 1996 10:15:50   Shirley
** No change.
** 
**    Rev 1.6   26 Jan 1996 09:12:42   Shirley
** No change.
** 
**    Rev 1.5   25 Jan 1996 13:13:22   Shirley
** No change.
** 
**    Rev 1.4   24 Jan 1996 10:40:20   Shirley
** No change.
** 
**    Rev 1.3   23 Jan 1996 11:22:20   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.2   18 Jan 1996 10:13:16   Shirley
** No change.
** 
**    Rev 1.1   15 Jan 1996 16:14:40   Shirley
** No change.
** 
**    Rev 1.0   04 Jan 1996 11:13:32   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT1.CPP
//
//  Description:The implement file of the class ShellEditor1
//
//  Author:     Roger Zhang
//
//  Date:       01/10/96
//
//  Modification:
//
//      1. 01/10/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include <ctype.h>

#include "shlcom.h"                   
#include "shledit.h"                   
#include "shledit1.h"

/////////////////////////////////////////////////////////////////////////////
// refer to command table

extern tagCmdTable CommandRecord[];
extern int nMaxCmdNo;

/////////////////////////////////////////////////////////////////////////////
// Argument Table
struct tagArgTable {
	char * m_pszArg;
	int m_nMin;
} ArgTable[] = { 
	"ADDRess", 4,
	"ALl", 2, 
	"APpend", 2,
	"ASsemble", 2,       
	"BACkward", 3,
	"BIt", 2,
	"BYte", 2,
	"CALl", 3,   
	"CENter", 3,
	"CLear", 2, 
	"CLOse", 3,  
	"COde",  2,
	"COMmand", 3,
	"COUnt", 3,
	"DATum", 3,
	"DELay", 3,
	"DEMand", 3,
	"DIsable", 2,
	"EA", 2,
	"EBEN", 4,
	"ENable", 2,
	"FOrever", 2,
	"FORWard", 4,
	"FRom", 2,
	"Global", 1,
	"High", 1,
	"Insensitive", 1,
	"IS",  2,
	"Length", 1, 
	"LOw", 2,
	"LV1", 3,
	"LV2", 3,
	"Mixed", 1,     
	"MOdule", 2,
	"NOCode", 3,
	"NODemand", 3,
	"NOSymbols", 3, 
	"NOWarn", 3,
	"On", 1,
	"OFf", 2, 
	"OVer", 2,
	"Range", 1,
	"REset", 2, 
	"RET", 3,
	"RUn", 2,  
	"Source", 1,
	"STatus", 2,
	"SYmbols", 2,
	"Then", 1,
	"TIll", 2, 
	"TIMer", 3,
	"TRace", 2,  
	"Warn", 1
};          

int nMaxArgs = 53;

/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor1::GetFirstToken(void)
{
	// Skip heading space
	m_nLeft = 0;
	while(m_nLeft < m_nLength) {
	 	if(isspace(m_pchText[m_nLeft]))	++ m_nLeft;
	 	else	break;
	}              
	
	// scan token                              
	m_nRight = m_nLeft;
	while(m_nRight < m_nLength) {
	 	if(!isspace(m_pchText[m_nRight]))	++ m_nRight;
	 	else break;
	}                                             
	
	if(m_nRight == m_nLeft) {	// No token found
		return	FALSE;	
	}            
	
	return	TRUE;	
}                
   
// return 0:Fail, 1:First token, 2:Not first token   
int ShellEditor1::GetToken(void)
{
	// Scan left
	m_nLeft = m_nPos;
	while(m_nLeft > 0) {
	 	if(isspace(m_pchText[m_nLeft-1]))	break;
	 	-- m_nLeft;
	}              
	
	// Scan right
	m_nRight = m_nPos;                            
	while(m_nRight < m_nLength) {
	 	if(isspace(m_pchText[m_nRight]))	break;
	 	++ m_nRight;
	}               
	
	if(m_nLeft == m_nRight || m_nLeft == m_nPos) {	// No token found
		return	0;
	}
	
	// is first token
	int nTemp = 0;
	while(nTemp < m_nLeft) {
	 	if(!isspace(m_pchText[nTemp])) {	// Found first token
	 		return	2;
	 	}   
	 	++ nTemp;
	}    
	
	return	1;	// First token
}                                              
    
// return -1:No cmd match or can't expand, >=0:Cmd ID    
int ShellEditor1::SearchCommand(void)                           
{
	int nLen = m_nPos - m_nLeft;
	
	for(int i = 0; i < ::nMaxCmdNo; i ++) {
		if(strnicmp(::CommandRecord[i].pszCommandName, m_pchText + m_nLeft,	
			nLen) == 0) {
			if((m_nKeyLen = strlen(::CommandRecord[i].pszCommandName))
				 == nLen) {	// Can't expand
				return	-1;
			}              
			if(nLen >= ::CommandRecord[i].nMinKeyword) {	// Match command
				return	i;			
			}	
		}	
	}                     
	
	return	-1;	// No match;
}
        
// return -1:No arg match or can't expand, >=0:arg ID    
int ShellEditor1::SearchArgument(void)                           
{
	int nLen = m_nPos - m_nLeft;
	
	for(int i = 0; i < ::nMaxArgs; i ++) {
		if(strnicmp(::ArgTable[i].m_pszArg, m_pchText + m_nLeft,	
			nLen) == 0) {
			if((m_nKeyLen = strlen(::ArgTable[i].m_pszArg)) == nLen) {
			// Can't expand
				return	-1;
			}              
			if(nLen >= ::ArgTable[i].m_nMin) {	// Match arg
				return	i;			
			}	
		}	
	}                     
	
	return	-1;	// No match;
}
        
// will change m_nCmdID depend on current first token        
CString ShellEditor1::GetHints(void)
{   
	// Default no command valid
 	m_nCmdID = -1;
 	
 	CString str("");	// use to hold the hints            
 	                           
	// Get first token 	                           
 	if(!GetFirstToken())	return	str;
 	                  
 	for(int i = 0; i < ::nMaxCmdNo; i ++) {
 	 	if(strnicmp(::CommandRecord[i].pszCommandName, m_pchText + m_nLeft, 
 	 		m_nRight - m_nLeft) == 0) {	// Found match
 	 		if((int)strlen(::CommandRecord[i].pszCommandName) == 
 	 			m_nRight - m_nLeft 
 	 			&& m_pchText[m_nRight] == ' ') {	// exact match
 	 			//str = ::CommandRecord[i].pszHints;
 	 			m_nCmdID = i;
 	 			return	str; 	
 	 		} else {  // partial match
 	 			str += ::CommandRecord[i].pszCommandName;
 	 			str += " ";
 	 		}	
 	 	}	
 	}            
 	
	if(str == "") 	//	no match
		str = "No such command";
		
	return	str;	
}               

BOOL ShellEditor1::ExpandCommand(int nCmd)
{
 	ASSERT(nCmd >= 0 && nCmd < ::nMaxCmdNo);                           
 	
 	int nLen = m_nPos - m_nLeft;
 	
 	if(m_isIns)	
 		return	InsString(::CommandRecord[nCmd].pszCommandName + nLen, 
 					m_nKeyLen - nLen);
 	else		
 		return	OvrString(::CommandRecord[nCmd].pszCommandName + nLen, 
 					m_nKeyLen - nLen);						
}                                        

BOOL ShellEditor1::ExpandArgument(int nArg)
{
 	ASSERT(nArg >= 0 && nArg < ::nMaxArgs);                           
 	
 	int nLen = m_nPos - m_nLeft;
 	
 	if(m_isIns)	return	InsString(::ArgTable[nArg].m_pszArg + nLen, 
 							m_nKeyLen - nLen);
	else		return	OvrString(::ArgTable[nArg].m_pszArg + nLen, 
 							m_nKeyLen - nLen); 							
}                                        

BOOL ShellEditor1::OnSpace(void)
{   
	BOOL is = TRUE;
	
	// Get token at current position
 	int i = GetToken();
 	
 	if(!i) {	// No token
 		goto _SHLNOEXPAND;
 	}	
 	else if(i == 1) {	// Command
		i = SearchCommand();
		if(i == -1)	{ // no match 	
		 	goto _SHLNOEXPAND;
		} else {
			is = ExpandCommand(i);
		 	goto _SHLNOEXPAND;
		}
 	} else {	// Argument
		i = SearchArgument();
		if(i == -1)	{ // no match 	
		 	goto _SHLNOEXPAND;
		} else {
			is = ExpandArgument(i);
		 	goto _SHLNOEXPAND;
		}
 	}        

_SHLNOEXPAND:   
	if(is) {	
		if(m_isIns)	return ShellEditor::InsChar(' '); 	
		else		return ShellEditor::OvrChar(' '); 	
	} else	return FALSE;
}
    
    
BOOL ShellEditor1::BackChar(void)
{                                       
	// can't do back delete
	if(m_nPos == 0)	return TRUE;
	
	// Record old pos
	int nOld = m_nPos;
	                 
	// Back Delete a space if exist	                 
	if(isspace(m_pchText[m_nPos-1]))	ShellEditor::BackChar();
	
	// Back delete all lowercase chars
	while(m_nPos > 0) {
	 	if(islower(m_pchText[m_nPos-1])) {
			ShellEditor::BackChar();
	 	} else break;
	}
	                                  
	// if nothing deleted, back delete any char	                                  
	if(nOld == m_nPos)	ShellEditor::BackChar();
	
	return TRUE; 	
}           
                
BOOL ShellEditor1::DelChar(void)
{
	return ShellEditor::DelChar(); 	
}           
                
BOOL ShellEditor1::InsChar(char ch)
{                        
	m_isIns = TRUE;
	                             
	if(ch == ' ')	return OnSpace();
	else return ShellEditor::InsChar((char)toupper(ch)); 	
}           
                
BOOL ShellEditor1::OvrChar(char ch)
{
	m_isIns = FALSE;
	                             
	if(ch == ' ')	return OnSpace();
	else return ShellEditor::OvrChar((char)toupper(ch)); 	
}                         

                