
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SHLMSGBR.CPP   1.29   02 Apr 1996 09:28:18   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SHLMSGBR.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:28:18   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:49:54   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:36   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:58   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:24   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:14   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:24   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:58   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:08:36   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:22   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:32   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:56   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:56   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:42   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:36   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:26   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:48   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:44   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:20   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:28   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:10   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:54   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:22   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLMSHBR.CPP
//
//  Description:The implement file for the class: CMessageBar
//
//  Author:     Roger Zhang
//
//  Date:       03/18/95
//
//  Modification:
//
//      1. 03/18/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "colors.h"            
#include "uicom.h"            
#include "shlcom.h"         
#include "spin.h"
#include "shlmsgbr.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMessageBar
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMessageBar::Create(LONG style, const RECT& rect, CWnd * pParent)
{
    const char * pszMessageBarClass =
        AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(GetStockObject(LTGRAY_BRUSH)));
    return CWnd::Create(pszMessageBarClass, "SHLMSGBR",
        style, rect, pParent, IDW);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CMessageBar::CMessageBar()
: m_nTextPos(0), m_nTextLen(0), m_nFont(STANDARD_FONT), 
  m_isSpinOn(FALSE)
{ 
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CMessageBar::~CMessageBar()
{
    FreeLibrary(m_hLib);
}

BEGIN_MESSAGE_MAP(CMessageBar, CWnd)
    //{{AFX_MSG_MAP(CMessageBar)
    ON_WM_CREATE()
    ON_WM_PAINT()
    ON_WM_SIZE()
    ON_WM_HSCROLL()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageBar::GetLength(void)
{
    CRect rect;
    GetClientRect(&rect);
    int i = m_isSpinOn ? SPINWD - 1 : 0;
    m_rectFrame.SetRect(BARHZEDGE, BARVTEDGE, 
        rect.Width()-i-BARHZEDGE, rect.Height()-BARVTEDGE - 1);       
    m_ptChar.x = m_rectFrame.left + 1;
    m_nLen = (m_rectFrame.Width() - 2)/m_szFont.cx;
}

// szText == 0: Clear
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageBar::ShowText(char * szText)
{                           
	if(szText)
		strcpy(m_pszText, szText);
    m_nTextPos = 0;
    m_nTextLen = szText ? strlen(m_pszText) : 0;
    if(m_nTextLen > m_nLen && !m_isSpinOn) {
        m_isSpinOn = CreateSpin();   
        ASSERT(m_isSpinOn);
    }                
    else if(m_nTextLen <= m_nLen && m_isSpinOn) {
        m_Spin.DestroyWindow();   m_isSpinOn = FALSE;
    }
    InvalidateRect(NULL);
}              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMessageBar::CreateSpin(void)
{
    CRect rect;
    GetClientRect(&rect);
    rect.left = rect.right - SPINWD;
    rect.top -= 1;
    rect.bottom += 1;
    if(m_Spin.Create(WS_VISIBLE|WS_CHILD|MSS_HORIZONTAL, rect, this,IDC_SPIN)
        == FALSE)   return FALSE;;
 //   m_Spin.SetAssociate(this);     
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageBar::DrawFrame(CDC * pDC, CRect &rect)
{        
    ::DrawFrame(pDC, rect, 0);
}

/////////////////////////////////////////////////////////////////////////////
// CMessageBar message handlers


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int CMessageBar::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CWnd::OnCreate(lpCreateStruct) == -1)
        return -1;

    // Load MUSCROLL.DLL
    if ((m_hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
        AfxMessageBox("Can't find MUSCROLL.DLL");

        // prevent it from happening again
        return -1;
    }

    // TODO: Add your specialized creation code here
    // Get Font Size
    TEXTMETRIC tm;
    CDC * pDC = GetDC();
    pDC->SelectStockObject(m_nFont);
    pDC->GetTextMetrics(&tm);
    m_szFont.cy = tm.tmHeight + tm.tmExternalLeading;
    m_szFont.cx = tm.tmAveCharWidth;
    ReleaseDC(pDC);
    
    return 0;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageBar::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    GetLength();
/*    CRect rect(dc.m_ps.rcPaint.left+8, dc.m_ps.rcPaint.top+1, 
        dc.m_ps.rcPaint.right-8, dc.m_ps.rcPaint.bottom-2);    */
    DrawFrame(&dc, m_rectFrame);

    if(!m_nTextLen)  return;

    dc.SelectStockObject(m_nFont);
    dc.SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
    dc.SetTextColor(PALETTEINDEX(COLOR_BLACK));
    int l = m_nTextLen - m_nTextPos > m_nLen ? 
            m_nLen : m_nTextLen - m_nTextPos;
    dc.TextOut(m_ptChar.x, m_ptChar.y, m_pszText+m_nTextPos, l);
    
    // Do not call CWnd::OnPaint() for painting messages
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageBar::OnSize(UINT nType, int cx, int cy)
{
    CWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here     
    m_ptChar.y = BARVTEDGE + 1;
    m_nTextPos = 0;
    GetLength();    
    if(m_nTextLen > m_nLen && !m_isSpinOn) {
        m_isSpinOn = CreateSpin();   
        ASSERT(m_isSpinOn);    
    }                
    else if(m_nTextLen <= m_nLen && m_isSpinOn) {
        m_Spin.DestroyWindow();   m_isSpinOn = FALSE;
    }                       
    if(m_isSpinOn)
        m_Spin.MoveWindow(cx-SPINWD+1, -1, SPINWD, cy+2, TRUE);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void CMessageBar::OnHScroll(UINT nSBCode, UINT /*nPos*/, 
    CScrollBar* /*pScrollBar*/)
{
    // TODO: Add your message handler code here and/or call default
    int nDelta = 0;
    if(nSBCode == SB_LINELEFT)          nDelta = -1;
    else if(nSBCode == SB_LINERIGHT)    nDelta = +1;
    else        return; // nothing special

    int nNew = m_nTextPos + nDelta;
    if(nNew <= m_nTextLen - m_nLen && nNew >= 0) {
        m_nTextPos = nNew;    InvalidateRect(NULL);
    }
    else    MessageBeep(-1);
}

///////////////////////////////(EOF)/////////////////////////////////////////
