
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SRCWIN.H__   1.29   02 Apr 1996 09:26:24   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SRCWIN.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:26:24   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:44   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:26   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:12   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:00   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:38   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:32   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:50   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:18   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:44   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:10   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:08:46   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:34   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:14   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:30   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:14   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:14   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:08   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:54   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:10   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:28   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:50:00   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:20   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:47:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:04   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCWIN.H
//
//  Description:The header file for the class: CSourceWindow
//
//  Author:     Roger Zhang
//
//  Date:       05/10/95
//
//  Modification:
//
//      1. 05/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCWIN_
#define _SRCWIN_

/////////////////////////////////////////////////////////////////////////////
class SyntaxColor {
public:
    SyntaxColor(void)  
    {
        EnableColor();
    }
    void EnableColor(void) {
        m_isColorOn = TRUE;
    
        m_nBackground = COLOR_WHITE;
        m_nForeground = COLOR_BLACK;
        m_nKeyword = COLOR_LTBLUE;
        m_nComment = COLOR_GREEN;
        m_nSource  = COLOR_BLACK;
        m_nMix     = COLOR_DKGRAY;
        m_nCodeLine= COLOR_BLACK;
        m_nNonCode = COLOR_DKGRAY;
        m_nForePCLine = COLOR_BLACK;
        m_nBackPCLine = COLOR_YELLOW;
        m_nForeBPLine = COLOR_BLACK;
        m_nBackBPLine = COLOR_RED;
        m_nSrcKey = COLOR_DKGRAY;
    }                  
    void DisableColor(void) {
        m_isColorOn = FALSE;

        m_nBackground = COLOR_WHITE;
        m_nForeground = COLOR_BLACK;
        m_nKeyword = COLOR_BLACK;
        m_nComment = COLOR_BLACK;
        m_nSource  = COLOR_BLACK;
        m_nMix     = COLOR_BLACK;
        m_nCodeLine= COLOR_BLACK;
        m_nNonCode = COLOR_BLACK;
        m_nForePCLine = COLOR_BLACK;
        m_nBackPCLine = COLOR_YELLOW;
        m_nForeBPLine = COLOR_BLACK;
        m_nBackBPLine = COLOR_RED;
        m_nSrcKey = COLOR_DKGRAY;
    }                 
    
    BOOL m_isColorOn;
    
    int m_nBackground;
    int m_nForeground;
    
    int m_nKeyword;
    int m_nSrcKey;
    int m_nComment;
    int m_nSource;
    int m_nMix;                 
    
    int m_nCodeLine;
    int m_nNonCode;   
    
    int m_nForePCLine;
    int m_nBackPCLine;
    
    int m_nForeBPLine;
    int m_nBackBPLine;
};    

/////////////////////////////////////////////////////////////////////////////
// CSourceWindow frame                                                       
/////////////////////////////////////////////////////////////////////////////

class CSourceWindow : public CMDIChildWnd
{
    DECLARE_DYNCREATE(CSourceWindow)
public:
    CSourceWindow(BOOL isPCOn=FALSE);            
    BOOL Create(LPCSTR szTitle, LONG style = 0,
        const RECT& rect = rectDefault, CMDIFrameWnd * pParent = NULL );

    virtual void ActivateFrame(int nCmdShow);
// Attributes
protected:                             
    enum { MARKER_PC, MARKER_BP, MARKER_PCBP };
    enum { MAX_ASM_RANGE = 16384 /* 0x4000 */ };
    
    int     m_nFont;        // font number
    CSize   m_szFont;       // font size
    CSize   m_szView;       // rows and cols of viewport
    CRect   m_rectClip;     // Clip rectangle of full view                
    CRect   m_rectScroll;   // Clip rectangle for horz scroll
    CPoint  m_ptOffset;     // display offset     
    CPoint  m_ptCaret;      // caret position
    CPoint  m_ptIndex;      // index position
    int     m_nLeft;        // width for line,addr,BP space on left edge
    
    CBitmap m_bmpPC;        // markers
    CBitmap m_bmpBP;
    CBitmap m_bmpPCBP;
    

    CSourceSearch   * m_pdlgSrch;    
    
    BOOL    m_isSel;
    CString m_strSel;
    int		m_nSelLine;
    int		m_nSelCol;
    
public:
    static CMenu NEAR m_menu;
    int     m_nDispMode;    // source,mixed,asm mode
    
// Operations
public:
    void SetStepOpt(void);
    void UpdateDisp(void);

	void CalcLeftEdge(void);
    int Row2Y(int nRow) const;
    int Col2X(int nCol) const;
    int Y2Row(int ny) const;
    int X2Col(int nx) const;              
    CRect Row2Rect(int nRow) const;
    
    BOOL IsXIn(int nx) const;
    BOOL IsYIn(int ny) const;
    
    int Line2Row(int nLine) const;
    int Row2Line(int nRow) const;
    
    void Caret2Index(void);
    void Index2Caret(void);
    
    void CalcFontSize(void);
    void CalcViewSize(int cx, int cy);
    void CalcScrollSize(void);
    
    void ShowSourceLine(CDC * pDC, int nRow, int nLine);
    void ShowDsmLine(CDC * pDC, int nRow, int nLine);
    void ShowMixedLine(CDC * pDC, int nRow, int nSrc, int nAsm);
    
    void ClearMarker(CDC * pDC, int nRow);
    void SetMarker(CDC * pDC, int nRow, int nType);
    
    BOOL UpdateSource(int nLine);
    BOOL UpdateAsm(long lAddr);
    BOOL UpdateMixed(int nLine);
    BOOL UpdateMixed(long lAddr);
    void UpdateMixedMode(int nOfs);
    
    void NewSource(void);
    BOOL LoadModule(unsigned long dwModule, BOOL isHist = TRUE);
    
    void UpdateRow(int nRow);

    void SelectText(BOOL isSel);

    void ShowPCMarker(void);
    void ShowPCAsmMarker(void);
    void ShowPCMixMarker(void);
    void ShowPCLineMarker(void);

    void SetTitle(void);
    void SetCaret(void);
    long GetCaretAddr(void);
    
    // these functions will change Offset & Index
    void OnUp(void);
    void OnDown(void);
    void OnLeft(void);
    void OnRight(void);
    void OnPgUp(void);
    void OnPgDn(void);
    void OnPgLeft(void);
    void OnPgRight(void);
    void OnHome(void);
    int  OnEnd(void);
    void OnUpMost(void);
    void OnDownMost(void);
    void HorzScroll(int nx);
    void VertScroll(int ny);

    void ScrollTo(int nLine, int nCol, int nLen, BOOL isLeft);
    BOOL Search(void);         
    void SetBreakpoint(int nRow);
                                                            
	void OnLocalMenu(CPoint point);
	BOOL IsFunction();
	BOOL IsVariable();                                                            
// Implementation                 
public:
    virtual ~CSourceWindow();

protected:
    // Generated message map functions
    //{{AFX_MSG(CSourceWindow)
    afx_msg void OnSrchComboKillFocus();
    afx_msg LONG OnXMSrcShowPC(UINT wParam, LONG lParam);
    afx_msg LONG OnXMRepaint(UINT wParam, LONG lParam);
    afx_msg void OnChildActivate();
    afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnPaint();
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg void OnEditBrowsefromaddress();
    afx_msg void OnEditBrowsefromline();
    afx_msg void OnEditBrowsefrompc();
    afx_msg void OnEditSearch();
    afx_msg void OnEditSearchnext();
    afx_msg void OnFileLoadinfo();
    afx_msg void OnFilePrevmodule();
    afx_msg void OnFileNextmodule();
    afx_msg void OnOptionsSourceextensionnames();
    afx_msg void OnOptionsSourceoptions();
    afx_msg void OnOptionsSourcepath();
    afx_msg void OnRunGotocursor();
    afx_msg void OnRunGofromcursor();
    afx_msg void OnRunJumptocursor();
    afx_msg void OnViewSourceonly();
    afx_msg void OnViewMixed();
    afx_msg void OnUpdateViewMixed(CCmdUI* pCmdUI);
    afx_msg void OnUpdateViewSourceonly(CCmdUI* pCmdUI);
    afx_msg void OnViewSymbolicdisassembly();
    afx_msg void OnUpdateViewSymbolicdisassembly(CCmdUI* pCmdUI);
    afx_msg void OnViewLinenumbering();
    afx_msg void OnUpdateViewLinenumbering(CCmdUI* pCmdUI);
    afx_msg void OnViewSyntaxcoloring();
    afx_msg void OnUpdateViewSyntaxcoloring(CCmdUI* pCmdUI);
    afx_msg void OnMouseMove(UINT nFlags, CPoint point);
    afx_msg void OnUpdateEditSearch(CCmdUI* pCmdUI);
    afx_msg void OnUpdateEditBrowsefromline(CCmdUI* pCmdUI);
    afx_msg void OnUpdateEditSearchnext(CCmdUI* pCmdUI);
    afx_msg void OnClose();
    afx_msg void OnUpdateFilePrevmodule(CCmdUI* pCmdUI);
    afx_msg void OnUpdateFileNextmodule(CCmdUI* pCmdUI);
    afx_msg void OnFileBrowsemodule();
    afx_msg void OnUpdateFileBrowsemodule(CCmdUI* pCmdUI);
    afx_msg void OnFileLoad();
    afx_msg void OnRunBreakpoint();
    afx_msg void OnRunJump();
    afx_msg void OnRunReset();
    afx_msg void OnViewSma();
    afx_msg void OnShiftreturn();
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg void OnSetBPFunc();
    afx_msg void OnClrBPFunc();
    afx_msg void OnSetBPVar();
    afx_msg void OnClrBPVar();
    afx_msg void OnShowLoadAddr();
    afx_msg void OnWatchVariable();
    afx_msg void OnInspectFunc();
    afx_msg void OnUpdateSearchCombo(CCmdUI* pCmdUI);
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////(EOF)///////////////////////////////////////////////
