
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/STKVIEW.CPP   1.29   02 Apr 1996 09:29:56   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/STKVIEW.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:29:56   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:00   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:18   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:40   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:54   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:08   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:02   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:22   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:08   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:14:48   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:54   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:58   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:14:14   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:04   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:10   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:46:02   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:06   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:54   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:51:00   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.4   13 Oct 1995 13:19:08   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:49:00   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:57:26   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:47:02   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKVIEW.CPP
//
//  Description: The implementation file for the class: CStackView.
//
//  Author: Chen Jun
//
//  Date: 07/29/95
//
//  Modification:
//      1. 07/29/95, Initial version of the class: CStackView.
//      2. 09/08/95, Fix bug 44, "UpdateGrid()".
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
#include "xview.h"

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"

#include "stkview.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStackView* pStkView;

HHOOK hookStkKeyFilter = 0;


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern class VarServer stkObject;

extern BOOL bStkShowAddress;
extern BOOL bStkShowEntryPoint;
extern BOOL bStkShowModule;
extern BOOL bStkShowParameters;


/////////////////////////////////////////////////////////////////////////////
// Local define.
/*
#define AFX_NUM_EVENTPARAM(type, lpParams) (type FAR&)(**(type FAR* FAR*)lpParams)
#define AFX_HLSTR_EVENTPARAM(lpParams) (HLSTR FAR&)(*(HLSTR FAR*)lpParams)
#define AFX_NUM_EVENTPARAMINDEX(type, lpParams, index) (short FAR&)(**((type FAR* FAR*)(lpParams) + index))
#define AFX_HLSTR_EVENTPARAMINDEX(lpParams, index) (HLSTR FAR&)(*((HLSTR FAR*)(lpParams) + index))
*/


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

// Defined in Stack server: STKSVR.CPP
int StkGetStkLevelNum(int& num );
int StkGetStkFirstNode(STKNode* & node);
int StkGetStkNextNode(STKNode* & node, STKNode* & nextNode);
int StkGetNodeDisplayString(STKNode* node, CString& s1, CString& s2,
                                    CString& s3, CString& s4, CString& s5);
int StkLevelToNode(int nLevel , struct STKNode* &node);

// Defined in STKLOCAL.CPP
void StkUpdateLocalWindow(int nLevel);

// Defined in SRCWIN.CPP
void SrcShowSource(unsigned short uAddr);
       
// Defined in BPTSERVE.CPP
BOOL BptAddBptfromWnd(unsigned short addr);

// Defined in EMUGO.CPP
void EmuServerGo(int nMode, unsigned short uAddr);
void OnEmulation(void);


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void StkUpdateStackWindow(BOOL bUpdateStackOnly = FALSE);
void StkViewSource(void);
void StkRunUntil(void);
void StkSetBreakpoint(void);
int StkGetActiveLevel(void);

LRESULT CALLBACK StkKeyFilterHook(int nCode, WORD wParam, LPMSG /* lpMsg */);


/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Filter the special key.
LRESULT CALLBACK StkKeyFilterHook(int nCode, WORD wParam, LPMSG /* lpMsg */)
{
    // Assertion of the input parameters.
    ASSERT( ::pStkView );

    // Hook the special key.
    LRESULT lRetValue = 0;
    
    switch ( nCode ) {
        case HC_ACTION:
            switch ( wParam ) {
                case VK_HOME:
                    ::pStkView->SendMessage(WM_HSCROLL, SB_TOP);
                    lRetValue = 1;
                    break;
                case VK_END:
                    ::pStkView->SendMessage(WM_HSCROLL, SB_BOTTOM);
                    lRetValue = 1;
                    break;
                case VK_SPACE:
                    lRetValue = 1;
                    break;
                case VK_PRIOR:
                    if ( GetKeyState(VK_CONTROL) & 0x8000 ) {
                        lRetValue = 1;
                    }
                    break;
                case VK_NEXT:
                    if ( GetKeyState(VK_CONTROL) & 0x8000 ) {
                        lRetValue = 1;
                    }
                    break;
                case VK_LEFT:
                    ::pStkView->SendMessage(WM_HSCROLL, SB_LINELEFT);
                    lRetValue = 1;
                    break;
                case VK_RIGHT:
                    ::pStkView->SendMessage(WM_HSCROLL, SB_LINERIGHT);
                    lRetValue = 1;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
    
    return (lRetValue);
}
    

// Update the stack view.
void StkUpdateStackWindow(BOOL bUpdateStackOnly)
{
    // Assertion of the input parameters.
    ASSERT( ::pStkView );
    
    // Update the stack view.
    ::pStkView->UpdateStackWindow(bUpdateStackOnly);
}

// Inspect the source line.
void StkInspectSource(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pStkView );
    
    // Inspect source line.
    ::pStkView->InspectSource();
}

// Set the breakpoint at the specific address.
void StkSetBreakpoint(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pStkView );
    
    // Set breakpoint.
    ::pStkView->SetBreakpoint();
}

// Run until the specific address.
void StkRunUntil(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pStkView );
    
    // Go till address.
    ::pStkView->RunUntil();
}

// Get the current active level.
int StkGetActiveLevel(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pStkView );

    // Get the current active level.
    return (::pStkView->GetActiveLevel());
}


/////////////////////////////////////////////////////////////////////////////
// CStackView

IMPLEMENT_DYNCREATE(CStackView, CFormView)

void CStackView::InitialMember(void)
{
    // Depand on design.
    m_nMaxColumn = totalColumn;

    m_strLevel = "";
    m_strAddress = "";
    m_strEntryPoint = "";
    m_strModule = "";
    m_strFunction = "";
    
    // Havn't initail grid.
    m_bInitialGrid = TRUE;
    m_bRedrawGrid = TRUE;
    m_bUpdateStackOnly = FALSE;
    
    // Get the maximum level number.
    GetMaxLevel();

    // Get each grid column width.
    GetColumnWidth();
}

CStackView::CStackView()
    : CFormView(CStackView::IDD)
{
    //{{AFX_DATA_INIT(CStackView)
    m_pGrid = NULL;
    //}}AFX_DATA_INIT
    
    // Initial.
    InitialMember();

    // Set the global pointer.
    ::pStkView = this;
}

CStackView::~CStackView()
{
}

void CStackView::DoDataExchange(CDataExchange* pDX)
{
    CFormView::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CStackView)
    DDX_VBControl(pDX, IDC_GRID_STACK, m_pGrid);
    DDX_VBLongRO(pDX, IDC_GRID_STACK, 23, m_lActiveRow);
    //}}AFX_DATA_MAP
}

CStackDoc* CStackView::GetDocument() // non-debug version is inline
{
    ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CStackDoc)));
    return (CStackDoc*)m_pDocument;
}


/////////////////////////////////////////////////////////////////////////////
// Public function.

// Update the whole stack pane.
void CStackView::UpdateStackWindow(BOOL bUpdateStackOnly)
{
    // Assertion of the input parameters.
    
    // Initial the grid.
    if ( m_pGrid && m_bInitialGrid ) {
        InitialGrid();
        m_bInitialGrid = FALSE;
    }

    // Initial again.
    if ( !bUpdateStackOnly ) {
        GetMaxLevel();
    }
    
    // Refresh the grid.
    m_bRedrawGrid = TRUE;
    m_bUpdateStackOnly = bUpdateStackOnly;
    UpdateGrid();
}

// Inspect the source line.
void CStackView::InspectSource(void)
{
    // Assertion of the input parameters.

    // Get the entry point address.
    if ( 0 == ::StkLevelToNode((int)(m_lActiveRow-1), m_pStkNode) ) {
        // Call SRCWIN routine.
        ::SrcShowSource((unsigned short)(m_pStkNode->addr));
    }
}

// Set the breakpoint at the specific address.
void CStackView::SetBreakpoint(void)
{
    // Assertion of the input parameters.

    // Get the entry point address.
    if ( 0 == ::StkLevelToNode((int)(m_lActiveRow-1), m_pStkNode) ) {
        // Call BPTSERVE routine.
        ::BptAddBptfromWnd((unsigned short)(m_pStkNode->addr1));

        // Call SRCWIN routine.
        ::SrcShowSource((unsigned short)(m_pStkNode->addr));
    }
}

// Run until the specific address.
void CStackView::RunUntil(void)
{
    // Assertion of the input parameters.

    // Get the entry point address.
    if ( 0 == ::StkLevelToNode((int)(m_lActiveRow-1), m_pStkNode) ) {
        // Call EMUGO routine.
        ::EmuServerGo(3, (unsigned short)(m_pStkNode->addr1));

        // Call SRCWIN routine.
        ::SrcShowSource((unsigned short)(m_pStkNode->addr));

        ::OnEmulation();
    }
}

// Get the active level.
int CStackView::GetActiveLevel(void)
{
    // Assertion of the input parameters.

    // Get the maximum level.
    if ( m_nMaxLevel < 1 ) {
        return (-1);
    }
    else {
        return ((int)(m_lActiveRow-1));
    }
}


/////////////////////////////////////////////////////////////////////////////
// Common function.

// Get the maximum stack level.
void CStackView::GetMaxLevel(void)
{
    // Assertion of the input parameters.
    
    // Delete all the local variables & stack information.
    ::stkObject.VarDeleteAll();

    // Get from Stack server.
    if ( -1 == ::StkGetStkLevelNum(m_nMaxLevel) ) {
        m_nMaxLevel = 0;
    }
}

// Get the information from Stack server.
void CStackView::GetStackInfo(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nMaxLevel > 0 );

    // Get the first node.
    if ( -1 == ::StkGetStkFirstNode(m_pStkNode) ) {
        return;
    }
        
    // Get the detail information by referring to m_pStkNode.
    m_nCurRow = 0;
    do {
        int nRetValue = ::StkGetNodeDisplayString(m_pStkNode, m_strLevel,
                m_strAddress, m_strEntryPoint, m_strModule, m_strFunction);
        if ( -1 == nRetValue ) {
            return;
        }
        else if ( 0 == nRetValue ) {
            m_nCurRow++;
            //SetColumnWidth();
            ShowStackInfo();
            HideColumn();
        }
        else {
            ASSERT( FALSE );
        }
    } while ( 0 == ::StkGetStkNextNode(m_pStkNode, m_pStkNode) );
}


/////////////////////////////////////////////////////////////////////////////
// Grid operation.

// Initial grid.
void CStackView::InitialGrid(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pGrid );
    ASSERT( m_bInitialGrid );

    // Select all the rows.
    m_pGrid->SetNumProperty("Row", -1);

    // Prevent the grid cell from editing.
    m_pGrid->SetNumProperty("Col", -1);
    m_pGrid->SetNumProperty("CellType", staticText);

    // Set the grid cell horizontal and verticla align attribute.
    m_pGrid->SetNumProperty("TypeHAlign", alignHLeft);
    m_pGrid->SetNumProperty("TypeTextAlignVert", alignVCenter);

    // Special properties for the column: Level & Address.
    // Horizontal align to center.
    // Prevent from resizing.
    for ( int i = levelColumn; i <= addressColumn; i++ ) {
        m_pGrid->SetNumProperty("Col", i);
        m_pGrid->SetNumProperty("TypeHAlign", alignHCenter);
        m_pGrid->SetNumProperty("AllowResize", FALSE);
    }
}

// Update grid.
void CStackView::UpdateGrid(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pGrid );
        
    // Prevent the grid from flickering.
    m_pGrid->SetNumProperty("Redraw", FALSE);
    
    // Adjust the grid height.
    m_pGrid->SetNumProperty("Height", m_rectClient.Height());
    
    // Adjust the row number of grid.
    ASSERT( m_nMaxLevel >= 0 );
    int nMaxRow = (int)
        (m_rectClient.Height() / m_pGrid->GetFloatProperty("RowHeight"));
    
    // Clear the Stack window when reset to no stack information.
    for ( int i = levelColumn; i <= functionColumn; i++ ) {
        m_pGrid->SetNumProperty("Row", -1);
        m_pGrid->SetNumProperty("Col", i);
        m_pGrid->SetStrProperty("Text", "");
    }

    // Reset the normal color.
    m_pGrid->SetNumProperty("Col", -1);
    m_pGrid->SetNumProperty("Row", -1);
    m_pGrid->SetNumProperty("BackColor", RGB(255, 255, 255));

    if ( 0 == m_nMaxLevel ) {
        m_pGrid->SetNumProperty("MaxRows", nMaxRow);
        // Clear the Local window when reset to no stack information.
        ::StkUpdateLocalWindow(-1);
        // Reset the active level.
        m_lActiveRow = 0;
        // Highlight the active row.
        m_pGrid->SetNumProperty("Col", -1);
        m_pGrid->SetNumProperty("Row", m_lActiveRow+1);
        m_pGrid->SetNumProperty("BackColor", RGB(255, 255, 0));
        return;
    }
    else {
        m_pGrid->SetNumProperty("MaxRows", max(m_nMaxLevel, nMaxRow));
    }

    // Adjust the column number of grid.
    m_pGrid->SetNumProperty("MaxCols", m_nMaxColumn);

    // Get the Stack information from server.
    if ( m_nMaxLevel > 0 ) {
        GetStackInfo();
    }
    
    // Reset the active row.
    ResetRow();
    
    // Highlight the active row.
    HighLightRow();

    // Allow the grid to redraw.
    m_pGrid->SetNumProperty("Redraw", TRUE);
}

// Hide the special columns.
void CStackView::HideColumn(void)
{
    // Assertion of the input parameters.

    // Hide or show address.
    m_pGrid->SetNumProperty("Col", addressColumn);
    m_pGrid->SetNumProperty("ColHidden", !::bStkShowAddress);
        
    // Hide or show entry point.
    m_pGrid->SetNumProperty("Col", entryPointColumn);
    m_pGrid->SetNumProperty("ColHidden", !::bStkShowEntryPoint);

    // Hide or show module.
    m_pGrid->SetNumProperty("Col", moduleColumn);
    m_pGrid->SetNumProperty("ColHidden", !::bStkShowModule);

    // Hide or show function parameters.
    m_pGrid->SetNumProperty("Row", m_nCurRow);
    m_pGrid->SetNumProperty("Col", functionColumn);
    if ( ::bStkShowParameters ) {
        m_pGrid->SetStrProperty("Text", m_strFunction);
    }
    else {
        int i = m_strFunction.Find('(');
        if ( -1 != i && ')' != m_strFunction[i+1] ) {
            CString str = m_strFunction.Left(i);
            str += "(...)";
            m_pGrid->SetStrProperty("Text", str);
        }
    }
}

// Show stack information in the grid.
void CStackView::ShowStackInfo(void)
{
    // Assertion of the input parameters.
                         
    // Set the current row.
    m_pGrid->SetNumProperty("Row", m_nCurRow);

    // Show level number.
    m_pGrid->SetNumProperty("Col", levelColumn);
    m_pGrid->SetStrProperty("Text", m_strLevel);

    // Show address.
    m_pGrid->SetNumProperty("Col", addressColumn);
    m_pGrid->SetStrProperty("Text", "0x" + m_strAddress);

    // Show entry point.
    m_pGrid->SetNumProperty("Col", entryPointColumn);
    m_pGrid->SetStrProperty("Text", m_strEntryPoint);

    // Show module.
    m_pGrid->SetNumProperty("Col", moduleColumn);
    m_pGrid->SetStrProperty("Text", m_strModule);

    // Show function.
    m_pGrid->SetNumProperty("Col", functionColumn);
    m_pGrid->SetStrProperty("Text", m_strFunction);
}

// Hihglight the active row.
void CStackView::HighLightRow(void)
{
    // Assertion of the input parameters.
    
    // Retrieve the active row.
    long lOldActiveRow = m_lActiveRow;
    UpdateData();
    
    // Set the row range.
    if ( m_lActiveRow > m_nMaxLevel ) {
        m_lActiveRow = m_nMaxLevel;
        ResetRow();
    }

    if ( m_lActiveRow <= 0 ) {
        return;
    }

    if ( TRUE == m_bRedrawGrid || m_lActiveRow != lOldActiveRow ) {
        // Reset the redraw flag.
        m_bRedrawGrid = FALSE;

        // Reset the normal color.
        m_pGrid->SetNumProperty("Col", -1);
        m_pGrid->SetNumProperty("Row", lOldActiveRow);
        m_pGrid->SetNumProperty("BackColor", RGB(255, 255, 255));
            
        // Highlight the active row.
        m_pGrid->SetNumProperty("Row", m_lActiveRow);
        m_pGrid->SetNumProperty("BackColor", RGB(255, 255, 0));

        // Update the local variables.
        if ( !m_bUpdateStackOnly ) {
            ::StkUpdateLocalWindow((int)(m_lActiveRow-1));
        }
        else {
            m_bUpdateStackOnly = FALSE;
        }
    }
}

// Reset to the active row.
void CStackView::ResetRow(void)
{
    // Assertion of the input parameters.
    
    // Reset and scroll to the cell(m_lActiveRow, 1).
    m_lActiveRow = max(m_lActiveRow, 1);

    m_pGrid->SetNumProperty("Row", m_lActiveRow);
    m_pGrid->SetNumProperty("Col", 1);
    m_pGrid->SetNumProperty("Action", actionActiveCell);
}

// Scroll up one line.
void CStackView::LineUp(void)
{
    // Assertion of the input parameters.

    // Scroll up one line.
    if ( m_lActiveRow > 1 ) {
        m_lActiveRow--;
        m_pGrid->SetNumProperty("Row", m_lActiveRow);
        m_pGrid->SetNumProperty("Col", m_pGrid->GetNumProperty("Col"));
        m_pGrid->SetNumProperty("Action", actionActiveCell);
        ScrollToLine(TRUE);
    }
}

// Scroll down one line.
void CStackView::LineDown(void)
{
    // Assertion of the input parameters.

    // Scroll down one line.
    if ( m_lActiveRow > 0 && m_lActiveRow < m_nMaxLevel ) {
        m_lActiveRow++;
        m_pGrid->SetNumProperty("Row", m_lActiveRow);
        m_pGrid->SetNumProperty("Col", m_pGrid->GetNumProperty("Col"));
        m_pGrid->SetNumProperty("Action", actionActiveCell);
        ScrollToLine(FALSE);
    }
}

// Hihglight the active row.
void CStackView::ScrollToLine(BOOL bScrollUp)
{
    // Assertion of the input parameters.
    ASSERT( m_lActiveRow > 0 );
    
    // Reset the normal color.
    if ( bScrollUp ) {
        m_pGrid->SetNumProperty("Row", m_lActiveRow+1);
    }
    else {
        m_pGrid->SetNumProperty("Row", m_lActiveRow-1);
    }
    m_pGrid->SetNumProperty("Col", -1);
    m_pGrid->SetNumProperty("BackColor", RGB(255, 255, 255));
            
    // Highlight the active row.
    m_pGrid->SetNumProperty("Row", m_lActiveRow);
    m_pGrid->SetNumProperty("BackColor", RGB(255, 255, 0));

    // Update the local variables.
    ::StkUpdateLocalWindow((int)(m_lActiveRow-1));
}

// Get the grid column width.
void CStackView::GetColumnWidth(void)
{
    // Assertion of the input parameters.
    
    // Get each grid column width.
    m_fColumnWidth[levelColumn-1] = 7.75;
    m_fColumnWidth[addressColumn-1] = 11.13;
    m_fColumnWidth[entryPointColumn-1] = 20.25;
    m_fColumnWidth[moduleColumn-1] = 14.25;
    m_fColumnWidth[functionColumn-1] = 26.50;
}

// Set the grid column width.
void CStackView::SetColumnWidth(void)
{
    // Assertion of the input parameters.
    
    // Get the Function column width;
    float fFunctionWidth = m_fColumnWidth[functionColumn-1];
    
    // Set each grid column width.
    m_pGrid->SetNumProperty("Row", -1);

    if ( ::bStkShowAddress ) {
        m_pGrid->SetNumProperty("Col", addressColumn);
        m_pGrid->SetFloatProperty("ColWidth", 
                                  m_fColumnWidth[addressColumn-1]);
    }
    else {
        fFunctionWidth += m_fColumnWidth[addressColumn-1];
    }
    
    if ( ::bStkShowEntryPoint ) {
        m_pGrid->SetNumProperty("Col", entryPointColumn);
        m_pGrid->SetFloatProperty("ColWidth", 
                                  m_fColumnWidth[entryPointColumn-1]);
    }
    else {
        fFunctionWidth += m_fColumnWidth[entryPointColumn-1];
    }
    
    if ( ::bStkShowModule ) {
        m_pGrid->SetNumProperty("Col", moduleColumn);
        m_pGrid->SetFloatProperty("ColWidth", 
                                  m_fColumnWidth[moduleColumn-1]);
    }
    else {
        fFunctionWidth += m_fColumnWidth[moduleColumn-1];
    }
    
    m_pGrid->SetNumProperty("Col", levelColumn);
    m_pGrid->SetFloatProperty("ColWidth", m_fColumnWidth[levelColumn-1]);

//    m_pGrid->SetNumProperty("Col", functionColumn);
//    m_pGrid->SetFloatProperty("ColWidth", fFunctionWidth);
}


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CStackView, CFormView)
    //{{AFX_MSG_MAP(CStackView)
    ON_VBXEVENT(VBN_CLICK, IDC_GRID_STACK, OnClickGridStack)
    ON_VBXEVENT(VBN_DBLCLICK, IDC_GRID_STACK, OnDblclickGridStack)
    ON_VBXEVENT(VBN_KEYDOWN, IDC_GRID_STACK, OnKeydownGridStack)
    ON_VBXEVENT(VBN_GOTFOCUS, IDC_GRID_STACK, OnGotfocusGridStack)
    ON_VBXEVENT(VBN_LOSTFOCUS, IDC_GRID_STACK, OnLostfocusGridStack)
    ON_VBXEVENT(VBN_MOUSEUP, IDC_GRID_STACK, OnMouseupGridStack)
    ON_WM_SIZE()
    ON_WM_SETCURSOR()
    ON_WM_HSCROLL()
    ON_WM_VSCROLL()
    ON_WM_DESTROY()
    ON_WM_RBUTTONDOWN()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CStackView message handlers

void CStackView::OnClickGridStack(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here
    
    // Hihglight the active row.
    HighLightRow();
}

void CStackView::OnDblclickGridStack(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here
    
    // Hihglight the active row.
    HighLightRow();
}

void CStackView::OnKeydownGridStack(UINT, int, CWnd*, LPVOID /* lpParams */)
{
    // TODO: Add your VBX event notification handler code here

    // Hihglight the active row.
    HighLightRow();
}

void CStackView::OnGotfocusGridStack(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here

    // Install the hook function in the hook chain.
    if ( !::hookStkKeyFilter ) {
        ::hookStkKeyFilter = 
            SetWindowsHookEx(WH_KEYBOARD, (HOOKPROC)::StkKeyFilterHook,
                             AfxGetApp()->m_hInstance, GetCurrentTask());
    }
}

void CStackView::OnLostfocusGridStack(UINT, int, CWnd*, LPVOID)
{
    // TODO: Add your VBX event notification handler code here

    // Remove the hook function from the hook chain.
    if ( ::hookStkKeyFilter ) {
        UnhookWindowsHookEx(::hookStkKeyFilter);
        ::hookStkKeyFilter = 0;
    }
}

void CStackView::OnMouseupGridStack(UINT, int, CWnd*, LPVOID lpParams)
{
    // TODO: Add your VBX event notification handler code here
    
    // Get the parameters.
    int nButton = AFX_NUM_EVENTPARAMINDEX(int, lpParams, 3);
    int xPos = AFX_NUM_EVENTPARAMINDEX(int, lpParams, 1);
    int yPos = AFX_NUM_EVENTPARAMINDEX(int, lpParams, 0);
    enum { rightButton = 2 };
    
    // Right button down.
    if ( rightButton == nButton ) {
        // Create the local menu.
        CMenu* pLocalMenu = new CMenu;
        ASSERT( NULL != pLocalMenu );
        if ( !pLocalMenu ) {
            AfxMessageBox("Insufficient memory.");
            return;
        }
        pLocalMenu->CreatePopupMenu();
    
        // Define the local menu.
        pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_INSPECTSOURCE, "&Inspect Source");
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SETBREAKPOINT, "Set &Breakpoint");
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_RUNUNTIL, "&Run Until");
        pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_FORMATFUNCTIONLIST, "For&mat Function List...");
    
        // Adjust the cursor location.
        //CPoint pt(xPos, yPos);
    	CPoint pt(m_rectClient.Width()/2, m_rectClient.Height()/2);
    
        // Display the local menu.
        ClientToScreen(&pt);
    
        // Active the local menu.
        pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, pt.x, pt.y, GetParent()->GetParent());
    
        // Release the allocated buffer.
        delete pLocalMenu;
    }
}


void CStackView::OnSize(UINT nType, int cx, int cy)
{
    CFormView::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here

    // Get the client area size.
    GetClientRect(m_rectClient);

    // Update grid contents.
    if ( m_pGrid ) {
        m_bRedrawGrid = TRUE;
        UpdateGrid();
    }
}

BOOL CStackView::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default

    // Send the WM_RBUTTONDOWN message to implement local menu.
    if( HTCLIENT == nHitTest && WM_RBUTTONDOWN == message ) {
        return FALSE;
    }

    return CFormView::OnSetCursor(pWnd, nHitTest, message);
}

void CStackView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default
    
    // Disable the thumb direct operation.
    switch ( nSBCode ) {
        case SB_LINELEFT:
            //m_pGrid->SendMessage(WM_HSCROLL, nSBCode);
            break;
        case SB_LINERIGHT: 
            //m_pGrid->SendMessage(WM_HSCROLL, nSBCode);
            break;
        case SB_PAGELEFT:
            //m_pGrid->SendMessage(WM_HSCROLL, nSBCode);
            break;
        case SB_PAGERIGHT: 
            //m_pGrid->SendMessage(WM_HSCROLL, nSBCode);
            break;
        case SB_TOP:
            //m_pGrid->SendMessage(WM_HSCROLL, nSBCode);
            break;
        case SB_BOTTOM:
            //m_pGrid->SendMessage(WM_HSCROLL, nSBCode);
            break;
        /*
        case SB_ENDSCROLL:
            break;
        case SB_THUMBPOSITION:
            m_pGrid->SendMessage(WM_HSCROLL, nSBCode, nPos);
            return;
        case SB_THUMBTRACK:
            m_pGrid->SendMessage(WM_HSCROLL, nSBCode, nPos);
            return;
        */
        default:
            return;
    }                      

    CFormView::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CStackView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default
    
    // Disable the thumb direct operation.
    switch ( nSBCode ) {
        case SB_LINEUP:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode);
            return;
        case SB_LINEDOWN:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode);
            return;
        case SB_PAGEUP:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode);
            return;
        case SB_PAGEDOWN:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode);
            return;
        case SB_TOP:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode);
            return;
        case SB_BOTTOM:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode);
            return;
        /*
        case SB_ENDSCROLL:
            break;
        case SB_THUMBPOSITION:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode, nPos);
            return;
        case SB_THUMBTRACK:
            m_pGrid->SendMessage(WM_VSCROLL, nSBCode, nPos);
            return;
        */
        default:
            return;
    }

    CFormView::OnVScroll(nSBCode, nPos, pScrollBar);
}

/*
void CStackView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default
    
    // Disable the thumb direct operation.
    switch ( nSBCode ) {
        case SB_LINEUP:
//            LineUp();
//            return;
            break;
        case SB_LINEDOWN:
//            LineDown();
//            return;
            break;
        case SB_PAGEUP:
//            LineUp();
//            return;
            break;
        case SB_PAGEDOWN:
//            LineDown();
//            return;
            break;

//        case SB_TOP:
//            break;
//        case SB_BOTTOM:
//            break;
//        case SB_ENDSCROLL:        
//            break;
//        case SB_THUMBPOSITION:       
//            break;
//        case SB_THUMBTRACK:     
//            break;
//        default:
//            break;
        default:
            return;
    }

    CFormView::OnVScroll(nSBCode, nPos, pScrollBar);
}
*/

void CStackView::OnDestroy()
{
    CFormView::OnDestroy();
    
    // TODO: Add your message handler code here
    
    // Remove the hook function from the hook chain.
    if ( ::hookStkKeyFilter ) {
        UnhookWindowsHookEx(::hookStkKeyFilter);
        ::hookStkKeyFilter = 0;
    }
}

void CStackView::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    
    // Create the local menu.
    CMenu* pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );
    if ( !pLocalMenu ) {
        AfxMessageBox("Insufficient memory.");
        return;
    }
    pLocalMenu->CreatePopupMenu();
    
    // Define the local menu.
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_INSPECTSOURCE, "&Inspect Source");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SETBREAKPOINT, "Set &Breakpoint");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_RUNUNTIL, "&Run Until");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_FORMATFUNCTIONLIST, "For&mat Function List...");
    
    // Adjust the cursor location.
    CPoint pt(m_rectClient.Width()/2, m_rectClient.Height()/2);
    
    // Display the local menu.
    ClientToScreen(&pt);
    
    // Active the local menu.
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, pt.x, pt.y, GetParent()->GetParent());
    
    // Release the allocated buffer.
    delete pLocalMenu;

    CFormView::OnRButtonDown(nFlags, point);
}
