
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SYMMEM.CPP   1.29   02 Apr 1996 09:30:22   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SYMMEM.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:22   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:40   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:08   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:22   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:42   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:26   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:06   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:44   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:14   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:30   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:28   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:34   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:04   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:46   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:30   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:36   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:54   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:30   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:54   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:06   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:14   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:04   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:26   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: SYMMEM.cpp
**
** Title: Memory Manager
**
** Purpose:
**  Create and manage the symbol table memory.  Included:
**      creating table
**      adding elements to table
**      growing table
**      closing table
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   C:/EPSLDV1/SRC/LOG/SYMMEM.CPP   1.29   02 Apr 1996 09:30:22   Shirley  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"                      
#include "memmanag.h"

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

//------------------------------------------------------------------------
// Table::InitOrExtendTable
//
// Purpose:
//    Initialize table if tableSize = 0 else
//    extend the table by <expandSize>.
//
// Input parameters:
//    allocFlag:
//       0 if memory does not need to be zeroed upon initialization
//       GMEM_ZEROINIT if memory needs to be zeroed upon initialization
//
// Output parameters: None
//
// Error:
//    Reports ER_SYM_OUT_OF_MEMORY if memory cannot be Alloc'ed or ReAlloc'ed
//------------------------------------------------------------------------
RETCODE Table::InitOrExtendTable(WORD zeroInitFlag) {

   HANDLE tempTableHandle;
   U32 memAvailable;
   U32 trialSize;    // latest incremental size to try

   if (!tableSize) {  // table has not been Alloc'ed yet
      if ((tableHandle = GlobalAlloc(GMEM_MOVEABLE | zeroInitFlag,
                                      initialSize)) == NULL) {
         // not enough memory found; compact then check again

         memAvailable = GlobalCompact(initialSize);
         if (memAvailable < initialSize) {
            return ER_SYM_OUT_OF_MEMORY;
         } else {
            if ((tableHandle = GlobalAlloc(GMEM_MOVEABLE | zeroInitFlag,
                                            initialSize))== NULL)
               return ER_SYM_OUT_OF_MEMORY;
         }
      }
      // memory found; fall thru

      if ((hpTableObject = (HPU8)GlobalLock(tableHandle)) != 0L) {
         //successful initial allocation
         // actual size may be larger than requested size, but we only want
         // the size on an even binary boundary
         tableSize= initialSize;
         return SUCCESS;
      }
   } else {  // table has been previously Alloc'ed; need to ReAlloc
      trialSize = expandSize;

#ifdef DEBUG
      if (expandSize < MIN_EXPAND_SIZE) return ER_EXPAND_SIZE_ERROR;
#endif

	   if ((tempTableHandle = GlobalReAlloc(tableHandle,
                                            (tableSize + trialSize),
                                            GMEM_MOVEABLE | zeroInitFlag))==NULL) {
         // GlobalReAlloc failed; compact and try again
         GlobalCompact(tableSize + trialSize);  // ignore return value
         for (;;)  {
            if ((tempTableHandle =
               GlobalReAlloc(tableHandle,
                             (tableSize + trialSize),
                             GMEM_MOVEABLE | zeroInitFlag)) != 0)
               // get out of loop if the ReAlloc worked
               { break; };

            // reduce requested size in half and try again
            if ((trialSize >>= 1) < 256)
               return ER_SYM_OUT_OF_MEMORY;
         }
      }
      // memory found
      tableHandle = tempTableHandle;    // restore handle

      // restore huge pointer
      if ((hpTableObject = (HPU8)GlobalLock(tableHandle)) != 0L)  {
         //successful lock; update total memory size
         tableSize += trialSize;

         // even though actual size may be larger than requested size,
         // want to maintain binary boundary of memory so that data
         // elements don't cross 64K boundary
         return SUCCESS;
      } else { //GlobalLock failed
         return ER_SYM_OUT_OF_MEMORY;
      }
   }  // end of else part of if (!tableSize)
   return SUCCESS;
};  // end of Table::InitOrExtendTable


//------------------------------------------------------------------------
// Table::ObliterateTable
//
// Purpose: release this table memory with GlobalFree
//------------------------------------------------------------------------
VOID Table::ObliterateTable(VOID) {

   // call the routines to free memory only if the tableHandle is non-zero ;
   if (tableHandle) {
      GlobalUnlock(tableHandle);
      GlobalFree(tableHandle);
   }
   tableHandle = 0;
   tableSize = 0L;
   initialSize = INITIAL_TABLE_SIZE;
   expandSize = MIN_EXPAND_SIZE;
}

/******************************** E O F *************************************/
