
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SYNCORE.H__   1.29   02 Apr 1996 09:22:32   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SYNCORE.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:22:32   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:51:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:28   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:58   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:20   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:18   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:28   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:20   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:18   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:46   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:14   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:00   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:12:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:40   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:14   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:56   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:30   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:30:00   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:06   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:24   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:40   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:10   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:24   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:51:10   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:54   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:45:20   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:32   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE.H
//
//  Description: The header file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNCORE_
#define _SYNCORE_

#include "synlib.h"

/////////////////////////////////////////////////////////////////////////////
// CSyntaxCheck class.
class CSyntaxCore : public CSyntaxLib
{
// Construction & Destruction.
public:
    CSyntaxCore();
    ~CSyntaxCore();
    
// Member variables.
protected:
    // Command parsing varibles.
    enum { MAX_CMDLINE = 255, MAX_ARGV = (255+1)/2 };
    
    enum { NO_ERROR         = 0,
           NO_SUCH_COMMAND  = 1,
           SYNTAX_ERROR     = 2,
           MAX_ERROR        = 100
    };
    
    int m_nArgc;
    char* m_pszArgv[MAX_ARGV];

    // Syntax error ID.
    int m_nErrorID;

    enum { MIN_CMDID        = 0,
           CMDID_ASSEMBLE   = 0,
           CMDID_BIT,
           CMDID_BREAKPOINT,
           CMDID_BYTE,
           CMDID_CHECKSUM,
           CMDID_CLEAR,
           CMDID_COMPARE,
           CMDID_CONTROL,
           CMDID_COPY,
           // CMDID_CPU,
           CMDID_CREATE,
           CMDID_CYCLE,
           CMDID_DELETE,
           CMDID_DISASSEMBLE,
           CMDID_EVENT,
           CMDID_EV1,
           CMDID_EV2,
           CMDID_EV3,
           CMDID_FILL,
           CMDID_GO,
           CMDID_HALT,
           CMDID_HELP,
           CMDID_IDENTIFY,
           CMDID_INCLUDE,
           CMDID_INPORT,
           CMDID_JUMP,
           CMDID_LEVEL,
           CMDID_LV1,
           CMDID_LV2,
           CMDID_LIST,
           CMDID_LOAD,
           CMDID_LOG,
           CMDID_LONG,
           CMDID_MAP,
           CMDID_MEMORY,
           CMDID_OUTPORT,
           // CMDID_PATCH,
           CMDID_PORT,
           CMDID_QUALIFY,
           // CMDID_QUIT,
           CMDID_QUERY,
           CMDID_REGISTER,
           CMDID_RESET,
           CMDID_SEARCH,
           CMDID_SRECALL,
           CMDID_SSAVE,
           CMDID_STEP,
           // CMDID_STEPOPTION,
           CMDID_SYMBOL,
           CMDID_TEST,
           CMDID_TIMER,
           CMDID_TRACE,
           CMDID_TRIGGER,
           CMDID_UPLOAD,
           CMDID_VERIFY,
           // CMDID_BACK,
           // CMDID_MODULE,
           // CMDID_WATCH,

        #ifdef _CHEN_
            CMDID_CALCULATE,
        #endif  // _CHEN_

        #ifdef _GATES
           CMDID_COUNT,
           CMDID_LINE,
           CMDID_STATEMENT,
           CMDID_VOID,
           CMDID_TYPE,
        #endif  // _GATES

           CMDID_WORD,
           MAX_CMDID    = CMDID_WORD

    };
    
// Implementations.
private:
    BOOL PreStringData(int nArgc, unsigned uDigit);
    void SymToAddr(void);

    // Syntax check kernel routine.
    void SyntaxCheckAssemble(void);
    void SyntaxCheckBit(void);
    void SyntaxCheckBreakpoint(void);
    void SyntaxCheckByte(void);
    void SyntaxCheckChecksum(void);
    void SyntaxCheckClear(void);
    void SyntaxCheckCompare(void);
    void SyntaxCheckControl(void);
    void SyntaxCheckCopy(void);
    void SyntaxCheckCpu(void);
    void SyntaxCheckCycle(void);
    void SyntaxCheckDisassemble(void);
    void SyntaxCheckEvent(void);
    void SyntaxCheckEv1(void);
    void SyntaxCheckEv2(void);
    void SyntaxCheckEv3(void);
    void SyntaxCheckFill(void);
    void SyntaxCheckGo(void);
    void SyntaxCheckHalt(void);
    void SyntaxCheckHelp(void);
    void SyntaxCheckIdentify(void);
    void SyntaxCheckInclude(void);
    void SyntaxCheckInport(void);
    void SyntaxCheckJump(void);
    void SyntaxCheckLevel(void);
    void SyntaxCheckLv1(void);
    void SyntaxCheckLv2(void);
    void SyntaxCheckList(void);
    void SyntaxCheckLog(void);
    void SyntaxCheckLong(void);
    void SyntaxCheckMap(void);
    void SyntaxCheckMemory(void);
    void SyntaxCheckOutport(void);
    void SyntaxCheckPatch(void);
    void SyntaxCheckPort(void);
    void SyntaxCheckQualify(void);
    void SyntaxCheckQuit(void);
    void SyntaxCheckRegister(void);
    void SyntaxCheckReset(void);
    void SyntaxCheckSearch(void);
    void SyntaxCheckStep(void);
    void SyntaxCheckStepoption(void);
    void SyntaxCheckTest(void);
    void SyntaxCheckTimer(void);
    void SyntaxCheckTrace(void);
    void SyntaxCheckTrigger(void);
    void SyntaxCheckUpload(void);
    void SyntaxCheckVerify(void);
    void SyntaxCheckWord(void);
    void SyntaxCheckBack(void);
    void SyntaxCheckCreate(void);
    void SyntaxCheckDelete(void);
    void SyntaxCheckLoad(void);
    void SyntaxCheckModule(void);
    void SyntaxCheckQuery(void);
    void SyntaxCheckSsave(void);
    void SyntaxCheckSrecall(void);
    void SyntaxCheckSymbol(void);
    void SyntaxCheckWatch(void);

    #ifdef _CHEN_
        void SyntaxCheckCalculate(void);
    #endif  // _CHEN_

    #ifdef _GATES
        void SyntaxCheckCount(void);
        void SyntaxCheckLine(void);
        void SyntaxCheckStatement(void);
        void SyntaxCheckVoid(void);
        void SyntaxCheckType(void);
    #endif  // _GATES

protected:
    void SyntaxDispatch(const int nCommandID);

};  // End of class: CSyntaxCore.

#endif
//////////////////////////////// End of File ////////////////////////////////
