
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SYNLIB.CPP   1.29   02 Apr 1996 09:30:04   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SYNLIB.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:30:04   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:06   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:24   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:52   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:46   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:02   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:14   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:46   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:34   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:08   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:11:12   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:15:00   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:46   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:22   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:42   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:07:24   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:47:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:30   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:02   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:02   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:36   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:54:22   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:52   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:06   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.CPP
//
//  Description: The implementation file for the class: CSyntaxLib.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLib.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include <ctype.h>

#include "symblsvr.h"
#include "cpucom.h"

#include "synlib.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
int SymToAddr(char* lpStr , U8* lpType , U32* lpAddr);
int GetControlOption(CString &strReset,CString &strEa,CString &strEben);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxLib.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::CSyntaxLib().
//
//  Description: The construction of the class: CSyntaxLib.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLib::CSyntaxLib()
{
    // Maximum of the memory type.
    m_ulMaxTypeP = 0x0FFFF;
    m_ulMaxTypeX = 0x0FFFF;
    m_ulMaxTypeI = 0x0FF;
    m_ulMaxTypeR = 0x0FF;
    m_ulMaxTypeB = 0x0FF;

}   // End of CSyntaxLib::CSyntaxLib().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::~CSyntaxLib().
//
//  Description: The destruction of the class: CSyntaxLib.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLib::~CSyntaxLib()
{

}   // End of CSyntaxLib::~CSyntaxLib().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::StrToVar().
//
//  Description: Convert the string to an unsigned long value.
//
//  Input:  pszStr - The string to be converted.
//
//  Output: None.
//
//  Return: An unsigned long value.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long CSyntaxLib::StrToVar(char* pszStr) const
{
    // Assertion of the input parameters.
    ASSERT( pszStr );
    
    // Convertion.
    char* pszStopStr;
    unsigned long ul = strtoul(pszStr, &pszStopStr, 16);
    
    // Return.
    return (ul);

}   // End of CSyntaxLib::StrToVar().


// Convert an unsigned long value to a string.
void CSyntaxLib::VarToStr(unsigned long ulVar, char* pszStr) const
{
    // Assertion of the input parameters.
    ASSERT( pszStr );
    
    // Convert an unsigned long value to a string.
    _ultoa(ulVar, pszStr, 16);

}   // End of CSyntaxLib::VarToStr().


// Convert the symbol name to address string.
void CSyntaxLib::SymbolToAddr(char* pszSymbol, char* pszAddr) const
{
    // Assertion of the input parameters.
    ASSERT( pszSymbol );
    ASSERT( pszAddr );
    
    // Call from symbol server.
    unsigned char uchType;
    unsigned long ulAddr;
    if ( 0 == ::SymToAddr(pszSymbol, &uchType, &ulAddr) ) {
        // Get address & type.
        char szAddr[33];
        VarToStr(ulAddr, szAddr);
        char szType[3];
        switch ( uchType ) {
            case 1:
                strcpy(szType, "P:");
                break;
            case 2:
                strcpy(szType, "X:");
                break;
            case 3:
                strcpy(szType, "I:");
                break;
            case 4:
                strcpy(szType, "R:");
                break;
            case 5:
                strcpy(szType, "B:");
                break;
            case 0:
                strcpy(szType, "");
                break;
            default:
                ASSERT( FALSE );
                strcpy(szType, "");
                break;
        }
        // Join to one string.
        strcpy(pszAddr, szType);
        strcat(pszAddr, szAddr);
    }
    else {
        strcpy(pszAddr, pszSymbol);
    }

}   // End of CSyntaxLib::SymbolToAddr().

// Convert the symbol name to address string without type prefix.
void CSyntaxLib::SymbolToAddr(char* pszSymbol, char* pszAddr, char chType) const
{
    // Assertion of the input parameters.
    ASSERT( pszSymbol );
    ASSERT( pszAddr );
    ASSERT( 'P' == chType || 'X' == chType || 'B' == chType );
    
    // Call from symbol server.
    unsigned char uchType;
    unsigned long ulAddr;
    if ( 0 == ::SymToAddr(pszSymbol, &uchType, &ulAddr) ) {
        // Get address & type.
        char szAddr[33];
        VarToStr(ulAddr, szAddr);
        switch ( uchType ) {
            case 1:
                if ( 'P' != chType ) {
                    pszAddr = pszSymbol;
                    return;
                }
                break;
            case 2:
                if ( 'X' != chType ) {
                    pszAddr = pszSymbol;
                    return;
                }
                break;
            case 3:
                ASSERT( FALSE );
                break;
            case 4:
                ASSERT( FALSE );
                break;
            case 5:
                if ( 'B' != chType ) {
                    pszAddr = pszSymbol;
                    return;
                }
                break;
            case 0:
                ASSERT( FALSE );
                break;
            default:
                ASSERT( FALSE );
                break;
        }
        // Join to one string.
        strcpy(pszAddr, szAddr);
    }
    else {
        strcpy(pszAddr, pszSymbol);
    }

}   // End of CSyntaxLib::SymbolToAddr().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::Is***().
//
//  Description: Syntax checking lib routines.
//
//  Input:  pszArgv - Token arguments of command.
//
//  Output: None.
//
//  Return: FALSE - error; TRUE - pass.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxLib::IsAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }
    
    // Is "p:xxxx".
    if ( IsPAddr(szArgv) ) {
        return (TRUE);
    }
    
    // Is "x:xxxx".
    else if ( IsXAddr(szArgv) ) {
        return (TRUE);
    }
    
    // Is "i:xx".
    else if ( IsIAddr(szArgv) ) {
        return (TRUE);
    }
    
    // Is "r:xx".
    else if ( IsRAddr(szArgv) ) {
        return (TRUE);
    }
    
    // Is "b:xx".
    else if ( IsBAddr(szArgv) ) {
        return (TRUE);
    }
    
    // Error.
    return (FALSE);
}


BOOL CSyntaxLib::IsPAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }
    
    // Is "p:xxxx".
    char* p;
    if ( 'P' != toupper(szArgv[0]) || ':' != szArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (szArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(szArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsPAddrDefault(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv, 'P');
    }
    
    // Is "xxxx".
    char* p;
    if ( strlen(p = szArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsXAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }
    
    // Is "x:xxxx".
    char* p;
    if ( 'X' != toupper(szArgv[0]) || ':' != szArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (szArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(szArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeX ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsXAddrDefault(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv, 'X');
    }
    
    // Is "xxxx".
    char* p;
    if ( strlen(p = szArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeX ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsIAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }
    
    // Is "i:xxxx".
    char* p;
    if ( 'I' != toupper(szArgv[0]) || ':' != szArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (szArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(szArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeI ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsIAddrDefault(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv, 'I');
    }
    
    // Is "xxxx".
    char* p;
    if ( strlen(p = szArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeI ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsRAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }
    
    // Is "r:xxxx".
    char* p;
    if ( 'R' != toupper(szArgv[0]) || ':' != szArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (szArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(szArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeR ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsRAddrDefault(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv, 'R');
    }
    
    // Is "xxxx".
    char* p;
    if ( strlen(p = szArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeR ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsBAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }
    
    // Is "b:xxxx".
    char* p;
    if ( 'B' != toupper(szArgv[0]) || ':' != szArgv[1] ) {
        return (FALSE);
    }
    if ( strlen(p = (szArgv+2)) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(szArgv+2);
    if ( ul < 0ul || ul > m_ulMaxTypeB ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsBAddrDefault(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv, 'B');
    }
    
    // Is "xxxx".
    char* p;
    if ( strlen(p = szArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }    
    }
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeB ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsAddrLen(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x010000ul ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsKeywordLength(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, "LENGTH") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
}


// Is in the range: "addr Length length".
BOOL CSyntaxLib::IsLengthRange(char* pszAddr, char* pszLen) const
{
    // Assertion of the input parameters.
    ASSERT( pszAddr && pszLen );
    
    // Convert symbol to standard address format.
    char szAddr[256];
    strcpy(szAddr, pszAddr);
    if ( '#' == szAddr[0] ) {
        SymbolToAddr(pszAddr, szAddr);
    }
    
    // Default X: address.
    if ( ':' != *(szAddr+1) ) {
        if ( StrToVar(szAddr) + StrToVar(pszLen) > m_ulMaxTypeX+1 ) {
            return (FALSE);
        }
        else {
            return (TRUE);
        }
    }

    // Address with space specifier.
    switch ( toupper(*szAddr) ) {
        case 'P':
            if ( StrToVar(szAddr+2) + StrToVar(pszLen) > m_ulMaxTypeP+1 ) {
                return (FALSE);
            }
            break;
        case 'X':
            if ( StrToVar(szAddr+2) + StrToVar(pszLen) > m_ulMaxTypeX+1 ) {
                return (FALSE);
            }
            break;
        case 'I':
            if ( StrToVar(szAddr+2) + StrToVar(pszLen) > m_ulMaxTypeI+1 ) {
                return (FALSE);
            }
            break;
        case 'R':
            if ( StrToVar(szAddr+2) + StrToVar(pszLen) > m_ulMaxTypeR+1 ) {
                return (FALSE);
            }
            break;
        case 'B':
            if ( StrToVar(szAddr+2) + StrToVar(pszLen) > m_ulMaxTypeB+1 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsLengthRange(char* /* pszAddr */, char* pszLen, char* pszTarget) const
{
    // Assertion of the input parameters.
    ASSERT( pszLen && pszTarget );
    
    // Convert symbol to standard address format.
    char szTarget[256];
    strcpy(szTarget, pszTarget);
    if ( '#' == szTarget[0] ) {
        SymbolToAddr(pszTarget, szTarget);
    }

    // Is "pszLen - 1 <= 0x0FFFF - pszTarget".
    char* p = (':' == szTarget[1]) ? szTarget+2 : szTarget;
    if ( StrToVar(pszLen) - 1 > 0x0FFFF - StrToVar(p) ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLib::IsAddrRange(char* pszAddr1, char* pszAddr2) const
{
    // Assertion of the input parameters.
    ASSERT( pszAddr1 && pszAddr2 );
    
    // Convert symbol to standard address format.
    char szAddr1[256];
    strcpy(szAddr1, pszAddr1);
    if ( '#' == szAddr1[0] ) {
        SymbolToAddr(pszAddr1, szAddr1);
    }
    
    char szAddr2[256];
    strcpy(szAddr2, pszAddr2);
    if ( '#' == szAddr2[0] ) {
        SymbolToAddr(pszAddr2, szAddr2);
    }

    // Is "addr2 >= addr1".
    char* p1 = (':' == szAddr1[1]) ? szAddr1+2 : szAddr1;
    char* p2 = (':' == szAddr2[1]) ? szAddr2+2 : szAddr2;
        
    if ( StrToVar(p1) > StrToVar(p2) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsAddrRange(char* pszAddr1, char* pszAddr2, char* pszAddr3) const
{
    // Assertion of the input parameters.
    ASSERT( pszAddr1 && pszAddr2 && pszAddr3 );
    
    // Convert symbol to standard address format.
    char szAddr1[256];
    strcpy(szAddr1, pszAddr1);
    if ( '#' == szAddr1[0] ) {
        SymbolToAddr(pszAddr1, szAddr1);
    }
    
    char szAddr2[256];
    strcpy(szAddr2, pszAddr2);
    if ( '#' == szAddr2[0] ) {
        SymbolToAddr(pszAddr2, szAddr2);
    }

    char szAddr3[256];
    strcpy(szAddr3, pszAddr3);
    if ( '#' == szAddr3[0] ) {
        SymbolToAddr(pszAddr3, szAddr3);
    }

    // Is "addr2 - addr1 <= 0x0FFFF - addr3".
    char* p1 = (':' == szAddr1[1]) ? szAddr1+2 : szAddr1;
    char* p2 = (':' == szAddr2[1]) ? szAddr2+2 : szAddr2;
    char* p3 = (':' == szAddr3[1]) ? szAddr3+2 : szAddr3;
    
    if ( StrToVar(p2) - StrToVar(p1) > 0x0FFFF - StrToVar(p3) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapStartAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }

    // Is "p:xxxx".
    if ( !IsPAddr(szArgv) &&
         !IsXAddr(szArgv) &&
         !IsXAddrDefault(szArgv) ) {
        return (FALSE);
    }

    // Check map bound.
    char* p1 = (':' == szArgv[1]) ? szArgv+2 : szArgv;
    char* p2 = p1;
    if ( strlen(p1) < 1 ) {
        return (FALSE);
    }
    while ( *p1 ) {
        if ( !isxdigit(*(p1++)) ) {
            return (FALSE);
        }    
    }

    unsigned long ul = StrToVar(p2);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapEndAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if ( '#' == szArgv[0] ) {
        SymbolToAddr(pszArgv, szArgv);
    }

    // Is "p:xxxx".
    if ( !IsPAddr(szArgv) &&
         !IsXAddr(szArgv) &&
         !IsXAddrDefault(szArgv) ) {
        return (FALSE);
    }

    // Check map bound.
    char* p1 = (':' == szArgv[1]) ? szArgv+2 : szArgv;
    char* p2 = p1;
    if ( strlen(p1) < 1 ) {
        return (FALSE);
    }
    while ( *p1 ) {
        if ( !isxdigit(*(p1++)) ) {
            return (FALSE);
        }    
    }

    unsigned long ul = StrToVar(p2);
    if ( ul < 0ul || ul > m_ulMaxTypeP ) {
        return (FALSE);
    }
    else if ( 0 != ((ul+1) % 0x080) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapAddrLen(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x010000ul ) {
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapMemType(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "X:...".
    if ( 2 != strlen(pszArgv) ) {
        return (FALSE);
    }
    
    if ( ':' != pszArgv[1] ) {
        return (FALSE);
    }
    
    if ( 'P' != toupper(pszArgv[0]) &&
         'X' != toupper(pszArgv[0]) ) {
        return (FALSE);
    }
    
    return (TRUE);
}


BOOL CSyntaxLib::IsMapAttr(char chType, char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    ASSERT( 'P' == toupper(chType) || 'X' == toupper(chType) );
    
    // Is "attribute".
    if ( !stricmp(pszArgv, "I") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "IR") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "G") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "E") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "ER") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "C") ) {
        if ( 'X' == toupper(chType) ) {
            return (TRUE);
        }
        else {
            return (FALSE);
        }
    }
    else if ( !stricmp(pszArgv, "CR") ) {
        if ( 'X' == toupper(chType) ) {
            return (TRUE);
        }
        else {
            return (FALSE);
        }
    }
    else {
        return (FALSE);
    }
}


BOOL CSyntaxLib::IsRegName(char* pszRegName) const
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    
#ifdef _SERVER_NO_ABI
    char* RegName[28] = {
        "PC",   "DPTR", "ACC",  "B",    "SP",   "PSW",
        "R0",   "R1",   "R2",   "R3",   "R4",   "R5",
        "R6",   "R7",   "IE",   "IP",   "SCON", "TMOD", 
        "TH0",  "TL0",  "TH1",  "TL1",  "TCON", "T2CON",
        "P0",   "P1",   "P2",   "P3"
    };
    int nMaxReg = 28;
#endif  // _SERVER_NO_ABI

    // Is in "RegName[]".
    CString str = strupr(pszRegName);
    for ( int i= 0; i < nMaxReg; i++ ) {
        if ( str == RegName[i] ) {
            return (TRUE);
        }
    }
    return (FALSE);
}


BOOL CSyntaxLib::IsRegData(char* pszRegName, char* pszRegData) const
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    ASSERT( pszRegData );
    
    // Is "REG DATA".
    char* p = pszRegData;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    CString str = strupr(pszRegName);
    unsigned long ul = StrToVar(pszRegData);
    if ( str == "PC" || str == "DPTR" ) {
        if ( ul < 0ul || ul > 0x0FFFFul ) {
            return (FALSE);
        }
    }
    else {
        if ( ul < 0ul || ul > 0x0FFul ) {
            return (FALSE);
        }
    }
    
    return (TRUE);
}


BOOL CSyntaxLib::IsKeywordAll(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, "ALL") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}


BOOL CSyntaxLib::IsFilename(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "filename".
    if ( strlen(pszArgv) >= _MAX_PATH ) {
        return (FALSE);
    }

    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
        return (FALSE);
    }
      
    // Local driver: "..." invalid.
    // Netware driver: "..." valid.
    //if ( strstr(pszArgv, "...") ) {
    //    return (FALSE);
    //}
        
    if ( strstr(pszArgv, "\\\\") ||
         strstr(pszArgv, "//")   ||
         strstr(pszArgv, "\\/")  ||
         strstr(pszArgv, "/\\") ) {
        return (FALSE);
    }
    
    char pszDrive[_MAX_DRIVE];
    char pszDir[_MAX_DIR];
    char pszFname[_MAX_FNAME];
    char pszExt[_MAX_EXT];

    _splitpath(pszArgv, pszDrive, pszDir, pszFname, pszExt);

    //DumpText(pszDrive);
    //DumpText(pszDir);
    //DumpText(pszFname);
    //DumpText(pszExt);

    if ( strchr(pszDir, ':')   ||
         strchr(pszFname, ':') ||
         strchr(pszExt, ':') ) {
        return (FALSE);
    }
    
    if ( *pszDrive && 
         !(*pszDrive >= 'A' && *pszDrive <= 'Z') &&
         !(*pszDrive >= 'a' && *pszDrive <= 'z') ) {
        return (FALSE);
    }
    
    if ( strchr(pszFname, '.') ) {
        return (FALSE);
    }
    
    if ( !*pszFname ) {
        return (FALSE);
    }
    
    return (TRUE);
}


BOOL CSyntaxLib::IsLoadOption(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( nArgc > 2 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    int nSymbols = FALSE, nNoSymbols = FALSE;
    int nCode = FALSE, nNoCode = FALSE;
    // int nProgress = FALSE, nNoProgress = FALSE;
    int nDemand = FALSE, nNoDemand = FALSE;
    int nWarm = FALSE, nNoWarm = FALSE;
    // int nMangle = FALSE, nNoMangle = FALSE;
    int nModule = FALSE;
    int nType = FALSE;
    
    // Is "LOAd filename [option]".
    for ( i = 2; i < nArgc; i++ ) {
        CString str = strupr(pszArgv[i]);
        if ( str == "NOSYMBOLS" ) {
            nNoSymbols = TRUE;
        }
        else if ( str == "SYMBOLS" ) {
            nSymbols = TRUE;
        }
        else if ( str == "NOCODE" ) {
            nNoCode = TRUE;
        }
        else if ( str == "CODE" ) {
            nCode = TRUE;
        }
        /*
        else if ( str == "NOPROGRESS" ) {
            nNoProgress = TRUE;
        }
        else if ( str == "PROGRESS" ) {
            nProgress = TRUE;
        }
        */
        else if ( str == "NODEMAND" ) {
            nNoDemand = TRUE;
        }
        else if ( str == "DEMAND" ) {
            nDemand = TRUE;
        }
        else if ( str == "NOWARN" ) {
            nNoWarm = TRUE;
        }
        else if ( str == "WARN" ) {
            nWarm = TRUE;
        }
        /*
        else if ( str == "NOMANGLE" ) {
            nNoMangle = TRUE;
        }
        else if ( str == "MANGLE" ) {
            nMangle = TRUE;
        }
        */
        else if ( str == "MODULE" ) {
            if ( i < nArgc-1 && IsModuleName(pszArgv[i++]) ) {
                nModule = TRUE;
            }
            else {
                return (FALSE);
            }
        }
        else if ( IsMapMemType(pszArgv[i]) ) {
            if ( TRUE == nType ) {
                return (FALSE);
            }
            nType = TRUE;
        }
        else {
            return (FALSE);
        }
    }
    
    if ( nSymbols && nNoSymbols ) {
        return (FALSE);
    }
    if ( nCode && nNoCode ) {
        return (FALSE);
    }
/*    
    if ( nProgress && nNoProgress ) {
        return (FALSE);
    }
*/    
    if ( nDemand && nNoDemand ) {
        return (FALSE);
    }
/*    
    if ( nMangle && nNoMangle ) {
        return (FALSE);
    }
*/    
    if ( nWarm && nNoWarm ) {
        return (FALSE);
    }

/*
    if ( nModule && nNoSymbols ) {
        return (FALSE);
    }
    if ( nNoCode && nNoSymbols ) {
        return (FALSE);
    }
*/    
    
    return (TRUE);
}


BOOL CSyntaxLib::IsModuleName(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "module_name".
    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, ':') ||
         strchr(pszArgv, '\\')||
         strchr(pszArgv, '/') ||
         strchr(pszArgv, '.') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLib::IsArgument(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "argument ...".
    return (TRUE);
}


BOOL CSyntaxLib::IsBackLevel(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "@n".
    if ( '@' != pszArgv[0] ) {
        return (FALSE);
    }
    char* p = pszArgv+1;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+1);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsVariableName(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
        return (FALSE);
    }

//    if ( !iscsymf(pszArgv[1]) && '?' != pszArgv[1] ) {
//        return (FALSE);
//    }

    if ( !iscsymf(pszArgv[1]) ) {
        return (FALSE);
    }

    if ( '_' == pszArgv[1] && strlen(pszArgv) < 3 ) {
        return (FALSE);
    }
    
    BOOL isUnderscore = FALSE;
    char* p = pszArgv+1;
    if ( '_' == *p ) {
        isUnderscore = TRUE;
    }
            
    while ( *p ) {
        if ( !iscsym(*p) && '?' != *p ) {
            return (FALSE);
        }
        else if ( '_' != *(p++) ) {
            isUnderscore = FALSE;
        }
    }

    if ( isUnderscore ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLib::IsSymbolName(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
        return (FALSE);
    }

    return (TRUE);
}


BOOL CSyntaxLib::IsDataBit(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1 0...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( '0' != *p && '1' != *p && ' ' != *p ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataBit().


BOOL CSyntaxLib::IsDataLong(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "12345678...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/4 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataLong().


BOOL CSyntaxLib::IsDataWord(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1234...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/2 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataWord().


BOOL CSyntaxLib::IsData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "x xx ...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsData().


BOOL CSyntaxLib::IsString(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "string".
    if ( strlen(pszArgv) > MAX_FILL_SIZE + 2 || strlen(pszArgv) < 3 ) {
        return (FALSE);
    }

    if ( '\"' != *pszArgv || '\"' != *(pszArgv+strlen(pszArgv)-1) ) {
        return (FALSE);
    }

    char* p = pszArgv;
    while ( *p ) {
        if ( *p < 0x020 || *p > 0x07E ) {
            return (FALSE);
        }
        /*
        if ( !isalnum(*p) && ('\"' != *p) && (' ' != *p) ) {
            return (FALSE);
        }
        */
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsString().


BOOL CSyntaxLib::IsBitRange(char* pszAddr, char* pszData) const
{
    // Assertion of the input parameters.
    ASSERT( pszAddr && pszData );
    
    // Check the Data field range.
    char* p = pszData;
    int nCount = 0;
    while ( *p ) {
        if ( ' ' == *p ) {
            nCount++;
        }
        p++;
    }

    // Convert symbol to standard address format.
    char szAddr[256];
    strcpy(szAddr, pszAddr);
    if ( '#' == szAddr[0] ) {
        SymbolToAddr(pszAddr, szAddr);
    }

    char* p1;
    if ( ':' == szAddr[1] ) {
        if ( 'B' != szAddr[0] && 'b' != szAddr[0] ) {
            return (FALSE);
        }
        p1 = szAddr + 2;
    }
    else {
        p1 = szAddr;
    }

    if ( m_ulMaxTypeB - StrToVar(p1) + 1 < (unsigned long)nCount ) {
        return (FALSE);
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsBitRange().


BOOL CSyntaxLib::IsDataRange(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 3 && nArgc <= 5 );
    
    // Check the Data field range.
    switch ( nArgc ) {
        char* p;
        char* p1;
        char* p2;
        int nCount;
        char szAddr1[256];
        char szAddr2[256];
        unsigned long ul;
        case 3:
            nCount = 0;
            p = pszArgv[2];
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            // Convert symbol to standard address format.
            strcpy(szAddr1, pszArgv[1]);
            if ( '#' == szAddr1[0] ) {
                SymbolToAddr(pszArgv[1], szAddr1);
            }
            if ( ':' == szAddr1[1] ) {
                if ( 'P' == szAddr1[0] || 'p' == szAddr1[0] ) {
                    ul = m_ulMaxTypeP;
                }
                else if ( 'X' == szAddr1[0] || 'x' == szAddr1[0] ) {
                    ul = m_ulMaxTypeX;
                }
                else if ( 'I' == szAddr1[0] || 'i' == szAddr1[0] ) {
                    ul = m_ulMaxTypeI;
                }
                else if ( 'R' == szAddr1[0] || 'r' == szAddr1[0] ) {
                    ul = m_ulMaxTypeR;
                }
                else if ( 'B' == szAddr1[0] || 'b' == szAddr1[0] ) {
                    ul = m_ulMaxTypeB;
                }
                p1 = szAddr1 + 2;
            }
            else {
                ul = m_ulMaxTypeX;
                p1 = szAddr1;
            }
            if ( ul - StrToVar(p1) + 1 < (unsigned long)nCount ) {
                return (FALSE);
            }
            break;
        case 4:
            nCount = 0;
            p = pszArgv[3];
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            // Convert symbol to standard address format.
            strcpy(szAddr1, pszArgv[1]);
            if ( '#' == szAddr1[0] ) {
                SymbolToAddr(pszArgv[1], szAddr1);
            }
            strcpy(szAddr2, pszArgv[2]);
            if ( '#' == szAddr2[0] ) {
                SymbolToAddr(pszArgv[2], szAddr2);
            }
            p1 = (':' == szAddr1[1]) ? szAddr1+2 : szAddr1;
            p2 = (':' == szAddr2[1]) ? szAddr2+2 : szAddr2;
            if ( StrToVar(p2)-StrToVar(p1)+1 < (unsigned long)nCount ) {
                return (FALSE);
            }
            break;
        case 5:
            nCount = 0;
            p = pszArgv[4];
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            if ( StrToVar(pszArgv[3]) < (unsigned long) nCount ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsDataRange().


BOOL CSyntaxLib::IsDataRange(int nArgc, char* pszArgv[], int nDigit) const
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    ASSERT( 1 == nDigit || 2 == nDigit || 4 == nDigit );
    
    // Check the Data field range.
    int nCount = 0;
    char* p = pszArgv[2];
    while ( *p ) {
        if ( ' ' == *p ) {
            nCount++;
        }
        p++;
    }

    // Convert symbol to standard address format.
    char szAddr1[256];
    strcpy(szAddr1, pszArgv[1]);
    if ( '#' == szAddr1[0] ) {
        SymbolToAddr(pszArgv[1], szAddr1);
    }

    char* p1;
    unsigned long ul;

    if ( ':' == szAddr1[1] ) {
        if ( 'P' == szAddr1[0] || 'p' == szAddr1[0] ) {
            ul = m_ulMaxTypeP;
        }
        else if ( 'X' == szAddr1[0] || 'x' == szAddr1[0] ) {
            ul = m_ulMaxTypeX;
        }
        else if ( 'I' == szAddr1[0] || 'i' == szAddr1[0] ) {
            ul = m_ulMaxTypeI;
        }
        else if ( 'R' == szAddr1[0] || 'r' == szAddr1[0] ) {
            ul = m_ulMaxTypeR;
        }
        else if ( 'B' == szAddr1[0] || 'b' == szAddr1[0] ) {
            ul = m_ulMaxTypeB;
        }
        p1 = szAddr1 + 2;
    }
    else {
        ul = m_ulMaxTypeX;
        p1 = szAddr1;
    }

    if ( ul - StrToVar(p1) + 1 < (unsigned long)(nCount * nDigit) ) {
        return (FALSE);
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataRange().


BOOL CSyntaxLib::IsStringRange(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 4 && nArgc <= 6 );
    
    // Check the Data field range.
    switch ( nArgc ) {
        char* p1;
        char* p2;
        char szAddr1[256];
        char szAddr2[256];
        case 4:
            // Convert symbol to standard address format.
            strcpy(szAddr1, pszArgv[1]);
            if ( '#' == szAddr1[0] ) {
                SymbolToAddr(pszArgv[1], szAddr1);
            }
            
            strcpy(szAddr2, pszArgv[2]);
            if ( '#' == szAddr2[0] ) {
                SymbolToAddr(pszArgv[2], szAddr2);
            }

            p1 = (':' == szAddr1[1]) ? szAddr1+2 : szAddr1;
            p2 = (':' == szAddr2[1]) ? szAddr2+2 : szAddr2;

            if ( StrToVar(p2) - StrToVar(p1) + 1 < strlen(pszArgv[3]) - 2 ) {
                return (FALSE);
            }

            break;
        case 5:
            if ( IsKeywordInsensitive(pszArgv[3]) ) {
                // Convert symbol to standard address format.
                strcpy(szAddr1, pszArgv[1]);
                if ( '#' == szAddr1[0] ) {
                    SymbolToAddr(pszArgv[1], szAddr1);
                }
                
                strcpy(szAddr2, pszArgv[2]);
                if ( '#' == szAddr2[0] ) {
                    SymbolToAddr(pszArgv[2], szAddr2);
                }
    
                p1 = (':' == szAddr1[1]) ? szAddr1+2 : szAddr1;
                p2 = (':' == szAddr2[1]) ? szAddr2+2 : szAddr2;

                if ( StrToVar(p2)-StrToVar(p1)+1 < strlen(pszArgv[4])-2 ) {
                    return (FALSE);
                }
            }
            else {
                if ( StrToVar(pszArgv[3]) < strlen(pszArgv[4]) - 2 ) {
                    return (FALSE);
                }
            }
            break;
        case 6:
            if ( StrToVar(pszArgv[3]) < strlen(pszArgv[5]) - 2 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsStringRange().


BOOL CSyntaxLib::IsKeywordInsensitive(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "insensitive".
    if ( 0 == stricmp(pszArgv, "INSENSITIVE") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordInsensitive().


BOOL CSyntaxLib::IsCaseStringRange(int nArgc, char* pszArgv[]) const
{
    // Assertion of the input parameters.
    ASSERT( 5 == nArgc || 6 == nArgc );
    
    // Check the Data field range.
    switch ( nArgc ) {
        case 5:
            if ( StrToVar(pszArgv[3]+2) - StrToVar(pszArgv[2]+2) + 1 < 
                 strlen(pszArgv[4]) - 2 ) {
                return (FALSE);
            }
            break;
        case 6:
            if ( StrToVar(pszArgv[4]) < strlen(pszArgv[5]) - 2 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsCaseStringRange().


BOOL CSyntaxLib::IsKeywordRun(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Run".
    if ( 0 == stricmp(pszArgv, "RUN") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordRun().


BOOL CSyntaxLib::IsKeywordFrom(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, "FROM") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordFrom().


BOOL CSyntaxLib::IsKeywordTill(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, "TILL") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordTill().


BOOL CSyntaxLib::IsKeywordOver(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "OVER") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordOver().


BOOL CSyntaxLib::IsKeywordForever(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "FOREVER") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordForever().


BOOL CSyntaxLib::IsKeywordRet(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "RET") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordRet().


BOOL CSyntaxLib::IsKeywordCall(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "CALL") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordCall().


BOOL CSyntaxLib::IsStepCount(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "FFFF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsStepCount().


BOOL CSyntaxLib::IsAddrData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "FFFF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsAddrData().


BOOL CSyntaxLib::IsKeywordInstruction(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "instruction".
    return ( 0 == stricmp(pszArgv, "INSTRUCTION") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordInstruction().


BOOL CSyntaxLib::IsKeywordStatement(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "statement".
    return ( 0 == stricmp(pszArgv, "STATEMENT") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordStatement().


BOOL CSyntaxLib::IsKeywordLine(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Line".
    return ( 0 == stricmp(pszArgv, "LINE") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLine().


BOOL CSyntaxLib::IsKeywordWith(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "With".
    return ( 0 == stricmp(pszArgv, "WITH") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordWith().


BOOL CSyntaxLib::IsKeywordClear(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Clear".
    return ( 0 == stricmp(pszArgv, "CLEAR") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordClear().


BOOL CSyntaxLib::IsEventID(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "1", "2" or "3".
    if ( 0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsEventID().


BOOL CSyntaxLib::IsKeywordHigh(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "High".
    return ( 0 == stricmp(pszArgv, "HIGH") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordHigh().


BOOL CSyntaxLib::IsKeywordLow(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Low".
    return ( 0 == stricmp(pszArgv, "LOW") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLow().


BOOL CSyntaxLib::IsKeywordRange(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Range".
    return ( 0 == stricmp(pszArgv, "RANGE") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordRange().


BOOL CSyntaxLib::IsWildcardAddr(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Binary or Hexadecimal wildcard code.
    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) ) {
        // Binary code.
        if ( 17 != strlen(pszArgv) ) {
            return (FALSE);
        }
        for ( int i = 0; i < 17-1; i++ ) {
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 17; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code.
        if ( 4 != strlen(pszArgv) ) {
            return (FALSE);
        }
        char* p = pszArgv;
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        }
        for ( int i = 0; i < 4; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }

}   // End of CSyntaxLib::IsWildcardAddr().


BOOL CSyntaxLib::IsWildcardData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Binary or Hexadecimal wildcard code.
    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) ) {
        // Binary code.
        if ( 9 != strlen(pszArgv) ) {
            return (FALSE);
        }
        for ( int i = 0; i < 9-1; i++ ) {
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 9; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code.
        if ( 2 != strlen(pszArgv) ) {
            return (FALSE);
        }
        char* p = pszArgv;
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        }
        for ( int i = 0; i < 2; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }

}   // End of CSyntaxLib::IsWildcardData().


BOOL CSyntaxLib::IsEventData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "FF".
    if ( strlen(pszArgv) < 1 || strlen(pszArgv) > 2 ) {
        return (FALSE);
    }
    while ( *pszArgv ) {
        if ( !isxdigit(*(pszArgv++)) ) {
            return (FALSE);
        }
    }
    return (TRUE);

}   // End of CSyntaxLib::IsEventData().


BOOL CSyntaxLib::IsListOption(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Check "SOURCE", "ASSEMBLE", "MIXED" or "MODULE".
    if ( 0 != stricmp(pszArgv, "SOURCE") &&
         0 != stricmp(pszArgv, "ASSEMBLE") &&
         0 != stricmp(pszArgv, "MIXED") &&
         0 != stricmp(pszArgv, "MODULE") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsListOption().


BOOL CSyntaxLib::IsListFrame(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "7FFF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x07FFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsListFrame().


BOOL CSyntaxLib::IsKeywordTrace(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "TRace".
    return ( 0 == stricmp(pszArgv, "TRACE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordTrace().


BOOL CSyntaxLib::IsKeywordTimer(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "TImer".
    return ( 0 == stricmp(pszArgv, "TIMER") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordTimer().


BOOL CSyntaxLib::IsKeywordOn(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ON".
    return ( 0 == stricmp(pszArgv, "ON") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordOn().


BOOL CSyntaxLib::IsKeywordOff(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "OFf".
    return ( 0 == stricmp(pszArgv, "OFF") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordOff().


BOOL CSyntaxLib::IsEventSequence(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ev1 and ev2...".
    const int nMaxSeq = 40;
    char* pszEventSequence[nMaxSeq] = {
        "ev1 ",
        "ev2 ",
        "ev3 ",
        "ev1 and ev2 ",
        "ev1 and ev3 ",
        "ev2 and ev1 ",
        "ev2 and ev3 ",
        "ev3 and ev1 ",
        "ev3 and ev2 ",
        "ev1 or ev2 ",
        "ev1 or ev3 ",
        "ev2 or ev1 ",
        "ev2 or ev3 ",
        "ev3 or ev1 ",
        "ev3 or ev2 ",
        "ev1 and ev2 and ev3 ",
        "ev1 and ev3 and ev2 ",
        "ev2 and ev1 and ev3 ",
        "ev2 and ev3 and ev1 ",
        "ev3 and ev1 and ev2 ",
        "ev3 and ev2 and ev1 ",
        "ev1 or ev2 or ev3 ",
        "ev1 or ev3 or ev2 ",
        "ev2 or ev1 or ev3 ",
        "ev2 or ev3 or ev1 ",
        "ev3 or ev1 or ev2 ",
        "ev3 or ev2 or ev1 ",
        "ev1 and ev2 or ev3 ",
        "ev1 and ev3 or ev2 ",
        "ev2 and ev1 or ev3 ",
        "ev2 and ev3 or ev1 ",
        "ev3 and ev1 or ev2 ",
        "ev3 and ev2 or ev1 ",
        "ev1 or ev2 and ev3 ",
        "ev1 or ev3 and ev2 ",
        "ev2 or ev1 and ev3 ",
        "ev2 or ev3 and ev1 ",
        "ev3 or ev1 and ev2 ",
        "ev3 or ev2 and ev1 ",
        ""
    };
    
    for ( int i = 0; i < nMaxSeq; i++ ) {
        if ( 0 == stricmp(pszArgv, pszEventSequence[i]) ) {
            return (TRUE);
        }
    }
    return (FALSE);

}   // End of CSyntaxLib::IsEventSequence().


BOOL CSyntaxLib::IsKeywordReset(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Reset".
    return ( 0 == stricmp(pszArgv, "RESET") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordReset().


BOOL CSyntaxLib::IsKeywordEa(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Ea".
    return ( 0 == stricmp(pszArgv, "EA") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordEa().


BOOL CSyntaxLib::IsKeywordEnable(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Enable".
    return ( 0 == stricmp(pszArgv, "ENABLE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordEnable().


BOOL CSyntaxLib::IsKeywordDisable(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Disable".
    return ( 0 == stricmp(pszArgv, "DISABLE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordDisable().


BOOL CSyntaxLib::IsKeywordBit(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Bit".
    return ( 0 == stricmp(pszArgv, "BIT") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordBit().


BOOL CSyntaxLib::IsKeywordByte(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Byte".
    return ( 0 == stricmp(pszArgv, "BYTE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordByte().


BOOL CSyntaxLib::IsCpuModule(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "80C32".
    return ( 0 == stricmp(pszArgv, "80C32") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsCpuModule().


BOOL CSyntaxLib::IsPort(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "0123".
    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsPort().


BOOL CSyntaxLib::IsBitNo(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "01234567".
    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ||
         0 == stricmp(pszArgv, "4") ||
         0 == stricmp(pszArgv, "5") ||
         0 == stricmp(pszArgv, "6") ||
         0 == stricmp(pszArgv, "7") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsBitNo().


BOOL CSyntaxLib::IsBitData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "0|1".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x01ul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsBitData().


BOOL CSyntaxLib::IsByteData(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "FF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsByteData().


BOOL CSyntaxLib::IsKeywordGlobal(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "GLOBAL".
    return ( 0 == stricmp(pszArgv, "GLOBAL") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordGlobal().


BOOL CSyntaxLib::IsLineNo(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
        return (FALSE);
    }

    char* p = pszArgv + 1;
    while ( *p ) {
        if ( !isdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    return (TRUE);

}   // End of CSyntaxLib::IsLineNo().


BOOL CSyntaxLib::IsKeywordClose(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Close".
    return ( 0 == stricmp(pszArgv, "CLOSE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordClose().


BOOL CSyntaxLib::IsKeywordAppend(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Append".
    return ( 0 == stricmp(pszArgv, "APPEND") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordAppend().


BOOL CSyntaxLib::IsKeywordCommand(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Command".
    return ( 0 == stricmp(pszArgv, "COMMAND") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordCommand().


BOOL CSyntaxLib::IsKeywordLv1(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv1".
    return ( 0 == stricmp(pszArgv, "LV1") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordLv1().


BOOL CSyntaxLib::IsKeywordLv2(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv2".
    return ( 0 == stricmp(pszArgv, "LV2") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordLv2().


BOOL CSyntaxLib::IsKeywordForward(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Forward".
    return ( 0 == stricmp(pszArgv, "FORWARD") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordForward().


BOOL CSyntaxLib::IsKeywordBackward(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Backward".
    return ( 0 == stricmp(pszArgv, "BACKWARD") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordBackward().


BOOL CSyntaxLib::IsKeywordCenter(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Center".
    return ( 0 == stricmp(pszArgv, "CENTER") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordCenter().


BOOL CSyntaxLib::IsKeywordDelay(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Delay".
    return ( 0 == stricmp(pszArgv, "DELAY") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordDelay().


BOOL CSyntaxLib::IsKeywordThen(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Then".
    return ( 0 == stricmp(pszArgv, "THEN") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordThen().


BOOL CSyntaxLib::IsKeywordModule(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Module".
    return ( 0 == stricmp(pszArgv, "MODULE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordModule().


BOOL CSyntaxLib::IsCommand(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "command".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isalpha(*pszArgv) ) {
            return (FALSE);
        }
        else {
            p++;
        }
    }
    return (TRUE);

}   // End of CSyntaxLib::IsCommand().


BOOL CSyntaxLib::IsKeywordMonitor(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Module".
    return ( 0 == stricmp(pszArgv, "MONITOR") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordMonitor().


BOOL CSyntaxLib::IsGoMonitorTimer(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "FF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsMonitorTimer().


BOOL CSyntaxLib::IsKeywordControlOption(char* pszArgv) const
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Get control option keyword.
    CString strReset, strEa, strEben;
    ::GetControlOption(strReset,strEa,strEben);
    
    // Is "Reset|Ea|Eben".
    if ( !strReset.IsEmpty() && !strReset.CompareNoCase(pszArgv) ) {
        return (TRUE);
    }
    else if ( !strEa.IsEmpty() && !strEa.CompareNoCase(pszArgv) ) {
        return (TRUE);
    }
    else if ( !strEben.IsEmpty() && !strEben.CompareNoCase(pszArgv) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsKeywordControlOption().

//////////////////////////////// End of File ////////////////////////////////
