
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SYNLIB.H__   1.29   02 Apr 1996 09:26:46   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SYNLIB.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:26:46   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:30:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:51:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:18   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:14   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:42   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:40   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:48   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:30   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:44   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:38   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:34   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:52   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:08:14   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:45:42   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:06   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:50:22   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:22   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:26   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:56   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:08   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.H
//
//  Description: The header file for the class: CSyntaxLib.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLib.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNLIB_
#define _SYNLIB_

#include "syntest.h"

/////////////////////////////////////////////////////////////////////////////
// CSyntaxLib class.
class CSyntaxLib : public CSyntaxTest
{
// Construction & Destruction.
public:
    CSyntaxLib();
    ~CSyntaxLib();
    
// Member variables.
private:
    // Local macro definition.
    enum { MAX_FILL_SIZE = 32 };
    
    // Maximum of the memory type.
    unsigned long m_ulMaxTypeP;
    unsigned long m_ulMaxTypeX;
    unsigned long m_ulMaxTypeI;
    unsigned long m_ulMaxTypeR;
    unsigned long m_ulMaxTypeB;
    
// Implementations.
protected:
    unsigned long StrToVar(char* pszStr) const;
    void VarToStr(unsigned long ulVar, char* pszStr) const;

    void SymbolToAddr(char* pszSymbol, char* pszAddr) const;
    void SymbolToAddr(char* pszSymbol, char* pszAddr, char chType) const;

    // Syntax check lib routine.
    BOOL IsAddr(char* pszArgv) const;
    BOOL IsPAddr(char* pszArgv) const;
    BOOL IsPAddrDefault(char* pszArgv) const;
    BOOL IsXAddr(char* pszArgv) const;
    BOOL IsXAddrDefault(char* pszArgv) const;
    BOOL IsIAddr(char* pszArgv) const;
    BOOL IsIAddrDefault(char* pszArgv) const;
    BOOL IsRAddr(char* pszArgv) const;
    BOOL IsRAddrDefault(char* pszArgv) const;
    BOOL IsBAddr(char* pszArgv) const;
    BOOL IsBAddrDefault(char* pszArgv) const;

    BOOL IsAddrLen(char* pszArgv) const;
    BOOL IsKeywordLength(char* pszArgv) const;
    BOOL IsLengthRange(char* pszAddr, char* pszLen) const;
    BOOL IsLengthRange(char* pszAddr, char* pszLen, char* pszTarget) const;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2) const;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2, char* pszAddr3) const;
    
    BOOL IsMapStartAddr(char* pszArgv) const;
    BOOL IsMapEndAddr(char* pszArgv) const;
    BOOL IsMapAddrLen(char* pszArgv) const;
    BOOL IsMapMemType(char* pszArgv) const;
    BOOL IsMapAttr(char chType, char* pszArgv) const;
    
    BOOL IsRegName(char* pszRegName) const;
    BOOL IsRegData(char* pszRegName, char* pszRegData) const;
    
    BOOL IsKeywordAll(char* pszArgv) const;
    
    BOOL IsFilename(char* pszArgv) const;
    BOOL IsLoadOption(int nArgc, char* pszArgv[]) const;
    BOOL IsModuleName(char* pszArgv) const;
    
    BOOL IsArgument(char* pszArgv) const;
    BOOL IsBackLevel(char* pszArgv) const;
    BOOL IsVariableName(char* pszArgv) const;
    BOOL IsSymbolName(char* pszArgv) const;
    
    BOOL IsData(char* pszArgv) const;
    BOOL IsDataBit(char* pszArgv) const;
    BOOL IsDataWord(char* pszArgv) const;
    BOOL IsDataLong(char* pszArgv) const;
    BOOL IsString(char* pszArgv) const;
    BOOL IsDataRange(int nArgc, char* pszArgv[]) const;
    BOOL IsDataRange(int nArgc, char* pszArgv[], int nDigit) const;
    BOOL IsStringRange(int nArgc, char* pszArgv[]) const;
    
    BOOL IsKeywordInsensitive(char* pszArgv) const;
    BOOL IsCaseStringRange(int nArgc, char* pszArgv[]) const;
    
    BOOL IsKeywordRun(char* pszArgv) const;
    BOOL IsKeywordFrom(char* pszArgv) const;
    BOOL IsKeywordTill(char* pszArgv) const;
    
    BOOL IsKeywordOver(char* pszArgv) const;
    BOOL IsKeywordForever(char* pszArgv) const;
    BOOL IsKeywordRet(char* pszArgv) const;
    BOOL IsKeywordCall(char* pszArgv) const;
    BOOL IsStepCount(char* pszArgv) const;
    BOOL IsAddrData(char* pszArgv) const;
    
    BOOL IsKeywordInstruction(char* pszArgv) const;
    BOOL IsKeywordStatement(char* pszArgv) const;
    BOOL IsKeywordLine(char* pszArgv) const;
    
    BOOL IsKeywordWith(char* pszArgv) const;
    BOOL IsKeywordClear(char* pszArgv) const;
    
    BOOL IsEventID(char* pszArgv) const;
    BOOL IsKeywordHigh(char* pszArgv) const;
    BOOL IsKeywordLow(char* pszArgv) const;
    BOOL IsKeywordRange(char* pszArgv) const;
    BOOL IsWildcardAddr(char* pszArgv) const;
    BOOL IsWildcardData(char* pszArgv) const;
    BOOL IsEventData(char* pszArgv) const;
    
    BOOL IsListOption(char* pszArgv) const;
    BOOL IsListFrame(char* pszArgv) const;
    
    BOOL IsKeywordTrace(char* pszArgv) const;
    BOOL IsKeywordTimer(char* pszArgv) const;
    BOOL IsKeywordOn(char* pszArgv) const;
    BOOL IsKeywordOff(char* pszArgv) const;
    BOOL IsEventSequence(char* pszArgv) const;

    BOOL IsKeywordReset(char* pszArgv) const;
    BOOL IsKeywordEa(char* pszArgv) const;
    BOOL IsKeywordEnable(char* pszArgv) const;
    BOOL IsKeywordDisable(char* pszArgv) const;
    BOOL IsKeywordBit(char* pszArgv) const;
    BOOL IsKeywordByte(char* pszArgv) const;

    BOOL IsCpuModule(char* pszArgv) const;
    BOOL IsPort(char* pszArgv) const;
    BOOL IsBitNo(char* pszArgv) const;
    BOOL IsBitData(char* pszArgv) const;
    BOOL IsBitRange(char* pszAddr, char* pszData) const;
    BOOL IsByteData(char* pszArgv) const;
    
    BOOL IsKeywordGlobal(char* pszArgv) const;
    BOOL IsLineNo(char* pszArgv) const;

    BOOL IsKeywordClose(char* pszArgv) const;
    BOOL IsKeywordAppend(char* pszArgv) const;
    BOOL IsKeywordCommand(char* pszArgv) const;

    BOOL IsKeywordLv1(char* pszArgv) const;
    BOOL IsKeywordLv2(char* pszArgv) const;
    BOOL IsKeywordForward(char* pszArgv) const;
    BOOL IsKeywordBackward(char* pszArgv) const;
    BOOL IsKeywordCenter(char* pszArgv) const;
    BOOL IsKeywordDelay(char* pszArgv) const;
    BOOL IsKeywordThen(char* pszArgv) const;
    
    BOOL IsKeywordModule(char* pszArgv) const;
    
    BOOL IsCommand(char* pszArgv) const;
    
    BOOL IsKeywordMonitor(char* pszArgv) const;
    BOOL IsGoMonitorTimer(char* pszArgv) const;

    BOOL IsKeywordControlOption(char* pszArgv) const;

};  // End of class: CSyntaxLib.

#endif
//////////////////////////////// End of File ////////////////////////////////
