
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/SYNTAX.CPP   1.29   02 Apr 1996 09:23:10   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/SYNTAX.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:23:10   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:51:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:30   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:30:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:20   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:20   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:28   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:20   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:18   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:46   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:14   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:14   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:00   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:12:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:40   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:14   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:56   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:30   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:30:02   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:26   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:04:06   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:46:04   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:24   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:40   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:10   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:20   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:51:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:26   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:58   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:08   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNTAX.CPP
//
//  Description: The implementation file for the class: CSyntaxCheck.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxCheck.
//      2. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "shlcom.h"

#include "syntax.h"
#include <ctype.h>


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.

// Maximum number of command.
#ifdef _CHEN_
    int nMaxCmdNo = 54;
#else
    int nMaxCmdNo = 53;
#endif


/////////////////////////////////////////////////////////////////////////////
// Static variables.
/*struct tagCmdTable {
    char* pszCommandName;
    int nMinKeyword;
}*/
tagCmdTable CommandRecord[] = {
    "Assemble",     1,
    "Bit",          1,
    "BReakpoint",   2,
    "BYte",         2,
    "Checksum",     1,
    "CLear",        2,
    "COmpare",      2,
    "CONtrol",      3,
    "COPy",         3,
//    "cpu",          2,
    "CReate",       2,
    "CYcle",        2,
    "Delete",       1,
    "DIsassemble",  2,
    "Event",        1,
    "EV1",          3,
    "EV2",          3,
    "EV3",          3,
    "Fill",         1,
    "Go",           1,
    "HAlt",         2,
    "Help",         1,
    "IDentify",     2,
    "Include",      1,
    "INPort",       3,
    "Jump",         1,
    "Level",        1,
    "LV1",          3,
    "LV2",          3,
    "LIst",         2,
    "LOad",         2,
    "LOG",          3,
    "LONg",         3,
    "MAp",          2,
    "Memory",       1,
    "Outport",      1,
//    "Patch",        1,
    "POrt",         2,
    "Qualify",      1,
//    "quit",         1,
    "QUEry",        3,
    "Register",     1,
    "RESet",        3,
    "SEarch",       2,
    "SRecall",      2,
    "SSave",        2,
    "Step",         1,
//    "stepoption",   5,
    "SYmbol",       2,
    "TEst",         2,
    "TImer",        2,
    "TRAce",        3,
    "Trigger",      1,
    "Upload",       1,
    "Verify",       1,
//    "back",         2,
//    "module",       2,
//    "watch",        1,

#ifdef _CHEN_
    "?",            1,
#endif  // _CHEN_

#ifdef _GATES
    "count",        5,
    "line",         4,
    "statement",    9,
    "void",         4,
    "type",         4,
#endif  // Gates

    "Word",         1,
    "",             0
};


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isRunInclude;   // Defined in TSTINC.CPP


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void ShowLine(char* pszBuffer);
void CommandProcess(char* pchBuf, int nLen);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.

// Defined in TSTLOG.CPP
void TstLogInfo(char* pchBuf, int nLen=0);

// Defined in TSTINC.CPP
void TstReadOneInc(char* pszBuf);
void TstFreeInclude(void);
BOOL TstIsInnerCommand(char* pszIncLine);

// Defined in TSTTEMP.CPP
void TstCreateStock(void);
void TstDestroyStock(void);
void TstOpenStock(void);
void TstCloseStock(void);
void TstAppendStock(char* pszPrompt, char* pszResult);

// Defined in UICOM.CPP
extern void ShlShowLine(char * pch, int nLen);
extern int TestKey(WORD wKey);

// Shell commands.
extern void AssembleCmd(int nArgc, char* pszArgv[]);
extern void BitCmd(int nArgc, char* pszArgv[]);
extern void BreakpointCmd(int nArgc, char* pszArgv[]);
extern void ByteCmd(int nArgc, char* pszArgv[]);
extern void ChecksumCmd(int nArgc, char* pszArgv[]);
extern void ClearCmd(int nArgc, char* pszArgv[]);
extern void CompareCmd(int nArgc, char* pszArgv[]);
extern void ControlCmd(int nArgc, char* pszArgv[]);
extern void CopyCmd(int nArgc, char* pszArgv[]);
// extern void CpuCmd(int nArgc, char* pszArgv[]);
extern void CycleCmd(int nArgc, char* pszArgv[]);
extern void DisassembleCmd(int nArgc, char* pszArgv[]);
extern void EventCmd(int nArgc, char* pszArgv[]);
extern void Ev1Cmd(int nArgc, char* pszArgv[]);
extern void Ev2Cmd(int nArgc, char* pszArgv[]);
extern void Ev3Cmd(int nArgc, char* pszArgv[]);
extern void FillCmd(int nArgc, char* pszArgv[]);
extern void GoCmd(int nArgc, char* pszArgv[]);
extern void HaltCmd(int nArgc, char* pszArgv[]);
extern void HelpCmd(int nArgc, char* pszArgv[]);
extern void IdentifyCmd(int nArgc, char* pszArgv[]);
extern void IncludeCmd(int nArgc, char* pszArgv[]);
extern void InportCmd(int nArgc, char* pszArgv[]);
extern void JumpCmd(int nArgc, char* pszArgv[]);
extern void LevelCmd(int nArgc, char* pszArgv[]);
extern void Lv1Cmd(int nArgc, char* pszArgv[]);
extern void Lv2Cmd(int nArgc, char* pszArgv[]);
extern void ListCmd(int nArgc, char* pszArgv[]);
extern void LogCmd(int nArgc, char* pszArgv[]);
extern void LongCmd(int nArgc, char* pszArgv[]);
extern void MapCmd(int nArgc, char* pszArgv[]);
extern void MemoryCmd(int nArgc, char* pszArgv[]);
extern void OutportCmd(int nArgc, char* pszArgv[]);
extern void PatchCmd(int nArgc, char* pszArgv[]);
extern void PortCmd(int nArgc, char* pszArgv[]);
extern void QualifyCmd(int nArgc, char* pszArgv[]);
// extern void QuitCmd(int nArgc, char* pszArgv[]);
extern void RegisterCmd(int nArgc, char* pszArgv[]);
extern void ResetCmd(int nArgc, char* pszArgv[]);
extern void SearchCmd(int nArgc, char* pszArgv[]);
extern void StepCmd(int nArgc, char* pszArgv[]);
extern void StepoptionCmd(int nArgc, char* pszArgv[]);
extern void TestCmd(int nArgc, char* pszArgv[]);
extern void TimerCmd(int nArgc, char* pszArgv[]);
extern void TraceCmd(int nArgc, char* pszArgv[]);
extern void TriggerCmd(int nArgc, char* pszArgv[]);
extern void UploadCmd(int nArgc, char* pszArgv[]);
extern void VerifyCmd(int nArgc, char* pszArgv[]);
extern void WordCmd(int nArgc, char* pszArgv[]);
// extern void BackCmd(int nArgc, char* pszArgv[]);
extern void CreateCmd(int nArgc, char* pszArgv[]);
extern void DeleteCmd(int nArgc, char* pszArgv[]);
extern void LoadCmd(int nArgc, char* pszArgv[]);
extern void ModuleCmd(void);
extern void QueryCmd(int nArgc, char* pszArgv[]);
extern void SsaveCmd(int nArgc, char* pszArgv[]);
extern void SrecallCmd(int nArgc, char* pszArgv[]);
extern void SymbolCmd(int nArgc, char* pszArgv[]);
// extern void WatchCmd(int nArgc, char* pszArgv[]);

#ifdef _CHEN_
    void CalculateCmd(int nArgc, char* pszArgv[]);
#endif  // _CHEN_

#ifdef _GATES
    extern void CountCmd(int nArgc, char* pszArgv[]);
    extern void LineCmd(int nArgc, char* pszArgv[]);
    extern void StatementCmd(int nArgc, char* pszArgv[]);
    extern void VoidCmd(int nArgc, char* pszArgv[]);
    extern void TypeCmd(int nArgc, char* pszArgv[]);
#endif  // _GATES
    

// Defined in UICOM.CPP
void MarkPC(void);
void RepaintSource(void);
void RepaintCPU(void);
void RepaintMemory(void);
void RepaintBMemory(void);
void RepaintTrace(void);
void RepaintStack(void);
void RepaintVariable(void);

void OnEmulation(void);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CommandProcess().
//
//  Description: The shell of the syntax checking kernel.
//
//  Input:  pchEditBuf - The line editor buffer.
//          nLen - The number of the characters in the line editor buffer.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CommandProcess(char* pchBuf, int nLen)
{
    // Allocate two buffers.
    char* pszIncBuf = new char[256+7];
    if ( !pszIncBuf ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    char* pszTemp = new char[256];
    if ( !pszTemp ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        delete []pszIncBuf;
        return;
    }

    // Include loop.
    do {
        // Set the Include input buffer.
        if ( isRunInclude ) {
            // Create the Include stock.
            TstCreateStock();
            // Detect the Ctrl-Break key instead of ESC key.
            if ( 1 == TestKey(VK_ESCAPE) ) {
                ShowLine("Include file is aborted by user.");
                nAsmFlag = 0;
                goto Exit;
            }
            // Initial the allocated buffer.
            memset(pszIncBuf, 0, sizeof(pszIncBuf));
            memset(pszTemp, 0, sizeof(pszTemp));
            // Read one line from the Include file.
            TstReadOneInc(pszTemp);
            nLen = strlen(pszTemp);
            if ( nLen > 0 ) {
                if ( '\n' == *(pszTemp+nLen-1) ) {
                    nLen -= 1;
                    *(pszTemp+nLen) = 0;
                }
            }
            // Link Command & Prompt.
            if ( 0 == nAsmFlag ) {
                nShellPrompt = PMT_NORMAL;
                ASSERT( 1 == strlen(PromptStr[nShellPrompt]) );
            }
            else {
                nShellPrompt = PMT_RND;
                ASSERT( 7 == strlen(PromptStr[nShellPrompt]) );
            }
            strcpy(pszIncBuf, PromptStr[nShellPrompt]);
            strcat(pszIncBuf, pszTemp);
            // Assign Include buffer.
            pchBuf = pszIncBuf;
        }
        
        // Assertion of the input parameters.
        ASSERT( pchBuf );
        ASSERT( nLen >= 0 && nLen <= 255 );
        
        // Log the user's commands.
        int nPromptLen = (1 == nAsmFlag) ? 7 : 1;
        if ( isRunInclude ) {
            // Show the Include commands.
            ShlShowLine(pchBuf, nLen+nPromptLen);
        }
        TstLogInfo(pchBuf, nLen+nPromptLen);
        
        // No input.
        if ( 0 == nLen ) {
            if ( isRunInclude ) {
                continue;
            }
            else {
                goto Exit;
            }
        }
        
        // Filter the Include line.
        if ( isRunInclude ) {
            if ( TstIsInnerCommand(pchBuf+nPromptLen) ) {
                continue;
            }
        }
        
        // Assemble command input.
        if ( 1 == nAsmFlag ) {
            // ESC('\\') to abort Assemble command.
            if ( isRunInclude ) {
                char* p = pchBuf + nPromptLen;
                while ( *p ) {
                    if ( isspace(*p) ) {
                        p++;
                    }
                    else {
                        break;
                    }
                }
                if ( '\\' == *p ) {
                    char* ptr = p+1;
                    while ( *ptr ) {
                        if ( isspace(*ptr) ) {
                            ptr++;
                        }
                        else {
                            break;
                        }
                    }
                    nAsmFlag = 0;
                    continue;
                }
            }
            TstOpenStock();
            pchBuf[nPromptLen+nLen] = 0;
            DadAssemble(pchBuf+nPromptLen);
            TstCloseStock();
            if ( isRunInclude ) {
                continue;
            }
            else {
                goto Exit;
            }
        }

        // Entry the Syntax checking routine.
        CSyntaxCheck* pSyntaxCheck = new CSyntaxCheck;
        if ( !pSyntaxCheck ) {
            AfxMessageBox("Insufficient Memory !");
            ASSERT( FALSE );
            return;
        }
        else {
            ASSERT( 1 == nPromptLen );
            TstOpenStock();
            pSyntaxCheck->CheckCommandSyntax(pchBuf+nPromptLen, nLen);
            delete pSyntaxCheck;
            TstCloseStock();
        }
        
//        CSyntaxCheck objSyntax;
//        ASSERT( 1 == nPromptLen );
//        objSyntax.CheckCommandSyntax(pchBuf+nPromptLen, nLen);
        
    } while ( isRunInclude );
    
Exit:
    // Free all of the Include objects.
    TstFreeInclude();
    
    // Destroy the Include stock.
    TstDestroyStock();

    // Free the allocated bufffer.
    if ( pszIncBuf ) {
        delete []pszIncBuf;
    }
    if ( pszTemp ) {
        delete []pszTemp;
    }
    
}   // End of CommandProcess().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   ShowLine().
//
//  Description: Show the results in the Shell window line.
//
//  Input:  pszBuffer - The line editor buffer.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void ShowLine(char* pszBuffer)
{
    // Assertion of the input parameters.
    ASSERT( pszBuffer );

    // Log the commands' result.
    TstLogInfo(pszBuffer);
    
    // Register command result.
    TstAppendStock(PromptStr[nShellPrompt], pszBuffer);
    
    // Display the message in the Shell window.
    ShlShowLine(pszBuffer, strlen(pszBuffer));

}   // End of ShowLine().


 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCheck.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::CSyntaxCheck().
//
//  Description: The construction of the class: CSyntaxCheck.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCheck::CSyntaxCheck()
{
    // Receive from the Shell command line initialization.
    m_nLen = 0;
    for ( int i = 0; i < MAX_CMDLINE+1; i++ ) {
        m_pchLineBuf[i] = '\0';
    }    

    // Command ID initialization.
    m_nCommandID = 0;

}   // End of CSyntaxCheck::CSyntaxCheck().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::~CSyntaxCheck().
//
//  Description: The destruction of the class: CSyntaxCheck.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCheck::~CSyntaxCheck()
{

}   // End of CSyntaxCheck::~CSyntaxCheck().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::CheckCommandSyntax().
//
//  Description: Main control routine of the class: CSyntaxCheck.
//
//  Input:  pchEditBuf - The line editor buffer.
//          nLen - The number of the characters in the line editor buffer.
//
//  Output: None.
//
//  Return: FALSE - syntax error; TRUE - syntax OK.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCheck::CheckCommandSyntax(const char* pchEditBuf, const int nLen)
{
    // Assertion of the input parameters.
    ASSERT( nLen >= 0 && nLen <= MAX_CMDLINE );
    for ( int i = 0; i < nLen; i++ ) {
        ASSERT( pchEditBuf[i] >= MIN_KEY && pchEditBuf[i] <= MAX_KEY );
    }
    
    // Make a copy from the editor buffer.
    CopyCommandLine(pchEditBuf, nLen);
    
    // Parse the command's parameters.
    if ( !CommandParse() ) {
        AfxMessageBox("Command Parsing error !");
        ASSERT( FALSE );
        return (FALSE);
    }
    
    // Check command keyword.
    if ( !CheckCommandKeyword() ) {
        m_nErrorID = NO_SUCH_COMMAND;
        DisplaySyntaxError();
        return (FALSE);
    }
    
    // Call the syntax core.
    SyntaxDispatch(m_nCommandID);
    
    // Return back.
    if ( 0 == m_nErrorID ) {
        DispatchCommand();
        return (TRUE);
    }
    else {
        DisplaySyntaxError();
        return (FALSE);
    }

}   // End of CSyntaxCheck::CheckCommandSyntax().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::CopyCommandLine().
//
//  Description: Make a copy from the editor buffer.
//
//  Input:  pchEditBuf - The line editor buffer.
//          nLen - The number of the characters in the line editor buffer.
//
//  Output: m_pchLineBuf - A copy of the line editor buffer.
//          m_pchLineBuf[255] = 0x20 (The last SPACE).
//          m_nLen - (nLen + 1).
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CSyntaxCheck::CopyCommandLine(const char* pchEditBuf, const int nLen)
{
    // Assertion of the input parameters.
    ASSERT( nLen >= 0 && nLen <= MAX_CMDLINE );
    for ( int i = 0; i < nLen; i++ ) {
        ASSERT( pchEditBuf[i] >= MIN_KEY && pchEditBuf[i] <= MAX_KEY );
        m_pchLineBuf[i] = pchEditBuf[i];
    }
    m_pchLineBuf[i] = TOKEN_KEY;
    m_nLen = nLen + 1;

}   // End of CSyntaxCheck::CopyCommandLine().
    

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::CommandParse().
//
//  Description: Parse the input commands.
//
//  Input:  m_pchLineBuf - To save the user's keyin and the last SPACE.
//          m_nLen - The number of the characters in the line buffer.
//
//  Output: m_nArgc - The number of the command parameters.
//          m_pszArgv[nArgc] - The contents of the command parameters.
//          m_pszArgv[0] is to save the command.
//
//  Return: FALSE - error; TRUE - normal.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCheck::CommandParse(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nLen > 0 && m_nLen <= MAX_CMDLINE+1 );
    for ( int i = 0; i < m_nLen; i++ ) {
        ASSERT( m_pchLineBuf[i] >= MIN_KEY && m_pchLineBuf[i] <= MAX_KEY );
    }
    
    // Get the token of the commands.
    char pszToken[MAX_CMDLINE+1];
    int nTokenLen = 0;
    BOOL isToken = FALSE;
    
    for ( i = 0; i < m_nLen; i++ ) {
        // Only for: "xxxx".
        if ( KEY_DQ == m_pchLineBuf[i] && TOKEN_KEY == m_pchLineBuf[i-1] ) {
            m_pszArgv[m_nArgc] = new char[m_nLen-i+1];
            if ( !m_pszArgv[m_nArgc] ) {
                AfxMessageBox("Insufficient Memory !");
                ASSERT( FALSE );
                return (FALSE);
            }
            else {
                memcpy(m_pszArgv[m_nArgc], m_pchLineBuf+i, m_nLen-i);
                m_pszArgv[m_nArgc++][m_nLen-i] = 0;
                //DumpText(m_pszArgv[m_nArgc-1]);
                return (TRUE);
            }    
        }

        // Normal case.
        if ( TOKEN_KEY == m_pchLineBuf[i] ) {
            if ( TRUE == isToken ) {
                pszToken[nTokenLen] = 0;
                m_pszArgv[m_nArgc] = new char[nTokenLen*sizeof(char)+1];
                if ( !m_pszArgv[m_nArgc] ) {
                    AfxMessageBox("Insufficient Memory !");
                    ASSERT( FALSE );
                    return (FALSE);
                }
                else {
                    isToken = FALSE;
                    strcpy(m_pszArgv[m_nArgc++], pszToken);
                    // DumpText(m_pszArgv[m_nArgc-1]);
                    nTokenLen = 0;
                }    
            }
        }
        else {
            if ( FALSE == isToken ) {
                isToken = TRUE;
            }
            pszToken[nTokenLen++] = m_pchLineBuf[i];
        }
    }
    
    // Return back.
    return (TRUE);

}   // End of CSyntaxCheck::CommandParse().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::CheckCommandKeyword().
//
//  Description: Check the command keyword and fill command ID.
//
//  Input:  m_pszArgv[0] is to save the command keyword.
//
//  Output: m_nCommandID - The command ID.
//
//  Return: FALSE - no such command; TRUE - pass.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCheck::CheckCommandKeyword(void)
{
    // Assertion of the input parameters.
    ASSERT( 0 == m_nCommandID );
    if ( 0 == m_nArgc ) {
        return (TRUE);
    }
    ASSERT( m_nArgc > 0 );
    ASSERT( m_pszArgv[0] );
    
    // Detect the command ID.
    CString strInput = strlwr(m_pszArgv[0]);
    for ( int i = MIN_CMDID; i <= MAX_CMDID; i++ ) {
        CString strTable = CommandRecord[i].pszCommandName;
        strTable.MakeLower();
        if ( strInput == strTable ) {
            m_nCommandID = i;
            return (TRUE);
        }
    }
    
    // No such command.
    return (FALSE);

}   // End of CSyntaxCheck::CheckCommandKeyword().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::DisplaySyntaxError().
//
//  Description: Display the syntax error message on the command line.
//
//  Input:  m_nErrorID - The ID of the syntax error.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CSyntaxCheck::DisplaySyntaxError(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > NO_ERROR && m_nErrorID < MAX_ERROR );
    
    // Define the error message.
    char* pszErrorMsg[] = {
        "",
        "No such command.",
        "Syntax error."
    };
    
    // Display the special error message.
    ShowLine(pszErrorMsg[m_nErrorID]);

}   // End of CSyntaxCheck::DisplaySyntaxError().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheck::DispatchCommand().
//
//  Description: Dispatch the commands.
//
//  Input:  m_nCommandID - The ID of the commands.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CSyntaxCheck::DispatchCommand(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nCommandID >= MIN_CMDID && m_nCommandID <= MAX_CMDID );
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Dispatch the command routine.
    switch ( m_nCommandID ) {
        case CMDID_ASSEMBLE:
            nAsmFlag = 1;
            AssembleCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_BIT:
            BitCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_BREAKPOINT:
            BreakpointCmd(m_nArgc, m_pszArgv);
            ::RepaintSource();
            break;
        case CMDID_BYTE:
            ByteCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_CHECKSUM:
            ChecksumCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_CLEAR:
            ClearCmd(m_nArgc, m_pszArgv);
            ::RepaintSource();
            break;
        case CMDID_COMPARE:
            CompareCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_CONTROL:
            ControlCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_COPY:
            CopyCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
//        case CMDID_CPU:
//            CpuCmd(m_nArgc, m_pszArgv);
//            break;
        case CMDID_CYCLE:
            CycleCmd(m_nArgc, m_pszArgv);
            ::MarkPC();
            ::RepaintCPU();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_DISASSEMBLE:
            DisassembleCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_EVENT:
            EventCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_EV1:
            Ev1Cmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_EV2:
            Ev2Cmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_EV3:
            Ev3Cmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_FILL:
            FillCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_GO:
            GoCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
        case CMDID_HALT:
            HaltCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
        case CMDID_HELP:
            HelpCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_IDENTIFY:
            IdentifyCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_INCLUDE:
            IncludeCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_INPORT:
            InportCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_JUMP:
            JumpCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
        case CMDID_LEVEL:
            LevelCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LV1:
            Lv1Cmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LV2:
            Lv2Cmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LIST:
            ListCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LOG:
            LogCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LONG:
            LongCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_MAP:
            MapCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_MEMORY:
            MemoryCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_OUTPORT:
            OutportCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
//        case CMDID_PATCH:
//            PatchCmd(m_nArgc, m_pszArgv);
//            break;
        case CMDID_PORT:
            PortCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_QUALIFY:
            QualifyCmd(m_nArgc, m_pszArgv);
            break;
//        case CMDID_QUIT:
//            QuitCmd(m_nArgc, m_pszArgv);
//            break;
        case CMDID_REGISTER:
            RegisterCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
        case CMDID_RESET:
            ResetCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
        case CMDID_SEARCH:
            SearchCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_STEP:
            StepCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
//        case CMDID_STEPOPTION:
//            StepoptionCmd(m_nArgc, m_pszArgv);
//            break;
        case CMDID_TEST:
            TestCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
        case CMDID_TIMER:
            TimerCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_TRACE:
            TraceCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_TRIGGER:
            TriggerCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_UPLOAD:
            UploadCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_VERIFY:
            VerifyCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_WORD:
            WordCmd(m_nArgc, m_pszArgv);
            ::RepaintMemory();
            ::RepaintBMemory();
            ::RepaintStack();
            ::RepaintVariable();
            break;
//        case CMDID_BACK:
//            BackCmd(m_nArgc, m_pszArgv);
//            break;
        case CMDID_CREATE:
            CreateCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_DELETE:
            DeleteCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LOAD:
            LoadCmd(m_nArgc, m_pszArgv);
            ::OnEmulation();
            break;
//        case CMDID_MODULE:
//            ModuleCmd(m_nArgc, m_pszArgv);
//            break;
        case CMDID_QUERY:
            QueryCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_SSAVE:
            SsaveCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_SRECALL:
            SrecallCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_SYMBOL:
            SymbolCmd(m_nArgc, m_pszArgv);
//            ModuleCmd();
            break;
//        case CMDID_WATCH:
//            WatchCmd(m_nArgc, m_pszArgv);
//            break;
    
    #ifdef _GATES
        case CMDID_COUNT:
            CountCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_LINE:
            LineCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_STATEMENT:
            ModuleCmd();
//            StatementCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_VOID:
            VoidCmd(m_nArgc, m_pszArgv);
            break;
        case CMDID_TYPE:
            TypeCmd(m_nArgc, m_pszArgv);
            break;
    #endif  // _GATES
            
    #ifdef _CHEN_
        case CMDID_CALCULATE:
            CalculateCmd(m_nArgc, m_pszArgv);
            break;
    #endif  // _CHEN_
            
        default:
            ASSERT( FALSE );
            break;
    }

}   // End of CSyntaxCheck::DispatchCommand().

//////////////////////////////// End of File ////////////////////////////////
