
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TRCGRPDI.CPP   1.29   02 Apr 1996 09:29:12   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TRCGRPDI.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:29:12   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:54:44   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.24   01 Feb 1996 10:16:46   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.21   24 Jan 1996 10:32:22   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:24:12   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:12:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:36   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:58   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:52   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:20   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:40   Shirley
** EasyPack/SLD Version 0.30
** 
**    Rev 1.12   12 Nov 1995 11:28:36   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:29:24   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:54   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:47:54   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:24:12   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.0   07 Sep 1995 09:54:14   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGRPDI.CPP
//
//  Description:The implement file for the class: CTraceGroupDialog
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"                
#include "resource.h"
#include "xview.h"
#include "abibase.h"
#include "trcserve.h"
//#include "trcview.h"
//#include "trcwin.h"
#include "trcgrpdi.h"
#include "stdlib.h"
#include "uicom.h"

#ifdef _DEBUG          
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#define	SYMHEAD	('#')

extern class CBusEvent ev1;
extern class CBusEvent ev2;
extern class CExtEvent ev3;
extern class CLevel Le1;
extern class CLevel Le2;
extern class CTrigger Trig;
extern class CQualify qlfy;
extern QUALIFY softQlfy;
extern unsigned char traceStatus;
extern unsigned char timerStatus;

extern STATUS AbiSetEvent(BUS_EVENT);
extern STATUS AbiSetTrigLevel(int,TRIGGER_LEVEL);
extern STATUS AbiSetTrigLogic(TRIGGER_LOGIC);
extern STATUS AbiSetQualify(QUALIFY);
extern STATUS AbiGetCpuStatus(UINT *uCpuStatus);
extern void TraceWnd(unsigned char);
extern void TimerWnd(unsigned char);

int GetTokenNum(char* string)
{
    char separation[3];
    char str1[200];
    char* temp;
    int num;
    
    separation[0]=' ';
    separation[1]=',';
    separation[2]='\0';       
    num = 0;     
    
    strcpy(str1,string);
    
    temp = strtok(str1, separation);
    if (temp == NULL) return num;
    
    do
    {
        num++;
        temp = strtok(NULL, separation);
    }while(temp!=NULL);    
    
    return num;
}              

BOOL CheckInvalid(char* str, char* set, int count)
{    
    int i;          
    int temp;
    
    i=0;
    do
    {   
        temp = strcspn(str, set);  
        if (temp!=0) return FALSE;
        i++;   
        str++;
    }while(i<count);              
    
    return TRUE;
}

int searchc(char* str1, char ch, int count)
{
    int i=0;
    int p=0;
    
    if (count==0) return 0;
    
    do
    {
        if (*str1==ch) i++;
        str1++; 
        p++;
    }while((i<count)&&(*str1!='\0'));
    return(p-1);
}           

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog dialog
      
void CTraceGroupDialog::GetEv1()
{           
    int i,j;  
    char txt[200];
            
    if (ev1.m_nClearflag==1)
    {  
        m_event.nEv1AddrMode = 1;
        m_event.Ev1StartAddrTxt[0]='\0';
        m_event.Ev1StartAddrTxt2[0]='\0';
        m_event.Ev1StartAddrTxt3[0]='\0';
        m_event.Ev1EndAddrTxt[0]='\0';
        m_event.nEv1AddrType = 0;
        m_event.nEv1DataMode = 1;
        m_event.Ev1StartDataTxt[0]='\0'; 
        m_event.Ev1StartDataTxt2[0]='\0'; 
        m_event.Ev1StartDataTxt3[0]='\0'; 
        m_event.Ev1EndDataTxt[0]='\0';
        m_event.nEv1DataType=0;
        m_event.bEv1S = FALSE;
        m_event.bEv1F = FALSE;
        m_event.bEv1R = FALSE;
        m_event.bEv1W = FALSE;
        m_event.bEv1AK = FALSE;
        m_event.Ev1CountTxt[0]='\0';
        return;
    }          
    
    switch (ev1.m_busEv.qlfyType[4])
    {
        case 0:                                  
            m_event.nEv1AddrMode = 3;
            strcpy(m_event.Ev1StartAddrTxt3,"XXXX");
            break;
        case 2:                    
            _itoa(ev1.m_busEv.addr[0][0],m_event.Ev1StartAddrTxt3,2);
            i = strlen(m_event.Ev1StartAddrTxt3);
            strncpy(txt,m_event.Ev1StartAddrTxt3,64);
            strcpy(&(m_event.Ev1StartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_event.Ev1StartAddrTxt3[j]='0';
                      
            if ((ev1.m_busEv.addr[1][0]&0x8000)==0)
                m_event.Ev1StartAddrTxt3[0]='X';
                
            if ((ev1.m_busEv.addr[1][0]&0x4000)==0)
                m_event.Ev1StartAddrTxt3[1]='X';

            if ((ev1.m_busEv.addr[1][0]&0x2000)==0)
                m_event.Ev1StartAddrTxt3[2]='X';

            if ((ev1.m_busEv.addr[1][0]&0x1000)==0)
                m_event.Ev1StartAddrTxt3[3]='X';

            if ((ev1.m_busEv.addr[1][0]&0x800)==0)
                m_event.Ev1StartAddrTxt3[4]='X';

            if ((ev1.m_busEv.addr[1][0]&0x400)==0)
                m_event.Ev1StartAddrTxt3[5]='X';

            if ((ev1.m_busEv.addr[1][0]&0x200)==0)
                m_event.Ev1StartAddrTxt3[6]='X';

            if ((ev1.m_busEv.addr[1][0]&0x100)==0)
                m_event.Ev1StartAddrTxt3[7]='X';

            if ((ev1.m_busEv.addr[1][0]&0x80)==0)
                m_event.Ev1StartAddrTxt3[8]='X';

            if ((ev1.m_busEv.addr[1][0]&0x40)==0)
                m_event.Ev1StartAddrTxt3[9]='X';

            if ((ev1.m_busEv.addr[1][0]&0x20)==0)
                m_event.Ev1StartAddrTxt3[10]='X';

            if ((ev1.m_busEv.addr[1][0]&0x10)==0)
                m_event.Ev1StartAddrTxt3[11]='X';

            if ((ev1.m_busEv.addr[1][0]&0x8)==0)
                m_event.Ev1StartAddrTxt3[12]='X';

            if ((ev1.m_busEv.addr[1][0]&0x4)==0)
                m_event.Ev1StartAddrTxt3[13]='X';

            if ((ev1.m_busEv.addr[1][0]&0x2)==0)
                m_event.Ev1StartAddrTxt3[14]='X';

            if ((ev1.m_busEv.addr[1][0]&0x1)==0)
                m_event.Ev1StartAddrTxt3[15]='X';
                
            m_event.Ev1StartAddrTxt3[16]='\0';
            j=0;
            for(i=0;i<16;i++)
            	j+=m_event.Ev1StartAddrTxt3[i];
            if(j=='X'*16)
            	 m_event.Ev1StartAddrTxt3[4]=0;	
            m_event.nEv1AddrMode = 3;
            break;
        case 0x10:                       
            _itoa(ev1.m_busEv.addr[0][0],m_event.Ev1StartAddrTxt,16);
            _itoa(ev1.m_busEv.addr[1][0],m_event.Ev1EndAddrTxt,16);
            m_event.nEv1AddrType = 0;
            m_event.nEv1AddrMode = 1;
            break;
        case 0x40:                   
            sprintf(m_event.Ev1StartAddrTxt2,"%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,",
                ev1.m_busEv.addr[0][0],ev1.m_busEv.addr[1][0],ev1.m_busEv.addr[2][0],ev1.m_busEv.addr[3][0],ev1.m_busEv.addr[4][0],
                ev1.m_busEv.addr[5][0],ev1.m_busEv.addr[6][0],ev1.m_busEv.addr[7][0],ev1.m_busEv.addr[8][0],ev1.m_busEv.addr[9][0]);
            i = searchc(m_event.Ev1StartAddrTxt2, ',', ev1.m_busEv.addrCount);
            m_event.Ev1StartAddrTxt2[i]='\0';
            m_event.nEv1AddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (ev1.m_busEv.qlfyType[6])
    {
        case 0:   
            m_event.nEv1DataMode = 3;                     
            strcpy(m_event.Ev1StartDataTxt3,"XX");
            break;
        case 2:
            _itoa(((WORD)ev1.m_busEv.data1),m_event.Ev1StartDataTxt3,2);
//          strncpy(m_event.Ev1StartDataTxt, &(m_event.Ev1StartDataTxt[8]), 8);
            i = strlen(m_event.Ev1StartDataTxt3);
            strncpy(txt,m_event.Ev1StartDataTxt3,64);
            strcpy(&(m_event.Ev1StartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_event.Ev1StartDataTxt3[j]='0';
                      
            if ((ev1.m_busEv.data2&0x80)==0)
                m_event.Ev1StartDataTxt3[0]='X';

            if ((ev1.m_busEv.data2&0x40)==0)
                m_event.Ev1StartDataTxt3[1]='X';

            if ((ev1.m_busEv.data2&0x20)==0)
                m_event.Ev1StartDataTxt3[2]='X';

            if ((ev1.m_busEv.data2&0x10)==0)
                m_event.Ev1StartDataTxt3[3]='X';

            if ((ev1.m_busEv.data2&0x8)==0)
                m_event.Ev1StartDataTxt3[4]='X';

            if ((ev1.m_busEv.data2&0x4)==0)
                m_event.Ev1StartDataTxt3[5]='X';

            if ((ev1.m_busEv.data2&0x2)==0)
                m_event.Ev1StartDataTxt3[6]='X';

            if ((ev1.m_busEv.data2&0x1)==0)
                m_event.Ev1StartDataTxt3[7]='X';
                
            m_event.Ev1StartDataTxt3[8]='\0';
            j=0;
            for(i=0;i<8;i++)
            	j+=m_event.Ev1StartDataTxt3[i];
            if(j=='X'*8)
            	 m_event.Ev1StartDataTxt3[2]=0;	

            m_event.nEv1DataMode = 3;
            break;
        case 0x10:
            _itoa(((WORD)ev1.m_busEv.data1),m_event.Ev1StartDataTxt,16);
            _itoa(((WORD)ev1.m_busEv.data2),m_event.Ev1EndDataTxt,16);
            m_event.nEv1DataType=0;
            m_event.nEv1DataMode = 1;
            break;
        case 0x1:
            sprintf(m_event.Ev1StartDataTxt2,"%x",ev1.m_busEv.data1);
            m_event.nEv1DataMode = 2;
        default:
            break;
    }             

    m_event.bEv1S = FALSE;
    m_event.bEv1F = FALSE;
    m_event.bEv1R = FALSE;
    m_event.bEv1W = FALSE;
    m_event.bEv1AK = FALSE;
    switch (ev1.m_busEv.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((ev1.m_busEv.status&1)==1)
                m_event.bEv1S = TRUE;
            if ((ev1.m_busEv.status&2)==2)
                m_event.bEv1F = TRUE;
            if ((ev1.m_busEv.status&4)==4)
                m_event.bEv1R = TRUE;
            if ((ev1.m_busEv.status&8)==8)
                m_event.bEv1W = TRUE;
            if ((ev1.m_busEv.status&0x10)==0x10)
                m_event.bEv1AK = TRUE;
            break;            
        default:
            break;
    }             
    
    switch (ev1.m_busEv.qlfyType[10])
    {
        case 0:
            m_event.Ev1CountTxt[0]='\0';
            break;
        case 1:
            sprintf(m_event.Ev1CountTxt,"%X",ev1.m_busEv.count);
        default:
            break;
    }
}

void CTraceGroupDialog::GetEv2()
{
    int i,j;  
    char txt[200];
            
    if (ev2.m_nClearflag==1)
    {  
        m_event.nEv2AddrMode = 1;
        m_event.Ev2StartAddrTxt[0]='\0';
        m_event.Ev2StartAddrTxt2[0]='\0';
        m_event.Ev2StartAddrTxt3[0]='\0';
        m_event.Ev2EndAddrTxt[0]='\0';
        m_event.nEv2AddrType = 0;
        m_event.nEv2DataMode = 1;
        m_event.Ev2StartDataTxt[0]='\0'; 
        m_event.Ev2StartDataTxt2[0]='\0';
        m_event.Ev2StartDataTxt3[0]='\0';
        m_event.Ev2EndDataTxt[0]='\0';
        m_event.nEv2DataType=0;
        m_event.bEv2S = FALSE;
        m_event.bEv2F = FALSE;
        m_event.bEv2R = FALSE;
        m_event.bEv2W = FALSE;
        m_event.bEv2AK = FALSE;
        return;
    }          
    
    switch (ev2.m_busEv.qlfyType[4])
    {
        case 0:                                  
            m_event.nEv2AddrMode = 3;
            strcpy(m_event.Ev2StartAddrTxt3,"XXXX");
            break;
        case 2:                    
            _itoa(ev2.m_busEv.addr[0][0],m_event.Ev2StartAddrTxt3,2);
            i = strlen(m_event.Ev2StartAddrTxt3);
            strncpy(txt,m_event.Ev2StartAddrTxt3,64);
            strcpy(&(m_event.Ev2StartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_event.Ev2StartAddrTxt3[j]='0';
                      
            if ((ev2.m_busEv.addr[1][0]&0x8000)==0)
                m_event.Ev2StartAddrTxt3[0]='X';
                
            if ((ev2.m_busEv.addr[1][0]&0x4000)==0)
                m_event.Ev2StartAddrTxt3[1]='X';

            if ((ev2.m_busEv.addr[1][0]&0x2000)==0)
                m_event.Ev2StartAddrTxt3[2]='X';

            if ((ev2.m_busEv.addr[1][0]&0x1000)==0)
                m_event.Ev2StartAddrTxt3[3]='X';

            if ((ev2.m_busEv.addr[1][0]&0x800)==0)
                m_event.Ev2StartAddrTxt3[4]='X';

            if ((ev2.m_busEv.addr[1][0]&0x400)==0)
                m_event.Ev2StartAddrTxt3[5]='X';

            if ((ev2.m_busEv.addr[1][0]&0x200)==0)
                m_event.Ev2StartAddrTxt3[6]='X';

            if ((ev2.m_busEv.addr[1][0]&0x100)==0)
                m_event.Ev2StartAddrTxt3[7]='X';

            if ((ev2.m_busEv.addr[1][0]&0x80)==0)
                m_event.Ev2StartAddrTxt3[8]='X';

            if ((ev2.m_busEv.addr[1][0]&0x40)==0)
                m_event.Ev2StartAddrTxt3[9]='X';

            if ((ev2.m_busEv.addr[1][0]&0x20)==0)
                m_event.Ev2StartAddrTxt3[10]='X';

            if ((ev2.m_busEv.addr[1][0]&0x10)==0)
                m_event.Ev2StartAddrTxt3[11]='X';

            if ((ev2.m_busEv.addr[1][0]&0x8)==0)
                m_event.Ev2StartAddrTxt3[12]='X';

            if ((ev2.m_busEv.addr[1][0]&0x4)==0)
                m_event.Ev2StartAddrTxt3[13]='X';

            if ((ev2.m_busEv.addr[1][0]&0x2)==0)
                m_event.Ev2StartAddrTxt3[14]='X';

            if ((ev2.m_busEv.addr[1][0]&0x1)==0)
                m_event.Ev2StartAddrTxt3[15]='X';
                                       
            m_event.Ev2StartAddrTxt3[16]='\0';
            j=0;
            for(i=0;i<16;i++)
            	j+=m_event.Ev2StartAddrTxt3[i];
            if(j=='X'*16)
            	 m_event.Ev2StartAddrTxt3[4]=0;	
            
            m_event.nEv2AddrMode = 3;
            break;
        case 0x10:                       
            _itoa(ev2.m_busEv.addr[0][0],m_event.Ev2StartAddrTxt,16);
            _itoa(ev2.m_busEv.addr[1][0],m_event.Ev2EndAddrTxt,16);
            m_event.nEv2AddrType = 0;
            m_event.nEv2AddrMode = 1;
            break;
        case 0x40:                   
            sprintf(m_event.Ev2StartAddrTxt2,"%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,",
                ev2.m_busEv.addr[0][0],ev2.m_busEv.addr[1][0],ev2.m_busEv.addr[2][0],ev2.m_busEv.addr[3][0],ev2.m_busEv.addr[4][0],
                ev2.m_busEv.addr[5][0],ev2.m_busEv.addr[6][0],ev2.m_busEv.addr[7][0],ev2.m_busEv.addr[8][0],ev2.m_busEv.addr[9][0]);
            i = searchc(m_event.Ev2StartAddrTxt2, ',', ev2.m_busEv.addrCount);
            m_event.Ev2StartAddrTxt2[i]='\0';
            m_event.nEv2AddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (ev2.m_busEv.qlfyType[6])
    {
        case 0:   
            m_event.nEv2DataMode = 3;                     
            strcpy(m_event.Ev2StartDataTxt3,"XX");
            break;
        case 2:
            _itoa(((WORD)ev2.m_busEv.data1),m_event.Ev2StartDataTxt3,2);
//          strncpy(m_event.Ev2StartDataTxt, &(m_event.Ev2StartDataTxt[8]), 8);
            i = strlen(m_event.Ev2StartDataTxt3);
            strncpy(txt,m_event.Ev2StartDataTxt3,64);
            strcpy(&(m_event.Ev2StartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_event.Ev2StartDataTxt3[j]='0';
                      
            if ((ev2.m_busEv.data2&0x80)==0)
                m_event.Ev2StartDataTxt3[0]='X';

            if ((ev2.m_busEv.data2&0x40)==0)
                m_event.Ev2StartDataTxt3[1]='X';

            if ((ev2.m_busEv.data2&0x20)==0)
                m_event.Ev2StartDataTxt3[2]='X';

            if ((ev2.m_busEv.data2&0x10)==0)
                m_event.Ev2StartDataTxt3[3]='X';

            if ((ev2.m_busEv.data2&0x8)==0)
                m_event.Ev2StartDataTxt3[4]='X';

            if ((ev2.m_busEv.data2&0x4)==0)
                m_event.Ev2StartDataTxt3[5]='X';

            if ((ev2.m_busEv.data2&0x2)==0)
                m_event.Ev2StartDataTxt3[6]='X';

            if ((ev2.m_busEv.data2&0x1)==0)
                m_event.Ev2StartDataTxt3[7]='X';
                
            m_event.Ev2StartDataTxt3[8]='\0';
            j=0;
            for(i=0;i<8;i++)
            	j+=m_event.Ev2StartDataTxt3[i];
            if(j=='X'*8)
            	 m_event.Ev2StartDataTxt3[2]=0;	
            
            m_event.nEv2DataMode = 3;
            break;
        case 0x10:
            _itoa(((WORD)ev2.m_busEv.data1),m_event.Ev2StartDataTxt,16);
            _itoa(((WORD)ev2.m_busEv.data2),m_event.Ev2EndDataTxt,16);
            m_event.nEv2DataType=0;
            m_event.nEv2DataMode = 1;
            break;
        case 0x1:
            sprintf(m_event.Ev2StartAddrTxt2,"%x",ev2.m_busEv.data1);
            m_event.nEv2DataMode = 2;
        default:
            break;
    }             

    m_event.bEv2S = FALSE;
    m_event.bEv2F = FALSE;
    m_event.bEv2R = FALSE;
    m_event.bEv2W = FALSE;
    m_event.bEv2AK = FALSE;
    switch (ev2.m_busEv.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((ev2.m_busEv.status&1)==1)
                m_event.bEv2S = TRUE;
            if ((ev2.m_busEv.status&2)==2)
                m_event.bEv2F = TRUE;
            if ((ev2.m_busEv.status&4)==4)
                m_event.bEv2R = TRUE;
            if ((ev2.m_busEv.status&8)==8)
                m_event.bEv2W = TRUE;
            if ((ev2.m_busEv.status&0x10)==0x10)
                m_event.bEv2AK = TRUE;
            break;            
        default:
            break;
    }             
}

void CTraceGroupDialog::GetEv3()
{
    if (ev3.m_nClearflag==1)
    {  
        m_event.nEv3HL = 0;
        return;
    }
    if (ev3.m_extEv.extrn==0) m_event.nEv3HL = 2;
    else m_event.nEv3HL = 1;
}

void CTraceGroupDialog::GetLevel1()
{
    switch (Le1.m_levelStructSave.Condition)
    {
        case (DWORD)0x0:
            m_trigger.level1.nSet = 0;
            break;
        case (DWORD)0xAAAAAAAA:
            m_trigger.level1.nSet = 1;
            break;
        case (DWORD)0xEEEEEEEE:
            m_trigger.level1.nSet = 2;
            break;
        case (DWORD)0xFAFAFAFA:
            m_trigger.level1.nSet = 3;
            break;
        case (DWORD)0xE0E0E0E0:
            m_trigger.level1.nSet = 4;
            break;
        case (DWORD)0xC8C8C8C8:
            m_trigger.level1.nSet = 5;
            break;
        case (DWORD)0xFEFEFEFE:
            m_trigger.level1.nSet = 6;
            break;
        case (DWORD)0x88888888:
            m_trigger.level1.nSet = 7;
            break;
        case (DWORD)0xA0A0A0A0:
            m_trigger.level1.nSet = 8;
            break;
        case (DWORD)0xF8F8F8F8:
            m_trigger.level1.nSet = 9;
            break;
        case (DWORD)0xECECECEC:
            m_trigger.level1.nSet = 10;
            break;
        case (DWORD)0x80808080:
            m_trigger.level1.nSet = 11;
            break;
        case (DWORD)0xCCCCCCCC:
            m_trigger.level1.nSet = 12;
            break;
        case (DWORD)0xFCFCFCFC:
            m_trigger.level1.nSet = 13;
            break;
        case (DWORD)0xA8A8A8A8:
            m_trigger.level1.nSet = 14;
            break;
        case (DWORD)0xC0C0C0C0:
            m_trigger.level1.nSet = 15;
            break;
        case (DWORD)0xEAEAEAEA:
            m_trigger.level1.nSet = 16;
            break;
        case (DWORD)0xF0F0F0F0:
            m_trigger.level1.nSet = 17;
            break;
        default:
            break;
    }
    
    if (Le1.m_levelStruct.TraceFlg==1)
        m_trigger.level1.bTraceOn=TRUE;
    else
        m_trigger.level1.bTraceOn=FALSE;
    
    if (Le1.m_levelStruct.TimerFlg==1)
        m_trigger.level1.bTimerOn=TRUE;
    else
        m_trigger.level1.bTimerOn=FALSE;
}

void CTraceGroupDialog::GetLevel2()
{
    switch (Le2.m_levelStructSave.Condition)
    {
        case (DWORD)0x0:
            m_trigger.level2.nSet = 0;
            break;
        case (DWORD)0xAAAAAAAA:
            m_trigger.level2.nSet = 1;
            break;
        case (DWORD)0xEEEEEEEE:
            m_trigger.level2.nSet = 2;
            break;
        case (DWORD)0xFAFAFAFA:
            m_trigger.level2.nSet = 3;
            break;
        case (DWORD)0xE0E0E0E0:
            m_trigger.level2.nSet = 4;
            break;
        case (DWORD)0xC8C8C8C8:
            m_trigger.level2.nSet = 5;
            break;
        case (DWORD)0xFEFEFEFE:
            m_trigger.level2.nSet = 6;
            break;
        case (DWORD)0x88888888:
            m_trigger.level2.nSet = 7;
            break;
        case (DWORD)0xA0A0A0A0:
            m_trigger.level2.nSet = 8;
            break;
        case (DWORD)0xF8F8F8F8:
            m_trigger.level2.nSet = 9;
            break;
        case (DWORD)0xECECECEC:
            m_trigger.level2.nSet = 10;
            break;
        case (DWORD)0x80808080:
            m_trigger.level2.nSet = 11;
            break;
        case (DWORD)0xCCCCCCCC:
            m_trigger.level2.nSet = 12;
            break;
        case (DWORD)0xFCFCFCFC:
            m_trigger.level2.nSet = 13;
            break;
        case (DWORD)0xA8A8A8A8:
            m_trigger.level2.nSet = 14;
            break;
        case (DWORD)0xC0C0C0C0:
            m_trigger.level2.nSet = 15;
            break;
        case (DWORD)0xEAEAEAEA:
            m_trigger.level2.nSet = 16;
            break;
        case (DWORD)0xF0F0F0F0:
            m_trigger.level2.nSet = 17;
            break;
        default:
            break;
    }
    
    if (Le2.m_levelStruct.TraceFlg==1)
        m_trigger.level2.bTraceOn=TRUE;
    else
        m_trigger.level2.bTraceOn=FALSE;
    
    if (Le2.m_levelStruct.TimerFlg==1)
        m_trigger.level2.bTimerOn=TRUE;
    else
        m_trigger.level2.bTimerOn=FALSE;
}

void CTraceGroupDialog::GetTrigger()
{
    UINT status;
    if(AbiGetCpuStatus(&status)!=ICE_OK)            //by chris
        {
         AfxMessageBox("Cannot Get CPU Status!");
         m_traceControl.bStartTrace= traceStatus;
         m_traceControl.bStartTimer = timerStatus;
        }         
    else    
        {
         m_traceControl.bStartTrace= (status&0x0004)?TRUE:FALSE;
         m_traceControl.bStartTimer= (status&0x0100)?TRUE:FALSE;
        }
    switch (Trig.m_trig.TrigFlg)
    {
        case 0:
            m_traceControl.nDelay = 4;
            sprintf(m_traceControl.delayTxt,"%X",Trig.m_trig.DlayCnt);
            break;
        case 1:
            m_traceControl.nDelay = 1;
            break;
        case 2:
            m_traceControl.nDelay = 3;
            break;
        case 3:
            m_traceControl.nDelay = 2;
            break;
        default:
            break;  
    }
    if (Trig.m_trig.RunFlg==0)
        m_trigger.bRun=FALSE;
    else
        m_trigger.bRun=TRUE;
        
    if (Trig.m_trig.LevelCount==1)
    {
        if (Trig.m_trig.LevelID[0]==1)
            m_trigger.nTriggerSet=1;
        else if (Trig.m_trig.LevelID[0]==2)
            m_trigger.nTriggerSet=2;
        else
            m_trigger.nTriggerSet=0;
    }
    else if (Trig.m_trig.LevelCount==2)
    {
        if ((Trig.m_trig.LevelID[0]==1)&&(Trig.m_trig.LevelID[1]==2))
            m_trigger.nTriggerSet=3;
//      else if ((Trig.m_trig.LevelID[0]==2)&&(Trig.m_trig.LevelID[2]==1))
//          m_trigger.nTriggerSet=4;        //mark by chris
        else
            m_trigger.nTriggerSet=0;
    }
    else
    {
        m_trigger.nTriggerSet=0;
    }                              
    
    if (Trig.m_nOnOffFlg==1)
        m_trigger.bTriggerEnable=TRUE;
    else
        m_trigger.bTriggerEnable=FALSE;
}

void CTraceGroupDialog::GetDisplayFilter()
{
    int i,j;  
    char txt[200];
            
    switch (softQlfy.qlfyType[4])
    {
        case 0:                                  
            m_filter.nDisplayAddrMode = 3;
            strcpy(m_filter.DisplayStartAddrTxt3,"XXXX");
            break;
        case 2:                    
            _itoa(softQlfy.addr[0][0],m_filter.DisplayStartAddrTxt3,2);
            i = strlen(m_filter.DisplayStartAddrTxt3);
            strncpy(txt,m_filter.DisplayStartAddrTxt3,64);
            strcpy(&(m_filter.DisplayStartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_filter.DisplayStartAddrTxt3[j]='0';
                      
            if ((softQlfy.addr[1][0]&0x8000)==0)
                m_filter.DisplayStartAddrTxt3[0]='X';
                
            if ((softQlfy.addr[1][0]&0x4000)==0)
                m_filter.DisplayStartAddrTxt3[1]='X';

            if ((softQlfy.addr[1][0]&0x2000)==0)
                m_filter.DisplayStartAddrTxt3[2]='X';

            if ((softQlfy.addr[1][0]&0x1000)==0)
                m_filter.DisplayStartAddrTxt3[3]='X';

            if ((softQlfy.addr[1][0]&0x800)==0)
                m_filter.DisplayStartAddrTxt3[4]='X';

            if ((softQlfy.addr[1][0]&0x400)==0)
                m_filter.DisplayStartAddrTxt3[5]='X';

            if ((softQlfy.addr[1][0]&0x200)==0)
                m_filter.DisplayStartAddrTxt3[6]='X';

            if ((softQlfy.addr[1][0]&0x100)==0)
                m_filter.DisplayStartAddrTxt3[7]='X';

            if ((softQlfy.addr[1][0]&0x80)==0)
                m_filter.DisplayStartAddrTxt3[8]='X';

            if ((softQlfy.addr[1][0]&0x40)==0)
                m_filter.DisplayStartAddrTxt3[9]='X';

            if ((softQlfy.addr[1][0]&0x20)==0)
                m_filter.DisplayStartAddrTxt3[10]='X';

            if ((softQlfy.addr[1][0]&0x10)==0)
                m_filter.DisplayStartAddrTxt3[11]='X';

            if ((softQlfy.addr[1][0]&0x8)==0)
                m_filter.DisplayStartAddrTxt3[12]='X';

            if ((softQlfy.addr[1][0]&0x4)==0)
                m_filter.DisplayStartAddrTxt3[13]='X';

            if ((softQlfy.addr[1][0]&0x2)==0)
                m_filter.DisplayStartAddrTxt3[14]='X';

            if ((softQlfy.addr[1][0]&0x1)==0)
                m_filter.DisplayStartAddrTxt3[15]='X';
                
            m_filter.DisplayStartAddrTxt3[16]='\0';
            j=0;
            for(i=0;i<16;i++)
            	j+=m_filter.DisplayStartAddrTxt3[i];
            if(j=='X'*16)
            	 m_filter.DisplayStartAddrTxt3[4]=0;	
            m_filter.nDisplayAddrMode = 3;
            break;
        case 0x10:                       
            _itoa(softQlfy.addr[0][0],m_filter.DisplayStartAddrTxt,16);
            _itoa(softQlfy.addr[1][0],m_filter.DisplayEndAddrTxt,16);
            m_filter.nDisplayAddrType = 0;
            m_filter.nDisplayAddrMode = 1;
            break;
        case 0x40:                   
            sprintf(m_filter.DisplayStartAddrTxt2,"%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,",
                softQlfy.addr[0][0],softQlfy.addr[1][0],softQlfy.addr[2][0],softQlfy.addr[3][0],softQlfy.addr[4][0],
                softQlfy.addr[5][0],softQlfy.addr[6][0],softQlfy.addr[7][0],softQlfy.addr[8][0],softQlfy.addr[9][0]);
            i = searchc(m_filter.DisplayStartAddrTxt2, ',', softQlfy.addrCount);
            m_filter.DisplayStartAddrTxt2[i]='\0';
            m_filter.nDisplayAddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (softQlfy.qlfyType[6])
    {
        case 0:   
            m_filter.nDisplayDataMode = 3;                     
            strcpy(m_filter.DisplayStartDataTxt3,"XX");
            break;
        case 2:
            _itoa(((WORD)softQlfy.data1),m_filter.DisplayStartDataTxt3,2);
//          strncpy(m_filter.DisplayStartDataTxt, &(m_filter.DisplayStartDataTxt[8]), 8);
            i = strlen(m_filter.DisplayStartDataTxt3);
            strncpy(txt,m_filter.DisplayStartDataTxt3,64);
            strcpy(&(m_filter.DisplayStartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_filter.DisplayStartDataTxt3[j]='0';
                      
            if ((softQlfy.data2&0x80)==0)
                m_filter.DisplayStartDataTxt3[0]='X';

            if ((softQlfy.data2&0x40)==0)
                m_filter.DisplayStartDataTxt3[1]='X';

            if ((softQlfy.data2&0x20)==0)
                m_filter.DisplayStartDataTxt3[2]='X';

            if ((softQlfy.data2&0x10)==0)
                m_filter.DisplayStartDataTxt3[3]='X';

            if ((softQlfy.data2&0x8)==0)
                m_filter.DisplayStartDataTxt3[4]='X';

            if ((softQlfy.data2&0x4)==0)
                m_filter.DisplayStartDataTxt3[5]='X';

            if ((softQlfy.data2&0x2)==0)
                m_filter.DisplayStartDataTxt3[6]='X';

            if ((softQlfy.data2&0x1)==0)
                m_filter.DisplayStartDataTxt3[7]='X';
                
            m_filter.DisplayStartDataTxt3[8]='\0';
            j=0;
            for(i=0;i<8;i++)
            	j+=m_filter.DisplayStartDataTxt3[i];
            if(j=='X'*8)
            	 m_filter.DisplayStartDataTxt3[2]=0;	
            m_filter.nDisplayDataMode = 3;
            break;
        case 0x10:
            _itoa(((WORD)softQlfy.data1),m_filter.DisplayStartDataTxt,16);
            _itoa(((WORD)softQlfy.data2),m_filter.DisplayEndDataTxt,16);
            m_filter.nDisplayDataType=0;
            m_filter.nDisplayDataMode = 1;
            break;
        case 0x1:
            sprintf(m_filter.DisplayStartDataTxt2,"%x",softQlfy.data1);
            m_filter.nDisplayDataMode = 2;
        default:
            break;
    }             

    m_filter.bDisplayS = FALSE;
    m_filter.bDisplayF = FALSE;
    m_filter.bDisplayR = FALSE;
    m_filter.bDisplayW = FALSE;
    m_filter.bDisplayAK = FALSE;
    switch (softQlfy.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((softQlfy.status&1)==1)
                m_filter.bDisplayS = TRUE;
            if ((softQlfy.status&2)==2)
                m_filter.bDisplayF = TRUE;
            if ((softQlfy.status&4)==4)
                m_filter.bDisplayR = TRUE;
            if ((softQlfy.status&8)==8)
                m_filter.bDisplayW = TRUE;
            if ((softQlfy.status&0x10)==0x10)
                m_filter.bDisplayAK = TRUE;
            break;            
        default:
            break;
    }             
}

void CTraceGroupDialog::GetTraceFilter()
{
    int i,j;  
    char txt[200];
            
    if (qlfy.m_nClearflag==1)
    {  
        m_filter.nTraceAddrMode = 1;
        m_filter.TraceStartAddrTxt[0]='\0';
        m_filter.TraceEndAddrTxt[0]='\0';
        m_filter.nTraceAddrType = 0;
        m_filter.nTraceDataMode = 1;
        m_filter.TraceStartDataTxt[0]='\0';
        m_filter.TraceEndDataTxt[0]='\0';
        m_filter.nTraceDataType=0;
        m_filter.bTraceS = FALSE;
        m_filter.bTraceF = FALSE;
        m_filter.bTraceR = FALSE;
        m_filter.bTraceW = FALSE;
        m_filter.bTraceAK = FALSE;
        return;
    }          
    
    switch (qlfy.m_qlfy.qlfyType[4])
    {
        case 0:                                  
            m_filter.nTraceAddrMode = 3;
            strcpy(m_filter.TraceStartAddrTxt3,"XXXX");
            break;
        case 2:                    
            _itoa(qlfy.m_qlfy.addr[0][0],m_filter.TraceStartAddrTxt3,2);
            i = strlen(m_filter.TraceStartAddrTxt3);
            strncpy(txt,m_filter.TraceStartAddrTxt3,64);
            strcpy(&(m_filter.TraceStartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_filter.TraceStartAddrTxt3[j]='0';
                      
            if ((qlfy.m_qlfy.addr[1][0]&0x8000)==0)
                m_filter.TraceStartAddrTxt3[0]='X';
                
            if ((qlfy.m_qlfy.addr[1][0]&0x4000)==0)
                m_filter.TraceStartAddrTxt3[1]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x2000)==0)
                m_filter.TraceStartAddrTxt3[2]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x1000)==0)
                m_filter.TraceStartAddrTxt3[3]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x800)==0)
                m_filter.TraceStartAddrTxt3[4]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x400)==0)
                m_filter.TraceStartAddrTxt3[5]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x200)==0)
                m_filter.TraceStartAddrTxt3[6]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x100)==0)
                m_filter.TraceStartAddrTxt3[7]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x80)==0)
                m_filter.TraceStartAddrTxt3[8]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x40)==0)
                m_filter.TraceStartAddrTxt3[9]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x20)==0)
                m_filter.TraceStartAddrTxt3[10]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x10)==0)
                m_filter.TraceStartAddrTxt3[11]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x8)==0)
                m_filter.TraceStartAddrTxt3[12]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x4)==0)
                m_filter.TraceStartAddrTxt3[13]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x2)==0)
                m_filter.TraceStartAddrTxt3[14]='X';

            if ((qlfy.m_qlfy.addr[1][0]&0x1)==0)
                m_filter.TraceStartAddrTxt3[15]='X';
                
            m_filter.TraceStartAddrTxt3[16]='\0';
            j=0;
            for(i=0;i<16;i++)
            	j+=m_filter.TraceStartAddrTxt3[i];
            if(j=='X'*16)
            	 m_filter.TraceStartAddrTxt3[4]=0;	
            m_filter.nTraceAddrMode = 3;
            break;
        case 0x10:                       
            _itoa(qlfy.m_qlfy.addr[0][0],m_filter.TraceStartAddrTxt,16);
            _itoa(qlfy.m_qlfy.addr[1][0],m_filter.TraceEndAddrTxt,16);
            m_filter.nTraceAddrType = 0;
            m_filter.nTraceAddrMode = 1;
            break;
        case 0x40:                   
            sprintf(m_filter.TraceStartAddrTxt2,"%x,%x,%x,%x,%x,%x,%x,%x,%x,%x,",
                qlfy.m_qlfy.addr[0][0],qlfy.m_qlfy.addr[1][0],qlfy.m_qlfy.addr[2][0],qlfy.m_qlfy.addr[3][0],qlfy.m_qlfy.addr[4][0],
                qlfy.m_qlfy.addr[5][0],qlfy.m_qlfy.addr[6][0],qlfy.m_qlfy.addr[7][0],qlfy.m_qlfy.addr[8][0],qlfy.m_qlfy.addr[9][0]);
            i = searchc(m_filter.TraceStartAddrTxt2, ',', qlfy.m_qlfy.addrCount);
            m_filter.TraceStartAddrTxt2[i]='\0';
            m_filter.nTraceAddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (qlfy.m_qlfy.qlfyType[6])
    {
        case 0:   
            m_filter.nTraceDataMode = 3;                     
            strcpy(m_filter.TraceStartDataTxt3,"XX");
            break;
        case 2:
            _itoa(((WORD)qlfy.m_qlfy.data1),m_filter.TraceStartDataTxt3,2);
//          strncpy(m_filter.TraceStartDataTxt, &(m_filter.TraceStartDataTxt[8]), 8);
            i = strlen(m_filter.TraceStartDataTxt3);
            strncpy(txt,m_filter.TraceStartDataTxt3,64);
            strcpy(&(m_filter.TraceStartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_filter.TraceStartDataTxt3[j]='0';
                      
            if ((qlfy.m_qlfy.data2&0x80)==0)
                m_filter.TraceStartDataTxt3[0]='X';

            if ((qlfy.m_qlfy.data2&0x40)==0)
                m_filter.TraceStartDataTxt3[1]='X';

            if ((qlfy.m_qlfy.data2&0x20)==0)
                m_filter.TraceStartDataTxt3[2]='X';

            if ((qlfy.m_qlfy.data2&0x10)==0)
                m_filter.TraceStartDataTxt3[3]='X';

            if ((qlfy.m_qlfy.data2&0x8)==0)
                m_filter.TraceStartDataTxt3[4]='X';

            if ((qlfy.m_qlfy.data2&0x4)==0)
                m_filter.TraceStartDataTxt3[5]='X';

            if ((qlfy.m_qlfy.data2&0x2)==0)
                m_filter.TraceStartDataTxt3[6]='X';

            if ((qlfy.m_qlfy.data2&0x1)==0)
                m_filter.TraceStartDataTxt3[7]='X';
                
            m_filter.TraceStartDataTxt3[8]='\0';    
            j=0;
            for(i=0;i<8;i++)
            	j+=m_filter.TraceStartDataTxt3[i];
            if(j=='X'*8)
            	 m_filter.TraceStartDataTxt3[2]=0;	
            m_filter.nTraceDataMode = 3;
            break;
        case 0x10:
            _itoa(((WORD)qlfy.m_qlfy.data1),m_filter.TraceStartDataTxt,16);
            _itoa(((WORD)qlfy.m_qlfy.data2),m_filter.TraceEndDataTxt,16);
            m_filter.nTraceDataType=0;
            m_filter.nTraceDataMode = 1;
            break;
        case 0x1:
            sprintf(m_filter.TraceStartDataTxt2,"%x",qlfy.m_qlfy.data1);
            m_filter.nTraceDataMode = 2;
        default:
            break;
    }             

    m_filter.bTraceS = FALSE;
    m_filter.bTraceF = FALSE;
    m_filter.bTraceR = FALSE;
    m_filter.bTraceW = FALSE;
    m_filter.bTraceAK = FALSE;
    switch (qlfy.m_qlfy.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((qlfy.m_qlfy.status&1)==1)
                m_filter.bTraceS = TRUE;
            if ((qlfy.m_qlfy.status&2)==2)
                m_filter.bTraceF = TRUE;
            if ((qlfy.m_qlfy.status&4)==4)
                m_filter.bTraceR = TRUE;
            if ((qlfy.m_qlfy.status&8)==8)
                m_filter.bTraceW = TRUE;
            if ((qlfy.m_qlfy.status&0x10)==0x10)
                m_filter.bTraceAK = TRUE;
            break;            
        default:
            break;
    }             
}

void CTraceGroupDialog::SetEv1()
{                  
    long lVar1,lVar2;   
    int j;
    char txt1[200];           
    char* ptr;      
    WORD addr;             
    char a[2];
    
    BeginWaitCursor();
    ev1.m_nClearflag = 0;
    
    ev1.m_tmpBusEv.qlfyType[0]=1;   
    ev1.m_eventID = 1;
    
    switch (m_event.nEv1AddrMode)
    {
        case 1:   
            lVar1 = strtoul(m_event.Ev1StartAddrTxt, NULL, 16);
            ev1.m_tmpBusEv.addr[0][0]=(WORD)lVar1;
            lVar2 = strtoul(m_event.Ev1EndAddrTxt, NULL, 16);
            if (m_event.nEv1AddrType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Address Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            ev1.m_tmpBusEv.addr[1][0]=(WORD)lVar1;
            //11/12/95: when address type is range, set addrCount to 2.
            ev1.m_tmpBusEv.addrCount=2;
            ev1.m_tmpBusEv.qlfyType[4]=0x10;
            break;
        case 2:
            strcpy(txt1,m_event.Ev1StartAddrTxt2);
            ptr = strtok(txt1," ,");
            j = 0;
            do
            {
                while(ptr[0]=='0')
                     ptr++;
                if(ptr[0]=='\0') ptr--;     
                lVar1=strtoul(ptr,NULL,16);
                ev1.m_tmpBusEv.addr[j][0]=(WORD)lVar1;
                ptr = strtok(NULL," ,");
                j++;
            }while(ptr!=NULL);
            ev1.m_tmpBusEv.qlfyType[4]=0x40;
            ev1.m_tmpBusEv.addrCount =(WORD) j;
            break;
        case 3:  
            ev1.m_tmpBusEv.addr[0][0]=0;
            ev1.m_tmpBusEv.addr[1][0]=0xffff;
            j =  strlen(m_event.Ev1StartAddrTxt3);
            if (j==4)
            {
                if ((m_event.Ev1StartAddrTxt3[3]=='x')||(m_event.Ev1StartAddrTxt3[3]=='X'))
                {                         
                    ev1.m_tmpBusEv.addr[1][0]&=0xfff0;
                }
                else
                {                            
                    a[0]=m_event.Ev1StartAddrTxt3[3];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    ev1.m_tmpBusEv.addr[0][0]+=addr;
                }
                
                if ((m_event.Ev1StartAddrTxt3[2]=='x')||(m_event.Ev1StartAddrTxt3[2]=='X'))
                {                         
                    ev1.m_tmpBusEv.addr[1][0]&=0xff0f;
                }
                else
                {                            
                    a[0]=m_event.Ev1StartAddrTxt3[2];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    ev1.m_tmpBusEv.addr[0][0]+=addr;
                }             
                
                if ((m_event.Ev1StartAddrTxt3[1]=='x')||(m_event.Ev1StartAddrTxt3[1]=='X'))
                {                         
                    ev1.m_tmpBusEv.addr[1][0]&=0xf0ff;
                }
                else
                {                            
                    a[0]=m_event.Ev1StartAddrTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);        
                    addr <<= 8;
                    ev1.m_tmpBusEv.addr[0][0]+=addr;
                }             
                
                if ((m_event.Ev1StartAddrTxt3[0]=='x')||(m_event.Ev1StartAddrTxt3[0]=='X'))
                {                         
                    ev1.m_tmpBusEv.addr[1][0]&=0x0fff;
                }
                else
                {                            
                    a[0]=m_event.Ev1StartAddrTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 12;
                    ev1.m_tmpBusEv.addr[0][0]+=addr;
                }
            }                  
            if (j==16)
            {
                for(j=0;j<=15;j++)
                {
                    switch (m_event.Ev1StartAddrTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            ev1.m_tmpBusEv.addr[1][0]-=(WORD)(1<<(15-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            ev1.m_tmpBusEv.addr[0][0]+=(WORD)(1<<(15-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            ev1.m_tmpBusEv.addrCount =2;            
            ev1.m_tmpBusEv.qlfyType[4]=0x2;
            break;
        default:
            break;      
    }

    switch (m_event.nEv1DataMode)
    {
        case 1:   
            lVar1 = strtoul(m_event.Ev1StartDataTxt, NULL, 16);
            ev1.m_tmpBusEv.data1=(DWORD)lVar1;
            lVar2 = strtoul(m_event.Ev1EndDataTxt, NULL, 16);
            if (m_event.nEv1DataType == 1)//length
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Data Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            ev1.m_tmpBusEv.data2=(DWORD)lVar1;
            ev1.m_tmpBusEv.qlfyType[6]=0x10;
            break;
        case 2: 
            lVar1 = strtoul(m_event.Ev1StartDataTxt2, NULL, 16);
            ev1.m_tmpBusEv.data1=(DWORD)lVar1;
            ev1.m_tmpBusEv.qlfyType[6]=1;
            break;
        case 3:
            ev1.m_tmpBusEv.data1=0;
            ev1.m_tmpBusEv.data2=0xff;
            j = strlen(m_event.Ev1StartDataTxt3);
            if (j==2)
            {
                if ((m_event.Ev1StartDataTxt3[1]=='x')||(m_event.Ev1StartDataTxt3[1]=='X'))
                {                         
                    ev1.m_tmpBusEv.data2&=0xf0;
                }
                else
                {                            
                    a[0]=m_event.Ev1StartDataTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    ev1.m_tmpBusEv.data1+=addr;
                }
                
                if ((m_event.Ev1StartDataTxt3[0]=='x')||(m_event.Ev1StartDataTxt3[0]=='X'))
                {                         
                    ev1.m_tmpBusEv.data2&=0xf;
                }
                else
                {                            
                    a[0]=m_event.Ev1StartDataTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    ev1.m_tmpBusEv.data1+=addr;
                }             
                
            }                  
            if (j==8)
            {
                for(j=0;j<=7;j++)
                {
                    switch (m_event.Ev1StartDataTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            ev1.m_tmpBusEv.data2-=(1<<(7-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            ev1.m_tmpBusEv.data1+=(1<<(7-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            ev1.m_tmpBusEv.qlfyType[6]=0x2;
            break;
        default:
            break;      
    }
    lVar1 = strtol(m_event.Ev1CountTxt,NULL,16);
    
    ev1.m_tmpBusEv.count = (DWORD)lVar1;
    if (lVar1>0)
        ev1.m_tmpBusEv.qlfyType[10]=1;
    else
        ev1.m_tmpBusEv.qlfyType[10]=0;
    
    lVar1=0;
    if (m_event.bEv1S) lVar1+=0x1;
    if (m_event.bEv1F) lVar1+=0x2;
    if (m_event.bEv1R) lVar1+=0x4;
    if (m_event.bEv1W) lVar1+=0x8;
    if (m_event.bEv1AK) lVar1+=0x10;
    
    ev1.m_tmpBusEv.status = (DWORD)lVar1;
    if (lVar1>0) ev1.m_tmpBusEv.qlfyType[8]=1;
    else ev1.m_tmpBusEv.qlfyType[8]=0;
    
//  memcpy(&(ev1.m_tmpBusEv),&(ev1.m_tmpBusEv),sizeof(BUS_EVENT));
//  ev1.SetbyWnd();
    
    int nErrorID = AbiSetEvent(ev1.m_tmpBusEv);
    EndWaitCursor();
    
    if (ICE_OK==nErrorID)
    {
        memcpy(&(ev1.m_busEv),&(ev1.m_tmpBusEv),sizeof(BUS_EVENT));
    }
    else
    {
        MessageBox("EV1 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }   
}

void CTraceGroupDialog::SetEv2()
{
    long lVar1,lVar2;   
    int j;
    char txt1[200];           
    char* ptr;      
    WORD addr;             
    char a[2];
                    
    BeginWaitCursor();                
    ev2.m_nClearflag = 0;
    
    ev2.m_tmpBusEv.qlfyType[0]=2;   
    ev2.m_eventID=2;
    
    switch (m_event.nEv2AddrMode)
    {
        case 1:   
            lVar1 = strtoul(m_event.Ev2StartAddrTxt, NULL, 16);
            ev2.m_tmpBusEv.addr[0][0]=(WORD)lVar1;
            lVar2 = strtoul(m_event.Ev2EndAddrTxt, NULL, 16);
            if (m_event.nEv2AddrType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Address Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            ev2.m_tmpBusEv.addr[1][0]=(WORD)lVar1;
            //11/12/95: when address type is range, set addrCount to 2.
            ev2.m_tmpBusEv.addrCount=2;
            ev2.m_tmpBusEv.qlfyType[4]=0x10;
            break;
        case 2:
            strcpy(txt1,m_event.Ev2StartAddrTxt2);
            ptr = strtok(txt1," ,");
            j = 0;
            do
            {
                while(ptr[0]=='0')
                     ptr++;
                if(ptr[0]=='\0') ptr--;     
                lVar1=strtoul(ptr,NULL,16);
                ev2.m_tmpBusEv.addr[j][0]=(WORD)lVar1;
                ptr = strtok(NULL," ,");
                j++;
            }while(ptr!=NULL);
            ev2.m_tmpBusEv.qlfyType[4]=0x40;
            ev2.m_tmpBusEv.addrCount = (WORD)j;
            break;
        case 3:  
            ev2.m_tmpBusEv.addr[0][0]=0;
            ev2.m_tmpBusEv.addr[1][0]=0xffff;
            j = strlen(m_event.Ev2StartAddrTxt3);
            if (j==4)
            {
                if ((m_event.Ev2StartAddrTxt3[3]=='x')||(m_event.Ev2StartAddrTxt3[3]=='X'))
                {                         
                    ev2.m_tmpBusEv.addr[1][0]&=0xfff0;
                }
                else
                {                            
                    a[0]=m_event.Ev2StartAddrTxt3[3];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    ev2.m_tmpBusEv.addr[0][0]+=addr;
                }
                
                if ((m_event.Ev2StartAddrTxt3[2]=='x')||(m_event.Ev2StartAddrTxt3[2]=='X'))
                {                         
                    ev2.m_tmpBusEv.addr[1][0]&=0xff0f;
                }
                else
                {                            
                    a[0]=m_event.Ev2StartAddrTxt3[2];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    ev2.m_tmpBusEv.addr[0][0]+=addr;
                }             
                
                if ((m_event.Ev2StartAddrTxt3[1]=='x')||(m_event.Ev2StartAddrTxt3[1]=='X'))
                {                         
                    ev2.m_tmpBusEv.addr[1][0]&=0xf0ff;
                }
                else
                {                            
                    a[0]=m_event.Ev2StartAddrTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16); 
                    addr <<= 8;
                    ev2.m_tmpBusEv.addr[0][0]+=addr;
                }             
                
                if ((m_event.Ev2StartAddrTxt3[0]=='x')||(m_event.Ev2StartAddrTxt3[0]=='X'))
                {                         
                    ev2.m_tmpBusEv.addr[1][0]&=0x0fff;
                }
                else
                {                            
                    a[0]=m_event.Ev2StartAddrTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 12;
                    ev2.m_tmpBusEv.addr[0][0]+=addr;
                }
            }                  
            if (j==16)
            {
                for(j=0;j<=15;j++)
                {
                    switch (m_event.Ev2StartAddrTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            ev2.m_tmpBusEv.addr[1][0]-=(WORD)(1<<(15-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            ev2.m_tmpBusEv.addr[0][0]+=(WORD)(1<<(15-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            ev2.m_tmpBusEv.addrCount =2;            
            ev2.m_tmpBusEv.qlfyType[4]=0x2;
            break;
        default:
            break;      
    }

    switch (m_event.nEv2DataMode)
    {
        case 1:   
            lVar1 = strtoul(m_event.Ev2StartDataTxt, NULL, 16);
            ev2.m_tmpBusEv.data1=(DWORD)lVar1;
            lVar2 = strtoul(m_event.Ev2EndDataTxt, NULL, 16);
            if (m_event.nEv2DataType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Data Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            ev2.m_tmpBusEv.data2=(DWORD)lVar1;
            ev2.m_tmpBusEv.qlfyType[6]=0x10;
            break;
        case 2: 
            lVar1 = strtoul(m_event.Ev2StartDataTxt2, NULL, 16);
            ev2.m_tmpBusEv.data1=(DWORD)lVar1;
            ev2.m_tmpBusEv.qlfyType[6]=1;
            break;
        case 3:
            ev2.m_tmpBusEv.data1=0;
            ev2.m_tmpBusEv.data2=0xff;
            j = strlen(m_event.Ev2StartDataTxt3);
            if (j==2)
            {
                if ((m_event.Ev2StartDataTxt3[1]=='x')||(m_event.Ev2StartDataTxt3[1]=='X'))
                {                         
                    ev2.m_tmpBusEv.data2&=0xf0;
                }
                else
                {                            
                    a[0]=m_event.Ev2StartDataTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    ev2.m_tmpBusEv.data1+=addr;
                }
                
                if ((m_event.Ev2StartDataTxt3[0]=='x')||(m_event.Ev2StartDataTxt3[0]=='X'))
                {                         
                    ev2.m_tmpBusEv.data2&=0xf;
                }
                else
                {                            
                    a[0]=m_event.Ev2StartDataTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    ev2.m_tmpBusEv.data1+=addr;
                }             
                
            }                  
            if (j==8)
            {
                for(j=0;j<=7;j++)
                {
                    switch (m_event.Ev2StartDataTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            ev2.m_tmpBusEv.data2-=(1<<(7-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            ev2.m_tmpBusEv.data1+=(1<<(7-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            ev2.m_tmpBusEv.qlfyType[6]=0x02;
            break;
        default:
            break;      
    }
    lVar1=0;
    if (m_event.bEv2S) lVar1+=0x1;
    if (m_event.bEv2F) lVar1+=0x2;
    if (m_event.bEv2R) lVar1+=0x4;
    if (m_event.bEv2W) lVar1+=0x8;
    if (m_event.bEv2AK) lVar1+=0x10;
    
    ev2.m_tmpBusEv.status = (DWORD)lVar1;
    if (lVar1>0) ev2.m_tmpBusEv.qlfyType[8]=1;
    else ev2.m_tmpBusEv.qlfyType[8]=0;

//  memcpy(&(ev2.m_tmpBusEv),&(ev2.m_tmpBusEv),sizeof(BUS_EVENT));
//  ev2.SetbyWnd();
    
    int nErrorID = AbiSetEvent(ev2.m_tmpBusEv);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(ev2.m_busEv),&(ev2.m_tmpBusEv),sizeof(BUS_EVENT));
    }
    else
    {
        MessageBox("EV2 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }   
}

void CTraceGroupDialog::SetEv3()
{
//  long lVar2;   
//  int j;
//  char txt1[200];           
//  char* ptr;      
//  WORD addr;             
//  char a[2];
                    
    BeginWaitCursor();                
    ev3.m_nClearflag = 0;
    
    ev3.m_tmpExtEv.qlfyType[0]=3;   
    
    switch (m_event.nEv3HL)
    {
        case 1:
            ev3.m_nStatusflag = 1;
            ev3.m_tmpExtEv.qlfyType[9]=1;
            ev3.m_tmpExtEv.extrn = 1;
            break;
        case 2:
            ev3.m_nStatusflag = 0;
            ev3.m_tmpExtEv.qlfyType[9]=1;
            ev3.m_tmpExtEv.extrn = 0;
            break;
        default:
            ev3.m_tmpExtEv.qlfyType[9]=0;
            ev3.m_nClearflag = 1;
            break;
    }
    
    int nErrorID = AbiSetEvent(ev3.m_tmpExtEv);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(ev3.m_extEv),&(ev3.m_tmpExtEv),sizeof(BUS_EVENT));
    }
    else
    {
        MessageBox("EV3 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }   
}

void CTraceGroupDialog::SetLevel1()
{
    BeginWaitCursor();
    switch (m_trigger.level1.nSet)
    {
        case 0:
            Le1.m_levelStruct.Condition = 0x0;
            break;
        case 1:
            Le1.m_levelStruct.Condition = 0xAAAAAAAA;
            break;
        case 2:
            Le1.m_levelStruct.Condition = 0xEEEEEEEE;
            break;
        case 3:
            Le1.m_levelStruct.Condition = 0xFAFAFAFA;
            break;
        case 4:
            Le1.m_levelStruct.Condition = 0xE0E0E0E0;
            break;
        case 5:
            Le1.m_levelStruct.Condition = 0xC8C8C8C8;
            break;
        case 6:
            Le1.m_levelStruct.Condition = 0xFEFEFEFE;
            break;
        case 7:
            Le1.m_levelStruct.Condition = 0x88888888;
            break;
        case 8:
            Le1.m_levelStruct.Condition = 0xA0A0A0A0;
            break;
        case 9:
            Le1.m_levelStruct.Condition = 0xF8F8F8F8;
            break;
        case 10:
            Le1.m_levelStruct.Condition = 0xECECECEC;
            break;
        case 11:
            Le1.m_levelStruct.Condition = 0x80808080;
            break;
        case 12:
            Le1.m_levelStruct.Condition = 0xCCCCCCCC;
            break;
        case 13:
            Le1.m_levelStruct.Condition = 0xFCFCFCFC;
            break;
        case 14:
            Le1.m_levelStruct.Condition = 0xA8A8A8A8;
            break;
        case 15:
            Le1.m_levelStruct.Condition = 0xC0C0C0C0;
            break;
        case 16:
            Le1.m_levelStruct.Condition = 0xEAEAEAEA;
            break;
        case 17:
            Le1.m_levelStruct.Condition = 0xF0F0F0F0;
            break;
    }
    
    if (m_trigger.level1.bTraceOn)
        Le1.m_levelStruct.TraceFlg=1;
    else
        Le1.m_levelStruct.TraceFlg=2;

    if (m_trigger.level1.bTimerOn)
        Le1.m_levelStruct.TimerFlg=1;
    else
        Le1.m_levelStruct.TimerFlg=2;
    
    TRIGGER_LEVEL trigLevel;
    memcpy(&trigLevel,&(Le1.m_levelStruct),sizeof(TRIGGER_LEVEL));
    int nErrorID=AbiSetTrigLevel(1,trigLevel);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Le1.m_levelStructSave),&(Le1.m_levelStruct),sizeof(TRIGGER_LEVEL));
    }
    else
    {
        MessageBox("Level1 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }
}

void CTraceGroupDialog::SetLevel2()
{
    BeginWaitCursor();
    switch (m_trigger.level2.nSet)
    {
        case 0:
            Le2.m_levelStruct.Condition = 0x0;
            break;
        case 1:
            Le2.m_levelStruct.Condition = 0xAAAAAAAA;
            break;
        case 2:
            Le2.m_levelStruct.Condition = 0xEEEEEEEE;
            break;
        case 3:
            Le2.m_levelStruct.Condition = 0xFAFAFAFA;
            break;
        case 4:
            Le2.m_levelStruct.Condition = 0xE0E0E0E0;
            break;
        case 5:
            Le2.m_levelStruct.Condition = 0xC8C8C8C8;
            break;
        case 6:
            Le2.m_levelStruct.Condition = 0xFEFEFEFE;
            break;
        case 7:
            Le2.m_levelStruct.Condition = 0x88888888;
            break;
        case 8:
            Le2.m_levelStruct.Condition = 0xA0A0A0A0;
            break;
        case 9:
            Le2.m_levelStruct.Condition = 0xF8F8F8F8;
            break;
        case 10:
            Le2.m_levelStruct.Condition = 0xECECECEC;
            break;
        case 11:
            Le2.m_levelStruct.Condition = 0x80808080;
            break;
        case 12:
            Le2.m_levelStruct.Condition = 0xCCCCCCCC;
            break;
        case 13:
            Le2.m_levelStruct.Condition = 0xFCFCFCFC;
            break;
        case 14:
            Le2.m_levelStruct.Condition = 0xA8A8A8A8;
            break;
        case 15:
            Le2.m_levelStruct.Condition = 0xC0C0C0C0;
            break;
        case 16:
            Le2.m_levelStruct.Condition = 0xEAEAEAEA;
            break;
        case 17:
            Le2.m_levelStruct.Condition = 0xF0F0F0F0;
            break;
    }
    
    if (m_trigger.level2.bTraceOn)
        Le2.m_levelStruct.TraceFlg=1;
    else
        Le2.m_levelStruct.TraceFlg=2;

    if (m_trigger.level2.bTimerOn)
        Le2.m_levelStruct.TimerFlg=1;
    else
        Le2.m_levelStruct.TimerFlg=2;

    TRIGGER_LEVEL trigLevel;
    memcpy(&trigLevel,&(Le2.m_levelStruct),sizeof(TRIGGER_LEVEL));
    int nErrorID=AbiSetTrigLevel(2,trigLevel);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Le2.m_levelStructSave),&(Le2.m_levelStruct),sizeof(TRIGGER_LEVEL));
    }
    else
    {
        MessageBox("Level2 Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }
}

void CTraceGroupDialog::SetTrigger()
{
    BeginWaitCursor();
    TraceWnd((unsigned char)m_traceControl.bStartTrace);
    TimerWnd((unsigned char)m_traceControl.bStartTimer);
    switch (m_traceControl.nDelay)
    {
        case 1:
            Trig.m_tmpTrig.TrigFlg = 1;			//forward
            break;
        case 2:
            Trig.m_tmpTrig.TrigFlg = 3;         //center
            break;
        case 3:
            Trig.m_tmpTrig.TrigFlg = 2;         //backward
            break;
        case 4:
            Trig.m_tmpTrig.TrigFlg = 0;			//delay count
            Trig.m_tmpTrig.DlayCnt=strtol(m_traceControl.delayTxt,NULL,16);
            break;
        default:
            break;  
    }
    if (m_trigger.bRun==FALSE)
        Trig.m_tmpTrig.RunFlg=0;
    else
        Trig.m_tmpTrig.RunFlg=1;

    switch (m_trigger.nTriggerSet)
    {
        case 0:
            Trig.m_tmpTrig.LevelCount=0;
            Trig.m_tmpTrig.LevelID[0]=0;
            Trig.m_tmpTrig.LevelID[2]=0;
            break;
        case 1:
            Trig.m_tmpTrig.LevelCount=1;
            Trig.m_tmpTrig.LevelID[0]=1;
            Trig.m_tmpTrig.LevelID[2]=0;
            break;
        case 2:
            Trig.m_tmpTrig.LevelCount=1;
            Trig.m_tmpTrig.LevelID[0]=2;
            Trig.m_tmpTrig.LevelID[2]=0;
            break;
        case 3:
            Trig.m_tmpTrig.LevelCount=2;
            Trig.m_tmpTrig.LevelID[0]=1;
            Trig.m_tmpTrig.LevelID[1]=2;
            break;
//      case 4:
//          Trig.m_tmpTrig.LevelCount=2;
//          Trig.m_tmpTrig.LevelID[0]=2;
//          Trig.m_tmpTrig.LevelID[2]=1;
//          break;
        default:
            break;  
    }   
    
    BYTE old=Trig.m_nOnOffFlg;
    if (m_trigger.bTriggerEnable)
        Trig.m_nOnOffFlg=1;
    else
        Trig.m_nOnOffFlg=0;
    
    TRIGGER_LOGIC trig;
    memcpy(&trig,&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
    int nErrorID=AbiSetTrigLogic(trig);
    if(old!=Trig.m_nOnOffFlg)
    	nErrorID|=AbiSetTrigStatus(FLAG(Trig.m_nOnOffFlg));
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Trig.m_trig),&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
    }
    else
    {
        MessageBox("Trigger Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }
}

void CTraceGroupDialog::SetDisplayFilter()
{
    long lVar1,lVar2;   
    int j;
    char txt1[200];           
    char* ptr;      
    WORD addr;             
    char a[2];
    
    BeginWaitCursor();
    
    softQlfy.qlfyType[0]=0;
    
    switch (m_filter.nDisplayAddrMode)
    {
        case 1:   
            lVar1 = strtoul(m_filter.DisplayStartAddrTxt, NULL, 16);
            softQlfy.addr[0][0]=(WORD)lVar1;
            lVar2 = strtoul(m_filter.DisplayEndAddrTxt, NULL, 16);
            if (m_filter.nDisplayAddrType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Address Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            softQlfy.addr[1][0]=(WORD)lVar1;
            //11/12/95: when address type is range, set addrCount to 2.
            softQlfy.addrCount=2;
            softQlfy.qlfyType[4]=0x10;
            break;
        case 2:
            strcpy(txt1,m_filter.DisplayStartAddrTxt2);
            ptr = strtok(txt1," ,");
            j = 0;
            do
            {
                while(ptr[0]=='0')
                     ptr++;
                if(ptr[0]=='\0') ptr--;     
                lVar1=strtoul(ptr,NULL,16);
                softQlfy.addr[j][0]=(WORD)lVar1;
                ptr = strtok(NULL," ,");
                j++;
            }while(ptr!=NULL);
            softQlfy.qlfyType[4]=0x40;
            softQlfy.addrCount = (WORD)j;
            break;
        case 3:  
            softQlfy.addr[0][0]=0;
            softQlfy.addr[1][0]=0xffff;
            j =(WORD) strlen(m_filter.DisplayStartAddrTxt3);
            if (j==4)
            {
                if ((m_filter.DisplayStartAddrTxt3[3]=='x')||(m_filter.DisplayStartAddrTxt3[3]=='X'))
                {                         
                    softQlfy.addr[1][0]&=0xfff0;
                }
                else
                {                            
                    a[0]=m_filter.DisplayStartAddrTxt3[3];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    softQlfy.addr[0][0]+=addr;
                }
                
                if ((m_filter.DisplayStartAddrTxt3[2]=='x')||(m_filter.DisplayStartAddrTxt3[2]=='X'))
                {                         
                    softQlfy.addr[1][0]&=0xff0f;
                }
                else
                {                            
                    a[0]=m_filter.DisplayStartAddrTxt3[2];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    softQlfy.addr[0][0]+=addr;
                }             
                
                if ((m_filter.DisplayStartAddrTxt3[1]=='x')||(m_filter.DisplayStartAddrTxt3[1]=='X'))
                {                         
                    softQlfy.addr[1][0]&=0xf0ff;
                }
                else
                {                            
                    a[0]=m_filter.DisplayStartAddrTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 8;
                    softQlfy.addr[0][0]+=addr;
                }             
                
                if ((m_filter.DisplayStartAddrTxt3[0]=='x')||(m_filter.DisplayStartAddrTxt3[0]=='X'))
                {                         
                    softQlfy.addr[1][0]&=0x0fff;
                }
                else
                {                            
                    a[0]=m_filter.DisplayStartAddrTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 12;
                    softQlfy.addr[0][0]+=addr;
                }
            }                  
            if (j==16)
            {
                for(j=0;j<=15;j++)
                {
                    switch (m_filter.DisplayStartAddrTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            softQlfy.addr[1][0]-=(WORD)(1<<(15-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            softQlfy.addr[0][0]+=(WORD)(1<<(15-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            softQlfy.addrCount =2;
            softQlfy.qlfyType[4]=0x2;
            break;
        default:
            break;      
    }

    switch (m_filter.nDisplayDataMode)
    {
        case 1:   
            lVar1 = strtoul(m_filter.DisplayStartDataTxt, NULL, 16);
            softQlfy.data1=(DWORD)lVar1;
            lVar2 = strtoul(m_filter.DisplayEndDataTxt, NULL, 16);
            if (m_filter.nDisplayDataType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Data Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            softQlfy.data2=(DWORD)lVar1;
            softQlfy.qlfyType[6]=0x10;
            break;
        case 2: 
            lVar1 = strtoul(m_filter.DisplayStartDataTxt2, NULL, 16);
            softQlfy.data1=(DWORD)lVar1;
            softQlfy.qlfyType[6]=1;
            break;
        case 3:
            softQlfy.data1=0;
            softQlfy.data2=0xff;
            j = strlen(m_filter.DisplayStartDataTxt3);
            if (j==2)
            {
                if ((m_filter.DisplayStartDataTxt3[1]=='x')||(m_filter.DisplayStartDataTxt3[1]=='X'))
                {                         
                    softQlfy.data2&=0xf0;
                }
                else
                {                            
                    a[0]=m_filter.DisplayStartDataTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    softQlfy.data1+=addr;
                }
                
                if ((m_filter.DisplayStartDataTxt3[0]=='x')||(m_filter.DisplayStartDataTxt3[0]=='X'))
                {                         
                    softQlfy.data2&=0xf;
                }
                else
                {                            
                    a[0]=m_filter.DisplayStartDataTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    softQlfy.data1+=addr;
                }             
                
            }                  
            if (j==8)
            {
                for(j=0;j<=7;j++)
                {
                    switch (m_filter.DisplayStartDataTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            softQlfy.data2-=(1<<(7-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            softQlfy.data1+=(1<<(7-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            softQlfy.qlfyType[6]=0x2;
            break;
        default:
            break;      
    }
    lVar1=0;
    if (m_filter.bDisplayS) lVar1+=0x1;
    if (m_filter.bDisplayF) lVar1+=0x2;
    if (m_filter.bDisplayR) lVar1+=0x4;
    if (m_filter.bDisplayW) lVar1+=0x8;
    if (m_filter.bDisplayAK) lVar1+=0x10;
    
    softQlfy.status = (DWORD)lVar1;
    if (lVar1>0) softQlfy.qlfyType[8]=1;
    else softQlfy.qlfyType[8]=0;
    
    EndWaitCursor();
}

void CTraceGroupDialog::SetTraceFilter()
{
    long lVar1,lVar2;   
    int j;
    char txt1[200];           
    char* ptr;      
    WORD addr;             
    char a[2];
    
    BeginWaitCursor();
    qlfy.m_nClearflag = 0;
    
    qlfy.m_tmpQlfy.qlfyType[0]=0;   
    
    switch (m_filter.nTraceAddrMode)
    {
        case 1:   
            lVar1 = strtoul(m_filter.TraceStartAddrTxt, NULL, 16);
            qlfy.m_tmpQlfy.addr[0][0]=(WORD)lVar1;
            lVar2 = strtoul(m_filter.TraceEndAddrTxt, NULL, 16);
            if (m_filter.nTraceAddrType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Address Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            qlfy.m_tmpQlfy.addr[1][0]=(WORD)lVar1;
            //11/12/95: when address type is range, set addrCount to 2.
            qlfy.m_tmpQlfy.addrCount=2;
            qlfy.m_tmpQlfy.qlfyType[4]=0x10;
            break;
        case 2:
            strcpy(txt1,m_filter.TraceStartAddrTxt2);
            ptr = strtok(txt1," ,");
            j = 0;
            do
            {
                while(ptr[0]=='0')
                     ptr++;
                if(ptr[0]=='\0') ptr--;     
                lVar1=strtoul(ptr,NULL,16);
                qlfy.m_tmpQlfy.addr[j][0]=(WORD)lVar1;
                ptr = strtok(NULL," ,");
                j++;
            }while(ptr!=NULL);
            qlfy.m_tmpQlfy.qlfyType[4]=0x40;
            qlfy.m_tmpQlfy.addrCount =(WORD) j;
            break;
        case 3:  
            qlfy.m_tmpQlfy.addr[0][0]=0;
            qlfy.m_tmpQlfy.addr[1][0]=0xffff;
            j = strlen(m_filter.TraceStartAddrTxt3);
            if (j==4)
            {
                if ((m_filter.TraceStartAddrTxt3[3]=='x')||(m_filter.TraceStartAddrTxt3[3]=='X'))
                {                         
                    qlfy.m_tmpQlfy.addr[1][0]&=0xfff0;
                }
                else
                {                            
                    a[0]=m_filter.TraceStartAddrTxt3[3];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    qlfy.m_tmpQlfy.addr[0][0]+=addr;
                }
                
                if ((m_filter.TraceStartAddrTxt3[2]=='x')||(m_filter.TraceStartAddrTxt3[2]=='X'))
                {                         
                    qlfy.m_tmpQlfy.addr[1][0]&=0xff0f;
                }
                else
                {                            
                    a[0]=m_filter.TraceStartAddrTxt3[2];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    qlfy.m_tmpQlfy.addr[0][0]+=addr;
                }             
                
                if ((m_filter.TraceStartAddrTxt3[1]=='x')||(m_filter.TraceStartAddrTxt3[1]=='X'))
                {                         
                    qlfy.m_tmpQlfy.addr[1][0]&=0xf0ff;
                }
                else
                {                            
                    a[0]=m_filter.TraceStartAddrTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);        
                    addr <<= 8;
                    qlfy.m_tmpQlfy.addr[0][0]+=addr;
                }             
                
                if ((m_filter.TraceStartAddrTxt3[0]=='x')||(m_filter.TraceStartAddrTxt3[0]=='X'))
                {                         
                    qlfy.m_tmpQlfy.addr[1][0]&=0x0fff;
                }
                else
                {                            
                    a[0]=m_filter.TraceStartAddrTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 12;
                    qlfy.m_tmpQlfy.addr[0][0]+=addr;
                }
            }                  
            if (j==16)
            {
                for(j=0;j<=15;j++)
                {
                    switch (m_filter.TraceStartAddrTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            qlfy.m_tmpQlfy.addr[1][0]-=(WORD)(1<<(15-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            qlfy.m_tmpQlfy.addr[0][0]+=(WORD)(1<<(15-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            qlfy.m_tmpQlfy.addrCount =2;
            qlfy.m_tmpQlfy.qlfyType[4]=0x2;
            break;
        default:                 
            break;      
    }

    switch (m_filter.nTraceDataMode)
    {
        case 1:   
            lVar1 = strtoul(m_filter.TraceStartDataTxt, NULL, 16);
            qlfy.m_tmpQlfy.data1=(DWORD)lVar1;
            lVar2 = strtoul(m_filter.TraceEndDataTxt, NULL, 16);
            if (m_filter.nTraceDataType == 1)
            {
                lVar1 = lVar1 + lVar2;
                if (lVar2>0) lVar1--;
            }   
            else
            {
                if (lVar1>lVar2) 
                {
                    MessageBox("End Data Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
                    return;
                }
                lVar1 = lVar2;                     
            }
            qlfy.m_tmpQlfy.data2=(DWORD)lVar1;
            qlfy.m_tmpQlfy.qlfyType[6]=0x10;
            break;
        case 2: 
            lVar1 = strtoul(m_filter.TraceStartDataTxt2, NULL, 16);
            qlfy.m_tmpQlfy.data1=(DWORD)lVar1;
            qlfy.m_tmpQlfy.qlfyType[6]=1;
            break;
        case 3:
            qlfy.m_tmpQlfy.data1=0;
            qlfy.m_tmpQlfy.data2=0xff;
            j = strlen(m_filter.TraceStartDataTxt3);
            if (j==2)
            {
                if ((m_filter.TraceStartDataTxt3[1]=='x')||(m_filter.TraceStartDataTxt3[1]=='X'))
                {                         
                    qlfy.m_tmpQlfy.data2&=0xf0;
                }
                else
                {                            
                    a[0]=m_filter.TraceStartDataTxt3[1];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    qlfy.m_tmpQlfy.data1+=addr;
                }
                
                if ((m_filter.TraceStartDataTxt3[0]=='x')||(m_filter.TraceStartDataTxt3[0]=='X'))
                {                         
                    qlfy.m_tmpQlfy.data2&=0xf;
                }
                else
                {                            
                    a[0]=m_filter.TraceStartDataTxt3[0];
                    a[1]='\0';
                    addr = (WORD)strtol( a, NULL, 16);
                    addr <<= 4;
                    qlfy.m_tmpQlfy.data1+=addr;
                }             
                
            }                  
            if (j==8)
            {
                for(j=0;j<=7;j++)
                {
                    switch (m_filter.TraceStartDataTxt3[j])
                    {
                        case 'x':
                        case 'X':
                            qlfy.m_tmpQlfy.data2-=(ULONG)(1<<(7-j));
                            break;
                        case '0':
                            break;
                        case '1':
                            qlfy.m_tmpQlfy.data1+=(ULONG)(1<<(7-j));
                            break;
                        default:
                            break;
                    }
                }
            }
            qlfy.m_tmpQlfy.qlfyType[6]=0x2;
            break;
        default:
            break;      
    }
    lVar1=0;
    if (m_filter.bTraceS) lVar1+=0x1;
    if (m_filter.bTraceF) lVar1+=0x2;
    if (m_filter.bTraceR) lVar1+=0x4;
    if (m_filter.bTraceW) lVar1+=0x8;
    if (m_filter.bTraceAK) lVar1+=0x10;
    
    qlfy.m_tmpQlfy.status = (DWORD)lVar1;
    if (lVar1>0) qlfy.m_tmpQlfy.qlfyType[8]=1;
    else qlfy.m_tmpQlfy.qlfyType[8]=0;
    
//  memcpy(&(qlfy.m_tmpBusEv),&(qlfy.m_tmpQlfy),sizeof(BUS_EVENT));
//  qlfy.SetbyWnd();
    
    QUALIFY q;
    memcpy(&q,&(qlfy.m_tmpQlfy),sizeof(QUALIFY));
    int nErrorID = AbiSetQualify(q);
    EndWaitCursor();
    
    if (ICE_OK==nErrorID)
    {
        memcpy(&(qlfy.m_qlfy),&(qlfy.m_tmpQlfy),sizeof(QUALIFY));
    }
    else
    {
        MessageBox("Qualify Set Error!",NULL, MB_OK | MB_ICONEXCLAMATION);
    }   
}
      
CTraceGroupDialog::CTraceGroupDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CTraceGroupDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CTraceGroupDialog)
    m_Tab = NULL;
    //}}AFX_DATA_INIT
    
    m_event.nActiveEvent = 1;                 
    m_event.nEv1AddrMode = 1;
    m_event.Ev1StartAddrTxt[0]='\0'; 
    m_event.Ev1StartAddrTxt2[0]='\0';
    m_event.Ev1StartAddrTxt3[0]='\0';
    m_event.Ev1EndAddrTxt[0]='\0';
    m_event.nEv1AddrType = 0;
    m_event.nEv1DataMode = 1;
    m_event.Ev1StartDataTxt[0]='\0'; 
    m_event.Ev1StartDataTxt2[0]='\0';
    m_event.Ev1StartDataTxt3[0]='\0';
    m_event.Ev1EndDataTxt[0]='\0';
    m_event.nEv1DataType=0;
    
    m_event.bEv1S = FALSE;
    m_event.bEv1F = FALSE;
    m_event.bEv1R = FALSE;
    m_event.bEv1W = FALSE;
    m_event.bEv1AK = FALSE;
    
    m_event.Ev1CountTxt[0]='\0';

    m_event.nEv2AddrMode = 1;
    m_event.Ev2StartAddrTxt[0]='\0'; 
    m_event.Ev2StartAddrTxt2[0]='\0';
    m_event.Ev2StartAddrTxt3[0]='\0';
    m_event.Ev2EndAddrTxt[0]='\0';
    m_event.nEv2AddrType = 0;
    m_event.nEv2DataMode = 1;
    m_event.Ev2StartDataTxt[0]='\0'; 
    m_event.Ev2StartDataTxt2[0]='\0';
    m_event.Ev2StartDataTxt3[0]='\0';
    m_event.Ev2EndDataTxt[0]='\0';
    m_event.nEv2DataType=0;
    
    m_event.bEv2S = FALSE;
    m_event.bEv2F = FALSE;
    m_event.bEv2R = FALSE;
    m_event.bEv2W = FALSE;
    m_event.bEv2AK = FALSE; 
    
    m_event.nEv3HL = 1;

    m_filter.nActiveChoice = 1;                 
    m_filter.nDisplayAddrMode = 1;
    m_filter.DisplayStartAddrTxt[0]='\0';
    m_filter.DisplayStartAddrTxt2[0]='\0';
    m_filter.DisplayStartAddrTxt3[0]='\0';
    m_filter.DisplayEndAddrTxt[0]='\0';
    m_filter.nDisplayAddrType = 0;
    m_filter.nDisplayDataMode = 1;
    m_filter.DisplayStartDataTxt[0]='\0';
    m_filter.DisplayStartDataTxt2[0]='\0';
    m_filter.DisplayStartDataTxt3[0]='\0';
    m_filter.DisplayEndDataTxt[0]='\0';
    m_filter.nDisplayDataType=0;
    
    m_filter.bDisplayS = FALSE;
    m_filter.bDisplayF = FALSE;
    m_filter.bDisplayR = FALSE;
    m_filter.bDisplayW = FALSE;
    m_filter.bDisplayAK = FALSE;
    
    m_filter.nTraceAddrMode = 1;
    m_filter.TraceStartAddrTxt[0]='\0';
    m_filter.TraceStartAddrTxt2[0]='\0';    
    m_filter.TraceStartAddrTxt3[0]='\0';
    m_filter.TraceEndAddrTxt[0]='\0';
    m_filter.nTraceAddrType = 0;
    m_filter.nTraceDataMode = 1;
    m_filter.TraceStartDataTxt[0]='\0';
    m_filter.TraceStartDataTxt2[0]='\0';
    m_filter.TraceStartDataTxt3[0]='\0';    
    m_filter.TraceEndDataTxt[0]='\0';
    m_filter.nTraceDataType=0;
    
    m_filter.bTraceS = FALSE;
    m_filter.bTraceF = FALSE;
    m_filter.bTraceR = FALSE;
    m_filter.bTraceW = FALSE;
    m_filter.bTraceAK = FALSE;                   
    
    UINT status;
    if(AbiGetCpuStatus(&status)!=ICE_OK)            //by chris
        {
         AfxMessageBox("Cannot Get CPU Status!");
         m_traceControl.bStartTrace= traceStatus;
         m_traceControl.bStartTimer = timerStatus;
        }         
    else    
        { 
         m_traceControl.bStartTrace= (status&0x0004)?TRUE:FALSE;
         m_traceControl.bStartTimer= (status&0x0100)?TRUE:FALSE;
        }
    m_traceControl.nDelay = 2;
    m_traceControl.delayTxt[0]='\0';        
    
    m_trigger.nActiveLevel = 1;
    m_trigger.level1.nSet = 11;
    m_trigger.level1.bTraceOn = TRUE;
    m_trigger.level1.bTimerOn = TRUE;
    m_trigger.level2.nSet = 0;
    m_trigger.level2.bTraceOn = TRUE;
    m_trigger.level2.bTimerOn = TRUE;
    m_trigger.bTriggerEnable = TRUE;
    m_trigger.bRun = TRUE;
    m_trigger.nTriggerSet = 1;
    
    m_activeTab = 0;
    m_bDisplayChange=FALSE;
    m_nIDHelp = IDD_TRCGRP_EVENT;
    switch (m_activeTab)
    {
        case 0:
            GetEv1();
            GetEv2();
            GetEv3();
            break;
        case 1:
        case 2:      
            GetTrigger();
            GetLevel1();
            GetLevel2();
            break;
        case 3:         
            GetDisplayFilter();
            GetTraceFilter();
            break;
        default:
            break;
    }
}                       

CTraceGroupDialog::CTraceGroupDialog(CWnd* pParent, int tab)
    : CDialog(CTraceGroupDialog::IDD, pParent)
{                               
    m_Tab = NULL;
    
    m_event.nActiveEvent = 1;                 
    m_event.nEv1AddrMode = 1;
    m_event.Ev1StartAddrTxt[0]='\0'; 
    m_event.Ev1StartAddrTxt2[0]='\0';
    m_event.Ev1StartAddrTxt3[0]='\0';
    m_event.Ev1EndAddrTxt[0]='\0';
    m_event.nEv1AddrType = 0;
    m_event.nEv1DataMode = 1;
    m_event.Ev1StartDataTxt[0]='\0'; 
    m_event.Ev1StartDataTxt2[0]='\0';
    m_event.Ev1StartDataTxt3[0]='\0';
    m_event.Ev1EndDataTxt[0]='\0';
    m_event.nEv1DataType=0;
    
    m_event.bEv1S = FALSE;
    m_event.bEv1F = FALSE;
    m_event.bEv1R = FALSE;
    m_event.bEv1W = FALSE;
    m_event.bEv1AK = FALSE;
    
    m_event.Ev1CountTxt[0]='\0';

    m_event.nEv2AddrMode = 1;
    m_event.Ev2StartAddrTxt[0]='\0'; 
    m_event.Ev2StartAddrTxt2[0]='\0';
    m_event.Ev2StartAddrTxt3[0]='\0';
    m_event.Ev2EndAddrTxt[0]='\0';
    m_event.nEv2AddrType = 0;
    m_event.nEv2DataMode = 1;
    m_event.Ev2StartDataTxt[0]='\0'; 
    m_event.Ev2StartDataTxt2[0]='\0';
    m_event.Ev2StartDataTxt3[0]='\0';
    m_event.Ev2EndDataTxt[0]='\0';
    m_event.nEv2DataType=0;
    
    m_event.bEv2S = FALSE;
    m_event.bEv2F = FALSE;
    m_event.bEv2R = FALSE;
    m_event.bEv2W = FALSE;
    m_event.bEv2AK = FALSE; 
    
    m_event.nEv3HL = 1;

    m_filter.nActiveChoice = 1;                 
    m_filter.nDisplayAddrMode = 1;
    m_filter.DisplayStartAddrTxt[0]='\0';
    m_filter.DisplayStartAddrTxt2[0]='\0';
    m_filter.DisplayStartAddrTxt3[0]='\0';
    m_filter.DisplayEndAddrTxt[0]='\0';
    m_filter.nDisplayAddrType = 0;
    m_filter.nDisplayDataMode = 1;
    m_filter.DisplayStartDataTxt[0]='\0';
    m_filter.DisplayStartDataTxt2[0]='\0';
    m_filter.DisplayStartDataTxt3[0]='\0';
    m_filter.DisplayEndDataTxt[0]='\0';
    m_filter.nDisplayDataType=0;
    
    m_filter.bDisplayS = FALSE;
    m_filter.bDisplayF = FALSE;
    m_filter.bDisplayR = FALSE;
    m_filter.bDisplayW = FALSE;
    m_filter.bDisplayAK = FALSE;
    
    m_filter.nTraceAddrMode = 1;
    m_filter.TraceStartAddrTxt[0]='\0';
    m_filter.TraceStartAddrTxt2[0]='\0';
    m_filter.TraceStartAddrTxt3[0]='\0';
    m_filter.TraceEndAddrTxt[0]='\0';
    m_filter.nTraceAddrType = 0;
    m_filter.nTraceDataMode = 1;
    m_filter.TraceStartDataTxt[0]='\0';
    m_filter.TraceStartDataTxt2[0]='\0';
    m_filter.TraceStartDataTxt3[0]='\0';
    m_filter.TraceEndDataTxt[0]='\0';
    m_filter.nTraceDataType=0;
    
    m_filter.bTraceS = FALSE;
    m_filter.bTraceF = FALSE;
    m_filter.bTraceR = FALSE;
    m_filter.bTraceW = FALSE;
    m_filter.bTraceAK = FALSE;                   
    
    m_traceControl.bStartTrace = TRUE;
    m_traceControl.bStartTimer = TRUE;
    m_traceControl.nDelay = 2;
    m_traceControl.delayTxt[0]='\0';        
    
    m_trigger.nActiveLevel = 1;
    m_trigger.level1.nSet = 11;
    m_trigger.level1.bTraceOn = TRUE;
    m_trigger.level1.bTimerOn = TRUE;
    m_trigger.level2.nSet = 0;
    m_trigger.level2.bTraceOn = TRUE;
    m_trigger.level2.bTimerOn = TRUE;
    m_trigger.bTriggerEnable = TRUE;
    m_trigger.bRun = TRUE;
    m_trigger.nTriggerSet = 1;

    m_activeTab = tab;
    switch (m_activeTab)
    {
        case 0:
            GetEv1();
            GetEv2();
            GetEv3();
            break;
        case 1:
        case 2:      
            GetTrigger();
            GetLevel1();
            GetLevel2();
            break;
        case 3:         
            GetDisplayFilter();
            GetTraceFilter();
            break;
        default:
            break;
    }
    m_bEV1AddrEmpty=FALSE;
    m_bEV2AddrEmpty=FALSE;
    m_bEV1DataEmpty=FALSE;
    m_bEV2DataEmpty=FALSE;
    m_bEV1CountEmpty=FALSE;
    m_bFilter1AddrEmpty=FALSE;
    m_bFilter2AddrEmpty=FALSE;  
    m_bFilter1DataEmpty=FALSE;
    m_bFilter2DataEmpty=FALSE;
}

void CTraceGroupDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CTraceGroupDialog)
    DDX_VBControl(pDX, IDC_TAB_TRACE, m_Tab);
    //}}AFX_DATA_MAP
}                                        

void CTraceGroupDialog::ShowEventDlg(int nCmdShow)     
{                           
        GetDlgItem(IDC_GRPTRC_EVT_EV1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_EV2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_EV3)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_WILD1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_WILD2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STATUS)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_S)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_F)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_R)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_W)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_AK)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_HIGH)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_EVT_LOW)->ShowWindow(nCmdShow);
}

void CTraceGroupDialog::ShowTraceControlDlg(int nCmdShow)
{
        GetDlgItem(IDC_GRPTRC_TRC_STARTTRACE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_STARTTIMER)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_TRIGGER1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_PRETRG)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_CENTRG)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_POSTTRG)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_DELAY)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRC_COMBO)->ShowWindow(nCmdShow);
}

void CTraceGroupDialog::ShowTriggerDlg(int nCmdShow)
{  
        GetDlgItem(IDC_GRPTRC_TRG_LEVEL)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_LV1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_LV2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_EVTYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRACE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRCON)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRCOFF)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC3)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TIMER)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TIMERON)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TIMEROFF)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRIGGER1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_ENABLE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_DISABLE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_STATIC4)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_RUN)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_TRIGGER2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_TRG_COMBO)->ShowWindow(nCmdShow);
}

void CTraceGroupDialog::ShowFilterDlg(int nCmdShow)
{
        GetDlgItem(IDC_GRPTRC_FLT_DISPLAY)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_TRACE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_ADDRMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_RANGE1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_MULTI1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_WILD1)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_ADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STARTADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_DATAMODE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_RANGE2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_MULTI2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_WILD2)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_DATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STARTDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STATUS)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_S)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_F)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_R)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_W)->ShowWindow(nCmdShow);
        GetDlgItem(IDC_GRPTRC_FLT_AK)->ShowWindow(nCmdShow);
}

void CTraceGroupDialog::EnableEventCtrl(BOOL bEnable)
{
        GetDlgItem(IDC_GRPTRC_EVT_EV1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_EV2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_EV3)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_WILD1)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_WILD2)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STATUS)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_S)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_F)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_R)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_W)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_AK)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(bEnable);
        GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(bEnable);
}                                                   

//void CTraceGroupDialog::EnableTriggerCtrl(BOOL bEnable)
//{
//}

void CTraceGroupDialog::EventInit()
{   
    switch (m_event.nActiveEvent)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV1); 
            Ev1Init();
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV2); 
            Ev2Init();
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV3); 
            Ev3Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::Ev1Init()
{                       
    EnableEventCtrl(TRUE);                
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(FALSE);

    if (m_event.nEv1AddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Address");
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Address");
    }
    if (m_event.nEv1DataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Data");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Data");
    }

    switch (m_event.nEv1AddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
        default:
            break;
    }

    switch (m_event.nEv1DataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
        default:
            break;
    }

    if(m_event.nEv1AddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt);
        }
    else if(m_event.nEv1AddrMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2);
    else if(m_event.nEv1AddrMode==3)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3);

    CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv1AddrType);

    t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv1DataType);
    if(m_event.nEv1DataMode==1) 
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt);
        }              
    else if(m_event.nEv1DataMode==2)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2);    
    else if(m_event.nEv1DataMode==3)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3);    
    SetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt);
    
    if (m_event.bEv1S) CheckDlgButton(IDC_GRPTRC_EVT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_S, FALSE);

    if (m_event.bEv1F) CheckDlgButton(IDC_GRPTRC_EVT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_F, FALSE);

    if (m_event.bEv1R) CheckDlgButton(IDC_GRPTRC_EVT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_R, FALSE);

    if (m_event.bEv1W) CheckDlgButton(IDC_GRPTRC_EVT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_W, FALSE);

    if (m_event.bEv1AK) CheckDlgButton(IDC_GRPTRC_EVT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_AK, FALSE);
    
}

void CTraceGroupDialog::Ev2Init()
{
    EnableEventCtrl(TRUE);                
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);

    if (m_event.nEv2AddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Address");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Address");
    }
    if (m_event.nEv2DataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Data");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Data");
    }

    switch (m_event.nEv2AddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
        default:
            break;
    }

    switch (m_event.nEv2DataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
        default:
            break;
    }
    if(m_event.nEv2AddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt);
        }
    else if(m_event.nEv2AddrMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2);
    else if(m_event.nEv2AddrMode==3)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3);

    CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv2AddrType);

    t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv2DataType);
    if(m_event.nEv2DataMode==1) 
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt);
        }              
    else if(m_event.nEv2DataMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2);    
    else if(m_event.nEv2DataMode==3)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3);    

    if (m_event.bEv2S) CheckDlgButton(IDC_GRPTRC_EVT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_S, FALSE);

    if (m_event.bEv2F) CheckDlgButton(IDC_GRPTRC_EVT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_F, FALSE);

    if (m_event.bEv2R) CheckDlgButton(IDC_GRPTRC_EVT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_R, FALSE);

    if (m_event.bEv2W) CheckDlgButton(IDC_GRPTRC_EVT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_W, FALSE);

    if (m_event.bEv2AK) CheckDlgButton(IDC_GRPTRC_EVT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_AK, FALSE);
}

void CTraceGroupDialog::Ev3Init()
{
    EnableEventCtrl(FALSE);                
    GetDlgItem(IDC_GRPTRC_EVT_EV1)->EnableWindow(TRUE);
    GetDlgItem(IDC_GRPTRC_EVT_EV2)->EnableWindow(TRUE);
    GetDlgItem(IDC_GRPTRC_EVT_EV3)->EnableWindow(TRUE);  
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_HIGH)->EnableWindow(TRUE);
    GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(TRUE);
    GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(TRUE);

    switch (m_event.nEv3HL)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_HIGH);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_LOW);
            break;
        default:
            break;
    }
}                                     

void CTraceGroupDialog::FilterInit()
{   
    switch (m_filter.nActiveChoice)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_DISPLAY);   
            DisplayInit();
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_TRACE); 
            TraceInit();
            break;
        default:
            break;
    }
}                   

void CTraceGroupDialog::DisplayInit()
{
    if (m_filter.nDisplayAddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Address");
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Address");
    }
    if (m_filter.nDisplayDataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Data");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Data");
    }

    switch (m_filter.nDisplayAddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
        default:
            break;
    }

    switch (m_filter.nDisplayDataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
        default:
            break;
    }

    if(m_filter.nDisplayAddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.DisplayEndAddrTxt);
        }
    else if(m_filter.nDisplayAddrMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt2);
    else if(m_filter.nDisplayAddrMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt3);
    CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_filter.nDisplayAddrType);

    t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_filter.nDisplayDataType);
    if(m_filter.nDisplayDataMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.DisplayEndDataTxt);
        }
    else if(m_filter.nDisplayDataMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt2);
    else if(m_filter.nDisplayDataMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt3);
    if (m_filter.bDisplayS) CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);

    if (m_filter.bDisplayF) CheckDlgButton(IDC_GRPTRC_FLT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_F, FALSE);

    if (m_filter.bDisplayR) CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);

    if (m_filter.bDisplayW) CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);

    if (m_filter.bDisplayAK) CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);
}

void CTraceGroupDialog::TraceInit()
{
    if (m_filter.nTraceAddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Address");
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Address");
    }
    if (m_filter.nTraceDataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Data");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Data");
    }

    switch (m_filter.nTraceAddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
        default:
            break;
    }

    switch (m_filter.nTraceDataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
        default:
            break;
    }

    if(m_filter.nTraceAddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.TraceEndAddrTxt);
        }
    else if(m_filter.nTraceAddrMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt2);
    else if(m_filter.nTraceAddrMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt3);
    CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_filter.nTraceAddrType);

    t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_filter.nTraceDataType);
    
    if(m_filter.nTraceDataMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.TraceEndDataTxt);
        }
    else if(m_filter.nTraceDataMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt2);  
    else if(m_filter.nTraceDataMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt3);  
    
    if (m_filter.bTraceS) CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);

    if (m_filter.bTraceF) CheckDlgButton(IDC_GRPTRC_FLT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_F, FALSE);

    if (m_filter.bTraceR) CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);

    if (m_filter.bTraceW) CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);

    if (m_filter.bTraceAK) CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);
}
                                                  
void CTraceGroupDialog::TraceControlInit()
{                                             
    if (m_traceControl.bStartTrace) CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, TRUE);
    else CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, FALSE);
    
    if (m_traceControl.bStartTimer) CheckDlgButton(IDC_GRPTRC_TRC_STARTTIMER, TRUE);
    else CheckDlgButton(IDC_GRPTRC_TRC_STARTTIMER, FALSE);
    
    switch (m_traceControl.nDelay)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_PRETRG);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_CENTRG);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_POSTTRG);
            break;
        case 4:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_DELAY);
            break;
        default:
            break;
    }
    
    if (m_traceControl.nDelay==4) 
    {
        GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(TRUE);
        //GetDlgItem(IDC_GRPTRC_TRC_COMBO)->SetFocus();
        SetDlgItemText(IDC_GRPTRC_TRC_COMBO,m_traceControl.delayTxt);
    }
    else GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
}                          

void CTraceGroupDialog::TriggerInit()
{           
    CComboBox* a;
    switch (m_trigger.nActiveLevel)
    {
        case 1:               
            CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV1);
            
            a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
            a->SetCurSel(m_trigger.level1.nSet);
            
            if (m_trigger.level1.bTraceOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
            
            if (m_trigger.level1.bTimerOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
            
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV2);
            
            a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
            a->SetCurSel(m_trigger.level2.nSet);
            
            if (m_trigger.level2.bTraceOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
            
            if (m_trigger.level2.bTimerOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
            
            break;
        default:
            break;
    }                           
    
    if (m_trigger.bTriggerEnable)
        CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_ENABLE);
    else
        CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_DISABLE);
    
    CheckDlgButton(IDC_GRPTRC_TRG_RUN, m_trigger.bRun);

    a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
    a->SetCurSel(m_trigger.nTriggerSet);
}
                                                  
BEGIN_MESSAGE_MAP(CTraceGroupDialog, CDialog)
    //{{AFX_MSG_MAP(CTraceGroupDialog)
    ON_VBXEVENT(VBN_TABACTIVATE, IDC_TAB_TRACE, OnTabActivate)
    ON_BN_CLICKED(IDC_GRPTRC_SET, OnGrptrcSet)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_EV1, OnGrptrcEvtEv1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_EV2, OnGrptrcEvtEv2)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_EV3, OnGrptrcEvtEv3)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI1, OnGrptrcEvtMulti1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI2, OnGrptrcEvtMulti2)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE1, OnGrptrcEvtRange1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE2, OnGrptrcEvtRange2)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD1, OnGrptrcEvtWild1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD2, OnGrptrcEvtWild2)
    ON_CBN_SELCHANGE(IDC_GRPTRC_EVT_ADDRTYPE, OnSelendokGrptrcEvtAddrtype)
    ON_CBN_SELCHANGE(IDC_GRPTRC_EVT_DATATYPE, OnSelendokGrptrcEvtDatatype)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_STARTADDR, OnChangeGrptrcEvtStartaddr)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_STARTDATA, OnChangeGrptrcEvtStartdata)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_ENDADDR, OnChangeGrptrcEvtEndaddr)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_ENDDATA, OnChangeGrptrcEvtEnddata)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_COUNT, OnChangeGrptrcEvtCount)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_AK, OnGrptrcEvtAk)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_F, OnGrptrcEvtF)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_HIGH, OnGrptrcEvtHigh)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_LOW, OnGrptrcEvtLow)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_R, OnGrptrcEvtR)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_S, OnGrptrcEvtS)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_W, OnGrptrcEvtW)
    ON_CBN_SELCHANGE(IDC_GRPTRC_FLT_ADDRTYPE, OnSelendokGrptrcFltAddrtype)
    ON_CBN_SELCHANGE(IDC_GRPTRC_FLT_DATATYPE, OnSelendokGrptrcFltDatatype)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_DISPLAY, OnGrptrcFltDisplay)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_TRACE, OnGrptrcFltTrace)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI1, OnGrptrcFltMulti1)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI2, OnGrptrcFltMulti2)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE1, OnGrptrcFltRange1)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE2, OnGrptrcFltRange2)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD1, OnGrptrcFltWild1)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD2, OnGrptrcFltWild2)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_ENDADDR, OnChangeGrptrcFltEndaddr)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_ENDDATA, OnChangeGrptrcFltEnddata)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_STARTADDR, OnChangeGrptrcFltStartaddr)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_STARTDATA, OnChangeGrptrcFltStartdata)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_AK, OnGrptrcFltAk)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_F, OnGrptrcFltF)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_R, OnGrptrcFltR)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_S, OnGrptrcFltS)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_W, OnGrptrcFltW)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_STARTTIMER, OnGrptrcTrcStarttimer)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_STARTTRACE, OnGrptrcTrcStarttrace)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_CENTRG, OnGrptrcTrcCentrg)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_DELAY, OnGrptrcTrcDelay)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_POSTTRG, OnGrptrcTrcPosttrg)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_PRETRG, OnGrptrcTrcPretrg)
    ON_EN_CHANGE(IDC_GRPTRC_TRC_COMBO, OnChangeGrptrcTrcCombo)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_LV1, OnGrptrcTrgLv1)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_LV2, OnGrptrcTrgLv2)
    ON_CBN_SELCHANGE(IDC_GRPTRC_TRG_EVTYPE, OnSelendokGrptrcTrgEvtype)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TRCON, OnGrptrcTrgTrcon)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TRCOFF, OnGrptrcTrgTrcoff)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TIMERON, OnGrptrcTrgTimeron)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TIMEROFF, OnGrptrcTrgTimeroff)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_ENABLE, OnGrptrcTrgEnable)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_DISABLE, OnGrptrcTrgDisable)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_RUN, OnGrptrcTrgRun)
    ON_CBN_SELCHANGE(IDC_GRPTRC_TRG_COMBO, OnSelendokGrptrcTrgCombo)
    ON_EN_KILLFOCUS(IDC_GRPTRC_EVT_STARTADDR, OnKillfocusGrptrcEvtStartaddr)
    ON_EN_KILLFOCUS(IDC_GRPTRC_EVT_ENDADDR, OnKillfocusGrptrcEvtEndaddr)
    ON_EN_KILLFOCUS(IDC_GRPTRC_EVT_STARTDATA, OnKillfocusGrptrcEvtStartdata)
    ON_EN_KILLFOCUS(IDC_GRPTRC_EVT_ENDDATA, OnKillfocusGrptrcEvtEnddata)
    ON_EN_KILLFOCUS(IDC_GRPTRC_EVT_COUNT, OnKillfocusGrptrcEvtCount)
    ON_EN_KILLFOCUS(IDC_GRPTRC_FLT_STARTADDR, OnKillfocusGrptrcFltStartaddr)
    ON_EN_KILLFOCUS(IDC_GRPTRC_FLT_STARTDATA, OnKillfocusGrptrcFltStartdata)
    ON_EN_KILLFOCUS(IDC_GRPTRC_FLT_ENDADDR, OnKillfocusGrptrcFltEndaddr)
    ON_EN_KILLFOCUS(IDC_GRPTRC_FLT_ENDDATA, OnKillfocusGrptrcFltEnddata)
    ON_EN_KILLFOCUS(IDC_GRPTRC_TRC_COMBO, OnKillfocusGrptrcTrcCombo)
    ON_BN_CLICKED(IDC_GRPTRC_CLOSE, OnGrptrcClose)
    ON_BN_CLICKED(IDC_GRPTRC_CANCEL, OnGrptrcCancel)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog message handlers

void CTraceGroupDialog::OnTabActivate(UINT, int, CWnd*, LPVOID lpParams)
{
    // TODO: Add your VBX event notification handler code here
    int nTabToActivate = AFX_NUM_EVENTPARAMINDEX(int, lpParams, 0);

    switch (m_activeTab)
    {
        case 0:
            ShowEventDlg(SW_HIDE);
            break;
        case 1:
            ShowTraceControlDlg(SW_HIDE);
            break;
        case 2:
            ShowTriggerDlg(SW_HIDE);
            break;
        case 3:
            ShowFilterDlg(SW_HIDE);
            break;
        default:
            break;
    }

    switch (nTabToActivate)
    {
        case 0:
            GetEv1();
            GetEv2();
            GetEv3();
            break;
        case 1:
        case 2:      
            GetTrigger();
            GetLevel1();
            GetLevel2();
            break;
        case 3:         
            GetDisplayFilter();
            GetTraceFilter();
            break;
        default:
            break;
    }

    switch (nTabToActivate)
    {
        case 0:
            m_nIDHelp = IDD_TRCGRP_EVENT;
            ShowEventDlg(SW_SHOW);
            EventInit();
            break;
        case 1:
            m_nIDHelp = IDD_TRCGRP_CONTROL;
            ShowTraceControlDlg(SW_SHOW);
            TraceControlInit();
            break;
        case 2:
            m_nIDHelp = IDD_TRCGRP_TRIGGER;
            ShowTriggerDlg(SW_SHOW);
            TriggerInit();
            break;
        case 3:
            m_nIDHelp = IDD_TRCGRP_FILTER;
            ShowFilterDlg(SW_SHOW);      
            FilterInit();
            break;
        default:
            break;
    }                            
    m_activeTab = nTabToActivate;
}

void CTraceGroupDialog::OnGrptrcSet()
{
    // TODO: Add your control notification handler code here
    int i;
    BOOL bErrorFlag;
    long temp;     
    char txt[129];            
    char txt1[200];
    char* ptr;                      
    CWnd* wnd;

    int nold_addrmode=0;
    int nold_datamode=0;
    
    m_bEV1AddrEmpty=FALSE;
    m_bEV2AddrEmpty=FALSE;
    m_bEV1DataEmpty=FALSE;
    m_bEV2DataEmpty=FALSE;
    m_bEV1CountEmpty=FALSE;
    m_bFilter1AddrEmpty=FALSE;
    m_bFilter2AddrEmpty=FALSE;  
    m_bFilter1DataEmpty=FALSE;
    m_bFilter2DataEmpty=FALSE;
    
    switch (m_activeTab)
    {
        case 0:                 //event tab     tab1
            bErrorFlag=FALSE;
            switch (m_event.nActiveEvent)
            {
                case 1:                     
                    switch (m_event.nEv1AddrMode)
                    {
                        case 1:
                            delzero(m_event.Ev1StartAddrTxt);
                            if(m_event.Ev1StartAddrTxt[0]==SYMHEAD)
                            	if(Sym2Addr(m_event.Ev1StartAddrTxt))
                            		{
                            		 bErrorFlag=TRUE;
                            		 break;
                            		} 	
                            i = lstrlen(m_event.Ev1StartAddrTxt);
                            if (i==0)
                            {
                                nold_addrmode=1;
                                m_event.nEv1AddrMode=3;
                                strcpy(m_event.Ev1StartAddrTxt3,"XXXX");
                                m_bEV1AddrEmpty=TRUE;
                                break;
                            }
                            if (i>4) bErrorFlag = TRUE;
                            temp = strtol(m_event.Ev1StartAddrTxt,NULL,16);
                            _ultoa(temp, txt, 16);
                            if (lstrcmpi(txt,m_event.Ev1StartAddrTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:     
                            i = GetTokenNum(m_event.Ev1StartAddrTxt2);
                            if (i>10) 
                            {
                                bErrorFlag = TRUE;
                                break;
                            }                                    
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_addrmode=2;
                             m_event.nEv1AddrMode=3;
                             strcpy(m_event.Ev1StartAddrTxt3,"XXXX");
                             m_bEV1AddrEmpty=TRUE;
                             break;
                            }
                            if(TransAddr(m_event.Ev1StartAddrTxt2))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                                }
                            strcpy(txt1,m_event.Ev1StartAddrTxt2);
                            ptr=strtok(txt1," ,");
                            do
                            {                                
                                while(ptr[0]=='0')
                                     ptr++;
                                if(ptr[0]=='\0')
                                     {
                                      ptr = strtok(NULL, " ,");
                                      continue;
                                     } 
                                i = lstrlen(ptr);
                                if (i>4) bErrorFlag = TRUE;
                                temp = strtol(ptr, NULL, 16);
                                _ultoa(temp,txt,16);
                                if (lstrcmpi(txt,ptr)!=0)
                                    bErrorFlag = TRUE;
                                ptr = strtok(NULL, " ,");
                            }while(ptr!=NULL);
                            break;
                        case 3:
                            delspace(m_event.Ev1StartAddrTxt3);
                            i = lstrlen(m_event.Ev1StartAddrTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_addrmode=3;
                                m_event.nEv1AddrMode=3;
                                strcpy(m_event.Ev1StartAddrTxt3,"XXXX");
                                m_bEV1AddrEmpty=TRUE;
                                break;
                            }
                            if(!(strchr(m_event.Ev1StartAddrTxt3, 'x')||
                            	strchr(m_event.Ev1StartAddrTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<4&&i>0)           //add 0
                                {
                                 int j=4;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev1StartAddrTxt3[j]=
                                        m_event.Ev1StartAddrTxt3[i];
                                 i++;       
                                 for(;i<=j;i++)
                                     m_event.Ev1StartAddrTxt3[i]='0';
                                 i=4;
                                }
                            if (i<16&&i>4)           //add 0
                                {
                                 int j=16;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev1StartAddrTxt3[j]=
                                        m_event.Ev1StartAddrTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_event.Ev1StartAddrTxt3[i]='0';
                                 i=16;
                                }

                            if ((i!=4)&&(i!=16))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==4) 
                                if (CheckInvalid(m_event.Ev1StartAddrTxt3, "1234567890abcdefABCDEFxX", 4)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==16) 
                                if (CheckInvalid(m_event.Ev1StartAddrTxt3, "10xX", 16)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                case 2:           
                    switch (m_event.nEv2AddrMode)
                    {
                        case 1:
                            delzero(m_event.Ev2StartAddrTxt);
        					if(m_event.Ev2StartAddrTxt[0]==SYMHEAD)
                            	if(Sym2Addr(m_event.Ev2StartAddrTxt))
                            		{
                            		 bErrorFlag=TRUE;
                            		 break;
                            		} 	                       
                            i = lstrlen(m_event.Ev2StartAddrTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_addrmode=1;
                             m_event.nEv2AddrMode=3;
                             strcpy(m_event.Ev2StartAddrTxt3,"XXXX");
                             m_bEV2AddrEmpty=TRUE;
                             break;
                            }
                            if (i>4) bErrorFlag = TRUE;
                            temp = strtol(m_event.Ev2StartAddrTxt,NULL,16);
                            _ultoa(temp, txt, 16); 
                            if (lstrcmpi(txt,m_event.Ev2StartAddrTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            i = GetTokenNum(m_event.Ev2StartAddrTxt2);
                            if (i>10) 
                            {
                                bErrorFlag = TRUE;
                                break;
                            }                                    
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_addrmode=2;
                             m_event.nEv2AddrMode=3;
                             strcpy(m_event.Ev2StartAddrTxt3,"XXXX");
                             m_bEV2AddrEmpty=TRUE;
                             break;
                            }
                            if(TransAddr(m_event.Ev2StartAddrTxt2))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                                }
                            strcpy(txt1,m_event.Ev2StartAddrTxt2);
                            ptr=strtok(txt1," ,");
                            do
                            {                                
                                while(ptr[0]=='0')
                                     ptr++;
                                if(ptr[0]=='\0')
                                     {
                                      ptr = strtok(NULL, " ,");
                                      continue;
                                     } 
                                i = lstrlen(ptr);
                                if (i>4) bErrorFlag = TRUE;
                                temp = strtol(ptr, NULL, 16);
                                _ultoa(temp,txt,16);
                                if (lstrcmpi(txt,ptr)!=0)
                                    bErrorFlag = TRUE;
                                ptr = strtok(NULL, " ,");
                            }while(ptr!=NULL);
                            break;
                        case 3:
                            delspace(m_event.Ev2StartAddrTxt3);
                            i = lstrlen(m_event.Ev2StartAddrTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_addrmode=3;
                             m_event.nEv2AddrMode=3;
                             strcpy(m_event.Ev2StartAddrTxt3,"XXXX");
                             m_bEV2AddrEmpty=TRUE;
                             break;                             
                            }
                            if(!(strchr(m_event.Ev2StartAddrTxt3, 'x')||
                            	strchr(m_event.Ev2StartAddrTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 

                            if (i<4&&i>0)           //add 0
                                {
                                 int j=4;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev2StartAddrTxt3[j]=
                                        m_event.Ev2StartAddrTxt3[i];
                                 i++;       
                                 for(;i<=j;i++)
                                     m_event.Ev2StartAddrTxt3[i]='0';
                                 i=4;
                                }
                            if (i<16&&i>4)           //add 0
                                {
                                 int j=16;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev2StartAddrTxt3[j]=
                                        m_event.Ev2StartAddrTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_event.Ev2StartAddrTxt3[i]='0';
                                 i=16;
                                }
                            if ((i!=4)&&(i!=16))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==4) 
                                if (CheckInvalid(m_event.Ev2StartAddrTxt3, "1234567890abcdefABCDEFxX", 4)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==16) 
                                if (CheckInvalid(m_event.Ev2StartAddrTxt3, "10xX", 16)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_EVT_STARTADDR);
                wnd->SetFocus();
                return;
            }

            bErrorFlag=FALSE;
            if (((m_event.nEv1AddrMode==1)&&(m_event.nActiveEvent==1))||
                ((m_event.nEv2AddrMode==1)&&(m_event.nActiveEvent==2)))
            switch (m_event.nActiveEvent)
            {
                case 1:   
                    delzero(m_event.Ev1EndAddrTxt);
                    if(m_event.Ev1EndAddrTxt[0]==SYMHEAD)	
                    	if(Sym2Addr(m_event.Ev1EndAddrTxt))
                		 {
                          bErrorFlag=TRUE;
                          break;
                         } 	
                    i = lstrlen(m_event.Ev1EndAddrTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev1EndAddrTxt,NULL,16);
                    if(m_event.nEv1AddrType==1)			//length
                    	if(temp+strtol(m_event.Ev1StartAddrTxt,NULL,16)
                    		-1<0x10000)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_event.Ev1EndAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:                            
                    delzero(m_event.Ev2EndAddrTxt);
                    if(m_event.Ev2EndAddrTxt[0]==SYMHEAD)                           	
                    	if(Sym2Addr(m_event.Ev2EndAddrTxt))
                		 {
                          bErrorFlag=TRUE;
                          break;
                         } 	
                    i = lstrlen(m_event.Ev2EndAddrTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev2EndAddrTxt,NULL,16);
                    if(m_event.nEv2AddrType==1)			//length
                    	if(temp+strtol(m_event.Ev2StartAddrTxt,NULL,16)
                    		-1<0x10000)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_event.Ev2EndAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_EVT_ENDADDR);
                wnd->SetFocus();
                return;
            }
            
            bErrorFlag=FALSE;
            switch (m_event.nActiveEvent)
            {
                case 1: 
                    switch (m_event.nEv1DataMode)
                    {
                        case 1:  
                            delzero(m_event.Ev1StartDataTxt);
                            i = lstrlen(m_event.Ev1StartDataTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_datamode=1;
                             m_event.nEv1DataMode=3;
                             strcpy(m_event.Ev1StartDataTxt3,"XX");
                             m_bEV1DataEmpty=TRUE;
                             break;
                            }
                            if (i>2) bErrorFlag = TRUE;
                            temp = strtol(m_event.Ev1StartDataTxt,NULL,16);
                            _ultoa(temp, txt, 16);
                            if (lstrcmpi(txt,m_event.Ev1StartDataTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            delzero(m_event.Ev1StartDataTxt2);
                            i = lstrlen(m_event.Ev1StartDataTxt2);
                            if (i==0) 
                            {
                             nold_datamode=2;
                             m_event.nEv1DataMode=3;
                             strcpy(m_event.Ev1StartDataTxt3,"XX");
                             m_bEV1DataEmpty=TRUE;
                             break;
                            }                          
                            if (i>2) bErrorFlag = TRUE;          
//                          if (i==0) return;
                            if(!isHex(m_event.Ev1StartDataTxt2))
                                    bErrorFlag = TRUE;                          
                            break;
                        case 3:
                            delspace(m_event.Ev1StartDataTxt3);
                            i = lstrlen(m_event.Ev1StartDataTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_datamode=3;
                             m_event.nEv1DataMode=3;
                             strcpy(m_event.Ev1StartDataTxt3,"XX");
                             m_bEV1DataEmpty=TRUE;
                             break;
                            }
                            if(!(strchr(m_event.Ev1StartDataTxt3, 'x')||
                            	strchr(m_event.Ev1StartDataTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<2&&i>0)           //add 0
                                {
                                 int j=2;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev1StartDataTxt3[j]=
                                        m_event.Ev1StartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_event.Ev1StartDataTxt3[i]='0';
                                 i=2;
                                }
                            if (i<8&&i>2)           //add 0
                                {
                                 int j=8;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev1StartDataTxt3[j]=
                                        m_event.Ev1StartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_event.Ev1StartDataTxt3[i]='0';
                                 i=8;
                                }
                            
                            if ((i!=2)&&(i!=8))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==2) 
                                if (CheckInvalid(m_event.Ev1StartDataTxt3, "1234567890abcdefABCDEFxX", 2)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==8) 
                                if (CheckInvalid(m_event.Ev1StartDataTxt3, "10xX", 8)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                case 2:   
                    switch (m_event.nEv2DataMode)
                    {
                        case 1:
                            delzero(m_event.Ev2StartDataTxt);
                            i = lstrlen(m_event.Ev2StartDataTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                             nold_datamode=1;
                             m_event.nEv2DataMode=3;
                             strcpy(m_event.Ev2StartDataTxt3,"XX");
                             m_bEV2DataEmpty=TRUE;
                             break;
                            }
                            if (i>2) bErrorFlag = TRUE;
                            temp = strtol(m_event.Ev2StartDataTxt,NULL,16);
                            _ultoa(temp, txt, 16); 
                            if (lstrcmpi(txt,m_event.Ev2StartDataTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            delzero(m_event.Ev2StartDataTxt2);
                            i = lstrlen(m_event.Ev2StartDataTxt2);
                            if (i==0) 
                            {
                             nold_datamode=2;
                             m_event.nEv2DataMode=3;
                             strcpy(m_event.Ev2StartDataTxt3,"XX");
                             m_bEV2DataEmpty=TRUE;
                             break;
                            }                          
                            if (i>2) bErrorFlag = TRUE;          
//                          if (i==0) return;
                            if(!isHex(m_event.Ev2StartDataTxt2))
                                    bErrorFlag = TRUE;                          
                            break;

                        case 3:
                            delspace(m_event.Ev2StartDataTxt3);
                            i = lstrlen(m_event.Ev2StartDataTxt3);
                            if (i==0) 
                                {
                                 nold_datamode=3;
                                 m_event.nEv2DataMode=3;
                                 strcpy(m_event.Ev2StartDataTxt3,"XX");
                                 m_bEV1DataEmpty=TRUE;
                                 break;
                                } 
                            if(!(strchr(m_event.Ev2StartDataTxt3, 'x')||
                            	strchr(m_event.Ev2StartDataTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<2&&i>0)           //add 0
                                {
                                 int j=2;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev2StartDataTxt3[j]=
                                        m_event.Ev2StartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_event.Ev2StartDataTxt3[i]='0';
                                 i=2;
                                }
                            if (i<8&&i>2)           //add 0
                                {
                                 int j=8;
                                 for(;i>=0;i--,j--)
                                     m_event.Ev2StartDataTxt3[j]=
                                        m_event.Ev2StartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_event.Ev2StartDataTxt3[i]='0';
                                 i=8;
                                }
                            
                            if ((i!=2)&&(i!=8))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==2) 
                                if (CheckInvalid(m_event.Ev2StartDataTxt3, "1234567890abcdefABCDEFxX", 2)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==8) 
                                if (CheckInvalid(m_event.Ev2StartDataTxt3, "10xX", 8)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_EVT_STARTDATA);
                wnd->SetFocus();
                return;
            }
            
            bErrorFlag=FALSE;
            if (((m_event.nEv1DataMode==1)&&(m_event.nActiveEvent==1))||
                ((m_event.nEv2DataMode==1)&&(m_event.nActiveEvent==2)))
            switch (m_event.nActiveEvent)
            {
                case 1:   
                    delzero(m_event.Ev1EndDataTxt);
                    i = lstrlen(m_event.Ev1EndDataTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev1EndDataTxt,NULL,16);
                    if(m_event.nEv1DataType==1)			//length
                    	if(temp+strtol(m_event.Ev1StartDataTxt,NULL,16)
                    		-1<0x100)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_event.Ev1EndDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    delzero(m_event.Ev2EndDataTxt);
                    i = lstrlen(m_event.Ev2EndDataTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev2EndDataTxt,NULL,16);
                    if(m_event.nEv2DataType==1)			//length
                    	if(temp+strtol(m_event.Ev2StartDataTxt,NULL,16)
                    		-1<0x100)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_event.Ev2EndDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_EVT_ENDDATA);
                wnd->SetFocus();
                return;
            }

            bErrorFlag=FALSE;
            switch (m_event.nActiveEvent)
            {
                case 1:   
                    delzero(m_event.Ev1CountTxt);
                    i = lstrlen(m_event.Ev1CountTxt);
                    if (i==0) 
                        {
                         m_bEV1CountEmpty=TRUE;
                         break;                
                        } 
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev1CountTxt,NULL,16);
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_event.Ev1CountTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_EVT_COUNT);
                wnd->SetFocus();
                return;
            }

            switch (m_event.nActiveEvent)
            {
                case 1:
//                  i = GetTokenNum(m_event.Ev1StartAddrTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_event.Ev1EndAddrTxt);
                    if ((i<=0)&&(m_event.nEv1AddrMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
//                  i = GetTokenNum(m_event.Ev1StartDataTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_event.Ev1EndDataTxt);
                    if ((i<=0)&&(m_event.nEv1DataMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
                    if (m_event.bEv1S||m_event.bEv1F||m_event.bEv1R
                        ||m_event.bEv1W||m_event.bEv1AK
                        ||!m_bEV1AddrEmpty||!m_bEV1DataEmpty
                        ||!m_bEV1CountEmpty)
                        {
                         SetEv1();
                         if(nold_addrmode||nold_datamode) 
                            Ev1Init();
//                          m_event.nEv1AddrMode=nold_addrmode;
//                       if(nold_datamode) 
//                          m_event.nEv1DataMode=nold_datamode; 
                        }   
                    else
                    {
                        MessageBox("You Must Input Something!", "Error");
                        if(nold_addrmode) 
                            m_event.nEv1AddrMode=nold_addrmode,
                            m_event.Ev1StartAddrTxt[0]=0;
                        if(nold_datamode) 
                            m_event.nEv1DataMode=nold_datamode,
                            m_event.Ev1StartDataTxt[0]=0;   
                        return;
                    }
                    break;
                case 2:
//                  i = GetTokenNum(m_event.Ev2StartAddrTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_event.Ev2EndAddrTxt);
                    if ((i<=0)&&(m_event.nEv2AddrMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
//                  i = GetTokenNum(m_event.Ev2StartDataTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_event.Ev2EndDataTxt);
                    if ((i<=0)&&(m_event.nEv2DataMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
                    if (m_event.bEv2S||m_event.bEv2F||m_event.bEv2R
                        ||m_event.bEv2W||m_event.bEv2AK
                        ||!m_bEV2AddrEmpty||!m_bEV2DataEmpty)
                        {
                         SetEv2();
                         if(nold_addrmode||nold_datamode) 
                            Ev2Init();
//                          m_event.nEv2AddrMode=nold_addrmode;
//                       if(nold_datamode) 
//                          m_event.nEv2DataMode=nold_datamode; 
                        }   
                    else
                    {
                        MessageBox("You Must Input Something!", "Error");
                        if(nold_addrmode) 
                            m_event.nEv2AddrMode=nold_addrmode,
                            m_event.Ev2StartAddrTxt[0]=0;
                        if(nold_datamode) 
                            m_event.nEv2DataMode=nold_datamode,
                            m_event.Ev2StartDataTxt[0]=0;   
                        return;
                    }
                    break;
                case 3:
                    SetEv3();
                    break;
                default:
                    break;
            }
            break;
        case 1:             //trace control tab    tab2
            if (m_traceControl.nDelay==4)
            {
                bErrorFlag=FALSE;
                delzero(m_traceControl.delayTxt);               
                i = lstrlen(m_traceControl.delayTxt);
//              if (i==0) return;
                if (i>4) bErrorFlag = TRUE;
                temp = strtol(m_traceControl.delayTxt,NULL,16);
                _ultoa(temp, txt, 16);
                if (lstrcmpi(txt,m_traceControl.delayTxt)!=0)
                    bErrorFlag = TRUE;
                
                if (bErrorFlag)
                {                   
                    MessageBox("Syntax Error!", "Error");
                    wnd = GetDlgItem(IDC_GRPTRC_TRC_COMBO);
                    wnd->SetFocus();
                    return;
                }
            
                i = GetTokenNum(m_traceControl.delayTxt);
                if (i<=0)
                {
                    MessageBox("Syntax Error!", "Error");
                    wnd = GetDlgItem(IDC_GRPTRC_TRC_COMBO);
                    wnd->SetFocus();
                    return;
                }
            }
        case 2:                 //trigger tab  tab3
            switch (m_trigger.nActiveLevel)
            {
                case 1:
                    SetLevel1();
                    break;
                case 2:
                    SetLevel2();
                    break;
                default:
                    break;
            }             
            SetTrigger();
            break;
        
        case 3:                         //filter tab  tab4
            bErrorFlag=FALSE;
            switch (m_filter.nActiveChoice)
            {
                case 1:            
                    switch (m_filter.nDisplayAddrMode)
                    {
                        case 1:
                            delzero(m_filter.DisplayStartAddrTxt);
                            if(m_filter.DisplayStartAddrTxt[0]==SYMHEAD)
                            	if(Sym2Addr(m_filter.DisplayStartAddrTxt))
                            		{
                            		 bErrorFlag=TRUE;
                            		 break;
                            		} 	
                            i = lstrlen(m_filter.DisplayStartAddrTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_addrmode=1;
                                m_filter.nDisplayAddrMode=3;
                                strcpy(m_filter.DisplayStartAddrTxt3,"XXXX");
                                m_bFilter1AddrEmpty=TRUE;
                                break;
                            }
                            if (i>4) bErrorFlag = TRUE;
                            temp = strtol(m_filter.DisplayStartAddrTxt,NULL,16);
                            _ultoa(temp, txt, 16);
                            if (lstrcmpi(txt,m_filter.DisplayStartAddrTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            i = GetTokenNum(m_filter.DisplayStartAddrTxt2);
                            if (i==0) 
                            {
                                nold_addrmode=2;
                                m_filter.nDisplayAddrMode=3;
                                strcpy(m_filter.DisplayStartAddrTxt3,"XXXX");
                                m_bFilter1AddrEmpty=TRUE;
                                break;
                            }                                    
//                          if (i==0) return;
                            if (i>10)
                            {
                                bErrorFlag=TRUE;
                                break;
                            }
                            if(TransAddr(m_filter.DisplayStartAddrTxt2))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                                }
                            strcpy(txt1,m_filter.DisplayStartAddrTxt2);
                            ptr=strtok(txt1," ,");
                            do
                            {                                
                                while(ptr[0]=='0')
                                     ptr++;
                                if(ptr[0]=='\0')
                                     {
                                      ptr = strtok(NULL, " ,");
                                      continue;                
                                     } 
                                i = lstrlen(ptr);
                                if (i>4) bErrorFlag = TRUE;
                                temp = strtol(ptr, NULL, 16);
                                _ultoa(temp,txt,16);
                                if (lstrcmpi(txt,ptr)!=0)
                                    bErrorFlag = TRUE;
                                ptr = strtok(NULL, " ,");
                            }while(ptr!=NULL);
                            break;
                        case 3:
                            delspace(m_filter.DisplayStartAddrTxt3);
                            i = lstrlen(m_filter.DisplayStartAddrTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_addrmode=3;
                                m_filter.nDisplayAddrMode=3;
                                strcpy(m_filter.DisplayStartAddrTxt3,"XXXX");
                                m_bFilter1AddrEmpty=TRUE;
                                break;
                            }      
                            if(!(strchr(m_filter.DisplayStartAddrTxt3, 'x')||
                            	strchr(m_filter.DisplayStartAddrTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<4&&i>0)           //add 0
                                {
                                 int j=4;
                                 for(;i>=0;i--,j--)
                                     m_filter.DisplayStartAddrTxt3[j]=
                                        m_filter.DisplayStartAddrTxt3[i];
                                 i++;       
                                 for(;i<=j;i++)
                                     m_filter.DisplayStartAddrTxt3[i]='0';
                                 i=4;
                                }
                            if (i<16&&i>4)           //add 0
                                {
                                 int j=16;
                                 for(;i>=0;i--,j--)
                                     m_filter.DisplayStartAddrTxt3[j]=
                                        m_filter.DisplayStartAddrTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.DisplayStartAddrTxt3[i]='0';
                                 i=16;
                                }
                            if ((i!=4)&&(i!=16))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==4) 
                                if (CheckInvalid(m_filter.DisplayStartAddrTxt3, "1234567890abcdefABCDEFxX", 4)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==16) 
                                if (CheckInvalid(m_filter.DisplayStartAddrTxt3, "10xX", 16)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                case 2:   
                    switch (m_filter.nTraceAddrMode)
                    {
                        case 1:
                            delzero(m_filter.TraceStartAddrTxt);
        					if(m_filter.TraceStartAddrTxt[0]==SYMHEAD)
                            	if(Sym2Addr(m_filter.TraceStartAddrTxt))
                            		{
                            		 bErrorFlag=TRUE;
                            		 break;
                            		} 	                       
                            i = lstrlen(m_filter.TraceStartAddrTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_addrmode=1;
                                m_filter.nTraceAddrMode=3;
                                strcpy(m_filter.TraceStartAddrTxt3,"XXXX");
                                m_bFilter2AddrEmpty=TRUE;
                                break;
                            }
                            if (i>4) bErrorFlag = TRUE;
                            temp = strtol(m_filter.TraceStartAddrTxt,NULL,16);
                            _ultoa(temp, txt, 16); 
                            if (lstrcmpi(txt,m_filter.TraceStartAddrTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            i = GetTokenNum(m_filter.TraceStartAddrTxt2);
                            if (i>10) 
                            {
                                bErrorFlag = TRUE;
                                break;
                            }                                    
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_addrmode=2;
                                m_filter.nTraceAddrMode=3;
                                strcpy(m_filter.TraceStartAddrTxt3,"XXXX");
                                m_bFilter2AddrEmpty=TRUE;
                                break;
                            }
                            if(TransAddr(m_filter.TraceStartAddrTxt2))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                                }
                            strcpy(txt1,m_filter.TraceStartAddrTxt2);
                            ptr=strtok(txt1," ,");
                            do
                            {                                
                                while(ptr[0]=='0')
                                     ptr++;
                                if(ptr[0]=='\0')
                                     {
                                      ptr = strtok(NULL, " ,");
                                      continue;                
                                     } 
                                i = lstrlen(ptr);
                                if (i>4) bErrorFlag = TRUE;
                                temp = strtol(ptr, NULL, 16);
                                _ultoa(temp,txt,16);
                                if (lstrcmpi(txt,ptr)!=0)
                                    bErrorFlag = TRUE;
                                ptr = strtok(NULL, " ,");
                            }while(ptr!=NULL);
                            break;
                        case 3:
                            delspace(m_filter.TraceStartAddrTxt3);
                            i = lstrlen(m_filter.TraceStartAddrTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_addrmode=1;
                                m_filter.nTraceAddrMode=3;
                                strcpy(m_filter.TraceStartAddrTxt3,"XXXX");
                                m_bFilter2AddrEmpty=TRUE;
                                break;
                            }
                            if(!(strchr(m_filter.TraceStartAddrTxt3, 'x')||
                            	strchr(m_filter.TraceStartAddrTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<4&&i>0)           //add 0
                                {
                                 int j=4;
                                 for(;i>=0;i--,j--)
                                     m_filter.TraceStartAddrTxt3[j]=
                                        m_filter.TraceStartAddrTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.TraceStartAddrTxt3[i]='0';
                                 i=4;
                                }
                            if (i<16&&i>4)           //add 0
                                {
                                 int j=16;
                                 for(;i>=0;i--,j--)
                                     m_filter.TraceStartAddrTxt3[j]=
                                        m_filter.TraceStartAddrTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.TraceStartAddrTxt3[i]='0';
                                 i=16;
                                }
                            if ((i!=4)&&(i!=16))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==4) 
                                if (CheckInvalid(m_filter.TraceStartAddrTxt3, "1234567890abcdefABCDEFxX", 4)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==16) 
                                if (CheckInvalid(m_filter.TraceStartAddrTxt3, "10xX", 16)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_FLT_STARTADDR);
                wnd->SetFocus();
                return;
            }

            bErrorFlag=FALSE;
            switch (m_filter.nActiveChoice)
            {
                case 1:   
                    switch (m_filter.nDisplayDataMode)
                    {
                        case 1:
                            delzero(m_filter.DisplayStartDataTxt);
                            i = lstrlen(m_filter.DisplayStartDataTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_datamode=1;
                                m_filter.nDisplayDataMode=3;
                                strcpy(m_filter.DisplayStartDataTxt3,"XX");
                                m_bFilter1DataEmpty=TRUE;
                                break;
                            }
                            if (i>2) bErrorFlag = TRUE;
                            temp = strtol(m_filter.DisplayStartDataTxt,NULL,16);
                            _ultoa(temp, txt, 16);
                            if (lstrcmpi(txt,m_filter.DisplayStartDataTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            delzero(m_filter.DisplayStartDataTxt2);
                            i = lstrlen(m_filter.DisplayStartDataTxt2);
                            if (i==0) 
                            {
                                nold_datamode=2;
                                m_filter.nDisplayDataMode=3;
                                strcpy(m_filter.DisplayStartDataTxt3,"XX");
                                m_bFilter1DataEmpty=TRUE;
                                break;
                            }                          
                            if (i>2) bErrorFlag = TRUE;          
//                          if (i==0) return;
                            if(!isHex(m_filter.DisplayStartDataTxt2))
                                    bErrorFlag = TRUE;                          
                            break;

                        case 3:
                            delspace(m_filter.DisplayStartDataTxt3);
                            i = lstrlen(m_filter.DisplayStartDataTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_datamode=3;
                                m_filter.nDisplayDataMode=3;
                                strcpy(m_filter.DisplayStartDataTxt3,"XX");
                                m_bFilter1DataEmpty=TRUE;
                                break;
                            }
                            if(!(strchr(m_filter.DisplayStartDataTxt3, 'x')||
                            	strchr(m_filter.DisplayStartDataTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<2&&i>0)           //add 0
                                {
                                 int j=2;
                                 for(;i>=0;i--,j--)
                                     m_filter.DisplayStartDataTxt3[j]=
                                        m_filter.DisplayStartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.DisplayStartDataTxt3[i]='0';
                                 i=2;
                                }
                            if (i<8&&i>2)           //add 0
                                {
                                 int j=8;
                                 for(;i>=0;i--,j--)
                                     m_filter.DisplayStartDataTxt3[j]=
                                        m_filter.DisplayStartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.DisplayStartDataTxt3[i]='0';
                                 i=8;
                                }
                            if ((i!=2)&&(i!=8))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==2) 
                                if (CheckInvalid(m_filter.DisplayStartDataTxt3, "1234567890abcdefABCDEFxX", 2)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==8) 
                                if (CheckInvalid(m_filter.DisplayStartDataTxt3, "10xX", 8)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                case 2:   
                    switch (m_filter.nTraceDataMode)
                    {
                        case 1:
                            delzero(m_filter.TraceStartDataTxt);
                            i = lstrlen(m_filter.TraceStartDataTxt);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_datamode=1;
                                m_filter.nTraceDataMode=3;
                                strcpy(m_filter.TraceStartDataTxt3,"XX");
                                m_bFilter2DataEmpty=TRUE;
                                break;
                            }
                            if (i>2) bErrorFlag = TRUE;
                            temp = strtol(m_filter.TraceStartDataTxt,NULL,16);
                            _ultoa(temp, txt, 16); 
                            if (lstrcmpi(txt,m_filter.TraceStartDataTxt)!=0)
                                bErrorFlag = TRUE;
                            break;
                        case 2:
                            delzero(m_filter.TraceStartDataTxt2);
                            i = lstrlen(m_filter.TraceStartDataTxt2);
                            if (i==0) 
                            {
                                nold_datamode=2;
                                m_filter.nTraceDataMode=3;
                                strcpy(m_filter.TraceStartDataTxt3,"XX");
                                m_bFilter2DataEmpty=TRUE;
                                break;
                            }                          
                            if (i>2) bErrorFlag = TRUE;          
//                          if (i==0) return;
                            if(!isHex(m_filter.TraceStartDataTxt2))
                                    bErrorFlag = TRUE;                          
                            break;

                        case 3:
                            delspace(m_filter.TraceStartDataTxt3);
                            i = lstrlen(m_filter.TraceStartDataTxt3);
//                          if (i==0) return;
                            if (i==0)
                            {
                                nold_datamode=3;
                                m_filter.nTraceDataMode=3;
                                strcpy(m_filter.TraceStartDataTxt3,"XX");
                                m_bFilter2DataEmpty=TRUE;
                                break;                          
                            }
                            if(!(strchr(m_filter.TraceStartDataTxt3, 'x')||
                            	strchr(m_filter.TraceStartDataTxt3, 'X')))
                            	{
                            	 bErrorFlag=TRUE;
                            	 break;
                            	} 
                            if (i<2&&i>0)           //add 0
                                {
                                 int j=2;
                                 for(;i>=0;i--,j--)
                                     m_filter.TraceStartDataTxt3[j]=
                                        m_filter.TraceStartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.TraceStartDataTxt3[i]='0';
                                 i=2;
                                }
                            if (i<8&&i>2)           //add 0
                                {
                                 int j=8;
                                 for(;i>=0;i--,j--)
                                     m_filter.TraceStartDataTxt3[j]=
                                        m_filter.TraceStartDataTxt3[i];
                                 i++;
                                 for(;i<=j;i++)
                                     m_filter.TraceStartDataTxt3[i]='0';
                                 i=8;
                                }
                            if ((i!=2)&&(i!=8))
                            {
                                bErrorFlag = TRUE;
                                break;
                            }           
                            if (i==2) 
                                if (CheckInvalid(m_filter.TraceStartDataTxt3, "1234567890abcdefABCDEFxX", 2)==FALSE)
                                    bErrorFlag = TRUE;
                            if (i==8) 
                                if (CheckInvalid(m_filter.TraceStartDataTxt3, "10xX", 8)==FALSE)
                                    bErrorFlag = TRUE;
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_FLT_STARTDATA);
                wnd->SetFocus();
                return;
            }

            bErrorFlag=FALSE;
            if (((m_filter.nDisplayAddrMode==1)&&(m_filter.nActiveChoice==1))||
                ((m_filter.nTraceAddrMode==1)&&(m_filter.nActiveChoice==2)))
            switch (m_filter.nActiveChoice)
            {
                case 1:   
                    delzero(m_filter.DisplayEndAddrTxt);                    
                    if(m_filter.DisplayEndAddrTxt[0]==SYMHEAD)                           	
                    	if(Sym2Addr(m_filter.DisplayEndAddrTxt))
                		 {
                          bErrorFlag=TRUE;
                          break;
                         } 	
                    i = lstrlen(m_filter.DisplayEndAddrTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_filter.DisplayEndAddrTxt,NULL,16);
                    if(m_filter.nDisplayAddrType==1)			//length
                    	if(temp+strtol(m_filter.DisplayStartAddrTxt,NULL,16)
                    		-1<0x10000)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_filter.DisplayEndAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    delzero(m_filter.TraceEndAddrTxt);                    
                    if(m_filter.TraceEndAddrTxt[0]==SYMHEAD)                           	
                    	if(Sym2Addr(m_filter.TraceEndAddrTxt))
                		 {
                          bErrorFlag=TRUE;
                          break;
                         } 	
                    i = lstrlen(m_filter.TraceEndAddrTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>4) bErrorFlag = TRUE;
                    if(m_filter.nTraceAddrType==1)			//length
                    	if(temp+strtol(m_filter.TraceStartAddrTxt,NULL,16)
                    		-1<0x10000)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    temp = strtol(m_filter.TraceEndAddrTxt,NULL,16);
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_filter.TraceEndAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_FLT_ENDADDR);
                wnd->SetFocus();
                return;
            }

            bErrorFlag=FALSE;
            if (((m_filter.nDisplayDataMode==1)&&(m_filter.nActiveChoice==1))||
                ((m_filter.nTraceDataMode==1)&&(m_filter.nActiveChoice==2)))
            switch (m_filter.nActiveChoice)
            {
                case 1:   
                    delzero(m_filter.DisplayEndDataTxt);
                    i = lstrlen(m_filter.DisplayEndDataTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_filter.DisplayEndDataTxt,NULL,16);
                    if(m_filter.nDisplayDataType==1)			//length
                    	if(temp+strtol(m_filter.DisplayStartDataTxt,NULL,16)
                    		-1<0x100)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_filter.DisplayEndDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    delzero(m_filter.TraceEndDataTxt);
                    i = lstrlen(m_filter.TraceEndDataTxt);
//                  if (i==0) return;
                    if (i==0)
                    {
                        bErrorFlag=TRUE;
                        break;
                    }
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_filter.TraceEndDataTxt,NULL,16);
                    if(m_filter.nTraceDataType==1)			//length
                    	if(temp+strtol(m_filter.TraceStartDataTxt,NULL,16)
                    		-1<0x100)
                    		bErrorFlag=FALSE;
                    	else bErrorFlag=TRUE;
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_filter.TraceEndDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }                                  
            if (bErrorFlag)
            {                   
                MessageBox("Syntax Error!", "Error");
                wnd = GetDlgItem(IDC_GRPTRC_FLT_ENDDATA);
                wnd->SetFocus();
                return;
            }
    
            switch (m_filter.nActiveChoice)
            {
                case 1:
//                  i = GetTokenNum(m_filter.DisplayStartAddrTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_filter.DisplayEndAddrTxt);
                    if ((i<=0)&&(m_filter.nDisplayAddrMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
//                  i = GetTokenNum(m_filter.DisplayStartDataTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_filter.DisplayEndDataTxt);
                    if ((i<=0)&&(m_filter.nDisplayDataMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
                    if (m_filter.bDisplayS||m_filter.bDisplayF||m_filter.bDisplayR
                        ||m_filter.bDisplayW||m_filter.bDisplayAK
                        ||!m_bFilter1AddrEmpty||!m_bFilter1DataEmpty)
                        { 
                         SetDisplayFilter();
                         if(nold_addrmode||nold_datamode) 
                            DisplayInit();

//                          m_filter.nDisplayAddrMode=nold_addrmode;
//                       if(nold_datamode) 
//                          m_filter.nDisplayDataMode=nold_datamode;    
                        }   
                         
                    else
                    {
                        MessageBox("You Must Input Something!", "Error");
                        if(nold_addrmode) 
                            m_filter.nDisplayAddrMode=nold_addrmode,
                            m_filter.DisplayStartAddrTxt[0]=0;
                        if(nold_datamode) 
                            m_filter.nDisplayDataMode=nold_datamode,
                            m_filter.DisplayStartDataTxt[0]=0;
                        return;
                    }
                    if(isTraceOn)
                        m_bDisplayChange=TRUE;
                    break;
                case 2:
//                  i = GetTokenNum(m_filter.TraceStartAddrTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_filter.TraceEndAddrTxt);
                    if ((i<=0)&&(m_filter.nTraceAddrMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
//                  i = GetTokenNum(m_filter.TraceStartDataTxt);
//                  if (i<=0)
//                  {
//                      MessageBox("Syntax Error!", "Error");
//                      return;
//                  }
                    i = GetTokenNum(m_filter.TraceEndDataTxt);
                    if ((i<=0)&&(m_filter.nTraceDataMode==1))
                    {
                        MessageBox("Syntax Error!", "Error");
                        return;
                    }
                    if (m_filter.bTraceS||m_filter.bTraceF||m_filter.bTraceR
                        ||m_filter.bTraceW||m_filter.bTraceAK
                        ||!m_bFilter2AddrEmpty||!m_bFilter2DataEmpty)
                        {
                         SetTraceFilter();
                         if(nold_addrmode|| nold_datamode)
                               TraceInit();
//                          m_filter.nTraceAddrMode=nold_addrmode;
  //                     if(nold_datamode) 
//                          m_filter.nTraceDataMode=nold_datamode;  
                        }   
                    else
                    {
                        MessageBox("You Must Input Something!", "Error");
                        if(nold_addrmode) 
                            m_filter.nTraceAddrMode=nold_addrmode,
                            m_filter.TraceStartAddrTxt[0]=0;
                        if(nold_datamode) 
                            m_filter.nTraceDataMode=nold_datamode,  
                            m_filter.TraceStartDataTxt[0]=0;
                        return;
                    }
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }
}

BOOL CTraceGroupDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    CenterWindow();
    
    // TODO: Add extra initialization here
//  ShowEventDlg(SW_SHOW);
//  m_activeTab = 0;

//  EventInit();               
    
    switch (m_activeTab)
    {
        case 0:                   
            m_Tab->SetNumProperty("ActiveTab", 0);
            ShowEventDlg(SW_SHOW);                
            EventInit();
            break;
        case 1:
            m_Tab->SetNumProperty("ActiveTab", 1);
            ShowTraceControlDlg(SW_SHOW);
            TraceControlInit();
            break;
        case 2:
            m_Tab->SetNumProperty("ActiveTab", 2);
            ShowTriggerDlg(SW_SHOW);
            TriggerInit();
            break;
        case 3:
            m_Tab->SetNumProperty("ActiveTab", 3);
            ShowFilterDlg(SW_SHOW);
            FilterInit();
            break;
        default:
            break;
    }
            
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTraceGroupDialog::OnGrptrcEvtEv1()
{
    // TODO: Add your control notification handler code here
    m_event.nActiveEvent = 1;                            
    
    Ev1Init();
}

void CTraceGroupDialog::OnGrptrcEvtEv2()
{
    // TODO: Add your control notification handler code here
    m_event.nActiveEvent = 2;
    
    Ev2Init();
}

void CTraceGroupDialog::OnGrptrcEvtEv3()
{
    // TODO: Add your control notification handler code here
    m_event.nActiveEvent = 3;
    
    Ev3Init();
}

void CTraceGroupDialog::OnGrptrcEvtMulti1()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1AddrMode = 2;
            Ev1Init();
            break;
        case 2:
            m_event.nEv2AddrMode = 2;
            Ev2Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcEvtMulti2()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1DataMode = 2;
            Ev1Init();
            break;
        case 2:
            m_event.nEv2DataMode = 2;
            Ev2Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcEvtRange1()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1AddrMode = 1;
            Ev1Init();
            break;
        case 2:
            m_event.nEv2AddrMode = 1;
            Ev2Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcEvtRange2()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1DataMode = 1;
            Ev1Init();
            break;
        case 2:
            m_event.nEv2DataMode = 1;
            Ev2Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcEvtWild1()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1AddrMode = 3;
            Ev1Init();
            break;
        case 2:
            m_event.nEv2AddrMode = 3;
            Ev2Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcEvtWild2()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1DataMode = 3;
            Ev1Init();
            break;
        case 2:
            m_event.nEv2DataMode = 3;
            Ev2Init();
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnSelendokGrptrcEvtAddrtype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    int i=t->GetCurSel();
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1AddrType = i;
            break;
        case 2:
            m_event.nEv2AddrType = i;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnSelendokGrptrcEvtDatatype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    int i=t->GetCurSel();
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1DataType = i;
            break;
        case 2:
            m_event.nEv2DataType = i;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcEvtStartaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
        if(m_event.nEv1AddrMode==1)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt,64);
        else if(m_event.nEv1AddrMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2,64);
        else if(m_event.nEv1AddrMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3,64);
            break;
        case 2:                                                          
        if(m_event.nEv2AddrMode==1) 
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt,64);
        else if(m_event.nEv2AddrMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2,64);
        else if(m_event.nEv2AddrMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3,64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcEvtStartdata()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
        if(m_event.nEv1DataMode==1)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt,64);
        else if(m_event.nEv1DataMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2,64);
        else if(m_event.nEv1DataMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3,64);
            break;
        case 2:                                                          
        if(m_event.nEv2DataMode==1)         
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt,64);
        else if(m_event.nEv2DataMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2,64);
        else if(m_event.nEv2DataMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3,64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcEvtEndaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            GetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt,64);
            break;
        case 2:                                                          
            GetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt,64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcEvtEnddata()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            GetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt,64);
            break;
        case 2:                                                          
            GetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt,64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcEvtCount()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            GetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt,64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcEvtAk()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_AK)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1AK = check;
            break;
        case 2:                                                          
            m_event.bEv2AK = check;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcEvtF()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_F)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1F = check;
            break;
        case 2:                                                          
            m_event.bEv2F = check;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcEvtHigh()
{
    // TODO: Add your control notification handler code here
    int i = GetCheckedRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW);
    if (i==IDC_GRPTRC_EVT_HIGH) m_event.nEv3HL = 1;
    
}

void CTraceGroupDialog::OnGrptrcEvtLow()
{
    // TODO: Add your control notification handler code here
    int i = GetCheckedRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW);
    if (i==IDC_GRPTRC_EVT_LOW) m_event.nEv3HL = 2;
    
}

void CTraceGroupDialog::OnGrptrcEvtR()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_R)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1R = check;
            break;
        case 2:                                                          
            m_event.bEv2R = check;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcEvtS()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_S)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1S = check;
            break;
        case 2:                                                          
            m_event.bEv2S = check;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcEvtW()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_W)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1W = check;
            break;
        case 2:                                                          
            m_event.bEv2W = check;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnSelendokGrptrcFltAddrtype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
    int i=t->GetCurSel();
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            m_filter.nDisplayAddrType = i;
            break;
        case 2:
            m_filter.nTraceAddrType = i;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnSelendokGrptrcFltDatatype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
    int i=t->GetCurSel();
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            m_filter.nDisplayDataType = i;
            break;
        case 2:
            m_filter.nTraceDataType = i;
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcFltDisplay()
{
    // TODO: Add your control notification handler code here
    m_filter.nActiveChoice = 1;
    
    FilterInit();
}

void CTraceGroupDialog::OnGrptrcFltTrace()
{
    // TODO: Add your control notification handler code here
    m_filter.nActiveChoice = 2;
    
    FilterInit();
}

void CTraceGroupDialog::OnGrptrcFltMulti1()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayAddrMode = 2;
            break;
        case 2:
            m_filter.nTraceAddrMode = 2;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt2);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt2);
            break;
        default:
            break;
    }

}

void CTraceGroupDialog::OnGrptrcFltMulti2()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayDataMode = 2;
            break;
        case 2:
            m_filter.nTraceDataMode = 2;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt2);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt2);
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcFltRange1()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayAddrMode = 1;
            break;
        case 2:
            m_filter.nTraceAddrMode = 1;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.DisplayEndAddrTxt);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.TraceEndAddrTxt);
            break;
        default:
            break;
    }

}

void CTraceGroupDialog::OnGrptrcFltRange2()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayDataMode = 1;
            break;
        case 2:
            m_filter.nTraceDataMode = 1;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.DisplayEndDataTxt);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.TraceEndDataTxt);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcFltWild1()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayAddrMode = 3;
            break;
        case 2:
            m_filter.nTraceAddrMode = 3;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt3);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt3);
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcFltWild2()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayDataMode = 3;
            break;
        case 2:
            m_filter.nTraceDataMode = 3;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt3);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt3);
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnChangeGrptrcFltEndaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDADDR, m_filter.DisplayEndAddrTxt, 64);
            break;
        case 2:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDADDR, m_filter.TraceEndAddrTxt, 64);
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnChangeGrptrcFltEnddata()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDDATA, m_filter.DisplayEndDataTxt, 64);
            break;
        case 2:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDDATA, m_filter.TraceEndDataTxt, 64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcFltStartaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            if(m_filter.nDisplayAddrMode == 1)//range
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt, 64);
            else if(m_filter.nDisplayAddrMode == 2)//multiple
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt2, 64);
            else if(m_filter.nDisplayAddrMode == 3)//wildcard
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt3, 64);
            break;
        case 2:
            if(m_filter.nTraceAddrMode == 1)//range
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt, 64);
            else if(m_filter.nTraceAddrMode == 2)//multiple
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt2, 64);
            else if(m_filter.nTraceAddrMode == 3)//wildcard
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt3, 64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnChangeGrptrcFltStartdata()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            if(m_filter.nDisplayDataMode ==1)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt, 64);
            else if(m_filter.nDisplayDataMode ==2)
                    GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt2, 64);
            else if(m_filter.nDisplayDataMode ==3)
                    GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt3, 64);
            break;
        case 2:
            if(m_filter.nTraceDataMode ==1)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt, 64);
            if(m_filter.nTraceDataMode ==2)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt2, 64);
            if(m_filter.nTraceDataMode ==3)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt3, 64);
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcFltAk()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_AK)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayAK = check;
            break;
        case 2:
            m_filter.bTraceAK = check;  
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcFltF()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_F)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayF = check;
            break;
        case 2:
            m_filter.bTraceF = check;   
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcFltR()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_R)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayR = check;
            break;
        case 2:
            m_filter.bTraceR = check;   
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcFltS()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_S)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayS = check;
            break;
        case 2:
            m_filter.bTraceS = check;   
            break;
        default:
            break;
    }
    
}

void CTraceGroupDialog::OnGrptrcFltW()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_W)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayW = check;
            break;
        case 2:
            m_filter.bTraceW = check;   
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcTrcStarttimer()
{
    // TODO: Add your control notification handler code here
    if (IsDlgButtonChecked(IDC_GRPTRC_TRC_STARTTIMER)==0) 
        m_traceControl.bStartTimer = FALSE;
    else
        m_traceControl.bStartTimer = TRUE;
    
    TraceControlInit();
}

void CTraceGroupDialog::OnGrptrcTrcStarttrace()
{
    // TODO: Add your control notification handler code here
    if (IsDlgButtonChecked(IDC_GRPTRC_TRC_STARTTRACE)==0) 
        m_traceControl.bStartTrace = FALSE;
    else
        m_traceControl.bStartTrace = TRUE;
    
    TraceControlInit();
    
}

void CTraceGroupDialog::OnGrptrcTrcCentrg()
{
    // TODO: Add your control notification handler code here
    CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_CENTRG);
    m_traceControl.nDelay = 2;
    TraceControlInit();
}

void CTraceGroupDialog::OnGrptrcTrcDelay()
{
    // TODO: Add your control notification handler code here
    CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_DELAY);
    m_traceControl.nDelay = 4;
    TraceControlInit();
    
}

void CTraceGroupDialog::OnGrptrcTrcPosttrg()
{
    // TODO: Add your control notification handler code here
    CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_POSTTRG);
    m_traceControl.nDelay = 3;
    TraceControlInit();
    
}

void CTraceGroupDialog::OnGrptrcTrcPretrg()
{
    // TODO: Add your control notification handler code here
    CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_PRETRG);
    m_traceControl.nDelay = 1;
    TraceControlInit();
    
}

void CTraceGroupDialog::OnChangeGrptrcTrcCombo()
{
    // TODO: Add your control notification handler code here
    GetDlgItemText(IDC_GRPTRC_TRC_COMBO, m_traceControl.delayTxt, 64);
}

void CTraceGroupDialog::OnGrptrcTrgLv1()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV1);
    m_trigger.nActiveLevel = 1;
    TriggerInit();
}

void CTraceGroupDialog::OnGrptrcTrgLv2()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV2);
    m_trigger.nActiveLevel = 2;
    TriggerInit();
}

void CTraceGroupDialog::OnSelendokGrptrcTrgEvtype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
    int i = t->GetCurSel();
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            m_trigger.level1.nSet = i;
            break;
        case 2:
            m_trigger.level2.nSet = i;
            break;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcTrgTrcon()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            m_trigger.level1.bTraceOn = TRUE;
            break;
        case 2:
            m_trigger.level2.bTraceOn = TRUE;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcTrgTrcoff()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            m_trigger.level1.bTraceOn = FALSE;
            break;
        case 2:
            m_trigger.level2.bTraceOn = FALSE;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcTrgTimeron()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            m_trigger.level1.bTimerOn = TRUE;
            break;
        case 2:
            m_trigger.level2.bTimerOn = TRUE;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcTrgTimeroff()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            m_trigger.level1.bTimerOn = FALSE;
            break;
        case 2:
            m_trigger.level2.bTimerOn = FALSE;
        default:
            break;
    }
}

void CTraceGroupDialog::OnGrptrcTrgEnable()
{
    // TODO: Add your control notification handler code here
    m_trigger.bTriggerEnable = TRUE;    
}

void CTraceGroupDialog::OnGrptrcTrgDisable()
{
    // TODO: Add your control notification handler code here
    m_trigger.bTriggerEnable = FALSE;
}

void CTraceGroupDialog::OnGrptrcTrgRun()
{
    // TODO: Add your control notification handler code here
    if (IsDlgButtonChecked(IDC_GRPTRC_TRG_RUN)==0) m_trigger.bRun = FALSE;
    else m_trigger.bRun = TRUE;
}

void CTraceGroupDialog::OnSelendokGrptrcTrgCombo()
{
    // TODO: Add your control notification handler code here
    CComboBox* t = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
    m_trigger.nTriggerSet = t->GetCurSel();
}

void CTraceGroupDialog::OnKillfocusGrptrcEvtStartaddr()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];            
    char txt1[200];
    char* ptr;                      
    CWnd* wnd;
                       
    switch (m_event.nActiveEvent)
    {
        case 1:                     
            switch (m_event.nEv1AddrMode)
            {
                case 1:
                    i = lstrlen(m_event.Ev1StartAddrTxt);
                    if (i==0) return;
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev1StartAddrTxt,NULL,16);
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_event.Ev1StartAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:     
                    i = GetTokenNum(m_event.Ev1StartAddrTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_event.Ev1StartAddrTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>4) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_event.Ev1StartAddrTxt);
                    if (i==0) return;
                    if ((i!=4)&&(i!=16))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==4) 
                        if (CheckInvalid(m_event.Ev1StartAddrTxt, "1234567890abcdefABCDEFxX", 4)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==16) 
                        if (CheckInvalid(m_event.Ev1StartAddrTxt, "10xX", 16)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        case 2:           
            switch (m_event.nEv2AddrMode)
            {
                case 1:
                    i = lstrlen(m_event.Ev2StartAddrTxt);
                    if (i==0) return;
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev2StartAddrTxt,NULL,16);
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_event.Ev2StartAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_event.Ev2StartAddrTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_event.Ev2StartAddrTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>4) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_event.Ev2StartAddrTxt);
                    if (i==0) return;
                    if ((i!=4)&&(i!=16))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==4) 
                        if (CheckInvalid(m_event.Ev2StartAddrTxt, "1234567890abcdefABCDEFxX", 4)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==16) 
                        if (CheckInvalid(m_event.Ev2StartAddrTxt, "10xX", 16)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_EVT_STARTADDR);
        wnd->SetFocus();
    }
*/  
}

void CTraceGroupDialog::OnKillfocusGrptrcEvtEndaddr()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    CWnd* wnd;
    
    switch (m_event.nActiveEvent)
    {
        case 1:   
            i = lstrlen(m_event.Ev1EndAddrTxt);
            if (i==0) return;
            if (i>4) bErrorFlag = TRUE;
            temp = strtol(m_event.Ev1EndAddrTxt,NULL,16);
            _ultoa(temp, txt, 16);
            if (lstrcmpi(txt,m_event.Ev1EndAddrTxt)!=0)
                bErrorFlag = TRUE;
            break;
        case 2:
            i = lstrlen(m_event.Ev2EndAddrTxt);
            if (i==0) return;
            if (i>4) bErrorFlag = TRUE;
            temp = strtol(m_event.Ev2EndAddrTxt,NULL,16);
            _ultoa(temp, txt, 16); 
            if (lstrcmpi(txt,m_event.Ev2EndAddrTxt)!=0)
                bErrorFlag = TRUE;
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_EVT_ENDADDR);
        wnd->SetFocus();
    }
*/
}

void CTraceGroupDialog::OnKillfocusGrptrcEvtStartdata()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    char txt1[200];
    char* ptr;                      
    CWnd* wnd;
    
    switch (m_event.nActiveEvent)
    {
        case 1: 
            switch (m_event.nEv1DataMode)
            {
                case 1:  
                    i = lstrlen(m_event.Ev1StartDataTxt);
                    if (i==0) return;
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev1StartDataTxt,NULL,16);
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_event.Ev1StartDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_event.Ev1StartDataTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_event.Ev1StartDataTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>2) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_event.Ev1StartDataTxt);
                    if (i==0) return;
                    if ((i!=2)&&(i!=8))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==2) 
                        if (CheckInvalid(m_event.Ev1StartDataTxt, "1234567890abcdefABCDEFxX", 2)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==8) 
                        if (CheckInvalid(m_event.Ev1StartDataTxt, "10xX", 8)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        case 2:   
            switch (m_event.nEv2DataMode)
            {
                case 1:
                    i = lstrlen(m_event.Ev2StartDataTxt);
                    if (i==0) return;
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_event.Ev2StartDataTxt,NULL,16);
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_event.Ev2StartDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_event.Ev2StartDataTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_event.Ev2StartDataTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>2) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_event.Ev2StartDataTxt);
                    if (i==0) return;
                    if ((i!=2)&&(i!=8))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==2) 
                        if (CheckInvalid(m_event.Ev2StartDataTxt, "1234567890abcdefABCDEFxX", 2)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==8) 
                        if (CheckInvalid(m_event.Ev2StartDataTxt, "10xX", 8)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_EVT_STARTDATA);
        wnd->SetFocus();
    }
*/
}

void CTraceGroupDialog::OnKillfocusGrptrcEvtEnddata()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    CWnd* wnd;
    
    switch (m_event.nActiveEvent)
    {
        case 1:   
            i = lstrlen(m_event.Ev1EndDataTxt);
            if (i==0) return;
            if (i>2) bErrorFlag = TRUE;
            temp = strtol(m_event.Ev1EndDataTxt,NULL,16);
            _ultoa(temp, txt, 16);
            if (lstrcmpi(txt,m_event.Ev1EndDataTxt)!=0)
                bErrorFlag = TRUE;
            break;
        case 2:
            i = lstrlen(m_event.Ev2EndDataTxt);
            if (i==0) return;
            if (i>2) bErrorFlag = TRUE;
            temp = strtol(m_event.Ev2EndDataTxt,NULL,16);
            _ultoa(temp, txt, 16); 
            if (lstrcmpi(txt,m_event.Ev2EndDataTxt)!=0)
                bErrorFlag = TRUE;
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_EVT_ENDDATA);
        wnd->SetFocus();
    }
*/
    
}

void CTraceGroupDialog::OnKillfocusGrptrcEvtCount()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    CWnd* wnd;
    
    switch (m_event.nActiveEvent)
    {
        case 1:   
            i = lstrlen(m_event.Ev1CountTxt);
            if (i==0) return;
            if (i>4) bErrorFlag = TRUE;
            temp = strtol(m_event.Ev1CountTxt,NULL,16);
            _ultoa(temp, txt, 16);
            if (lstrcmpi(txt,m_event.Ev1CountTxt)!=0)
                bErrorFlag = TRUE;
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_EVT_COUNT);
        wnd->SetFocus();
    }
*/  
}

void CTraceGroupDialog::OnKillfocusGrptrcFltStartaddr()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    char txt1[200];
    char* ptr;                      
    CWnd* wnd;
    
    switch (m_filter.nActiveChoice)
    {
        case 1:            
            switch (m_filter.nDisplayAddrMode)
            {
                case 1:
                    i = lstrlen(m_filter.DisplayStartAddrTxt);
                    if (i==0) return;
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_filter.DisplayStartAddrTxt,NULL,16);
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_filter.DisplayStartAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_filter.DisplayStartAddrTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_filter.DisplayStartAddrTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>4) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_filter.DisplayStartAddrTxt);
                    if (i==0) return;
                    if ((i!=4)&&(i!=16))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==4) 
                        if (CheckInvalid(m_filter.DisplayStartAddrTxt, "1234567890abcdefABCDEFxX", 4)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==16) 
                        if (CheckInvalid(m_filter.DisplayStartAddrTxt, "10xX", 16)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        case 2:   
            switch (m_filter.nTraceAddrMode)
            {
                case 1:
                    i = lstrlen(m_filter.TraceStartAddrTxt);
                    if (i==0) return;
                    if (i>4) bErrorFlag = TRUE;
                    temp = strtol(m_filter.TraceStartAddrTxt,NULL,16);
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_filter.TraceStartAddrTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_filter.TraceStartAddrTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_filter.TraceStartAddrTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>4) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_filter.TraceStartAddrTxt);
                    if (i==0) return;
                    if ((i!=4)&&(i!=16))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==4) 
                        if (CheckInvalid(m_filter.TraceStartAddrTxt, "1234567890abcdefABCDEFxX", 4)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==16) 
                        if (CheckInvalid(m_filter.TraceStartAddrTxt, "10xX", 16)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_FLT_STARTADDR);
        wnd->SetFocus();
    }
*/  
}

void CTraceGroupDialog::OnKillfocusGrptrcFltStartdata()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    char txt1[200];
    char* ptr;                      
    CWnd* wnd;
    
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            switch (m_filter.nDisplayDataMode)
            {
                case 1:
                    i = lstrlen(m_filter.DisplayStartDataTxt);
                    if (i==0) return;
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_filter.DisplayStartDataTxt,NULL,16);
                    _ultoa(temp, txt, 16);
                    if (lstrcmpi(txt,m_filter.DisplayStartDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_filter.DisplayStartDataTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_filter.DisplayStartDataTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>2) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_filter.DisplayStartDataTxt);
                    if (i==0) return;
                    if ((i!=2)&&(i!=8))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==2) 
                        if (CheckInvalid(m_filter.DisplayStartDataTxt, "1234567890abcdefABCDEFxX", 2)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==8) 
                        if (CheckInvalid(m_filter.DisplayStartDataTxt, "10xX", 8)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        case 2:   
            switch (m_filter.nTraceDataMode)
            {
                case 1:
                    i = lstrlen(m_filter.TraceStartDataTxt);
                    if (i==0) return;
                    if (i>2) bErrorFlag = TRUE;
                    temp = strtol(m_filter.TraceStartDataTxt,NULL,16);
                    _ultoa(temp, txt, 16); 
                    if (lstrcmpi(txt,m_filter.TraceStartDataTxt)!=0)
                        bErrorFlag = TRUE;
                    break;
                case 2:
                    i = GetTokenNum(m_filter.TraceStartDataTxt);
                    if (i>10) 
                    {
                        bErrorFlag = TRUE;
                        break;
                    }                                    
                    if (i==0) return;
                    strcpy(txt1,m_filter.TraceStartDataTxt);
                    ptr=strtok(txt1," ,");
                    do
                    {                                
                        i = lstrlen(ptr);
                        if (i>2) bErrorFlag = TRUE;
                        temp = strtol(ptr, NULL, 16);
                        _ultoa(temp,txt,16);
                        if (lstrcmpi(txt,ptr)!=0)
                            bErrorFlag = TRUE;
                        ptr = strtok(NULL, " ,");
                    }while(ptr!=NULL);
                    break;
                case 3:
                    i = lstrlen(m_filter.TraceStartDataTxt);
                    if (i==0) return;
                    if ((i!=2)&&(i!=8))
                    {
                        bErrorFlag = TRUE;
                        break;
                    }           
                    if (i==2) 
                        if (CheckInvalid(m_filter.TraceStartDataTxt, "1234567890abcdefABCDEFxX", 2)==FALSE)
                            bErrorFlag = TRUE;
                    if (i==8) 
                        if (CheckInvalid(m_filter.TraceStartDataTxt, "10xX", 8)==FALSE)
                            bErrorFlag = TRUE;
                    break;
                default:
                    break;
            }
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_FLT_STARTDATA);
        wnd->SetFocus();
    }
*/
}

void CTraceGroupDialog::OnKillfocusGrptrcFltEndaddr()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    CWnd* wnd;
    
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            i = lstrlen(m_filter.DisplayEndAddrTxt);
            if (i==0) return;
            if (i>4) bErrorFlag = TRUE;
            temp = strtol(m_filter.DisplayEndAddrTxt,NULL,16);
            _ultoa(temp, txt, 16);
            if (lstrcmpi(txt,m_filter.DisplayEndAddrTxt)!=0)
                bErrorFlag = TRUE;
            break;
        case 2:
            i = lstrlen(m_filter.TraceEndAddrTxt);
            if (i==0) return;
            if (i>4) bErrorFlag = TRUE;
            temp = strtol(m_filter.TraceEndAddrTxt,NULL,16);
            _ultoa(temp, txt, 16); 
            if (lstrcmpi(txt,m_filter.TraceEndAddrTxt)!=0)
                bErrorFlag = TRUE;
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_FLT_ENDADDR);
        wnd->SetFocus();
    }
*/  
}

void CTraceGroupDialog::OnKillfocusGrptrcFltEnddata()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    CWnd* wnd;
    
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            i = lstrlen(m_filter.DisplayEndDataTxt);
            if (i==0) return;
            if (i>2) bErrorFlag = TRUE;
            temp = strtol(m_filter.DisplayEndDataTxt,NULL,16);
            _ultoa(temp, txt, 16);
            if (lstrcmpi(txt,m_filter.DisplayEndDataTxt)!=0)
                bErrorFlag = TRUE;
            break;
        case 2:
            i = lstrlen(m_filter.TraceEndDataTxt);
            if (i==0) return;
            if (i>2) bErrorFlag = TRUE;
            temp = strtol(m_filter.TraceEndDataTxt,NULL,16);
            _ultoa(temp, txt, 16); 
            if (lstrcmpi(txt,m_filter.TraceEndDataTxt)!=0)
                bErrorFlag = TRUE;
            break;
        default:
            break;
    }                                  
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_FLT_ENDDATA);
        wnd->SetFocus();
    }
*/  
}

void CTraceGroupDialog::OnKillfocusGrptrcTrcCombo()
{
    // TODO: Add your control notification handler code here
/*
    BOOL bErrorFlag=FALSE;
    int i;                   
    long temp;     
    char txt[129];
    CWnd* wnd;
    
    i = lstrlen(m_traceControl.delayTxt);
    if (i==0) return;
    if (i>4) bErrorFlag = TRUE;
    temp = strtol(m_traceControl.delayTxt,NULL,16);
    _ultoa(temp, txt, 16);
    if (lstrcmpi(txt,m_traceControl.delayTxt)!=0)
        bErrorFlag = TRUE;
    
    if (bErrorFlag)
    {                   
        MessageBox("Syntax Error!", "Error");
        wnd = GetDlgItem(IDC_GRPTRC_TRC_COMBO);
        wnd->SetFocus();
    }
*/  
}

void CTraceGroupDialog::OnGrptrcClose()
{
    // TODO: Add your control notification handler code here
    EndDialog(5);
}

void CTraceGroupDialog::OnGrptrcCancel()
{
    // TODO: Add your control notification handler code here
    EndDialog(4);
}

void delzero(char* content)
{
int i;  
int len=lstrlen(content);
    
    
    for(i=len-1;i>=0;i--)
    	if(content[i]==' ')
    		content[i]=0;
    	else break;		
    len=lstrlen(content);
    for(i=0;i<len;i++)
        if(content[i]!=' ') break;
    for(;i<len;i++)
        if(content[i]!='0') break;
    if (i==0) return;
    if(content[i]=='\0'||content[i]==' '||content[i]==',')
        i--;
    memmove(content, &content[i],len+1-i);
}   
        
void delspace(char* content)
{
int i;  
int len=lstrlen(content);
    
    for(i=len-1;i>=0;i--)
    	if(content[i]==' ')
    		content[i]=0;
    	else break;		
    len=lstrlen(content);
    for(i=0;i<len;i++)
        if(content[i]!=' ') break;
    if (i==0) return;
    if(content[i]=='\0') 
        {
         content[0]=0;
         return;
        } 
    memmove(content, &content[i],len+1-i);
}   

BOOL isHex(char* data)
{
unsigned long temp;     
char txt[20];
    
    temp = strtoul(data,NULL,16);
    _ultoa(temp, txt, 16);
    return(!lstrcmpi(txt,data));
}   

BOOL Sym2Addr(char* buf)
{
int	i;
unsigned char type;
unsigned long addr;
	
	ASSERT(buf[0]==SYMHEAD);
	i=strlen(buf)-1;
	while(buf[i]==' '||buf[i]==',')
		 i--;
	buf[i+1]=0;	 
	if(SymToAddr(buf, &type, &addr))
		return TRUE;					//error
	if(type!=1)							
		return TRUE;					//not code data
	_ultoa(addr, buf, 16);
	return FALSE;						//success
}


BOOL TransAddr(char* buf)
{
char * 	ptr;	                   
int 	bhead, btail, ttail, len;
char temp[150];
char sym[50];           
BOOL	retcode=FALSE;
BOOL	bend=FALSE;	

	if((ptr=strchr(buf,SYMHEAD))==NULL)
		return FALSE;        
	bhead=0;
	btail=ptr-buf;
	ttail=0;
	do{
	   //btail~ #, 
	   memcpy(&temp[ttail], &buf[bhead], btail-bhead);
	   ttail+=btail-bhead;
	   bhead=btail;
	   while(buf[btail]!=' '&&buf[btail]!=','&&buf[btail]!='\0')	
	   		btail++;                                           
	   if(buf[btail]=='\0')
	   		bend=TRUE;
	   memcpy(sym, &buf[bhead], btail-bhead);
	   sym[btail-bhead]=0;
	   if(Sym2Addr(sym))
			retcode=TRUE;	   
	   len=strlen(sym);
	   memcpy(&temp[ttail], sym, len);
	   ttail+=len;
	   bhead=btail;
	   if(!bend)
	   		{
	   		 ptr=strchr(&buf[btail],SYMHEAD);
	   		 btail=ptr?ptr-buf:0;
	   		}
	  }while(btail&&(!bend));
	if(!btail)
		strcpy(&temp[ttail], &buf[bhead]);
	else            	//must bend==TRUE
	  	temp[ttail]=0;
	len=strlen(temp);
	if(len>64)
		{
		 temp[64]=0;
		 retcode=TRUE;		//error
		} 
	strcpy(buf, temp);
	return retcode;	  	
}