
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TRCGRPDI.H__   1.29   02 Apr 1996 09:30:32   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TRCGRPDI.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:30:32   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:52:02   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.24   01 Feb 1996 10:13:54   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.18   15 Jan 1996 16:15:06   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:54   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:30   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:14   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:32   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:45:40   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:20:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:36   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:06   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:12   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGRPDI.H
//
//  Description:The header file for the class: CTraceGroupDialog
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

struct eventInfo{
	int nActiveEvent;	// 1/2/3

	int nEv1AddrMode;	// 1/2/3
	char Ev1StartAddrTxt[65];
	char Ev1StartAddrTxt2[65];
	char Ev1StartAddrTxt3[65];	
	char Ev1EndAddrTxt[65];
	int  nEv1AddrType;  // 0/1
	
	int nEv1DataMode; 	// 1/2/3
	char Ev1StartDataTxt[65];
	char Ev1StartDataTxt2[65];
	char Ev1StartDataTxt3[65];
	char Ev1EndDataTxt[65];
	int  nEv1DataType; 	// 0
	
	BOOL bEv1S;
	BOOL bEv1F;
	BOOL bEv1R;
	BOOL bEv1W;
	BOOL bEv1AK;
	
	char Ev1CountTxt[10];

	int nEv2AddrMode; 	// 1/2/3
	char Ev2StartAddrTxt[65];
    char Ev2StartAddrTxt2[65];
    char Ev2StartAddrTxt3[65];
	char Ev2EndAddrTxt[65];
	int  nEv2AddrType;	// 0/1
	
	int nEv2DataMode;	// 1/2/3
	char Ev2StartDataTxt[65]; 
	char Ev2StartDataTxt2[65];
	char Ev2StartDataTxt3[65];
	char Ev2EndDataTxt[65];
	int  nEv2DataType;	// 0
	
	BOOL bEv2S;
	BOOL bEv2F;
	BOOL bEv2R;
	BOOL bEv2W;
	BOOL bEv2AK;

	int nEv3HL;	// 1/2
};             

struct filterInfo{
	int nActiveChoice;	// 1/2

	int nDisplayAddrMode;	// 1/2/3
	char DisplayStartAddrTxt[65];
	char DisplayStartAddrTxt2[65];
	char DisplayStartAddrTxt3[65];
	char DisplayEndAddrTxt[65];
	int  nDisplayAddrType;	// 0/1
	
	int nDisplayDataMode;	// 1/2/3
	char DisplayStartDataTxt[65];
	char DisplayStartDataTxt2[65];
	char DisplayStartDataTxt3[65];
	char DisplayEndDataTxt[65];
	int  nDisplayDataType;	// 0
	
	BOOL bDisplayS;
	BOOL bDisplayF;
	BOOL bDisplayR;
	BOOL bDisplayW;
	BOOL bDisplayAK;
	
	int nTraceAddrMode;	// 1/2/3
	char TraceStartAddrTxt[65];
	char TraceStartAddrTxt2[65];
	char TraceStartAddrTxt3[65];
	char TraceEndAddrTxt[65];
	int  nTraceAddrType;	// 0/1
	
	int nTraceDataMode;	// 1/2/3
	char TraceStartDataTxt[65];
	char TraceStartDataTxt2[65];
	char TraceStartDataTxt3[65];
	char TraceEndDataTxt[65];
	int  nTraceDataType;	// 0
	
	BOOL bTraceS;
	BOOL bTraceF;
	BOOL bTraceR;
	BOOL bTraceW;
	BOOL bTraceAK;
}; 

struct traceControlInfo {
	BOOL bStartTrace;
	BOOL bStartTimer;
	
	int nDelay; 	// 1/2/3/4
	char delayTxt[65];
};            

struct level {
	int nSet; // 0-14
	BOOL bTraceOn;
	BOOL bTimerOn;
};                

struct triggerInfo {    
	int nActiveLevel;	// 1/2
	struct level level1;
	struct level level2;
	BOOL bTriggerEnable;
	BOOL bRun;
	int nTriggerSet;	// 0-4
};

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog dialog

class CTraceGroupDialog : public CDialog
{
// Construction
public:
    CTraceGroupDialog(CWnd* pParent = NULL);    // standard constructor
    CTraceGroupDialog(CWnd* pParent, int tab);
    
    void ShowEventDlg(int);
    void ShowTraceControlDlg(int);
    void ShowTriggerDlg(int);
    void ShowFilterDlg(int);
    
    void EnableEventCtrl(BOOL);
//    void EnableTriggerCtrl(BOOL);
    
    void EventInit();
    void Ev1Init();
    void Ev2Init();
    void Ev3Init();
    
    void FilterInit();
    void DisplayInit();
    void TraceInit();               
    
    void TriggerInit();
    
    void TraceControlInit(); 
    
    void GetEv1();
    void GetEv2();
    void GetEv3();
    void GetLevel1();
    void GetLevel2();
    void GetTrigger();
    void GetDisplayFilter();
    void GetTraceFilter();

    void SetEv1();
    void SetEv2();
    void SetEv3();
    void SetLevel1();
    void SetLevel2();
    void SetTrigger();
    void SetDisplayFilter();
    void SetTraceFilter();
    
// Dialog Data
    //{{AFX_DATA(CTraceGroupDialog)
	enum { IDD = IDD_GROUP_TRACE };
	CVBControl*	m_Tab;
	//}}AFX_DATA                            
	
public:
	int m_activeTab;	                     
	BOOL 	m_bDisplayChange;
	struct eventInfo m_event;
	struct filterInfo m_filter;   
	struct traceControlInfo m_traceControl;
	struct triggerInfo m_trigger;

private:
	BOOL 	m_bEV1AddrEmpty;
	BOOL	m_bEV2AddrEmpty;
	BOOL	m_bEV1DataEmpty;
	BOOL	m_bEV2DataEmpty;
	BOOL	m_bEV1CountEmpty;
	BOOL	m_bFilter1AddrEmpty;
	BOOL	m_bFilter2AddrEmpty;  
	BOOL	m_bFilter1DataEmpty;
	BOOL	m_bFilter2DataEmpty;
// Implementation
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

    // Generated message map functions
    //{{AFX_MSG(CTraceGroupDialog)
	afx_msg void OnTabActivate(UINT, int, CWnd*, LPVOID);
	afx_msg void OnGrptrcSet();
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcEvtEv1();
	afx_msg void OnGrptrcEvtEv2();
	afx_msg void OnGrptrcEvtEv3();
	afx_msg void OnGrptrcEvtMulti1();
	afx_msg void OnGrptrcEvtMulti2();
	afx_msg void OnGrptrcEvtRange1();
	afx_msg void OnGrptrcEvtRange2();
	afx_msg void OnGrptrcEvtWild1();
	afx_msg void OnGrptrcEvtWild2();
	afx_msg void OnSelendokGrptrcEvtAddrtype();
	afx_msg void OnSelendokGrptrcEvtDatatype();
	afx_msg void OnChangeGrptrcEvtStartaddr();
	afx_msg void OnChangeGrptrcEvtStartdata();
	afx_msg void OnChangeGrptrcEvtEndaddr();
	afx_msg void OnChangeGrptrcEvtEnddata();
	afx_msg void OnChangeGrptrcEvtCount();
	afx_msg void OnGrptrcEvtAk();
	afx_msg void OnGrptrcEvtF();
	afx_msg void OnGrptrcEvtHigh();
	afx_msg void OnGrptrcEvtLow();
	afx_msg void OnGrptrcEvtR();
	afx_msg void OnGrptrcEvtS();
	afx_msg void OnGrptrcEvtW();
	afx_msg void OnSelendokGrptrcFltAddrtype();
	afx_msg void OnSelendokGrptrcFltDatatype();
	afx_msg void OnGrptrcFltDisplay();
	afx_msg void OnGrptrcFltTrace();
	afx_msg void OnGrptrcFltMulti1();
	afx_msg void OnGrptrcFltMulti2();
	afx_msg void OnGrptrcFltRange1();
	afx_msg void OnGrptrcFltRange2();
	afx_msg void OnGrptrcFltWild1();
	afx_msg void OnGrptrcFltWild2();
	afx_msg void OnChangeGrptrcFltEndaddr();
	afx_msg void OnChangeGrptrcFltEnddata();
	afx_msg void OnChangeGrptrcFltStartaddr();
	afx_msg void OnChangeGrptrcFltStartdata();
	afx_msg void OnGrptrcFltAk();
	afx_msg void OnGrptrcFltF();
	afx_msg void OnGrptrcFltR();
	afx_msg void OnGrptrcFltS();
	afx_msg void OnGrptrcFltW();
	afx_msg void OnGrptrcTrcStarttimer();
	afx_msg void OnGrptrcTrcStarttrace();
	afx_msg void OnGrptrcTrcCentrg();
	afx_msg void OnGrptrcTrcDelay();
	afx_msg void OnGrptrcTrcPosttrg();
	afx_msg void OnGrptrcTrcPretrg();
	afx_msg void OnChangeGrptrcTrcCombo();
	afx_msg void OnGrptrcTrgLv1();
	afx_msg void OnGrptrcTrgLv2();
	afx_msg void OnSelendokGrptrcTrgEvtype();
	afx_msg void OnGrptrcTrgTrcon();
	afx_msg void OnGrptrcTrgTrcoff();
	afx_msg void OnGrptrcTrgTimeron();
	afx_msg void OnGrptrcTrgTimeroff();
	afx_msg void OnGrptrcTrgEnable();
	afx_msg void OnGrptrcTrgDisable();
	afx_msg void OnGrptrcTrgRun();
	afx_msg void OnSelendokGrptrcTrgCombo();
	afx_msg void OnKillfocusGrptrcEvtStartaddr();
	afx_msg void OnKillfocusGrptrcEvtEndaddr();
	afx_msg void OnKillfocusGrptrcEvtStartdata();
	afx_msg void OnKillfocusGrptrcEvtEnddata();
	afx_msg void OnKillfocusGrptrcEvtCount();
	afx_msg void OnKillfocusGrptrcFltStartaddr();
	afx_msg void OnKillfocusGrptrcFltStartdata();
	afx_msg void OnKillfocusGrptrcFltEndaddr();
	afx_msg void OnKillfocusGrptrcFltEnddata();
	afx_msg void OnKillfocusGrptrcTrcCombo();
	afx_msg void OnGrptrcClose();
	afx_msg void OnGrptrcCancel();
	//}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

int GetTokenNum(char*); 
BOOL CheckInvalid(char*, char*, int);     
int searchc(char*, char, int);
void delzero(char*);
void delspace(char*);
void del0(char*);
BOOL isHex(char* data);

BOOL Sym2Addr(char* buf);
BOOL TransAddr(char* buf);

extern int SymToAddr(char *lpStr, unsigned char* lpType, 
            unsigned long* lpAddr );
