
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TRCVIEW.CPP   1.29   02 Apr 1996 09:21:48   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TRCVIEW.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:21:48   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:46:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:01:20   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:26:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:10:46   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:11:34   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:11:54   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:31:18   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:21:38   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:07:04   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:09:50   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:18   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:07:40   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:28:42   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:38   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:14   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:27:50   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:22   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:18   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:43:00   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:22:04   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:40   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:06   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:00   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCVIEW.CPP
//
//  Description:The implement file for the class: CTraceView
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcview.cpp : implementation file
//

#include "stdafx.h"
#include "uicom.h"
#include "xview.h"
#include "trcserve.h"
#include "trcview.h"
#include "resource.h"					

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CListTrace* pLTrace;
extern BOOL ListTrcCToWnd(int,WORD*,WORD*,WORD*,FrameC*);

/////////////////////////////////////////////////////////////////////////////
// CTraceView

CTraceView::CTraceView()
{                   
    m_titleLeft = 0;
    m_titleTop = 0;
    m_titleHeight = 20;

    m_titleLeft2 = 0;
    m_titleTop2 = 0;
    m_titleHeight2 = 20;
    
    m_lpszTitle1 = "Frame";
    m_titleMinWidth1 = 45;
    m_lpszTitle2 = "Address";
    m_titleMinWidth2 = 60;
    m_lpszTitle3 = "Data";
    m_titleMinWidth3 = 35;
    m_lpszTitle4 = "Status";
    m_titleMinWidth4 = 50;
    m_lpszTitle5 = "Spare[4-0]";
    m_titleMinWidth5 = 80;
    m_lpszTitle6 = "Port";
    m_titleMinWidth6 = 35;
    m_lpszTitle7 = "";
    m_titleMinWidth7 = 18; 
    m_lpszTitle8 = "Instruction";
    m_titleMinWidth8 = 204;
    m_lpszTitle9 = "Line";
    m_titleMinWidth9 = 60;
    m_lpszTitle10 = "Source";
    m_titleMinWidth10=204;
    
    m_traceHeight = 15;

//  m_traceBuffer = new struct traceFrame[128];
//  ASSERT(m_traceBuffer!=NULL);
    m_winBuffer = new struct traceFrame3[33];       //bus mode
    ASSERT(m_winBuffer!=NULL);
    m_winBuffer2 = new struct traceFrame2[33];      //instruction mode
    ASSERT(m_winBuffer2!=NULL);
    m_winBuffer4 = new struct traceFrame4[33];		//source mode
    ASSERT(m_winBuffer2!=NULL);

    pLTrace = new CListTrace;
    
    m_traceFirstFrameNo = 0;
    m_traceLastFrameNo = 0;
    m_traceBufferFirstFrameNo = 0;
    m_traceBufferLastFrameNo = 0;
    m_traceWinTopFrameNo = 0;
    m_traceWinBottomFrameNo = 0;      

    m_MinWidth = m_titleMinWidth1 +
                 m_titleMinWidth2 +
                 m_titleMinWidth3 +
                 m_titleMinWidth4 +
                 m_titleMinWidth5 +
                 m_titleMinWidth6 + 6;
                 
    m_MinWidth2 = m_titleMinWidth1 +
                  m_titleMinWidth2 +
                  m_titleMinWidth8 + 3;          

    m_MinWidth4 = m_titleMinWidth1 +
                  m_titleMinWidth9 +
                  m_titleMinWidth10 + 3;          

    m_count = 0;
    m_topFrame = 0;              
    m_VScrollFlag = 0;
    nTraceViewOption = 3;
    m_bRead = TRUE;
    m_nPrevCx = 0;
    m_nPrevCy = 0;
//	m_bMostRight=FALSE;			//ADDED BY CHRIS.
	m_nCharWidth=-1;
	m_nhPos2=-1;
	m_nhMaxpos2=-1;
	m_bRefreshflag=FALSE;
	m_bRePaintFlag=FALSE;
}

CTraceView::~CTraceView()
{                                           
//  delete m_traceBuffer;     
    delete m_winBuffer;     
    delete m_winBuffer2;
    delete m_winBuffer4;
}                                                      
                           
void CTraceView::GetTraceInfo()
{                
#ifdef _LANE
    UINT lastFrameNo;        
    int nErrorID = AbiGetTraceLastFrame(&lastFrameNo);
    if(ICE_OK != nErrorID)
    {
        m_traceFirstFrameNo = 0;
        m_traceLastFrameNo = 0;
    }                         
    else
    {
        m_traceFirstFrameNo = 0;
        m_traceLastFrameNo = lastFrameNo;
        if (m_traceLastFrameNo>1) m_traceLastFrameNo--;
    }
#else
    m_traceFirstFrameNo = 1;
    m_traceLastFrameNo = 0x8000;   
//  m_scrollUnit = (int)(m_traceLastFrameNo / 0x8000 + 1);
#endif
    m_scrollUnit = (int)(m_traceLastFrameNo / 0x8000 + 1);//windows limit
}                                

void CTraceView::GetLaneTrace(struct traceFrame* pTrcBuf, long firstNo, long lastNo)
{       
    long i;    
    char buf[5];

    firstNo --;
    lastNo --; 
    for(i = firstNo; i <= lastNo; i++)
    {           
        sprintf(buf,"%04lX", i);
        lstrcpyn(pTrcBuf->frameNo, buf, 5);
        lstrcpyn(pTrcBuf->address,"A000",5);
        lstrcpyn(pTrcBuf->data,"FF",3);
        lstrcpyn(pTrcBuf->status,"W ",3);
        lstrcpyn(pTrcBuf->spare,"10110",6);
        lstrcpyn(pTrcBuf->port,"F0",3);    
        pTrcBuf++;
    }
}                               

void CTraceView::GetQualifyTrace(long* topFrame, long* bottomFrame, int* count, int flag, struct traceFrame3* pTrcBuf)
{
//    int i, j;
//    long k,m; 
//    char buf[5];
    WORD lineCnt;

#ifdef _LANE       
	if (m_bRead==FALSE) 
	{
		m_bRead=TRUE;
		return;
	}
    lineCnt=(WORD)*count;
    ListTrcDataToWnd(flag, (WORD*)topFrame, (WORD*)bottomFrame, &lineCnt, (struct FrameData*)pTrcBuf);
    *count = (int)lineCnt;
/*#else                    
    j = *count;
    k = 0x1000;
    *topFrame = k;                 
    *bottomFrame = k+(long)count-1;
    m = k;
    for(i=1;i<=j;i++)
    {
        sprintf(buf,"%04lX", m);
        lstrcpyn(pTrcBuf->frameNo, buf, 5);
        lstrcpyn(pTrcBuf->address,"A000",5);
        lstrcpyn(pTrcBuf->data,"FF",3);
        lstrcpyn(pTrcBuf->status,"W ",3);
        lstrcpyn(pTrcBuf->spare,"10110",6);
        lstrcpyn(pTrcBuf->port,"F0",3);    
        pTrcBuf++;            
        m++;
    }   
*/
#endif  
}

void CTraceView::GetInstructionTrace(long* topFrame, long* bottomFrame, int* count, int flag, struct traceFrame2* pTrcBuf)
{
//    int i, j;
//    long k,m; 
//    char buf[5];
    WORD lineCnt;
    
#ifdef _LANE
	if (m_bRead==FALSE) 
	{
		m_bRead=TRUE;
		return;
	}
    lineCnt=(WORD)*count;
  ListTrcInstToWnd(flag, (WORD*)topFrame, (WORD*)bottomFrame, &lineCnt, (struct FrameInst*)pTrcBuf);
//  pLTrace->ListTrcInstToWnd(flag, (WORD*)topFrame, (WORD*)bottomFrame, &lineCnt, (struct FrameInst*)pTrcBuf);
    *count = (int)lineCnt;
/*#else                    
    j = *count;
    k = 0x1000;
    *topFrame = k;                 
    *bottomFrame = k+(long)count-1;
    m = k;
    for(i=1;i<=j;i++)
    {
        sprintf(buf,"%04lX", m);
        lstrcpyn(pTrcBuf->frameNo, buf, 5);
        lstrcpyn(pTrcBuf->address,"A000",5);
        lstrcpyn(pTrcBuf->instruction,"move a,b",9);
        pTrcBuf++;            
        m++;
    }                     
*/
#endif  
}

void CTraceView::GetSourceTrace(long* topFrame, long* bottomFrame, int* count, int flag, struct traceFrame4* pTrcBuf)
{
//    int i, j;
//    long k,m; 
//    char buf[5];
    WORD lineCnt;
    
#ifdef _LANE
	if (m_bRead==FALSE) 
	{
		m_bRead=TRUE;
		return;
	}
    lineCnt=(WORD)*count;
  ListTrcCToWnd(flag, (WORD*)topFrame, (WORD*)bottomFrame, &lineCnt, (struct FrameC*)pTrcBuf);
    *count = (int)lineCnt;
#endif  
}

void CTraceView::ShowTrace2(struct traceFrame2* pTrcBuf, long count, int left, int top, int height, CDC* pDc)
{
    RECT rect;                                  
//    SIZE size;
    int addX,addY;
    long i;                      
    int w1,w2,w3;
    int j;

	pDc->SelectStockObject(ANSI_FIXED_FONT);    
    w1=30;
    w2=30;
    w3=0;

    rect.top = top;
    rect.bottom = rect.top + height;
    addY = 0;
	for (i = 1; i <= count; i++)
	{
	    //display "Frame No" field
	    rect.left = left;
	    rect.right = rect.left + m_titleWidth1 + 1;  
//	    addX = (m_titleWidth1 - w1)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->frameNo,
	        4,
	        NULL);
	
	    //display "Address" field    
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth2 + 1;
//	    addX = (m_titleWidth2 - w2)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->address,
	        4,
	        NULL);
	    
	    //display "Data" field
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth8 + 1+m_nCharWidth*3;
	    addX = 0;
	    j = strlen((char*)pTrcBuf->instruction);
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        (char*)pTrcBuf->instruction,
	        j,
	        NULL);
	
	    pTrcBuf++;      
	    rect.top = rect.bottom;
	    rect.bottom = rect.top + height;
	}   

}

void CTraceView::ShowTrace4(struct traceFrame4* pTrcBuf, long count, int left, int top, int height, CDC* pDc)
{
    RECT rect;                                  
    SIZE size;
    int addX,addY;
    long i;                      
    int w1,w2,w3;
    int j;
    RECT rect2;

	pDc->SelectStockObject(ANSI_FIXED_FONT);    
    w1=30;
    w2=30;
    w3=0;

    rect.top = top;
    rect.bottom = rect.top + height;
    addY = 0;
	for (i = 1; i <= count; i++)
	{
	    //display "Frame No" field
	    rect.left = left;
	    rect.right = rect.left + m_titleWidth1 + 1;  
//	    addX = (m_titleWidth1 - w1)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->frameNo,
	        4,
	        NULL);
	
	    //display "Address" field    
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth9 + 1;
//	    addX = (m_titleWidth2 - w2)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->line,
	        4,
	        NULL);
	    
	    //display "Data" field
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth10;
	    addX = 0;
	    j = strlen((char*)pTrcBuf->source);
	    size = pDc->GetTextExtent((char*)pTrcBuf->source,j);
	    if ((size.cx>m_titleMinWidth10)&&(size.cx>m_titleWidth10))
	    {
	    	GetParent()->GetWindowRect(&rect2);
	    	rect2.right = rect2.right - rect2.left;
	    	rect2.bottom = rect2.bottom - rect2.top;
//	    	rect2.right += (size.cx - m_titleMinWidth10 + 10);
	    	m_titleMinWidth10 = size.cx+10;
	    	m_MinWidth4 = m_titleMinWidth1 + m_titleMinWidth9 + m_titleMinWidth10;
	    	GetParent()->SetWindowPos(NULL,0,0,rect2.right+1,rect2.bottom,SWP_NOMOVE|SWP_NOZORDER);
	    }
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        (char*)pTrcBuf->source,
	        j,
	        NULL);
	
	    pTrcBuf++;      
	    rect.top = rect.bottom;
	    rect.bottom = rect.top + height;
	}   

}

void CTraceView::ShowTrace3(struct traceFrame3* pTrcBuf, long count, int left, int top, int height, CDC* pDc)
{
    RECT rect;                                  
//    SIZE size;
    int addX,addY;
    long i;                      
    int w1,w2,w3,w4,w5,w6;               
    
    pDc->SelectStockObject(ANSI_FIXED_FONT);
    w1=30;
    w2=30;
    w3=15;
    w4=20;
    w5=40;
    w6=15;

    rect.top = top;
    rect.bottom = rect.top + height;
    addY = 0;
	for (i = 1; i <= count; i++)
	{
	    //display "Frame No" field
	    rect.left = left;
	    rect.right = rect.left + m_titleWidth1 + 1;  
//	    addX = (m_titleWidth1 - w1)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->frameNo,
	        4,
	        NULL);
	
	    //display "Address" field    
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth2 + 1;
//	    addX = (m_titleWidth2 - w2)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->address,
	        4,
	        NULL);
	    
	    //display "Data" field
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth3 + 1;
//	    addX = (m_titleWidth3 - w3)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->data,
	        2,
	        NULL);
	    
	    //display "status" field        
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth4 + 1;
//	    addX = (m_titleWidth4 - w4)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->status,
	        2,
	        NULL);
	    
	    
	    //display "Spare[4-0]" field          
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth5 + 1;
//	    addX = (m_titleWidth5 - w5)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->spare,
	        5,
	        NULL);
	    
	    //display "P0/P1/P2/P3" field   
	    rect.left = rect.right;
	    rect.right = rect.left + m_titleWidth6 + 1;
//	    addX = (m_titleWidth6 - w6)/2;
	    addX = 0;
	    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
	        ETO_CLIPPED | ETO_OPAQUE,
	        &rect,
	        pTrcBuf->port,
	        2,
	        NULL);
	        
	    pTrcBuf++;      
	    rect.top = rect.bottom;
	    rect.bottom = rect.top + height;
	}   

}

void CTraceView::FlushTraceBuffer()
{                                                                 
    if (m_traceWinBottomFrameNo > m_traceLastFrameNo) 
        m_traceWinBottomFrameNo = m_traceLastFrameNo;
    if (m_traceWinTopFrameNo < m_traceFirstFrameNo)
        m_traceWinTopFrameNo = m_traceFirstFrameNo;
        
    if ((m_traceBufferFirstFrameNo > m_traceWinTopFrameNo) ||
        (m_traceBufferLastFrameNo < m_traceWinBottomFrameNo))
    {
        m_traceBufferFirstFrameNo = m_traceWinTopFrameNo - 
                (128 - (m_traceWinBottomFrameNo - m_traceWinTopFrameNo + 1))/2; 
        m_traceBufferLastFrameNo = m_traceBufferFirstFrameNo + 127;

        if (m_traceBufferLastFrameNo > m_traceLastFrameNo) 
            m_traceBufferLastFrameNo = m_traceLastFrameNo;
        if (m_traceBufferFirstFrameNo < m_traceFirstFrameNo)
            m_traceBufferFirstFrameNo = m_traceFirstFrameNo;
            
        GetLaneTrace(m_traceBuffer, m_traceBufferFirstFrameNo, m_traceBufferLastFrameNo);
    }
}            

void CTraceView::ShowTrace(struct traceFrame* pTrcBuf, long count, int left, int top, int height, CDC* pDc)
{
    RECT rect;                                  
//    SIZE size;
    int addX,addY;
    long i;                      
    int w1,w2,w3,w4,w5,w6;
    
    w1=30;
    w2=30;
    w3=15;
    w4=20;
    w5=40;
    w6=15;

    rect.top = top;
    rect.bottom = rect.top + height;
    addY = 0;
for (i = 1; i <= count; i++)
{
    //display "Frame No" field
    rect.left = left;
    rect.right = rect.left + m_titleWidth1 + 1;  
    addX = (m_titleWidth1 - w1)/2;
    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
        ETO_CLIPPED | ETO_OPAQUE,
        &rect,
        pTrcBuf->frameNo,
        4,
        NULL);

    //display "Address" field    
    rect.left = rect.right;
    rect.right = rect.left + m_titleWidth2 + 1;
    addX = (m_titleWidth2 - w2)/2;
    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
        ETO_CLIPPED | ETO_OPAQUE,
        &rect,
        pTrcBuf->address,
        4,
        NULL);
    
    //display "Data" field
    rect.left = rect.right;
    rect.right = rect.left + m_titleWidth3 + 1;
    addX = (m_titleWidth3 - w3)/2;
    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
        ETO_CLIPPED | ETO_OPAQUE,
        &rect,
        pTrcBuf->data,
        2,
        NULL);
    
    //display "status" field        
    rect.left = rect.right;
    rect.right = rect.left + m_titleWidth4 + 1;
    addX = (m_titleWidth4 - w4)/2;
    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
        ETO_CLIPPED | ETO_OPAQUE,
        &rect,
        pTrcBuf->status,
        2,
        NULL);
    
    
    //display "Spare[4-0]" field          
    rect.left = rect.right;
    rect.right = rect.left + m_titleWidth5 + 1;
    addX = (m_titleWidth5 - w5)/2;
    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
        ETO_CLIPPED | ETO_OPAQUE,
        &rect,
        pTrcBuf->spare,
        5,
        NULL);
    
    //display "P0/P1/P2/P3" field   
    rect.left = rect.right;
    rect.right = rect.left + m_titleWidth6 + 1;
    addX = (m_titleWidth6 - w6)/2;
    pDc->ExtTextOut(rect.left+addX, rect.top+addY,
        ETO_CLIPPED | ETO_OPAQUE,
        &rect,
        pTrcBuf->port,
        2,
        NULL);
        
    pTrcBuf++;      
    rect.top = rect.bottom;
    rect.bottom = rect.top + height;
}   
}


BEGIN_MESSAGE_MAP(CTraceView, CWnd)
    //{{AFX_MSG_MAP(CTraceView)
    ON_WM_RBUTTONDOWN()
    ON_WM_SIZE()
    ON_WM_HSCROLL()
    ON_WM_PAINT()
    ON_WM_VSCROLL()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceView message handlers

void CTraceView::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
//    if (nFlags == MK_RBUTTON) 
//    {                                             
        LPARAM lParam;
        lParam = (WORD)point.y + 20;
        lParam <<= 16;
        lParam += (WORD)point.x;
        GetParent()->SendMessage(WM_RBUTTONDOWN, nFlags, lParam);
//    }
    
    CWnd::OnRButtonDown(nFlags, point);
}

void CTraceView::OnSize(UINT nType, int cx, int cy)
{
    CWnd::OnSize(nType, cx, cy);   
    
    // TODO: Add your message handler code here
    int nPos;
    long tmp;
    RECT rect;          
    if (cy > (m_nPrevCy-2)) m_bRead = TRUE;
    m_nPrevCx = cx;
    m_nPrevCy = cy;
    
    int width = 0;
    int count = 0;
    int add = 0;   
    int add2 = 0;           
    
switch (nTraceViewOption)
{
//    case 1: 
//    if (cx < m_MinWidth)
//  {
//      SetScrollRange(SB_HORZ, 0, m_MinWidth, FALSE);
//      ASSERT(m_titleLeft<=0);
//      tmp = (long)m_MinWidth*(long)(-m_titleLeft);
//      nPos = (int)(tmp/(m_MinWidth - cx));
//      SetScrollPos(SB_HORZ, nPos, TRUE);
//  }                      
//  else
//      SetScrollRange(SB_HORZ, 0, 0);       
    
//  GetClientRect(&rect);
//  cy = rect.bottom - rect.top;
//  GetTraceInfo();
//  if (m_traceLastFrameNo==0)
//  {       
//      m_traceFirstFrameNo = 0;
//      m_traceLastFrameNo = 0;
//      m_traceBufferFirstFrameNo = 0;
//      m_traceBufferLastFrameNo = 0;
//      m_traceWinTopFrameNo = 0;
//      m_traceWinBottomFrameNo = 0;      
//      EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
//  }                           
//  else
//  {                           
//      if (m_traceWinBottomFrameNo==0) m_traceWinTopFrameNo = 1;  
//      m_pageLines = cy/m_traceHeight;                
//      if (m_pageLines == 0) m_pageLines = 1;
//      if (((cy/m_traceHeight)!=0)&&((cy%m_traceHeight) > 3))
//          m_bModeLine = TRUE;    
//      else
//          m_bModeLine = FALSE;
//      m_traceWinBottomFrameNo = m_traceWinTopFrameNo + m_pageLines - 1;
//      if (m_bModeLine == TRUE) m_traceWinBottomFrameNo++;
//      if (m_traceLastFrameNo>1)
//      {
//          EnableScrollBar(SB_VERT, ESB_ENABLE_BOTH);
//          SetScrollRange(SB_VERT, 0, (UINT)((m_traceLastFrameNo-1)/m_scrollUnit), TRUE);
//          SetScrollPos(SB_VERT, (UINT)((m_traceWinTopFrameNo-1)/m_scrollUnit), TRUE);
//      }                                      
//      else
//          EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
//  }   
//  break;
    
    case 3:   
        if (cx < m_MinWidth)
        {             
            SetScrollRange(SB_HORZ, 0, m_MinWidth, FALSE);
            ASSERT(m_titleLeft<=0);
            tmp = (long)m_MinWidth*(long)(-m_titleLeft);
            nPos = (int)(tmp/(m_MinWidth - cx));
            SetScrollPos(SB_HORZ, nPos, TRUE);
        }                      
        else
            SetScrollRange(SB_HORZ, 0, 0);       
    
        GetClientRect(&rect);
        cy = rect.bottom - rect.top;
        GetTraceInfo();
        if (m_traceLastFrameNo==0)
        {       
            m_traceFirstFrameNo = 0;
            m_traceBufferFirstFrameNo = 0;
            m_traceBufferLastFrameNo = 0;
            m_traceWinTopFrameNo = 0;
            m_traceWinBottomFrameNo = 0;      
            EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
        }
        else
        {
            m_pageLines = cy/m_traceHeight;                
            if ((m_pageLines!=0)&&((cy%m_traceHeight) > 3))
                m_bModeLine = TRUE;    
            else
                m_bModeLine = FALSE;
            
            m_count = m_pageLines;
            if (m_bModeLine) m_count++;
                
            if (m_traceLastFrameNo>m_count/2)			//modify by chris, 19/10/1995
            {
                EnableScrollBar(SB_VERT, ESB_ENABLE_BOTH);
                SetScrollRange(SB_VERT, 0, (UINT)((m_traceLastFrameNo-m_count/2)/m_scrollUnit), TRUE);
                SetScrollPos(SB_VERT, (UINT)(m_topFrame/m_scrollUnit), TRUE);
            }                                      
            else
                EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
        }                           
        break;
    
    case 2:            						
        width += m_titleMinWidth1;
        count += 1;
        width += m_titleMinWidth2;
        count += 1;
        width += m_titleMinWidth8;
        count += 1;
        width += m_titleMinWidth7;
    
        if (cx >= (width + count -1))
        {
            int i = cx - (width + count -1);
            add = 0;                 
            add2 = i;                    
        }                                           
        
        m_titleWidth1 = m_titleMinWidth1 + add;
        m_titleWidth2 = m_titleMinWidth2 + add;
        m_titleWidth8 = m_titleMinWidth8 + add + add2;
        m_titleWidth7 = m_titleMinWidth7;
        
        
        RECT rect;
        rect.top = m_titleTop2;
        rect.bottom = m_titleHeight2;  
        rect.left=0;
        rect.right=cy;
        
        if (cx < m_MinWidth2+m_nCharWidth*2)
        {
            m_nhMaxpos2=(m_MinWidth2-cx)/m_nCharWidth+2;			//a space be left
            m_nhPos2=GetScrollPos(SB_HORZ);
            SetScrollRange(SB_HORZ, 0, m_nhMaxpos2, FALSE);
            ASSERT(m_titleLeft2<=0);
			m_nhPos2=m_nhPos2<m_nhMaxpos2?m_nhPos2:m_nhMaxpos2;
            SetScrollPos(SB_HORZ, m_nhPos2, TRUE);
			m_titleLeft2=-(m_nhPos2*m_nCharWidth);            
        }                      
        else
            {
             SetScrollRange(SB_HORZ, 0, 0);       
			 m_titleLeft2=0;
			}             
        GetParent()->InvalidateRect(&rect,TRUE);
        GetClientRect(&rect);
        cy = rect.bottom - rect.top;
        GetTraceInfo();
        if (m_traceLastFrameNo==0)
        {       
            m_traceFirstFrameNo = 0;
            m_traceLastFrameNo = 0;
            m_traceBufferFirstFrameNo = 0;
            m_traceBufferLastFrameNo = 0;
            m_traceWinTopFrameNo = 0;
            m_traceWinBottomFrameNo = 0;      
            EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
        }
        else
        {
            m_pageLines = cy/m_traceHeight;                
            if (((m_pageLines)!=0)&&((cy%m_traceHeight) > 3))
                m_bModeLine = TRUE;    
            else
                m_bModeLine = FALSE;
            
            m_count = m_pageLines;
            if (m_bModeLine) m_count++;
                
            if (m_traceLastFrameNo>m_count/2)
            {
                EnableScrollBar(SB_VERT, ESB_ENABLE_BOTH);
                SetScrollRange(SB_VERT, 0, (UINT)((m_traceLastFrameNo-m_count/2)/m_scrollUnit), FALSE);
                SetScrollPos(SB_VERT, (UINT)(m_topFrame/m_scrollUnit), TRUE);
            }                                      
            else
                EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
        }                           

        break;

    case 4:
        if (cx < m_MinWidth4)
        {
            SetScrollRange(SB_HORZ, 0, m_MinWidth4, FALSE);
            ASSERT(m_titleLeft2<=0);
            tmp = (long)m_MinWidth4*(long)(-m_titleLeft2);
            nPos = (int)(tmp/(m_MinWidth4 - cx));
            SetScrollPos(SB_HORZ, nPos, TRUE);
        }                      
        else
            SetScrollRange(SB_HORZ, 0, 0);       

        GetClientRect(&rect);
        cy = rect.bottom - rect.top;
        GetTraceInfo();
        if (m_traceLastFrameNo==0)
        {       
            m_traceFirstFrameNo = 0;
            m_traceLastFrameNo = 0;
            m_traceBufferFirstFrameNo = 0;
            m_traceBufferLastFrameNo = 0;
            m_traceWinTopFrameNo = 0;
            m_traceWinBottomFrameNo = 0;      
            EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
        }
        else
        {
            m_pageLines = cy/m_traceHeight;                
            if (((m_pageLines)!=0)&&((cy%m_traceHeight) > 3))
                m_bModeLine = TRUE;    
            else
                m_bModeLine = FALSE;
            
            m_count = m_pageLines;
            if (m_bModeLine) m_count++;
                
            if (m_traceLastFrameNo>m_count/2)
            {
                EnableScrollBar(SB_VERT, ESB_ENABLE_BOTH);
                SetScrollRange(SB_VERT, 0, (UINT)((m_traceLastFrameNo-m_count/2)/m_scrollUnit), TRUE);
                SetScrollPos(SB_VERT, (UINT)(m_topFrame/m_scrollUnit), TRUE);
            }                                      
            else
                EnableScrollBar(SB_VERT, ESB_DISABLE_BOTH);
        }                           

        break;
        
    default:
        break;
}
}

void CTraceView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default
    RECT rect;
    int pos;              
    long tmp;
    GetClientRect(&rect);   
    int Minpos,Maxpos;
    
    int page;
    GetScrollRange(SB_HORZ, &Minpos, &Maxpos);
    
    
switch (nTraceViewOption)
{
//    case 1: 
    case 3:
    switch (nSBCode)
    {
        case SB_LINERIGHT:
        	m_bRead = FALSE;
            if ((rect.right - m_titleLeft) >= m_MinWidth) break;
            m_titleLeft -= 3;
            if ((rect.right - m_titleLeft) > m_MinWidth)
                m_titleLeft = rect.right - m_MinWidth;
            tmp = (long)m_MinWidth*(long)(-m_titleLeft);
            pos = (int)(tmp/(m_MinWidth - rect.right));
            SetScrollPos(SB_HORZ, pos, TRUE);          
            rect.top = m_titleTop;
            rect.bottom = m_titleHeight;  
            GetParent()->InvalidateRect(&rect,FALSE);
            InvalidateRgn(NULL,FALSE);
            break;
        case SB_LINELEFT:
        	m_bRead = FALSE;
            if (m_titleLeft >= 0) break;
            m_titleLeft += 3;
            if (m_titleLeft >= 0) m_titleLeft = 0;
            tmp = (long)m_MinWidth*(long)(-m_titleLeft);
            pos = (int)(tmp/(m_MinWidth - rect.right));
            SetScrollPos(SB_HORZ, pos, TRUE);
            rect.top = m_titleTop;
            rect.bottom = m_titleHeight;  
            GetParent()->InvalidateRect(&rect,FALSE);
            InvalidateRgn(NULL,FALSE);
            break;                                  
        case SB_PAGELEFT:
        	m_bRead = FALSE;
            if (m_titleLeft >= 0) break;
            m_titleLeft += rect.right;
            if (m_titleLeft >= 0) m_titleLeft = 0;
            tmp = (long)m_MinWidth*(long)(-m_titleLeft);
            pos = (int)(tmp/(m_MinWidth - rect.right));
            SetScrollPos(SB_HORZ, pos, TRUE);
            rect.top = m_titleTop;
            rect.bottom = m_titleHeight;  
            GetParent()->InvalidateRect(&rect,FALSE);
            InvalidateRect(NULL,FALSE);
            break;                                  
        case SB_PAGERIGHT:
        	m_bRead = FALSE;
            if ((rect.right - m_titleLeft) >= m_MinWidth) break;
            m_titleLeft -= rect.right;
            if ((rect.right - m_titleLeft) > m_MinWidth)
                m_titleLeft = rect.right - m_MinWidth;
            tmp = (long)m_MinWidth*(long)(-m_titleLeft);
            pos = (int)(tmp/(m_MinWidth - rect.right));
            SetScrollPos(SB_HORZ, pos, TRUE);  
            rect.top = m_titleTop;
            rect.bottom = m_titleHeight;  
            GetParent()->InvalidateRect(&rect,FALSE);
            InvalidateRect(NULL,FALSE);
            break;                                 
        case SB_THUMBPOSITION:
        	m_bRead = FALSE;
            SetScrollPos(SB_HORZ, nPos, TRUE);
            tmp = (long)nPos*(long)(m_MinWidth-rect.right);
            m_titleLeft = -(int)(tmp/(long)(m_MinWidth));   
            if (nPos == 0) m_titleLeft = 0;
            if (nPos == (UINT)m_MinWidth) m_titleLeft = rect.right - m_MinWidth;
            rect.top = m_titleTop;
            rect.bottom = m_titleHeight;  
            GetParent()->InvalidateRect(&rect,FALSE); 
            InvalidateRect(NULL,FALSE);
            break;               
        default: break;
    }   
    break;
    
    case 2:
        switch (nSBCode)
        {
            case SB_LINERIGHT:
	        	m_bRead = FALSE;
                
                if (m_nhMaxpos2<=m_nhPos2) break;			//can't be right
                m_nhPos2++;
                ASSERT(m_nhPos2<=m_nhMaxpos2);
                m_titleLeft2 -= m_nCharWidth;
                SetScrollPos(SB_HORZ, m_nhPos2, TRUE);
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRgn(NULL,FALSE);
                break;
            case SB_LINELEFT:
	        	m_bRead = FALSE;
                ASSERT(m_titleLeft2 <= 0);
                if(m_nhPos2<=0) break;
                m_nhPos2--;
                ASSERT(m_nhPos2>=0);
                m_titleLeft2 += m_nCharWidth;
                if (m_titleLeft2 >= 0) m_titleLeft2 = 0;
                SetScrollPos(SB_HORZ, m_nhPos2, TRUE);
//				if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;                
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRgn(NULL,FALSE);
                break;                                  
            case SB_PAGELEFT:
	        	m_bRead = FALSE;              
	        	if(m_nhPos2==0) break;
	        	page=rect.right/m_nCharWidth;
	        	m_nhPos2-=page;
	        	if(m_nhPos2<0) m_nhPos2=0;
                m_titleLeft2=-(m_nhPos2*m_nCharWidth);
                SetScrollPos(SB_HORZ, m_nhPos2, TRUE);
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRect(NULL,FALSE);
                break;                                  
            case SB_PAGERIGHT:
	        	m_bRead = FALSE;
                if (m_nhPos2==m_nhMaxpos2) break;
                page=rect.right/m_nCharWidth;
                m_nhPos2+=page;
				if(m_nhPos2>m_nhMaxpos2) m_nhPos2=m_nhMaxpos2;
                m_titleLeft2=-(m_nhPos2*m_nCharWidth);                
                SetScrollPos(SB_HORZ, m_nhPos2, TRUE);  
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRect(NULL,FALSE);
                break;                                 
            case SB_THUMBPOSITION:
	        	m_bRead = FALSE;
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                if(nPos==(UINT)m_nhPos2) break;
                m_nhPos2=nPos;
                SetScrollPos(SB_HORZ, nPos, TRUE);
                m_titleLeft2 = -((int)nPos*m_nCharWidth);   
//                if (nPos == 0) m_titleLeft2 = 0;
//                if (nPos == (UINT)m_MinWidth2) m_titleLeft2 = rect.right - m_MinWidth2;
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE); 
                InvalidateRect(NULL,FALSE);
                break;               
            default: break;
        }   
        break;

    case 4:
        switch (nSBCode)
        {
            case SB_LINERIGHT:
	        	m_bRead = FALSE;
                if ((rect.right - m_titleLeft2) >= m_MinWidth4) break;
                m_titleLeft2 -= 3;
                if ((rect.right - m_titleLeft2) > m_MinWidth4)
                    m_titleLeft2 = rect.right - m_MinWidth4;
                tmp = (long)m_MinWidth4*(long)(-m_titleLeft2);
                pos = (int)(tmp/(m_MinWidth4 - rect.right));
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                SetScrollPos(SB_HORZ, pos, TRUE);
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRgn(NULL,FALSE);
                break;
            case SB_LINELEFT:
	        	m_bRead = FALSE;
                if (m_titleLeft2 >= 0) break;
                m_titleLeft2 += 3;
                if (m_titleLeft2 >= 0) m_titleLeft2 = 0;
                tmp = (long)m_MinWidth4*(long)(-m_titleLeft2);
                pos = (int)(tmp/(m_MinWidth4 - rect.right));
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                SetScrollPos(SB_HORZ, pos, TRUE);
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRgn(NULL,FALSE);
                break;                                  
            case SB_PAGELEFT:
	        	m_bRead = FALSE;
                if (m_titleLeft2 >= 0) break;
                m_titleLeft2 += rect.right;
                if (m_titleLeft2 >= 0) m_titleLeft2 = 0;
                tmp = (long)m_MinWidth4*(long)(-m_titleLeft2);
                pos = (int)(tmp/(m_MinWidth4 - rect.right));
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                SetScrollPos(SB_HORZ, pos, TRUE);
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRect(NULL,FALSE);
                break;                                  
            case SB_PAGERIGHT:
	        	m_bRead = FALSE;
                if ((rect.right - m_titleLeft2) >= m_MinWidth4) break;
                m_titleLeft2 -= rect.right;
                if ((rect.right - m_titleLeft2) > m_MinWidth4)
                    m_titleLeft2 = rect.right - m_MinWidth4;
                tmp = (long)m_MinWidth4*(long)(-m_titleLeft2);
                pos = (int)(tmp/(m_MinWidth4 - rect.right));
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                SetScrollPos(SB_HORZ, pos, TRUE);  
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE);
                InvalidateRect(NULL,FALSE);
                break;                                 
            case SB_THUMBPOSITION:
	        	m_bRead = FALSE;
//                if(nPos==Maxpos) m_bMostRight=TRUE;
//    			else	m_bMostRight=FALSE;
                SetScrollPos(SB_HORZ, nPos, TRUE);
                tmp = (long)nPos*(long)(m_MinWidth4-rect.right);
                m_titleLeft2 = -(int)(tmp/(long)(m_MinWidth4));   
                if (nPos == 0) m_titleLeft2 = 0;
                if (nPos == (UINT)m_MinWidth4) m_titleLeft2 = rect.right - m_MinWidth4;
                rect.top = m_titleTop2;
                rect.bottom = m_titleHeight2;  
                GetParent()->InvalidateRect(&rect,FALSE); 
                InvalidateRect(NULL,FALSE);
                break;               
            default: break;
        }   
        break;
        
    default:
        break;
}
    
    CWnd::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CTraceView::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here   
//    struct traceFrame* pTraceBuffer;
    static long bottomFrame=-1;                                                                
    int count, len;
//    WPARAM	type;
//    LPARAM	lParam;
//    RECT	rect;

switch (nTraceViewOption)
{
//    case 1: 
//    ASSERT(m_traceFirstFrameNo<=m_traceLastFrameNo);
//  ASSERT(m_traceBufferFirstFrameNo<=m_traceBufferLastFrameNo);
//  ASSERT(m_traceWinTopFrameNo<=m_traceWinBottomFrameNo);
//  
//  if (0 == m_traceLastFrameNo)
//  {   
//      GetTraceInfo();
//        if (0 == m_traceLastFrameNo) return;
//    }
//    
//    FlushTraceBuffer();
//    ASSERT(m_traceBuffer!=NULL);
//    ASSERT(m_traceWinTopFrameNo>=m_traceBufferFirstFrameNo);
//    ASSERT(m_traceWinBottomFrameNo<=m_traceBufferLastFrameNo);
    
//    pTraceBuffer = m_traceBuffer;
//    pTraceBuffer += (m_traceWinTopFrameNo-m_traceBufferFirstFrameNo);
//    ShowTrace(pTraceBuffer, 
//                m_traceWinBottomFrameNo - m_traceWinTopFrameNo + 1,
//                m_titleLeft,
//                0,
//                m_traceHeight,
//                &dc);
//    break;                         
    
    case 3:   
        if (0 == m_traceLastFrameNo)
        {   
            GetTraceInfo();
            if (0 == m_traceLastFrameNo) return;
        }              
                                                                             
        count = m_count;             
		BeginWaitCursor();   
        GetQualifyTrace(&m_topFrame, &bottomFrame, &count, m_VScrollFlag, m_winBuffer);
//        if (m_count>count)
//            InvalidateRect(NULL,TRUE);
		EndWaitCursor();    
        ShowTrace3(m_winBuffer, count, m_titleLeft, 0, m_traceHeight, &dc);

        SetScrollPos(SB_VERT, (UINT)(m_topFrame/m_scrollUnit), TRUE);
        m_VScrollFlag = 0;
    
        break;
    
    case 2:
        if (0 == m_traceLastFrameNo)
        {   
            GetTraceInfo();
            if (0 == m_traceLastFrameNo) return;
        }
        count = m_count+1;     	//add 1 is to avoid flash cause by hscrollbar's exist or noexit
	    if(!m_bRePaintFlag)
		{
		BeginWaitCursor();  
        
        GetInstructionTrace(&m_topFrame, &bottomFrame, &count, m_VScrollFlag, m_winBuffer2);
		len=GetInstructionLen(m_winBuffer2,count);	//len: Instruction section length
		if(len!=m_titleMinWidth8)
			{
			 m_bRePaintFlag=TRUE;	
			 m_MinWidth2+=(len-m_titleMinWidth8);
			 m_titleMinWidth8=len;
			 /*
			 if (IsZoomed()) type=2;
			 	else type=0;
			 GetClientRect(&rect); 
			 lParam = rect.bottom;
			 lParam <<=16;
  			 lParam += rect.right;
			 SendMessage(WM_SIZE,type, lParam);
			 */
			 GetParent()->SendMessage(WM_COMMAND, ID_VIEW_REFRESH, NULL);
			 EndWaitCursor();    				 
			 return;
			 //m_bRefreshflag=FALSE;
			} 
//        if (m_count>count)
//            InvalidateRect(NULL,TRUE);
		EndWaitCursor();    
		}
//		if(m_bMostRight)
//             ShowTrace2(m_winBuffer2, count, m_titleLeft2-
//					 	GetInstructionLen(m_winBuffer2,count), 0, 
//				 		m_traceHeight, &dc);
        ShowTrace2(m_winBuffer2, count, m_titleLeft2, 0, m_traceHeight, &dc);
        m_bRePaintFlag=FALSE;

        SetScrollPos(SB_VERT, (UINT)(m_topFrame/m_scrollUnit), TRUE);
        m_VScrollFlag = 0;
        break;

    case 4:
        if (0 == m_traceLastFrameNo)
        {   
            GetTraceInfo();
            if (0 == m_traceLastFrameNo) return;
        }
        count = m_count;     
		BeginWaitCursor();
        GetSourceTrace(&m_topFrame, &bottomFrame, &count, m_VScrollFlag, m_winBuffer4);
//        if (m_count>count)
//            InvalidateRect(NULL,TRUE);
		EndWaitCursor();    
//        if(m_bMostRight)
//			 ShowTrace4(m_winBuffer4, count, 
//			 			m_titleLeft2-GetCLen(m_winBuffer4,count), 
//			 			0, m_traceHeight, &dc);
        ShowTrace4(m_winBuffer4, count, m_titleLeft2, 0, m_traceHeight, &dc);

        SetScrollPos(SB_VERT, (UINT)(m_topFrame/m_scrollUnit), TRUE);
        m_VScrollFlag = 0;
        break;

    default:
        break;
}   
    // Do not call CWnd::OnPaint() for painting messages
}

int CTraceView::GetInstructionLen(struct traceFrame2* pBuffer,long counts) 
{
int len, max=0;
	for(int i=0; i<counts; i++)
		{
		 len=strlen((const char*)pBuffer->instruction);
		 if(max<len)	max=len;
		 pBuffer++;
		} 
	len=max*m_nCharWidth;
		
    len=len>204?len:204;							//204 see CTraceView::CTraceView()
    return len;
}    

/*
int CTraceView::GetCLen(struct traceFrame4* pBuffer,long counts) 
{
int inc, len, max=0;
	for(int i=0; i<counts; i++)
		{
		 len=strlen((const char*)pBuffer->source);
		 if(max<len)	max=len;
		 pBuffer++;
		} 
	len=max*m_nCharWidth;
    inc=len-m_titleMinWidth10;
    inc=inc<0?0:inc;
    return inc;
}        
*/

void CTraceView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
    // TODO: Add your message handler code here and/or call default 
//    BOOL bFlush;               
    int  dummy,max;

switch (nTraceViewOption)
{
/*    case 1: 
    bFlush = FALSE;
    
    switch (nSBCode)
    {
        case SB_LINEDOWN:              
            if (m_traceWinTopFrameNo >= m_traceLastFrameNo) break;
            m_traceWinTopFrameNo ++;                                
            m_traceWinBottomFrameNo = m_traceWinTopFrameNo + m_pageLines - 1;
            if (m_bModeLine==TRUE) m_traceWinBottomFrameNo++;
            if (m_traceWinBottomFrameNo > m_traceLastFrameNo)
                m_traceWinBottomFrameNo = m_traceLastFrameNo;
            SetScrollPos(SB_VERT, (UINT)((m_traceWinTopFrameNo-1)/m_scrollUnit), TRUE);
            if (m_bModeLine == TRUE)
            {
                if ((m_traceWinBottomFrameNo-m_traceWinTopFrameNo)<m_pageLines)
                    bFlush = TRUE;
            }
            else
            {
                if ((m_traceWinBottomFrameNo-m_traceWinTopFrameNo)<(m_pageLines-1))
                    bFlush = TRUE;
            }
            InvalidateRect(NULL,bFlush);
            break;
        case SB_LINEUP:                
            if (m_traceWinTopFrameNo <= m_traceFirstFrameNo) break;
            m_traceWinTopFrameNo --;
            m_traceWinBottomFrameNo = m_traceWinTopFrameNo + m_pageLines - 1;
            if (m_bModeLine==TRUE) m_traceWinBottomFrameNo++;
            if (m_traceWinBottomFrameNo > m_traceLastFrameNo)
                m_traceWinBottomFrameNo = m_traceLastFrameNo;
            SetScrollPos(SB_VERT, (UINT)((m_traceWinTopFrameNo-1)/m_scrollUnit), TRUE);
            InvalidateRect(NULL,bFlush);
            break;  
        case SB_PAGEDOWN:
            if (m_traceWinBottomFrameNo >= m_traceLastFrameNo) break;
            if (m_bModeLine==TRUE) m_traceWinTopFrameNo = m_traceWinBottomFrameNo;
            else m_traceWinTopFrameNo = m_traceWinBottomFrameNo + 1;
            m_traceWinBottomFrameNo = m_traceWinTopFrameNo + m_pageLines - 1;
            if (m_bModeLine==TRUE) m_traceWinBottomFrameNo++;
            if (m_traceWinBottomFrameNo > m_traceLastFrameNo)
                m_traceWinBottomFrameNo = m_traceLastFrameNo;
            SetScrollPos(SB_VERT, (UINT)((m_traceWinTopFrameNo-1)/m_scrollUnit), TRUE);
            if (m_bModeLine == TRUE)
            {
                if ((m_traceWinBottomFrameNo-m_traceWinTopFrameNo)<m_pageLines)
                    bFlush = TRUE;
            }
            else
            {
                if ((m_traceWinBottomFrameNo-m_traceWinTopFrameNo)<(m_pageLines-1))
                    bFlush = TRUE;
            }
            InvalidateRect(NULL,bFlush);
            break;
        case SB_PAGEUP:
            if (m_traceWinTopFrameNo <= m_traceFirstFrameNo) break;
            m_traceWinTopFrameNo = m_traceWinTopFrameNo - m_pageLines;
            if (m_traceWinTopFrameNo < m_traceFirstFrameNo)
                m_traceWinTopFrameNo = m_traceFirstFrameNo;
            m_traceWinBottomFrameNo = m_traceWinTopFrameNo + m_pageLines - 1;
            if (m_bModeLine==TRUE) m_traceWinBottomFrameNo++;
            if (m_traceWinBottomFrameNo > m_traceLastFrameNo)
                m_traceWinBottomFrameNo = m_traceLastFrameNo;
            SetScrollPos(SB_VERT, (UINT)((m_traceWinTopFrameNo-1)/m_scrollUnit), TRUE);
            InvalidateRect(NULL,bFlush);
            break;
        case SB_TOP:
        	nPos=0;
        case SB_BOTTOM:
        	if(nSBCode==SB_BOTTOM)
        		GetScrollRange(	&dummy, &nPos);
        case SB_THUMBPOSITION:
            SetScrollPos(SB_VERT, nPos, TRUE);
            m_traceWinTopFrameNo = nPos*m_scrollUnit + 1;
            m_traceWinBottomFrameNo = m_traceWinTopFrameNo + m_pageLines - 1;
            if (m_bModeLine==TRUE) m_traceWinBottomFrameNo++;
            if (m_traceWinBottomFrameNo > m_traceLastFrameNo)
                m_traceWinBottomFrameNo = m_traceLastFrameNo;
            if (m_bModeLine == TRUE)
            {
                if ((m_traceWinBottomFrameNo-m_traceWinTopFrameNo)<m_pageLines)
                    bFlush = TRUE;
            }
            else
            {
                if ((m_traceWinBottomFrameNo-m_traceWinTopFrameNo)<(m_pageLines-1))
                    bFlush = TRUE;
            }
            InvalidateRect(NULL,bFlush);
            break;     
        default:
            break;
    }   
    break;                            
*/    
    case 3:   
        switch (nSBCode)
        {                  
            case SB_LINEUP:
            	m_bRead=TRUE;
                m_VScrollFlag = -1;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_LINEDOWN:
            	m_bRead=TRUE;
                m_VScrollFlag = 1;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_PAGEUP:
            	m_bRead=TRUE;
                m_VScrollFlag = -2;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_PAGEDOWN:              
            	m_bRead=TRUE;
                m_VScrollFlag = 2;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_TOP:
        		nPos=0;
        	case SB_BOTTOM:
        		if(nSBCode==SB_BOTTOM)
        			{
        			 GetScrollRange(SB_VERT,	&dummy, &max);
        			 nPos=(UINT)max;
        			} 
            case SB_THUMBPOSITION: 
            	m_bRead=TRUE;
                m_VScrollFlag = 0;
                m_topFrame = nPos*m_scrollUnit;
                InvalidateRect(NULL,FALSE);
                break;
            default: 
                m_VScrollFlag = 0;
                break;
        }
    
        break;
    
    case 2:
        switch (nSBCode)
        {                  
            case SB_LINEUP:
            	m_bRead=TRUE;
                m_VScrollFlag = -1;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_LINEDOWN:
            	m_bRead=TRUE;
                m_VScrollFlag = 1;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_PAGEUP:
            	m_bRead=TRUE;
                m_VScrollFlag = -2;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_PAGEDOWN:              
            	m_bRead=TRUE;
                m_VScrollFlag = 2;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_TOP:
        		nPos=0;
        	case SB_BOTTOM:
        		if(nSBCode==SB_BOTTOM)
        			{
        			 GetScrollRange(SB_VERT,	&dummy, &max);
        			 nPos=(UINT)max;
        			} 
            case SB_THUMBPOSITION: 
            	m_bRead=TRUE;
                m_VScrollFlag = 0;
                m_topFrame = nPos*m_scrollUnit;
                InvalidateRect(NULL,FALSE);
                break;
            default: 
                m_VScrollFlag = 0;
                break;
        }
        break;

    case 4:
        switch (nSBCode)
        {                  
            case SB_LINEUP:
            	m_bRead=TRUE;
                m_VScrollFlag = -1;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_LINEDOWN:
            	m_bRead=TRUE;
                m_VScrollFlag = 1;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_PAGEUP:
            	m_bRead=TRUE;
                m_VScrollFlag = -2;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_PAGEDOWN:              
            	m_bRead=TRUE;
                m_VScrollFlag = 2;
                InvalidateRect(NULL,FALSE);
                break;
            case SB_TOP:
        		nPos=0;
        	case SB_BOTTOM:
        		if(nSBCode==SB_BOTTOM)
        			{
        			 GetScrollRange(SB_VERT,	&dummy, &max);
        			 nPos=(UINT)max;
        			} 
            case SB_THUMBPOSITION: 
            	m_bRead=TRUE;
                m_VScrollFlag = 0;
                m_topFrame = nPos*m_scrollUnit;
                InvalidateRect(NULL,FALSE);
                break;
            default: 
                m_VScrollFlag = 0;
                break;
        }
        break;
    
    default:
        break;
}
    
    CWnd::OnVScroll(nSBCode, nPos, pScrollBar);
}

int CTraceView::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	TEXTMETRIC tm;
	CDC* pdc=GetDC();
	pdc->SelectStockObject(ANSI_FIXED_FONT);
	pdc->GetTextMetrics(&tm);
	m_nCharWidth=tm.tmAveCharWidth;
	return 0;
}

