
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TRCVIEW.H__   1.29   02 Apr 1996 09:28:44   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TRCVIEW.H__  $
** 
**    Rev 1.29   02 Apr 1996 09:28:44   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:50:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:32   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:36   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:14   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:24   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:18   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:42   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:26   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:46   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:18   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:06   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:44:56   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:21:06   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:32   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:14   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:46   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCVIEW.H
//
//  Description:The header file for the class: CTraceView
//
//  Author:     Lane Li ,Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcview.h : header file
//

struct traceFrame {
	char frameNo[5];
	char address[5];
	char data[3];
	char status[3];
	char spare[6];
	char port[3];
};

struct traceFrame3 {
	UINT nFrame;
	char frameNo[5];
	char address[5];
	char data[3];
	char status[3];
	char spare[6];
	char port[3];
};

struct traceFrame2 {
	UINT nFrame;
	char frameNo[5];
	char address[5];
	unsigned char instruction[128];
};

struct traceFrame4 {
	UINT nFrame;
	char frameNo[5];
	char line[10];
	unsigned char source[256];
};

/////////////////////////////////////////////////////////////////////////////
// CTraceView window

class CTraceView : public CWnd
{
// Construction
public:
	CTraceView();  

// Attributes
public:         
	int m_titleLeft;
	int m_titleTop;
	int m_titleHeight;

	int m_titleLeft2;
	int m_titleTop2;
	int m_titleHeight2;
	
	LPCSTR m_lpszTitle1;
	int m_titleMinWidth1;
	int m_titleWidth1;
	LPCSTR m_lpszTitle2;
	int m_titleMinWidth2;
	int m_titleWidth2;			
	LPCSTR m_lpszTitle3;
	int m_titleMinWidth3;
	int m_titleWidth3;
	LPCSTR m_lpszTitle4;
	int m_titleMinWidth4;
	int m_titleWidth4;
	LPCSTR m_lpszTitle5;
	int m_titleMinWidth5;
	int m_titleWidth5;
	LPCSTR m_lpszTitle6;
	int m_titleMinWidth6;
	int m_titleWidth6;
	LPCSTR m_lpszTitle7;
	int m_titleMinWidth7;
	int m_titleWidth7;         
	
	LPCSTR m_lpszTitle8;
	int m_titleMinWidth8;
	int m_titleWidth8;
	LPCSTR m_lpszTitle9;
	int m_titleMinWidth9;
	int m_titleWidth9;
	LPCSTR m_lpszTitle10;
	int m_titleMinWidth10;
	int m_titleWidth10;

	int m_MinWidth;      			//minwidth of bus mode when no hscroll
	int m_MinWidth2;                //modify smart by content!  
	int m_MinWidth4;
	
	int m_nhPos2;
	int m_nhMaxpos2;
	
	long m_traceFirstFrameNo;
	long m_traceLastFrameNo;
	long m_traceBufferFirstFrameNo;
	long m_traceBufferLastFrameNo;
	long m_traceWinTopFrameNo;
	long m_traceWinBottomFrameNo;     
	
	int m_traceHeight;              //The height of every ine in trace window is 15
	int m_pageLines;                
	BOOL m_bModeLine;                 
	
	int m_scrollUnit;                 
	
	long m_topFrame;
	int m_count;                        
	int m_VScrollFlag;
	
	BOOL m_bRead;
	BOOL m_bRefreshflag;
	BOOL m_bRePaintFlag;
	
	int m_nPrevCx;
	int m_nPrevCy;
	
	struct traceFrame* m_traceBuffer;      
	struct traceFrame3* m_winBuffer;
	struct traceFrame2* m_winBuffer2;
	struct traceFrame4* m_winBuffer4;

private:
//	BOOL	m_bMostRight;
	int		m_nCharWidth;
	int		GetInstructionLen(struct traceFrame2* pBuffer,long count);
//	int		GetCLen(struct traceFrame4* pBuffer,long count); 
       
// Operations
public:   
    
	void GetLaneTrace(struct traceFrame*, long, long);                                              
	void FlushTraceBuffer();
	void ShowTrace(struct traceFrame*, long, int, int, int, CDC*);     
	void ShowTrace3(struct traceFrame3*, long, int, int, int, CDC*);     
	void GetTraceInfo();                     
	void GetQualifyTrace(long*, long*, int*, int, struct traceFrame3*);
	void GetInstructionTrace(long*, long*, int*, int, struct traceFrame2*);
	void GetSourceTrace(long*, long*, int*, int, struct traceFrame4*);
	void ShowTrace2(struct traceFrame2*, long, int, int, int, CDC*);     
	void ShowTrace4(struct traceFrame4*, long, int, int, int, CDC*);     

// Implementation
public:
	virtual ~CTraceView();

protected:
	// Generated message map functions
	//{{AFX_MSG(CTraceView)
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnPaint();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);  //by chris
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
