
/***************************************************************************
**
**    $Header:   C:/EPSLDV1/SRC/LOG/TRCWIN.CPP   1.29   02 Apr 1996 09:25:22   Shirley  $
**
**    $Log:   C:/EPSLDV1/SRC/LOG/TRCWIN.CPP  $
** 
**    Rev 1.29   02 Apr 1996 09:25:22   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:56:44   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:02   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:30   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:50   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:14   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:44   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:29:02   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:10:46   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:02   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:26   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:24   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:40   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:04   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:38   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:33:44   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:26   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:48:58   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:21:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:28   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:14   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:08   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCWIN.CPP
//
//  Description:The implement file for the class: CTraceWindow
//
//  Author:     Lane Li & Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "trcview.h"
#include "trcwin.h"
#include "spin.h"
#include "myedit.h"
#include "trcgtdlg.h"
#include "trcschdg.h"
#include "lanecom.h"
#include "string.h"     
#include "trcgrpdi.h"
#include "trcfidlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  
///////////////////////////////////////////////////////////////////////
void TrcOpenWindow(CMDIFrameWnd * pParent)
{                                         
    nTraceViewOption = 3;
    
    if(isTraceOn)    return;
    pTraceWnd = new CTraceWindow;
    if(!((CTraceWindow *)pTraceWnd)->Create("Trace", 
        WS_CHILD|WS_VISIBLE|WS_OVERLAPPEDWINDOW,
        CFrameWnd::rectDefault, pParent))
        ASSERT(0);                

    isTraceOn = TRUE;
}

//////////////////////////////////////////////
CMenu NEAR CTraceWindow::m_menu;                              

/////////////////////////////////////////////////////////////////////////////
// CTraceWindow

IMPLEMENT_DYNCREATE(CTraceWindow, CMDIChildWnd)

BOOL CTraceWindow::Create(LPCSTR szTitle, LONG style,
    const RECT& rect, CMDIFrameWnd * pParent)
{
    // Setup the shared m_menu
    if(m_menu.m_hMenu == NULL)
        m_menu.LoadMenu(IDR_TRACE);
    m_hMenuShared = m_menu.m_hMenu;

    const char * pszTraceClass =
        AfxRegisterWndClass(CS_HREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(COLOR_WINDOW + 1),
            AfxGetApp()->LoadIcon(IDI_TRACE));
    return CMDIChildWnd::Create(pszTraceClass, szTitle,
        style, rect, pParent);
}

CTraceWindow::CTraceWindow()
{                                                 
	m_nIDHelp = IDR_TRACE;
}

CTraceWindow::~CTraceWindow()
{                 
    isTraceOn = FALSE;
}                     
/*
long CTraceWindow::Search1(int begin)    
{       
    long count,firstNo,lastNo,i;                                 
    char* find;
    struct traceFrame* ptrBuf;
    struct traceFrame* buf = new struct traceFrame[10];          
    ASSERT(buf!=NULL);
    m_viewTrace.GetTraceInfo();
    count = m_viewTrace.m_traceWinTopFrameNo-1 ;    
    count += begin;
    find = NULL;
    while (count<m_viewTrace.m_traceLastFrameNo)
    {
        firstNo = count + 1;                   
        lastNo = firstNo + 9;
        if (lastNo > m_viewTrace.m_traceLastFrameNo) lastNo = m_viewTrace.m_traceLastFrameNo;
        m_viewTrace.GetLaneTrace(buf,firstNo,lastNo);
        ptrBuf = buf;
        for(i=firstNo;i<=lastNo;i++)
        {      
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->address, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->data, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->status, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->spare, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->port, searchContent);
            if (find!=NULL)
                break;
            count++;
            ptrBuf++;
        }                        
        if (find!=NULL) break;
    }                                  
    delete buf;
    if (find!=NULL) return (count);
    else return(-1);
}            
*/

long CTraceWindow::Search2(int begin)
{
    long count,firstNo,lastNo,i;                                 
    char* find;
    int a;
    struct traceFrame2* ptrBuf;
    struct traceFrame2* buf = new struct traceFrame2[2];          
    ASSERT(buf!=NULL);
    m_viewTrace.GetTraceInfo();
    count = m_viewTrace.m_topFrame;    
    count += begin;
    find = NULL;
    a = 1;
    while (count<m_viewTrace.m_traceLastFrameNo)
    {
        if(TestKey(VK_ESCAPE))
        	return (-lastNo);
        firstNo = count;                   
        lastNo = firstNo + 2;
//        if (lastNo > m_viewTrace.m_traceLastFrameNo) lastNo = m_viewTrace.m_traceLastFrameNo;
        a = 2;								//if more than 2, we can't know which frame has searchcontent.
        m_viewTrace.GetInstructionTrace(&firstNo,&lastNo,&a,0,buf);
        ptrBuf = buf;
        for(i=0;i<a;i++)
        {      
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->address, searchContent);
            if (find!=NULL)
                break;
            find = strstr((char*)(ptrBuf->instruction), searchContent);
            if (find!=NULL)
                break;
            ptrBuf++;
        }   
      
        if (find!=NULL) break;
        count=lastNo+1;
    }                                  
    delete buf;
    if (find!=NULL) 
    	{
    	 if(i)
    	 	return (lastNo);
    	 return (firstNo);
    	} 
    else return(-1);
}            

long CTraceWindow::Search3(int begin)
{
    long count,firstNo,lastNo,i;                                 
    char* find;
    int a;
    struct traceFrame3* ptrBuf;
    struct traceFrame3* buf = new struct traceFrame3[10];          
    ASSERT(buf!=NULL);
    m_viewTrace.GetTraceInfo();
    count = m_viewTrace.m_topFrame;    
    count += begin;
    find = NULL;
    a = 1;
    while (count<m_viewTrace.m_traceLastFrameNo)
    {
        if(TestKey(VK_ESCAPE))
        	return (-lastNo);
        firstNo = count;                   
        lastNo = firstNo + 1;
        if (lastNo > m_viewTrace.m_traceLastFrameNo) lastNo = m_viewTrace.m_traceLastFrameNo;
        a = 1;
        m_viewTrace.GetQualifyTrace(&firstNo,&lastNo,&a,0,buf);
        count = firstNo;
        ptrBuf = buf;
        for(i=firstNo;i<=lastNo;i++)
        {      
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->address, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->data, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->status, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->spare, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->port, searchContent);
            if (find!=NULL)
                break;
            count++;
            ptrBuf++;
        }                        
        if (find!=NULL) break;
    }                                  
    delete buf;
    if (find!=NULL) return (count);
    else return(-1);
}

long CTraceWindow::Search4(int begin)
{
    long count,firstNo,lastNo,i;                                 
    char* find;
    int a;
    struct traceFrame4* ptrBuf;
    struct traceFrame4* buf = new struct traceFrame4[2];          
    ASSERT(buf!=NULL);
    m_viewTrace.GetTraceInfo();
    count = m_viewTrace.m_topFrame;    
    count += begin;
    find = NULL;
    a = 1;
    while (count<m_viewTrace.m_traceLastFrameNo)
    {                   
        if(TestKey(VK_ESCAPE))
        	return (-lastNo);
        firstNo = count;                   
        lastNo = firstNo + 2;
//        if (lastNo > m_viewTrace.m_traceLastFrameNo) lastNo = m_viewTrace.m_traceLastFrameNo;
        a = 2;
        m_viewTrace.GetSourceTrace(&firstNo,&lastNo,&a,0,buf);
        ptrBuf = buf;
        for(i=0;i<a;i++)
        {      
            find = strstr(ptrBuf->frameNo, searchContent);
            if (find!=NULL)
                break;
            find = strstr(ptrBuf->line, searchContent);
            if (find!=NULL)
                break;
            find = strstr((char*)(ptrBuf->source), searchContent);
            if (find!=NULL)
                break;
            ptrBuf++;
        }                        
        if (find!=NULL) break;
        count=lastNo+1;
    }                                  
    delete buf;
    if (find!=NULL) 
    	{
    	 if(i)
    	 	return (lastNo);
    	 return (firstNo);
    	} 	
    else return(-1);
}

BEGIN_MESSAGE_MAP(CTraceWindow, CMDIChildWnd)
    //{{AFX_MSG_MAP(CTraceWindow)
    ON_WM_MDIACTIVATE()
    ON_WM_RBUTTONDOWN()
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchnext)
    ON_WM_SETCURSOR()
    ON_WM_PAINT()
    ON_WM_SIZE()
    ON_WM_CREATE()
    ON_COMMAND(ID_VIEW_BUS, OnViewBus)
    ON_UPDATE_COMMAND_UI(ID_VIEW_BUS, OnUpdateViewBus)
    ON_COMMAND(ID_VIEW_INSTRUCTION, OnViewInstruction)
    ON_UPDATE_COMMAND_UI(ID_VIEW_INSTRUCTION, OnUpdateViewInstruction)
    ON_COMMAND(ID_EDIT_GOTOFRAME, OnEditGotoframe)
    ON_UPDATE_COMMAND_UI(ID_EDIT_GOTOFRAME, OnUpdateEditGotoframe)
    ON_COMMAND(ID_EDIT_GOTOSTARTFRAME, OnEditGotostartframe)
    ON_UPDATE_COMMAND_UI(ID_EDIT_GOTOSTARTFRAME, OnUpdateEditGotostartframe)
    ON_COMMAND(ID_EDIT_GOTOENDFRAME, OnEditGotoendframe)
    ON_UPDATE_COMMAND_UI(ID_EDIT_GOTOENDFRAME, OnUpdateEditGotoendframe)
    ON_COMMAND(ID_TRACE_CONTROL, OnTraceControl)
    ON_UPDATE_COMMAND_UI(ID_TRACE_CONTROL, OnUpdateTraceControl)
    ON_COMMAND(ID_TRACE_EVENT, OnTraceEvent)
    ON_UPDATE_COMMAND_UI(ID_TRACE_EVENT, OnUpdateTraceEvent)
    ON_COMMAND(ID_TRACE_FILTER, OnTraceFilter)
    ON_UPDATE_COMMAND_UI(ID_TRACE_FILTER, OnUpdateTraceFilter)
    ON_COMMAND(ID_TRACE_TRIGGER, OnTraceTrigger)
    ON_UPDATE_COMMAND_UI(ID_TRACE_TRIGGER, OnUpdateTraceTrigger)
    ON_COMMAND(ID_FILE_SAVETRACE, OnFileSavetrace)
    ON_UPDATE_COMMAND_UI(ID_FILE_SAVETRACE, OnUpdateFileSavetrace)
	ON_COMMAND(ID_VIEW_SOURCE, OnViewSource)
	ON_UPDATE_COMMAND_UI(ID_VIEW_SOURCE, OnUpdateViewSource)
	ON_COMMAND(ID_VIEW_REFRESH, OnViewRefresh)
    ON_MESSAGE(XM_REPAINT,OnXMRepaint)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_SHIFTRETURN, OnShiftreturn)
	ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCHNEXT, OnUpdateEditSearchnext)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CTraceWindow::DrawStatic(LPCSTR lpszText, UINT nCount, RECT rect, CDC* pDc)
{
    COLORREF oldColor;                           
    SIZE size;  
    CPen pen1;
    CPen* oldPen;
                   
	pDc->SelectStockObject(ANSI_FIXED_FONT);      
    oldColor = pDc->SetBkColor(PALETTEINDEX(7));
    size = pDc->GetOutputTextExtent(lpszText, nCount);
//    int addx = (rect.right - rect.left - size.cx) / 2;
    int addx = 0;
    int addy = (rect.bottom - rect.top - size.cy) / 2;
    pDc->ExtTextOut(rect.left+addx, rect.top+addy, 
        ETO_CLIPPED | ETO_OPAQUE, 
        &rect, 
        lpszText, 
        nCount, 
        NULL);
    pDc->SetBkColor(oldColor);
    pen1.CreatePen(PS_SOLID,1,PALETTEINDEX(12));
    oldPen = pDc->SelectObject(&pen1);
    pDc->MoveTo((rect.right-1),rect.top);
    pDc->LineTo((rect.right-1),(rect.bottom-1));
    pDc->LineTo(rect.left,(rect.bottom-1));
    pDc->SelectObject(oldPen);
}

/////////////////////////////////////////////////////////////////////////////
// CTraceWindow message handlers


void CTraceWindow::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
    CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
    
    // TODO: Add your message handler code here
    if(bActivate && pActivateWnd == this)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
            LONG(WID_TRACE));
    else if(!bActivate && !pActivateWnd)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 
}

void CTraceWindow::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    CMenu * pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );

    pLocalMenu->CreatePopupMenu();
	pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_REFRESH, "&Refresh");
	pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_BUS, "&Bus");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_INSTRUCTION,
                            "&Instruction");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SOURCE,
                            "S&ource");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTOSTARTFRAME,
                          	"Goto &Start Frame");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTOENDFRAME, "Goto &End Frame");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_GOTOFRAME, "&Goto Frame...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_FILE_SAVETRACE, "S&ave Trace...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_CONTROL, "Trace &Control...");
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_EVENT, "E&vent...");
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_TRIGGER, "&Trigger...");
    pLocalMenu->AppendMenu(MF_STRING, ID_TRACE_FILTER, "Trace &Filter...");

    ClientToScreen(&point);
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, this);
    delete pLocalMenu;
    
    CMDIChildWnd::OnRButtonDown(nFlags, point);
}

BOOL CTraceWindow::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default
    if(message == WM_RBUTTONDOWN)   
        return FALSE;
    return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}
  
void CTraceWindow::OnEditSearch()
{
    // TODO: Add your command handler code here
    long result;
    CTrcSchDg dlg(this);

    result = dlg.DoModal();
    if (result!=1) return;

	BeginWaitCursor();
	
    switch (nTraceViewOption)
    {
//        case 1:                              
//            result = (int)Search1(0); 
//            if (result<0) 
//            {
//                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
//                break;
//            }
//            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
//            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
//            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
//            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
//               m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
//            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
//                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;
//            m_viewTrace.InvalidateRect(NULL,TRUE);
//            m_viewTrace.SetScrollPos(SB_VERT,(result/m_viewTrace.m_scrollUnit),TRUE);
//            break;
        case 2:                     
            result = Search2(0);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.m_topFrame = result;
/*            
            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
                m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;
*/
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(int)(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
        case 3:                     
            result = Search3(0);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.m_topFrame = result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(int)(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
        case 4:   
            result = Search4(0);
			EndWaitCursor();
			if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.m_topFrame = result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(int)(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
        default:
            break;
    }   
    
}

void CTraceWindow::OnEditSearchnext()
{
    // TODO: Add your command handler code here
    long result;


//    if (searchContent[0]== '\0')
//    {
//    	CTrcSchDg dlg(this);
//        result = dlg.DoModal();
//        if (result!=1) return;
//    }

	BeginWaitCursor();
    
    switch (nTraceViewOption)
    {
/*        case 1:                              
            result = (int)Search1(1); 
            if (result<0) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            
            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
                m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;

            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
*/
        case 2:                     
            result = Search2(1);
            EndWaitCursor();
            
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.m_topFrame = result;
/*
            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
                m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;
*/
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(int)(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
        case 3:                     
            result = Search3(1);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.m_topFrame = result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(int)(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
        case 4:                     
            result = Search4(1);
            EndWaitCursor();
            if (result<-1)
            {
                char info[50];
                sprintf(info, "Break by User at frame 0x%lX !", -result);
                MessageBox(info,"Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            if (result==-1) 
            {
                MessageBox("String Not Found!","Search",MB_OK|MB_ICONHAND|MB_ICONSTOP);
                break;
            }
            m_viewTrace.m_topFrame = result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(int)(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
        default:
            break;
    }   
    
}

void CTraceWindow::OnUpdateEditSearchnext(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
	pCmdUI->Enable(searchContent[0]!= '\0');
}

void CTraceWindow::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    RECT rect;     
    RECT rect2;
    
switch (nTraceViewOption)
{
//    case 1:
    case 3:
        dc.SelectStockObject(WHITE_PEN);
    
        rect.left = m_viewTrace.m_titleLeft;
        rect.top = m_viewTrace.m_titleTop; 
        rect.right = rect.left + m_viewTrace.m_titleWidth1;
        rect.bottom = rect.top + m_viewTrace.m_titleHeight;
        DrawStatic(m_viewTrace.m_lpszTitle1, lstrlen(m_viewTrace.m_lpszTitle1), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);
    
        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth2;
        DrawStatic(m_viewTrace.m_lpszTitle2, lstrlen(m_viewTrace.m_lpszTitle2), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth3;
        DrawStatic(m_viewTrace.m_lpszTitle3, lstrlen(m_viewTrace.m_lpszTitle3), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth4;
        DrawStatic(m_viewTrace.m_lpszTitle4, lstrlen(m_viewTrace.m_lpszTitle4), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth5;
        DrawStatic(m_viewTrace.m_lpszTitle5, lstrlen(m_viewTrace.m_lpszTitle5), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth6;
        DrawStatic(m_viewTrace.m_lpszTitle6, lstrlen(m_viewTrace.m_lpszTitle6), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);
                 
        dc.SelectStockObject(BLACK_PEN);                 
        GetClientRect(&rect2);                 
        rect.right = rect2.right;           
        rect.left = rect.right - m_viewTrace.m_titleWidth7 + 1;
        DrawStatic(m_viewTrace.m_lpszTitle7, lstrlen(m_viewTrace.m_lpszTitle7), rect, &dc);
    
        dc.MoveTo(rect.left,rect.top);
        dc.LineTo(rect.left,rect.bottom);
        break;
    
    case 2:    
        dc.SelectStockObject(WHITE_PEN);
    
        rect.left = m_viewTrace.m_titleLeft2;
        rect.top = m_viewTrace.m_titleTop2; 
        rect.right = rect.left + m_viewTrace.m_titleWidth1;
        rect.bottom = rect.top + m_viewTrace.m_titleHeight2;
        DrawStatic(m_viewTrace.m_lpszTitle1, lstrlen(m_viewTrace.m_lpszTitle1), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);
    
        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth2;
        DrawStatic(m_viewTrace.m_lpszTitle2, lstrlen(m_viewTrace.m_lpszTitle2), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        GetClientRect(&rect2);                 
        rect.left = rect.right + 1;
//        rect.right = rect.left + m_viewTrace.m_titleWidth8;
		rect.right=rect2.right-m_viewTrace.m_titleWidth7;
        ASSERT(rect.right>rect.left);
        //Draw Instruction Title:
        DrawStatic(m_viewTrace.m_lpszTitle8, lstrlen(m_viewTrace.m_lpszTitle8), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        dc.SelectStockObject(BLACK_PEN);                 
        rect.right = rect2.right;           
        rect.left = rect.right - m_viewTrace.m_titleWidth7 + 1;
        DrawStatic(m_viewTrace.m_lpszTitle7, lstrlen(m_viewTrace.m_lpszTitle7), rect, &dc);
    
        dc.MoveTo(rect.left,rect.top);
        dc.LineTo(rect.left,rect.bottom);
        break;
        
    case 4:
        dc.SelectStockObject(WHITE_PEN);
    
        rect.left = m_viewTrace.m_titleLeft2;
        rect.top = m_viewTrace.m_titleTop2; 
        rect.right = rect.left + m_viewTrace.m_titleWidth1;
        rect.bottom = rect.top + m_viewTrace.m_titleHeight2;
        DrawStatic(m_viewTrace.m_lpszTitle1, lstrlen(m_viewTrace.m_lpszTitle1), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);
    
        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth9;
        DrawStatic(m_viewTrace.m_lpszTitle9, lstrlen(m_viewTrace.m_lpszTitle9), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        rect.left = rect.right + 1;
        rect.right = rect.left + m_viewTrace.m_titleWidth10;
        DrawStatic(m_viewTrace.m_lpszTitle10, lstrlen(m_viewTrace.m_lpszTitle10), rect, &dc);
        dc.MoveTo(rect.right,rect.top);
        dc.LineTo(rect.right,rect.bottom);

        dc.SelectStockObject(BLACK_PEN);                 
        GetClientRect(&rect2);                 
        rect.right = rect2.right;           
        rect.left = rect.right - m_viewTrace.m_titleWidth7 + 1;
        DrawStatic(m_viewTrace.m_lpszTitle7, lstrlen(m_viewTrace.m_lpszTitle7), rect, &dc);
    
        dc.MoveTo(rect.left,rect.top);
        dc.LineTo(rect.left,rect.bottom);
    	break;   
    
    default:
        break;
}
    // Do not call CMDIChildWnd::OnPaint() for painting messages
}

void CTraceWindow::OnSize(UINT nType, int cx, int cy)
{
    CMDIChildWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here
    int width;
    int count;
    int add;
    int add2;          

switch (nTraceViewOption)
{
//    case 1:
    case 3: 
    if ((cx-m_viewTrace.m_titleMinWidth7) > (m_viewTrace.m_MinWidth+ m_viewTrace.m_titleLeft))
        m_viewTrace.m_titleLeft = cx - m_viewTrace.m_MinWidth - m_viewTrace.m_titleMinWidth7;
        
    if (m_viewTrace.m_titleLeft > 0)
        m_viewTrace.m_titleLeft = 0;
    
    width = 0;
    count = 0;
    add = 0;   
    add2 = 0;           
    
    width += m_viewTrace.m_titleMinWidth1;
    count += 1;
    width += m_viewTrace.m_titleMinWidth2;
    count += 1;
    width += m_viewTrace.m_titleMinWidth3;
    count += 1;
    width += m_viewTrace.m_titleMinWidth4;
    count += 1;
    width += m_viewTrace.m_titleMinWidth5;
    count += 1;
    width += m_viewTrace.m_titleMinWidth6;
    count += 1;               
    width += m_viewTrace.m_titleMinWidth7;
    
    if (cx >= (width + count -1))
    {
        int i = cx - (width + count -1);
        add = 0;                 
        add2 = i;                    
    }                                           
        
    m_viewTrace.m_titleWidth1 = m_viewTrace.m_titleMinWidth1 + add;
    m_viewTrace.m_titleWidth2 = m_viewTrace.m_titleMinWidth2 + add;
    m_viewTrace.m_titleWidth3 = m_viewTrace.m_titleMinWidth3 + add;
    m_viewTrace.m_titleWidth4 = m_viewTrace.m_titleMinWidth4 + add;
    m_viewTrace.m_titleWidth5 = m_viewTrace.m_titleMinWidth5 + add;
    m_viewTrace.m_titleWidth6 = m_viewTrace.m_titleMinWidth6 + add + add2;
    m_viewTrace.m_titleWidth7 = m_viewTrace.m_titleMinWidth7;
    
    m_viewTrace.SetWindowPos(NULL, 0, 20, cx, cy-m_viewTrace.m_titleHeight, SWP_NOZORDER);
    break;
    
    case 2:
        
    
        m_viewTrace.SetWindowPos(NULL, 0, 20, cx, cy-m_viewTrace.m_titleHeight2, SWP_NOZORDER);
        break;

    case 4:
        if ((cx-m_viewTrace.m_titleMinWidth7) > (m_viewTrace.m_MinWidth4+ m_viewTrace.m_titleLeft2))
            m_viewTrace.m_titleLeft2 = cx - m_viewTrace.m_MinWidth4 - m_viewTrace.m_titleMinWidth9;
        
        if ((cx-m_viewTrace.m_titleMinWidth7) >= m_viewTrace.m_MinWidth4)
            m_viewTrace.m_titleLeft2 = 0;
    
        width = 0;
        count = 0;
        add = 0;   
        add2 = 0;           
    
        width += m_viewTrace.m_titleMinWidth1;
        count += 1;
        width += m_viewTrace.m_titleMinWidth9;
        count += 1;
        width += m_viewTrace.m_titleMinWidth10;
        count += 1;
        width += m_viewTrace.m_titleMinWidth7;
    
        if (cx >= (width + count -1))
        {
            int i = cx - (width + count -1);
            add = 0;                 
            add2 = i;                    
        }                                           
        
        m_viewTrace.m_titleWidth1 = m_viewTrace.m_titleMinWidth1 + add;
        m_viewTrace.m_titleWidth9 = m_viewTrace.m_titleMinWidth9 + add;
        m_viewTrace.m_titleWidth10 = m_viewTrace.m_titleMinWidth10 + add*4 + add2;
        m_viewTrace.m_titleWidth7 = m_viewTrace.m_titleMinWidth7;
    
        m_viewTrace.SetWindowPos(NULL, 0, 20, cx, cy-m_viewTrace.m_titleHeight2, SWP_NOZORDER);
        break;

    default:
        break;
}
}

int CTraceWindow::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here 
    const char * pszTraceClass =
        AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(COLOR_WINDOW + 1),
            NULL);
    
    if (!(m_viewTrace.Create(pszTraceClass,NULL,
        WS_CHILD | WS_VISIBLE | WS_VSCROLL,
        CFrameWnd::rectDefault,
        this,1000,NULL)))
        ASSERT(0);
    return 0;
}                     


void CTraceWindow::OnViewBus()
{
    // TODO: Add your command handler code here
//    RECT rect;                      
//    WPARAM type;
//    LPARAM lParam;
    if (nTraceViewOption==3) return;
    nTraceViewOption = 3;       
	SendMessage(WM_COMMAND, ID_VIEW_REFRESH, NULL);
//    GetClientRect(&rect); 
//	if (IsZoomed()) type=2;
//	else type=0;
//	lParam = rect.bottom;
//	lParam <<=16;
//	lParam += rect.right;
//	SendMessage(WM_SIZE,type,lParam);
//	InvalidateRect(NULL,TRUE);
//	m_viewTrace.InvalidateRect(NULL,TRUE);
}

void CTraceWindow::OnUpdateViewBus(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==3) pCmdUI->SetRadio(1);
    else pCmdUI->SetRadio(0);
}

void CTraceWindow::OnViewInstruction()
{
    // TODO: Add your command handler code here  
//    RECT rect;          
//    WPARAM type;
//    LPARAM lParam;
    if (nTraceViewOption==2) return;
    nTraceViewOption = 2;       
    SendMessage(WM_COMMAND, ID_VIEW_REFRESH, NULL);
//    GetClientRect(&rect); 
//	if (IsZoomed()) type=2;
//	else type=0;
//	lParam = rect.bottom;
//	lParam <<=16;
//	lParam += rect.right;
//	SendMessage(WM_SIZE,type,lParam);	
//	m_viewTrace.SendMessage(WM_SIZE,type,lParam);
//	InvalidateRect(NULL,TRUE);
//	m_viewTrace.InvalidateRect(NULL,TRUE);
}

void CTraceWindow::OnUpdateViewInstruction(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==2) pCmdUI->SetRadio(1);
    else pCmdUI->SetRadio(0);
    
}

void CTraceWindow::OnEditGotoframe()
{
    // TODO: Add your command handler code here
    HINSTANCE hLib;
    int i = 1;
    if ((hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
    	AfxMessageBox("Can't find MUSCROLL.DLL");
    	i = 0;
    }
    CTrcGtdlg dlg(this);
    int result = dlg.DoModal();
    if(i) FreeLibrary(hLib);
    if (result<0) return;
    switch (nTraceViewOption)
    {
/*        case 1:
            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
                m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            m_viewTrace.SetScrollPos(SB_VERT,(result/m_viewTrace.m_scrollUnit),TRUE);
            break;
*/  
        case 2:                                       
            m_viewTrace.m_topFrame = result;
            m_viewTrace.m_bRead = TRUE;
            nPrevGotoFrameNo = (UINT)result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            break;
        case 3:
            m_viewTrace.m_topFrame = result;
            m_viewTrace.m_bRead = TRUE;
            nPrevGotoFrameNo = (UINT)result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            break;
        case 4:
            m_viewTrace.m_topFrame = result;
            m_viewTrace.m_bRead = TRUE;
            nPrevGotoFrameNo = (UINT)result;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            break;
        default:
            break;
    }
}

void CTraceWindow::OnUpdateEditGotoframe(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnEditGotostartframe()
{
    // TODO: Add your command handler code here
    int result;
    result = 0;
    switch (nTraceViewOption)
    {
//        case 1:
//            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
//            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
//            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
//            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
//                m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
//            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
//                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;
//            m_viewTrace.InvalidateRect(NULL,TRUE);
//            m_viewTrace.SetScrollPos(SB_VERT,(result/m_viewTrace.m_scrollUnit),TRUE);
//            break;
        case 2:                                       
            m_viewTrace.m_topFrame = result;
            m_viewTrace.m_bRead = TRUE;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            break;
        case 3:
            m_viewTrace.m_topFrame = result;
            m_viewTrace.m_bRead = TRUE;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            break;
        case 4:
            m_viewTrace.m_topFrame = result;
            m_viewTrace.m_bRead = TRUE;
            m_viewTrace.InvalidateRect(NULL,TRUE);
            break;
        default:
            break;
    }
    
}

void CTraceWindow::OnUpdateEditGotostartframe(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnEditGotoendframe()         
{
    // TODO: Add your command handler code here
    int result;
    result = (int)m_viewTrace.m_traceLastFrameNo;
    switch (nTraceViewOption)
    {
//        case 1:
//            m_viewTrace.m_traceWinTopFrameNo=(long)result+1;
//            m_viewTrace.m_traceWinBottomFrameNo=(long)result + m_viewTrace.m_pageLines;
//            if (m_viewTrace.m_bModeLine==TRUE) m_viewTrace.m_traceWinBottomFrameNo++;
//            if (m_viewTrace.m_traceWinBottomFrameNo > m_viewTrace.m_traceLastFrameNo)
//                m_viewTrace.m_traceWinBottomFrameNo = m_viewTrace.m_traceLastFrameNo;
//            if (m_viewTrace.m_traceWinTopFrameNo > m_viewTrace.m_traceWinBottomFrameNo)
//                m_viewTrace.m_traceWinTopFrameNo = m_viewTrace.m_traceWinBottomFrameNo;
//            m_viewTrace.InvalidateRect(NULL,TRUE);
//            m_viewTrace.SetScrollPos(SB_VERT,(result/m_viewTrace.m_scrollUnit),TRUE);
//            break;
        case 2:
//            m_viewTrace.m_topFrame = result;
//            m_viewTrace.m_bRead = TRUE;
//            m_viewTrace.InvalidateRect(NULL,TRUE);
//            break;
        case 3:
//            m_viewTrace.m_topFrame = result;
//            m_viewTrace.m_bRead = TRUE;
//            m_viewTrace.InvalidateRect(NULL,TRUE);            
//            break;
        case 4:
//            m_viewTrace.m_topFrame = result;
//            m_viewTrace.m_bRead = TRUE;
//            m_viewTrace.InvalidateRect(NULL,TRUE);             
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_BOTTOM, 0l);            
            break;
        default:
            break;
    }
}

void CTraceWindow::OnUpdateEditGotoendframe(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnTraceControl()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this,1);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
    	SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnUpdateTraceControl(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);   
}

void CTraceWindow::OnTraceEvent()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this, 0);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
    	SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnUpdateTraceEvent(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnTraceFilter()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this,3);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
    	SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnUpdateTraceFilter(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnTraceTrigger()
{
    // TODO: Add your command handler code here
    CTraceGroupDialog dlg(this,2);
    dlg.DoModal();
    if(dlg.m_bDisplayChange)
    	SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
}

void CTraceWindow::OnUpdateTraceTrigger(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnFileSavetrace()
{
    // TODO: Add your command handler code here
	long b;
    HINSTANCE hLib;
    int i = 1;
    struct traceFrame3 bus[2];
    struct traceFrame2 instruction[2];      
    struct traceFrame4 source[2];
    long topFrame,bottomFrame;
    int count;      
    char line[256]; 
    BOOL Isreadonly=FALSE;
    CString filename;
    
    if ((hLib = LoadLibrary("MUSCROLL.DLL")) < HINSTANCE_ERROR)
    {
    	AfxMessageBox("Can't find MUSCROLL.DLL");
    	i = 0;
    }
    CTrcFiDlg dlg(this);
    count = dlg.DoModal();
    if(dlg.GetReadOnlyPref())						//by chris.
    		{
    		 Isreadonly=TRUE;
    		 filename=dlg.GetPathName();
    		} 
        
    if(i) FreeLibrary(hLib);
    if (count==1)
    {
    	BeginWaitCursor();
    	
    	CStdioFile savefile;
    	savefile.Open(dlg.GetPathName(),CFile::modeCreate|CFile::modeWrite);
    	switch (dlg.m_nTraceMode)
    	{
    		case 2:
    			savefile.WriteString("Frame  Address  Instruction\n");
    			break;
    		case 3:
    			savefile.WriteString("Frame  Line     Source\n");
    			break;
    		default:
    			savefile.WriteString("Frame  Address  Data  Status  Spare[4-0]  Port\n");
    			break;
    	}
    	b=(long)dlg.m_nSaveStart;
    	while(b<=(long)dlg.m_nSaveEnd)
    	{        
    		switch (dlg.m_nTraceMode)
    		{
    			case 2: 			//instruction
    				topFrame = b;
    				bottomFrame = b;                     
    				count = 1;
    				m_viewTrace.GetInstructionTrace(&topFrame,
    												&bottomFrame,
    												&count,
    												0,instruction);
    				b = topFrame;
    				if (b>dlg.m_nSaveEnd)
    					break;
    				if (instruction[0].frameNo[0]==' ') 
    				{
    					b = dlg.m_nSaveEnd;
    					break;
    				}              
    				line[0]='\0';
    				sprintf(line,"%4s   %4s     %s\n",
    					instruction[0].frameNo,instruction[0].address,instruction[0].instruction);
    				savefile.WriteString(line);
    				break;
    			case 3:
    				topFrame = b;
    				bottomFrame = b;                     
    				count = 1;
    				m_viewTrace.GetSourceTrace(&topFrame,
    											&bottomFrame,
    											&count,
    											0,source);
    				b = topFrame;
    				if (b>dlg.m_nSaveEnd)
    					break;
    				if (source[0].frameNo[0]==' ') 
    				{
    					b = dlg.m_nSaveEnd;
    					break;
    				}              
    				line[0]='\0';
    				sprintf(line,"%4s   %s     %s\n",
    					source[0].frameNo,source[0].line,source[0].source);
    				savefile.WriteString(line);
    				break;
    			default:      
    				topFrame = b;
    				bottomFrame = b;                     
    				count = 1;
    				m_viewTrace.GetQualifyTrace(&topFrame,
    											&bottomFrame,
    											&count,
    											0,bus);
    				b = topFrame;
    				if (b>dlg.m_nSaveEnd)
    					break;
    				if (bus[0].frameNo[0]==' ') 
    				{
    					b = dlg.m_nSaveEnd;
    					break;
    				}              
    				line[0]='\0';
    				sprintf(line,"%4s   %4s     %2s    %2s      %5s       %2s\n",
    					bus[0].frameNo,bus[0].address,bus[0].data,bus[0].status,bus[0].spare,bus[0].port);
    				savefile.WriteString(line);
    				break;
    		}
    		b++;
    	}
    	savefile.Close();
    	if(Isreadonly)						//by chris.
  		{
			 CFileStatus status;
			 CFile::GetStatus( (const char*)filename, status );
			 status.m_attribute |= 0x01;			//read only attribute
    		 CFile::SetStatus( (const char*)filename, status );
    		} 
    	EndWaitCursor();
    }
}

void CTraceWindow::OnUpdateFileSavetrace(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    
}

void CTraceWindow::OnViewSource()
{
	// TODO: Add your command handler code here
//    RECT rect;          
//    LPARAM lParam;
//    WPARAM type;
    
    if (nTraceViewOption==4) return;
    nTraceViewOption = 4;       
	SendMessage(WM_COMMAND,ID_VIEW_REFRESH, NULL);
//	GetClientRect(&rect); 
//	if (IsZoomed()) type=2;
//	else type=0;
//	lParam = rect.bottom;
//	lParam <<=16;
//	lParam += rect.right;
//	SendMessage(WM_SIZE,type,lParam);
//	InvalidateRect(NULL,TRUE);
//	m_viewTrace.InvalidateRect(NULL,TRUE);
	
}

void CTraceWindow::OnUpdateViewSource(CCmdUI* pCmdUI)
{
	// TODO: Add your command update UI handler code here
    pCmdUI->Enable(TRUE);
    if (nTraceViewOption==4) pCmdUI->SetRadio(1);
    else pCmdUI->SetRadio(0);
	
}

void CTraceWindow::OnViewRefresh()
{
	// TODO: Add your command handler code here
    RECT rect;          
    LPARAM lParam;
    WPARAM type;            
    m_viewTrace.m_bRefreshflag=TRUE;
    GetClientRect(&rect); 
	if (IsZoomed()) type=2;
	else type=0;
	lParam = rect.bottom;
	lParam <<=16;
	lParam += rect.right;
	SendMessage(WM_SIZE,type,lParam);
	m_viewTrace.GetClientRect(&rect); 	
	lParam = rect.bottom;
	lParam <<=16;
	lParam += rect.right;
	m_viewTrace.SendMessage(WM_SIZE,type,lParam);
    InvalidateRect(NULL,TRUE);
	m_viewTrace.InvalidateRect(NULL,TRUE);
}

long CTraceWindow::OnXMRepaint(UINT wParam,LONG lParam)
{
    RECT rect;          
    LPARAM lparam;
    WPARAM type;
    GetClientRect(&rect); 
	if (IsZoomed()) type=2;
	else type=0;
	lparam = rect.bottom;
	lparam <<=16;
	lparam += rect.right;
	m_viewTrace.SendMessage(WM_SIZE,type,lparam);
	SendMessage(WM_SIZE,type,lparam);
	InvalidateRect(NULL,TRUE);
	m_viewTrace.InvalidateRect(NULL,TRUE);
    return 0;
}


void CTraceWindow::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: Add your message handler code here and/or call default
		switch(nChar)
		{
		 case VK_HOME:
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_TOP, 0l);
		 	break;
		 case VK_END:
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_BOTTOM, 0l);
		 	break;		 	
	     case VK_PRIOR:
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_PAGEUP, 0l);
		 	break;                                 
		 case VK_NEXT:
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_PAGEDOWN, 0l);
		 	break;
		 case VK_UP:
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_LINEUP, 0l);
		 	break;	                               
		 case VK_DOWN:
		 	m_viewTrace.SendMessage(WM_VSCROLL, SB_LINEDOWN, 0l);
		 	break;	                                 
		 case VK_LEFT:
			m_viewTrace.SendMessage(WM_HSCROLL, SB_LINEUP, 0l);	
		 	break;	                                        
		 case VK_RIGHT:
		 	m_viewTrace.SendMessage(WM_HSCROLL, SB_LINEDOWN, 0l);	
		 	break;	                                   
		} 	
		return;

	
//	CMDIChildWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CTraceWindow::OnShiftreturn()
{
	// TODO: Add your command handler code here
	SendMessage(WM_RBUTTONDOWN);
}

